/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineActionHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineRefactoringFUSCollector;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0014H&J\"\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u0014H&J\"\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u001d\u001a\u00020\u0012J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020\u0014R\u0017\u0010\u0016\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineActionHandler;", "Lcom/intellij/lang/refactoring/InlineActionHandler;", "<init>", "()V", "isEnabledForLanguage", "", "language", "Lcom/intellij/lang/Language;", "canInlineElement", "element", "Lcom/intellij/psi/PsiElement;", "inlineElement", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getActionName", "", "canInlineKotlinElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "inlineKotlinElement", "refactoringName", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "getRefactoringName", "()Ljava/lang/String;", "helpId", "getHelpId", "showErrorHint", "message", "checkSources", "declaration", "kotlin.refactorings.common"})
public abstract class KotlinInlineActionHandler
extends InlineActionHandler {
    @Nullable
    private final String helpId;

    public boolean isEnabledForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE);
    }

    public final boolean canInlineElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtElement ktElement = KotlinInlineActionHandlerKt.access$unwrapKotlinElement(element);
        if (ktElement == null) {
            return false;
        }
        KtElement kotlinElement = ktElement;
        return this.canInlineKotlinElement(kotlinElement);
    }

    public final void inlineElement(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtElement ktElement = KotlinInlineActionHandlerKt.access$unwrapKotlinElement(element);
        if (ktElement == null) {
            throw new IllegalStateException("Kotlin element not found".toString());
        }
        KtElement kotlinElement = ktElement;
        PsiElement psiElement = (PsiElement)kotlinElement;
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"INSTANCE");
        KotlinInlineRefactoringFUSCollector.INSTANCE.log(psiElement, (Language)kotlinLanguage, false);
        this.inlineKotlinElement(project, editor, kotlinElement);
    }

    @NotNull
    public String getActionName(@Nullable PsiElement element) {
        return this.getRefactoringName();
    }

    public abstract boolean canInlineKotlinElement(@NotNull KtElement var1);

    public abstract void inlineKotlinElement(@NotNull Project var1, @Nullable Editor var2, @NotNull KtElement var3);

    @NotNull
    public abstract String getRefactoringName();

    @Nullable
    public String getHelpId() {
        return this.helpId;
    }

    public final void showErrorHint(@NotNull Project project, @Nullable Editor editor, @NlsContexts.DialogMessage @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.getRefactoringName(), (String)this.getHelpId());
    }

    public final boolean checkSources(@NotNull Project project, @Nullable Editor editor, @NotNull KtElement declaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        boolean it = bl = declaration.getContainingKtFile().isCompiled();
        boolean bl2 = false;
        if (it) {
            String string = DescriptiveNameUtil.getDescriptiveName((PsiElement)((PsiElement)declaration));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptiveName(...)");
            String declarationName = string;
            Object[] objectArray = new Object[]{declarationName};
            this.showErrorHint(project, editor, KotlinBundle.message((String)"error.hint.text.cannot.inline.0.from.a.decompiled.file", (Object[])objectArray));
        }
        return !bl;
    }
}

