/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.inspections.ScopeFunctionConversionInspectionKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH$J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "counterpartName", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "postprocessLambda", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "analyzeLambda", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "lambdaDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "replacements", "Lorg/jetbrains/kotlin/idea/inspections/ReplacementCollection;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nScopeFunctionConversionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionFix\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,368:1\n73#2:369\n*S KotlinDebug\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionFix\n*L\n161#1:369\n*E\n"})
public abstract class ConvertScopeFunctionFix
implements LocalQuickFix {
    @NotNull
    private final String counterpartName;

    public ConvertScopeFunctionFix(@NotNull String counterpartName) {
        Intrinsics.checkNotNullParameter((Object)counterpartName, (String)"counterpartName");
        this.counterpartName = counterpartName;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.counterpartName};
        return KotlinBundle.message((String)"convert.scope.function.fix.family.name", (Object[])objectArray);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement = problemDescriptor.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        KtNameReferenceExpression callee = (KtNameReferenceExpression)psiElement;
        PsiElement psiElement2 = callee.getParent();
        KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        BindingContext bindingContext = ResolutionUtils.analyze$default((KtElement)callExpression, null, 1, null);
        List list2 = callExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list2);
        if (ktLambdaArgument == null) {
            return;
        }
        KtLambdaArgument lambda2 = ktLambdaArgument;
        KtLambdaExpression ktLambdaExpression = lambda2.getLambdaExpression();
        if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) == null) {
            return;
        }
        KtLambdaExpression functionLiteral = ktLambdaExpression;
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)functionLiteral);
        if (simpleFunctionDescriptor == null) {
            return;
        }
        SimpleFunctionDescriptor lambdaDescriptor = simpleFunctionDescriptor;
        KtParameterList ktParameterList = functionLiteral.getValueParameterList();
        if (ktParameterList != null) {
            ktParameterList.delete();
        }
        PsiElement psiElement3 = functionLiteral.getArrow();
        if (psiElement3 != null) {
            psiElement3.delete();
        }
        ReplacementCollection replacements = new ReplacementCollection(project);
        this.analyzeLambda(bindingContext, lambda2, lambdaDescriptor, replacements);
        KtExpression ktExpression = new KtPsiFactory(project, false, 2, null).createExpression(this.counterpartName);
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        callee.replace((PsiElement)((KtNameReferenceExpression)ktExpression));
        replacements.apply();
        this.postprocessLambda(lambda2);
        if (replacements.isNotEmpty() && replacements.getElementToRename() != null) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                PsiElement psiElement4 = replacements.getElementToRename();
                Intrinsics.checkNotNull((Object)psiElement4);
                ScopeFunctionConversionInspectionKt.access$startInPlaceRename(psiElement4);
            }
        }
    }

    protected abstract void postprocessLambda(@NotNull KtLambdaArgument var1);

    protected abstract void analyzeLambda(@NotNull BindingContext var1, @NotNull KtLambdaArgument var2, @NotNull SimpleFunctionDescriptor var3, @NotNull ReplacementCollection var4);
}

