/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.plugins.emojipicker.Emoji;
import org.jetbrains.plugins.emojipicker.EmojiSkinTone;
import org.jetbrains.plugins.emojipicker.service.EmojiService;
import org.jetbrains.plugins.emojipicker.ui.EmojiPickerStyle;

public final class EmojiInfoPanel
extends JPanel {
    private final EmojiPickerStyle myStyle;
    @NlsSafe
    private String myCurrentEmoji;
    @Nls
    private String myCurrentEmojiName;

    EmojiInfoPanel(EmojiPickerStyle style) {
        this.myStyle = style;
        Dimension size = new Dimension(0, JBUIScale.scale((int)51));
        this.setPreferredSize(size);
        this.setMinimumSize(size);
    }

    @Override
    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
        g.setColor(this.myCurrentEmoji != null ? this.myStyle.myToolbarColor : this.myStyle.myBackgroundColor);
        RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, 0.0, (double)this.getWidth(), (double)this.getHeight(), (Object)6.0);
        RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, 0.0, (double)this.getWidth(), (double)(this.getHeight() - 6));
        if (this.myCurrentEmoji != null) {
            g.setColor(this.myStyle.myBorderColor);
            RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, 0.0, (double)this.getWidth(), (double)this.myStyle.myBorder.getFloat());
            new TextLayout(this.myCurrentEmoji, this.myStyle.myEmojiFont, ((Graphics2D)g).getFontRenderContext()).draw((Graphics2D)g, JBUIScale.scale((int)16), this.getHeight() - JBUIScale.scale((int)17));
            if (this.myCurrentEmojiName != null) {
                g.setFont(this.myStyle.myFont);
                g.setColor(this.myStyle.myTextColor);
                g.drawString(this.myCurrentEmojiName, JBUIScale.scale((int)49), this.getHeight() - JBUIScale.scale((int)20));
            }
        }
    }

    void showEmojiInfo(Emoji emoji, EmojiSkinTone skinTone) {
        if (emoji == null) {
            this.myCurrentEmojiName = null;
            this.myCurrentEmoji = null;
        } else {
            this.myCurrentEmoji = emoji.getTonedValue(skinTone);
            this.myCurrentEmojiName = EmojiService.getInstance().findNameForEmoji(emoji);
        }
        this.repaint();
    }
}

