/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.selector;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

public final class ScopeDependencySelector
implements DependencySelector {
    private final boolean transitive;
    private final Collection<String> included;
    private final Collection<String> excluded;

    public ScopeDependencySelector(Collection<String> included, Collection<String> excluded) {
        this.transitive = false;
        this.included = ScopeDependencySelector.clone(included);
        this.excluded = ScopeDependencySelector.clone(excluded);
    }

    private static Collection<String> clone(Collection<String> scopes) {
        AbstractCollection copy2;
        if (scopes == null || scopes.isEmpty()) {
            copy2 = null;
        } else {
            copy2 = new HashSet<String>(scopes);
            if (copy2.size() <= 2) {
                copy2 = new ArrayList<String>(new TreeSet<String>(copy2));
            }
        }
        return copy2;
    }

    public ScopeDependencySelector(String ... excluded) {
        this(null, excluded != null ? Arrays.asList(excluded) : null);
    }

    private ScopeDependencySelector(boolean transitive, Collection<String> included, Collection<String> excluded) {
        this.transitive = transitive;
        this.included = included;
        this.excluded = excluded;
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency cannot be null");
        if (!this.transitive) {
            return true;
        }
        String scope = dependency.getScope();
        return !(this.included != null && !this.included.contains(scope) || this.excluded != null && this.excluded.contains(scope));
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        if (this.transitive || context.getDependency() == null) {
            return this;
        }
        return new ScopeDependencySelector(true, this.included, this.excluded);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencySelector that = (ScopeDependencySelector)obj;
        return this.transitive == that.transitive && Objects.equals(this.included, that.included) && Objects.equals(this.excluded, that.excluded);
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = hash2 * 31 + (this.transitive ? 1 : 0);
        hash2 = hash2 * 31 + (this.included != null ? this.included.hashCode() : 0);
        hash2 = hash2 * 31 + (this.excluded != null ? this.excluded.hashCode() : 0);
        return hash2;
    }

    public String toString() {
        return String.format("%s(included: %s, excluded: %s, transitive: %s)", this.getClass().getSimpleName(), this.included, this.excluded, this.transitive);
    }
}

