; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=jump-threading -S < %s | FileCheck %s

; The indirectbr needs a block address. The add can't produce that.
; This shouldn't crash.
define void @cast_with_binop() {
; CHECK-LABEL: @cast_with_binop(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[OP:%.*]] = add i64 ptrtoint (ptr inttoptr (i32 1 to ptr) to i64), undef
; CHECK-NEXT:    [[CAST:%.*]] = inttoptr i64 [[OP]] to ptr
; CHECK-NEXT:    indirectbr ptr [[CAST]], [label [[BB3:%.*]], label %bb2]
; CHECK:       bb2:
; CHECK-NEXT:    unreachable
; CHECK:       bb3:
; CHECK-NEXT:    ret void
;
bb:
  %op = add i64 ptrtoint (ptr inttoptr (i32 1 to ptr) to i64), undef
  %cast = inttoptr i64 %op to ptr
  indirectbr ptr %cast, [label %bb3, label %bb2]
bb2:
  unreachable
bb3:
  ret void
}

; The indirectbr needs a block address. The add can't produce that.
; This shouldn't crash.
define void @cast_with_i1(i1 %x, i1 %y) {
; CHECK-LABEL: @cast_with_i1(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[OP:%.*]] = add i1 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[CAST:%.*]] = inttoptr i1 [[OP]] to ptr
; CHECK-NEXT:    indirectbr ptr [[CAST]], [label [[BB3:%.*]], label %bb2]
; CHECK:       bb2:
; CHECK-NEXT:    unreachable
; CHECK:       bb3:
; CHECK-NEXT:    ret void
;
bb:
  %op = add i1 %x, %y
  %cast = inttoptr i1 %op to ptr
  indirectbr ptr %cast, [label %bb3, label %bb2]
bb2:
  unreachable
bb3:
  ret void
}

; The indirectbr needs a block address. The cmp can't produce that.
; This shouldn't crash.
define void @cast_with_cmp(i1 %x, i1 %y) {
; CHECK-LABEL: @cast_with_cmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[OP:%.*]] = icmp slt i1 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[CAST:%.*]] = inttoptr i1 [[OP]] to ptr
; CHECK-NEXT:    indirectbr ptr [[CAST]], [label [[BB3:%.*]], label %bb2]
; CHECK:       bb2:
; CHECK-NEXT:    unreachable
; CHECK:       bb3:
; CHECK-NEXT:    ret void
;
bb:
  %op = icmp slt i1 %x, %y
  %cast = inttoptr i1 %op to ptr
  indirectbr ptr %cast, [label %bb3, label %bb2]
bb2:
  unreachable
bb3:
  ret void
}
