# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p870 -iterations=1 -instruction-tables=full < %s | FileCheck %s
# COM: Check if we're only bypassing on rs3 of FMADD (i.e. addend) or not.
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p870 -iterations=1 -timeline < %s | FileCheck %s --check-prefix=TIMELINE

fmadd.s fa0, fa0, fa1, fa2
fmadd.s fa2, fa2, fa1, fa0
fmadd.s ft1, ft1, fa2, ft0

fmadd.d fa0, fa0, fa1, fa2
fmadd.d fa2, fa2, fa1, fa0
fmadd.d ft1, ft1, fa2, ft0

fmadd.h fa0, fa0, fa1, fa2
fmadd.h fa2, fa2, fa1, fa0
fmadd.h ft1, ft1, fa2, ft0

# TIMELINE:      Iterations:        1
# TIMELINE-NEXT: Instructions:      9
# TIMELINE-NEXT: Total Cycles:      25
# TIMELINE-NEXT: Total uOps:        9

# CHECK:         Resources:
# CHECK-NEXT:    [0]   - SiFiveP800Branch:2 SiFiveP800IEXQ4, SiFiveP800IEXQ5
# CHECK-NEXT:    [1]   - SiFiveP800Div:1
# CHECK-NEXT:    [2]   - SiFiveP800FEXQ0:1
# CHECK-NEXT:    [3]   - SiFiveP800FEXQ1:1
# CHECK-NEXT:    [4]   - SiFiveP800FloatArith:2 SiFiveP800FEXQ0, SiFiveP800FEXQ1
# CHECK-NEXT:    [5]   - SiFiveP800FloatDiv:1
# CHECK-NEXT:    [6]   - SiFiveP800IEXQ0:1
# CHECK-NEXT:    [7]   - SiFiveP800IEXQ1:1
# CHECK-NEXT:    [8]   - SiFiveP800IEXQ2:1
# CHECK-NEXT:    [9]   - SiFiveP800IEXQ3:1
# CHECK-NEXT:    [10]  - SiFiveP800IEXQ4:1
# CHECK-NEXT:    [11]  - SiFiveP800IEXQ5:1
# CHECK-NEXT:    [12]  - SiFiveP800IntArith:4 SiFiveP800IEXQ0, SiFiveP800IEXQ1, SiFiveP800IEXQ2, SiFiveP800IEXQ3
# CHECK-NEXT:    [13]  - SiFiveP800LD:1
# CHECK-NEXT:    [14]  - SiFiveP800LDST:2
# CHECK-NEXT:    [15]  - SiFiveP800Load:3 SiFiveP800LDST, SiFiveP800LDST, SiFiveP800LD
# CHECK-NEXT:    [16]  - SiFiveP800Mul:2 SiFiveP800IEXQ1, SiFiveP800IEXQ3
# CHECK-NEXT:    [17]  - SiFiveP800VDiv:1
# CHECK-NEXT:    [18]  - SiFiveP800VEXQ0:1
# CHECK-NEXT:    [19]  - SiFiveP800VEXQ1:1
# CHECK-NEXT:    [20]  - SiFiveP800VFloatDiv:1
# CHECK-NEXT:    [21]  - SiFiveP800VLD:1
# CHECK-NEXT:    [22]  - SiFiveP800VST:1
# CHECK-NEXT:    [23]  - SiFiveP800VectorArith:2 SiFiveP800VEXQ0, SiFiveP800VEXQ1

# TIMELINE:      Dispatch Width:    6
# TIMELINE-NEXT: uOps Per Cycle:    0.36
# TIMELINE-NEXT: IPC:               0.36
# TIMELINE-NEXT: Block RThroughput: 4.5

# CHECK:         Instruction Info:
# CHECK-NEXT:    [1]: #uOps
# CHECK-NEXT:    [2]: Latency
# CHECK-NEXT:    [3]: RThroughput
# CHECK-NEXT:    [4]: MayLoad
# CHECK-NEXT:    [5]: MayStore
# CHECK-NEXT:    [6]: HasSideEffects (U)
# CHECK-NEXT:    [7]: Bypass Latency
# CHECK-NEXT:    [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT:    [9]: LLVM Opcode Name

# TIMELINE:      Instruction Info:
# TIMELINE-NEXT: [1]: #uOps
# TIMELINE-NEXT: [2]: Latency
# TIMELINE-NEXT: [3]: RThroughput
# TIMELINE-NEXT: [4]: MayLoad
# TIMELINE-NEXT: [5]: MayStore
# TIMELINE-NEXT: [6]: HasSideEffects (U)

# CHECK:         [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_S                    fmadd.s	fa0, fa0, fa1, fa2
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_S                    fmadd.s	fa2, fa2, fa1, fa0
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_S                    fmadd.s	ft1, ft1, fa2, ft0
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_D                    fmadd.d	fa0, fa0, fa1, fa2
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_D                    fmadd.d	fa2, fa2, fa1, fa0
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_D                    fmadd.d	ft1, ft1, fa2, ft0
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_H                    fmadd.h	fa0, fa0, fa1, fa2
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_H                    fmadd.h	fa2, fa2, fa1, fa0
# CHECK-NEXT:     1      4     0.50                         2     SiFiveP800FloatArith                       FMADD_H                    fmadd.h	ft1, ft1, fa2, ft0

# TIMELINE:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# TIMELINE-NEXT:  1      4     0.50                        fmadd.s	fa0, fa0, fa1, fa2
# TIMELINE-NEXT:  1      4     0.50                        fmadd.s	fa2, fa2, fa1, fa0
# TIMELINE-NEXT:  1      4     0.50                        fmadd.s	ft1, ft1, fa2, ft0
# TIMELINE-NEXT:  1      4     0.50                        fmadd.d	fa0, fa0, fa1, fa2
# TIMELINE-NEXT:  1      4     0.50                        fmadd.d	fa2, fa2, fa1, fa0
# TIMELINE-NEXT:  1      4     0.50                        fmadd.d	ft1, ft1, fa2, ft0
# TIMELINE-NEXT:  1      4     0.50                        fmadd.h	fa0, fa0, fa1, fa2
# TIMELINE-NEXT:  1      4     0.50                        fmadd.h	fa2, fa2, fa1, fa0
# TIMELINE-NEXT:  1      4     0.50                        fmadd.h	ft1, ft1, fa2, ft0

# CHECK:         Resources:
# CHECK-NEXT:    [0]   - SiFiveP800Div
# CHECK-NEXT:    [1]   - SiFiveP800FEXQ0
# CHECK-NEXT:    [2]   - SiFiveP800FEXQ1
# CHECK-NEXT:    [3]   - SiFiveP800FloatDiv
# CHECK-NEXT:    [4]   - SiFiveP800IEXQ0
# CHECK-NEXT:    [5]   - SiFiveP800IEXQ1
# CHECK-NEXT:    [6]   - SiFiveP800IEXQ2
# CHECK-NEXT:    [7]   - SiFiveP800IEXQ3
# CHECK-NEXT:    [8]   - SiFiveP800IEXQ4
# CHECK-NEXT:    [9]   - SiFiveP800IEXQ5
# CHECK-NEXT:    [10]  - SiFiveP800LD
# CHECK-NEXT:    [11.0] - SiFiveP800LDST
# CHECK-NEXT:    [11.1] - SiFiveP800LDST
# CHECK-NEXT:    [12]  - SiFiveP800VDiv
# CHECK-NEXT:    [13]  - SiFiveP800VEXQ0
# CHECK-NEXT:    [14]  - SiFiveP800VEXQ1
# CHECK-NEXT:    [15]  - SiFiveP800VFloatDiv
# CHECK-NEXT:    [16]  - SiFiveP800VLD
# CHECK-NEXT:    [17]  - SiFiveP800VST

# TIMELINE:      Resources:
# TIMELINE-NEXT: [0]   - SiFiveP800Div
# TIMELINE-NEXT: [1]   - SiFiveP800FEXQ0
# TIMELINE-NEXT: [2]   - SiFiveP800FEXQ1
# TIMELINE-NEXT: [3]   - SiFiveP800FloatDiv
# TIMELINE-NEXT: [4]   - SiFiveP800IEXQ0
# TIMELINE-NEXT: [5]   - SiFiveP800IEXQ1
# TIMELINE-NEXT: [6]   - SiFiveP800IEXQ2
# TIMELINE-NEXT: [7]   - SiFiveP800IEXQ3
# TIMELINE-NEXT: [8]   - SiFiveP800IEXQ4
# TIMELINE-NEXT: [9]   - SiFiveP800IEXQ5
# TIMELINE-NEXT: [10]  - SiFiveP800LD
# TIMELINE-NEXT: [11.0] - SiFiveP800LDST
# TIMELINE-NEXT: [11.1] - SiFiveP800LDST
# TIMELINE-NEXT: [12]  - SiFiveP800VDiv
# TIMELINE-NEXT: [13]  - SiFiveP800VEXQ0
# TIMELINE-NEXT: [14]  - SiFiveP800VEXQ1
# TIMELINE-NEXT: [15]  - SiFiveP800VFloatDiv
# TIMELINE-NEXT: [16]  - SiFiveP800VLD
# TIMELINE-NEXT: [17]  - SiFiveP800VST

# CHECK:         Resource pressure per iteration:
# CHECK-NEXT:    [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]
# CHECK-NEXT:     -     4.50   4.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -

# TIMELINE:      Resource pressure per iteration:
# TIMELINE-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]
# TIMELINE-NEXT:  -     4.00   5.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -

# CHECK:         Resource pressure by instruction:
# CHECK-NEXT:    [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]   Instructions:
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.s	fa0, fa0, fa1, fa2
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.s	fa2, fa2, fa1, fa0
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.s	ft1, ft1, fa2, ft0
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.d	fa0, fa0, fa1, fa2
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.d	fa2, fa2, fa1, fa0
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.d	ft1, ft1, fa2, ft0
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.h	fa0, fa0, fa1, fa2
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.h	fa2, fa2, fa1, fa0
# CHECK-NEXT:     -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.h	ft1, ft1, fa2, ft0

# TIMELINE:      Resource pressure by instruction:
# TIMELINE-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]   Instructions:
# TIMELINE-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.s	fa0, fa0, fa1, fa2
# TIMELINE-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.s	fa2, fa2, fa1, fa0
# TIMELINE-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.s	ft1, ft1, fa2, ft0
# TIMELINE-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.d	fa0, fa0, fa1, fa2
# TIMELINE-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.d	fa2, fa2, fa1, fa0
# TIMELINE-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.d	ft1, ft1, fa2, ft0
# TIMELINE-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.h	fa0, fa0, fa1, fa2
# TIMELINE-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.h	fa2, fa2, fa1, fa0
# TIMELINE-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fmadd.h	ft1, ft1, fa2, ft0

# TIMELINE:      Timeline view:
# TIMELINE-NEXT:                     0123456789
# TIMELINE-NEXT: Index     0123456789          01234

# TIMELINE:      [0,0]     DeeeeER   .    .    .   .   fmadd.s	fa0, fa0, fa1, fa2
# TIMELINE-NEXT: [0,1]     D==eeeeER .    .    .   .   fmadd.s	fa2, fa2, fa1, fa0
# TIMELINE-NEXT: [0,2]     D======eeeeER  .    .   .   fmadd.s	ft1, ft1, fa2, ft0
# TIMELINE-NEXT: [0,3]     D======eeeeER  .    .   .   fmadd.d	fa0, fa0, fa1, fa2
# TIMELINE-NEXT: [0,4]     D========eeeeER.    .   .   fmadd.d	fa2, fa2, fa1, fa0
# TIMELINE-NEXT: [0,5]     D============eeeeER .   .   fmadd.d	ft1, ft1, fa2, ft0
# TIMELINE-NEXT: [0,6]     .D===========eeeeER .   .   fmadd.h	fa0, fa0, fa1, fa2
# TIMELINE-NEXT: [0,7]     .D=============eeeeER   .   fmadd.h	fa2, fa2, fa1, fa0
# TIMELINE-NEXT: [0,8]     .D=================eeeeER   fmadd.h	ft1, ft1, fa2, ft0

# TIMELINE:      Average Wait times (based on the timeline view):
# TIMELINE-NEXT: [0]: Executions
# TIMELINE-NEXT: [1]: Average time spent waiting in a scheduler's queue
# TIMELINE-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# TIMELINE-NEXT: [3]: Average time elapsed from WB until retire stage

# TIMELINE:            [0]    [1]    [2]    [3]
# TIMELINE-NEXT: 0.     1     1.0    1.0    0.0       fmadd.s	fa0, fa0, fa1, fa2
# TIMELINE-NEXT: 1.     1     3.0    0.0    0.0       fmadd.s	fa2, fa2, fa1, fa0
# TIMELINE-NEXT: 2.     1     7.0    0.0    0.0       fmadd.s	ft1, ft1, fa2, ft0
# TIMELINE-NEXT: 3.     1     7.0    0.0    0.0       fmadd.d	fa0, fa0, fa1, fa2
# TIMELINE-NEXT: 4.     1     9.0    0.0    0.0       fmadd.d	fa2, fa2, fa1, fa0
# TIMELINE-NEXT: 5.     1     13.0   0.0    0.0       fmadd.d	ft1, ft1, fa2, ft0
# TIMELINE-NEXT: 6.     1     12.0   0.0    0.0       fmadd.h	fa0, fa0, fa1, fa2
# TIMELINE-NEXT: 7.     1     14.0   0.0    0.0       fmadd.h	fa2, fa2, fa1, fa0
# TIMELINE-NEXT: 8.     1     18.0   0.0    0.0       fmadd.h	ft1, ft1, fa2, ft0
# TIMELINE-NEXT:        1     9.3    0.1    0.0       <total>
