; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O2 -mtriple=x86_64-linux-android \
; RUN:     -enable-legalize-types-checking | FileCheck %s --check-prefix=ANDROID
; RUN: llc < %s -O2 -mtriple=x86_64-linux-gnu \
; RUN:     -enable-legalize-types-checking | FileCheck %s --check-prefix=GNU
; RUN: llc < %s -O2 -mtriple=i686-linux-gnu -mattr=sse2 \
; RUN:     -enable-legalize-types-checking | FileCheck %s --check-prefix=X86

; Check all soft floating point library function calls.

@vf64 = common dso_local global double 0.000000e+00, align 8
@vf128 = common dso_local global fp128 0xL00000000000000000000000000000000, align 16

define dso_local void @Test128Add(fp128 %d1, fp128 %d2) nounwind {
; CHECK-LABEL: Test128Add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __addtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128Add:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __addtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Add:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __addtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Add:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __addtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %add = fadd fp128 %d1, %d2
  store fp128 %add, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Add(fp128 %d1) nounwind {
; CHECK-LABEL: Test128_1Add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps vf128(%rip), %xmm0
; CHECK-NEXT:    callq __addtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128_1Add:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq __addtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Add:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq __addtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Add:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl vf128+12
; X86-NEXT:    pushl vf128+8
; X86-NEXT:    pushl vf128+4
; X86-NEXT:    pushl vf128
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __addtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %add = fadd fp128 %0, %d1
  store fp128 %add, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Sub(fp128 %d1, fp128 %d2) nounwind {
; CHECK-LABEL: Test128Sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __subtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128Sub:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __subtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Sub:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __subtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Sub:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __subtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sub = fsub fp128 %d1, %d2
  store fp128 %sub, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Sub(fp128 %d1) nounwind {
; CHECK-LABEL: Test128_1Sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps vf128(%rip), %xmm0
; CHECK-NEXT:    callq __subtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128_1Sub:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq __subtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Sub:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq __subtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Sub:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl vf128+12
; X86-NEXT:    pushl vf128+8
; X86-NEXT:    pushl vf128+4
; X86-NEXT:    pushl vf128
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __subtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %sub = fsub fp128 %0, %d1
  store fp128 %sub, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Mul(fp128 %d1, fp128 %d2) nounwind {
; CHECK-LABEL: Test128Mul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __multf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128Mul:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __multf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Mul:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __multf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Mul:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __multf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %mul = fmul fp128 %d1, %d2
  store fp128 %mul, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Mul(fp128 %d1) nounwind {
; CHECK-LABEL: Test128_1Mul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps vf128(%rip), %xmm0
; CHECK-NEXT:    callq __multf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128_1Mul:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq __multf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Mul:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq __multf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Mul:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl vf128+12
; X86-NEXT:    pushl vf128+8
; X86-NEXT:    pushl vf128+4
; X86-NEXT:    pushl vf128
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __multf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %mul = fmul fp128 %0, %d1
  store fp128 %mul, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Div(fp128 %d1, fp128 %d2) nounwind {
; CHECK-LABEL: Test128Div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __divtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128Div:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __divtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Div:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __divtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Div:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __divtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %div = fdiv fp128 %d1, %d2
  store fp128 %div, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Div(fp128 %d1) nounwind {
; CHECK-LABEL: Test128_1Div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps vf128(%rip), %xmm0
; CHECK-NEXT:    callq __divtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128_1Div:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq __divtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Div:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq __divtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Div:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl vf128+12
; X86-NEXT:    pushl vf128+8
; X86-NEXT:    pushl vf128+4
; X86-NEXT:    pushl vf128
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __divtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %div = fdiv fp128 %0, %d1
  store fp128 %div, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Rem(fp128 %d1, fp128 %d2) nounwind {
; ANDROID-LABEL: Test128Rem:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fmodl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Rem:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fmodf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Rem:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll fmodl
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %div = frem fp128 %d1, %d2
  store fp128 %div, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Rem(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128_1Rem:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq fmodl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Rem:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq fmodf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Rem:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl vf128+12
; X86-NEXT:    pushl vf128+8
; X86-NEXT:    pushl vf128+4
; X86-NEXT:    pushl vf128
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll fmodl
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %div = frem fp128 %0, %d1
  store fp128 %div, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Sqrt(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Sqrt:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sqrtl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Sqrt:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sqrtf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Sqrt:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll sqrtl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.sqrt.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.sqrt.f128(fp128)

define dso_local void @Test128Sin(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Sin:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sinl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Sin:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sinf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Sin:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll sinl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.sin.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.sin.f128(fp128)

define dso_local void @Test128Cos(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Cos:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq cosl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Cos:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq cosf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Cos:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll cosl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.cos.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.cos.f128(fp128)

define dso_local void @Test128Ceil(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Ceil:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq ceill@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Ceil:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq ceilf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Ceil:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll ceill
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.ceil.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.ceil.f128(fp128)

define dso_local void @Test128Floor(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Floor:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq floorl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Floor:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq floorf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Floor:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll floorl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.floor.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.floor.f128(fp128)

define dso_local void @Test128Trunc(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Trunc:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq truncl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Trunc:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq truncf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Trunc:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll truncl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.trunc.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.trunc.f128(fp128)

define dso_local void @Test128Nearbyint(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Nearbyint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq nearbyintl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Nearbyint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq nearbyintf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Nearbyint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll nearbyintl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.nearbyint.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.nearbyint.f128(fp128)

define dso_local void @Test128Rint(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Rint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq rintl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Rint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq rintf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Rint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll rintl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.rint.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.rint.f128(fp128)

define dso_local void @Test128Round(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Round:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq roundl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Round:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq roundf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Round:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $40, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll roundl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.round.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.round.f128(fp128)

define fp128 @Test128FMA(fp128 %a, fp128 %b, fp128 %c) nounwind {
; ANDROID-LABEL: Test128FMA:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    jmp fmal@PLT # TAILCALL
;
; GNU-LABEL: Test128FMA:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    jmp fmaf128@PLT # TAILCALL
;
; X86-LABEL: Test128FMA:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll fmal
; X86-NEXT:    addl $60, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %call = call fp128 @llvm.fma.f128(fp128 %a, fp128 %b, fp128 %c)
  ret fp128 %call
}
declare fp128 @llvm.fma.f128(fp128, fp128, fp128)
