; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -global-isel=0 -mcpu=gfx1010 < %s | FileCheck %s --check-prefixes=CHECK,DAGISEL
; RUN: llc -mtriple=amdgcn -global-isel=0 -mcpu=gfx1100 -mattr=+real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck %s --check-prefixes=CHECK,DAGISEL,DAGISEL-TRUE16
; RUN: llc -mtriple=amdgcn -global-isel=0 -mcpu=gfx1100 -mattr=-real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck %s --check-prefixes=CHECK,DAGISEL,DAGISEL-FAKE16
; RUN: llc -mtriple=amdgcn -global-isel -mcpu=gfx1010 < %s | FileCheck %s --check-prefixes=CHECK,GISEL
; RUN: llc -mtriple=amdgcn -global-isel -mcpu=gfx1100 -mattr=+real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck %s --check-prefixes=CHECK,GISEL,GISEL-TRUE16
; RUN: llc -mtriple=amdgcn -global-isel -mcpu=gfx1100 -mattr=-real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck %s --check-prefixes=CHECK,GISEL,GISEL-FAKE16

declare i64 @llvm.amdgcn.ballot.i64(i1)
declare i64 @llvm.ctpop.i64(i64)

; Test ballot(0)

define amdgpu_cs i64 @constant_false() {
; CHECK-LABEL: constant_false:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_mov_b32 s0, 0
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    ; return to shader part epilog
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 0)
  ret i64 %ballot
}

; Test ballot(1)

define amdgpu_cs i64 @constant_true() {
; DAGISEL-LABEL: constant_true:
; DAGISEL:       ; %bb.0:
; DAGISEL-NEXT:    s_mov_b32 s0, exec_lo
; DAGISEL-NEXT:    s_mov_b32 s1, exec_hi
; DAGISEL-NEXT:    ; return to shader part epilog
;
; GISEL-LABEL: constant_true:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_mov_b32 s0, exec_lo
; GISEL-NEXT:    s_mov_b32 s1, 0
; GISEL-NEXT:    ; return to shader part epilog
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 1)
  ret i64 %ballot
}

; Test ballot of a non-comparison operation

define amdgpu_cs i64 @non_compare(i32 %x) {
; DAGISEL-LABEL: non_compare:
; DAGISEL:       ; %bb.0:
; DAGISEL-NEXT:    v_and_b32_e32 v0, 1, v0
; DAGISEL-NEXT:    s_mov_b32 s1, 0
; DAGISEL-NEXT:    v_cmp_ne_u32_e64 s0, 0, v0
; DAGISEL-NEXT:    ; return to shader part epilog
;
; GISEL-TRUE16-LABEL: non_compare:
; GISEL-TRUE16:       ; %bb.0:
; GISEL-TRUE16-NEXT:    v_and_b16 v0.l, 1, v0.l
; GISEL-TRUE16-NEXT:    s_mov_b32 s1, 0
; GISEL-TRUE16-NEXT:    v_cmp_ne_u16_e32 vcc_lo, 0, v0.l
; GISEL-TRUE16-NEXT:    s_and_b32 s0, vcc_lo, exec_lo
; GISEL-TRUE16-NEXT:    ; return to shader part epilog
;
; GISEL-FAKE16-LABEL: non_compare:
; GISEL-FAKE16:       ; %bb.0:
; GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GISEL-FAKE16-NEXT:    s_mov_b32 s1, 0
; GISEL-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GISEL-FAKE16-NEXT:    s_and_b32 s0, vcc_lo, exec_lo
; GISEL-FAKE16-NEXT:    ; return to shader part epilog
  %trunc = trunc i32 %x to i1
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %trunc)
  ret i64 %ballot
}

; Test ballot of comparisons

define amdgpu_cs i64 @compare_ints(i32 %x, i32 %y) {
; CHECK-LABEL: compare_ints:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    v_cmp_eq_u32_e64 s0, v0, v1
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    ; return to shader part epilog
  %cmp = icmp eq i32 %x, %y
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %cmp)
  ret i64 %ballot
}

define amdgpu_cs i64 @compare_int_with_constant(i32 %x) {
; DAGISEL-LABEL: compare_int_with_constant:
; DAGISEL:       ; %bb.0:
; DAGISEL-NEXT:    v_cmp_lt_i32_e64 s0, 0x62, v0
; DAGISEL-NEXT:    s_mov_b32 s1, 0
; DAGISEL-NEXT:    ; return to shader part epilog
;
; GISEL-LABEL: compare_int_with_constant:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    v_cmp_le_i32_e64 s0, 0x63, v0
; GISEL-NEXT:    s_mov_b32 s1, 0
; GISEL-NEXT:    ; return to shader part epilog
  %cmp = icmp sge i32 %x, 99
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %cmp)
  ret i64 %ballot
}

define amdgpu_cs i64 @compare_floats(float %x, float %y) {
; CHECK-LABEL: compare_floats:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    v_cmp_gt_f32_e64 s0, v0, v1
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    ; return to shader part epilog
  %cmp = fcmp ogt float %x, %y
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %cmp)
  ret i64 %ballot
}

define amdgpu_cs i64 @ctpop_of_ballot(float %x, float %y) {
; CHECK-LABEL: ctpop_of_ballot:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    v_cmp_gt_f32_e64 s0, v0, v1
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; CHECK-NEXT:    ; return to shader part epilog
  %cmp = fcmp ogt float %x, %y
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %cmp)
  %bcnt = call i64 @llvm.ctpop.i64(i64 %ballot)
  ret i64 %bcnt
}

define amdgpu_cs i32 @branch_divergent_ballot64_ne_zero_compare(i32 %v) {
; CHECK-LABEL: branch_divergent_ballot64_ne_zero_compare:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    v_cmp_gt_u32_e64 s0, 12, v0
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    s_cmp_eq_u64 s[0:1], 0
; CHECK-NEXT:    s_cbranch_scc1 .LBB7_2
; CHECK-NEXT:  ; %bb.1: ; %true
; CHECK-NEXT:    s_mov_b32 s0, 42
; CHECK-NEXT:    s_branch .LBB7_3
; CHECK-NEXT:  .LBB7_2: ; %false
; CHECK-NEXT:    s_mov_b32 s0, 33
; CHECK-NEXT:    s_branch .LBB7_3
; CHECK-NEXT:  .LBB7_3:
  %c = icmp ult i32 %v, 12
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %c)
  %ballot_ne_zero = icmp ne i64 %ballot, 0
  br i1 %ballot_ne_zero, label %true, label %false
true:
  ret i32 42
false:
  ret i32 33
}

define amdgpu_cs i32 @branch_divergent_ballot64_ne_zero_and(i32 %v1, i32 %v2) {
; DAGISEL-LABEL: branch_divergent_ballot64_ne_zero_and:
; DAGISEL:       ; %bb.0:
; DAGISEL-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 12, v0
; DAGISEL-NEXT:    v_cmp_lt_u32_e64 s0, 34, v1
; DAGISEL-NEXT:    s_mov_b32 s1, 0
; DAGISEL-NEXT:    s_and_b32 s0, vcc_lo, s0
; DAGISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; DAGISEL-NEXT:    v_cmp_ne_u32_e64 s0, 0, v0
; DAGISEL-NEXT:    s_cmp_eq_u64 s[0:1], 0
; DAGISEL-NEXT:    s_cbranch_scc1 .LBB8_2
; DAGISEL-NEXT:  ; %bb.1: ; %true
; DAGISEL-NEXT:    s_mov_b32 s0, 42
; DAGISEL-NEXT:    s_branch .LBB8_3
; DAGISEL-NEXT:  .LBB8_2: ; %false
; DAGISEL-NEXT:    s_mov_b32 s0, 33
; DAGISEL-NEXT:    s_branch .LBB8_3
; DAGISEL-NEXT:  .LBB8_3:
;
; GISEL-LABEL: branch_divergent_ballot64_ne_zero_and:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 12, v0
; GISEL-NEXT:    v_cmp_lt_u32_e64 s0, 34, v1
; GISEL-NEXT:    s_mov_b32 s1, 0
; GISEL-NEXT:    s_and_b32 s0, vcc_lo, s0
; GISEL-NEXT:    s_cmp_eq_u64 s[0:1], 0
; GISEL-NEXT:    s_cbranch_scc1 .LBB8_2
; GISEL-NEXT:  ; %bb.1: ; %true
; GISEL-NEXT:    s_mov_b32 s0, 42
; GISEL-NEXT:    s_branch .LBB8_3
; GISEL-NEXT:  .LBB8_2: ; %false
; GISEL-NEXT:    s_mov_b32 s0, 33
; GISEL-NEXT:    s_branch .LBB8_3
; GISEL-NEXT:  .LBB8_3:
  %v1c = icmp ult i32 %v1, 12
  %v2c = icmp ugt i32 %v2, 34
  %c = and i1 %v1c, %v2c
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %c)
  %ballot_ne_zero = icmp ne i64 %ballot, 0
  br i1 %ballot_ne_zero, label %true, label %false
true:
  ret i32 42
false:
  ret i32 33
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; DAGISEL-FAKE16: {{.*}}
; DAGISEL-TRUE16: {{.*}}
