/* bigram-decoder.c generated by valac 0.38.8, the Vala compiler
 * generated from bigram-decoder.vala, do not modify */

/*
 * Copyright (C) 2012-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define KKC_TYPE_NBEST_NODE (kkc_nbest_node_get_type ())
#define KKC_NBEST_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_NBEST_NODE, KkcNbestNode))
#define KKC_NBEST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_NBEST_NODE, KkcNbestNodeClass))
#define KKC_IS_NBEST_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_NBEST_NODE))
#define KKC_IS_NBEST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_NBEST_NODE))
#define KKC_NBEST_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_NBEST_NODE, KkcNbestNodeClass))

typedef struct _KkcNbestNode KkcNbestNode;
typedef struct _KkcNbestNodeClass KkcNbestNodeClass;
typedef struct _KkcNbestNodePrivate KkcNbestNodePrivate;

#define KKC_TYPE_TRELLIS_NODE (kkc_trellis_node_get_type ())
#define KKC_TRELLIS_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_TRELLIS_NODE, KkcTrellisNode))
#define KKC_TRELLIS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_TRELLIS_NODE, KkcTrellisNodeClass))
#define KKC_IS_TRELLIS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_TRELLIS_NODE))
#define KKC_IS_TRELLIS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_TRELLIS_NODE))
#define KKC_TRELLIS_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_TRELLIS_NODE, KkcTrellisNodeClass))

typedef struct _KkcTrellisNode KkcTrellisNode;
typedef struct _KkcTrellisNodeClass KkcTrellisNodeClass;
#define _kkc_trellis_node_unref0(var) ((var == NULL) ? NULL : (var = (kkc_trellis_node_unref (var), NULL)))
#define _kkc_nbest_node_unref0(var) ((var == NULL) ? NULL : (var = (kkc_nbest_node_unref (var), NULL)))
typedef struct _KkcParamSpecNbestNode KkcParamSpecNbestNode;

#define KKC_TYPE_DECODER (kkc_decoder_get_type ())
#define KKC_DECODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DECODER, KkcDecoder))
#define KKC_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DECODER, KkcDecoderClass))
#define KKC_IS_DECODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DECODER))
#define KKC_IS_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DECODER))
#define KKC_DECODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DECODER, KkcDecoderClass))

typedef struct _KkcDecoder KkcDecoder;
typedef struct _KkcDecoderClass KkcDecoderClass;
typedef struct _KkcDecoderPrivate KkcDecoderPrivate;

#define KKC_TYPE_SEGMENT (kkc_segment_get_type ())
#define KKC_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT, KkcSegment))
#define KKC_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT, KkcSegmentClass))
#define KKC_IS_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT))
#define KKC_IS_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT))
#define KKC_SEGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT, KkcSegmentClass))

typedef struct _KkcSegment KkcSegment;
typedef struct _KkcSegmentClass KkcSegmentClass;

#define KKC_TYPE_BIGRAM_DECODER (kkc_bigram_decoder_get_type ())
#define KKC_BIGRAM_DECODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoder))
#define KKC_BIGRAM_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoderClass))
#define KKC_IS_BIGRAM_DECODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_DECODER))
#define KKC_IS_BIGRAM_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_BIGRAM_DECODER))
#define KKC_BIGRAM_DECODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoderClass))

typedef struct _KkcBigramDecoder KkcBigramDecoder;
typedef struct _KkcBigramDecoderClass KkcBigramDecoderClass;
typedef struct _KkcBigramDecoderPrivate KkcBigramDecoderPrivate;

#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;

#define KKC_TYPE_UNIGRAM_LANGUAGE_MODEL (kkc_unigram_language_model_get_type ())
#define KKC_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel))
#define KKC_IS_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL))
#define KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModelIface))

typedef struct _KkcUnigramLanguageModel KkcUnigramLanguageModel;
typedef struct _KkcUnigramLanguageModelIface KkcUnigramLanguageModelIface;

#define KKC_TYPE_LANGUAGE_MODEL_ENTRY (kkc_language_model_entry_get_type ())
typedef struct _KkcLanguageModelEntry KkcLanguageModelEntry;

#define KKC_TYPE_BIGRAM_LANGUAGE_MODEL (kkc_bigram_language_model_get_type ())
#define KKC_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModel))
#define KKC_IS_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL))
#define KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModelIface))

typedef struct _KkcBigramLanguageModel KkcBigramLanguageModel;
typedef struct _KkcBigramLanguageModelIface KkcBigramLanguageModelIface;
enum  {
	KKC_BIGRAM_DECODER_0_PROPERTY,
	KKC_BIGRAM_DECODER_MODEL_PROPERTY,
	KKC_BIGRAM_DECODER_NUM_PROPERTIES
};
static GParamSpec* kkc_bigram_decoder_properties[KKC_BIGRAM_DECODER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_UNIGRAM_TRELLIS_NODE (kkc_unigram_trellis_node_get_type ())
#define KKC_UNIGRAM_TRELLIS_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_TRELLIS_NODE, KkcUnigramTrellisNode))
#define KKC_UNIGRAM_TRELLIS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_UNIGRAM_TRELLIS_NODE, KkcUnigramTrellisNodeClass))
#define KKC_IS_UNIGRAM_TRELLIS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_TRELLIS_NODE))
#define KKC_IS_UNIGRAM_TRELLIS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_UNIGRAM_TRELLIS_NODE))
#define KKC_UNIGRAM_TRELLIS_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_UNIGRAM_TRELLIS_NODE, KkcUnigramTrellisNodeClass))

typedef struct _KkcUnigramTrellisNode KkcUnigramTrellisNode;
typedef struct _KkcUnigramTrellisNodeClass KkcUnigramTrellisNodeClass;
#define _kkc_language_model_entry_free0(var) ((var == NULL) ? NULL : (var = (kkc_language_model_entry_free (var), NULL)))
typedef struct _KkcTrellisNodePrivate KkcTrellisNodePrivate;
typedef struct _KkcSegmentPrivate KkcSegmentPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KkcNbestNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KkcNbestNodePrivate * priv;
	KkcTrellisNode* node;
	gdouble gn;
	gdouble fn;
	KkcNbestNode* next;
};

struct _KkcNbestNodeClass {
	GTypeClass parent_class;
	void (*finalize) (KkcNbestNode *self);
};

struct _KkcParamSpecNbestNode {
	GParamSpec parent_instance;
};

struct _KkcDecoder {
	GObject parent_instance;
	KkcDecoderPrivate * priv;
};

struct _KkcDecoderClass {
	GObjectClass parent_class;
	KkcSegment** (*decode) (KkcDecoder* self, const gchar* input, gint nbest, gint* constraint, int constraint_length1, int* result_length1);
	KkcSegment** (*decode_with_costs) (KkcDecoder* self, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1);
};

struct _KkcBigramDecoder {
	KkcDecoder parent_instance;
	KkcBigramDecoderPrivate * priv;
};

struct _KkcBigramDecoderClass {
	KkcDecoderClass parent_class;
	gdouble (*path_cost) (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos);
};

struct _KkcLanguageModelEntry {
	gchar* input;
	gchar* output;
	guint id;
};

struct _KkcUnigramLanguageModelIface {
	GTypeInterface parent_iface;
	gdouble (*unigram_cost) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
	gdouble (*unigram_backoff) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
};

struct _KkcBigramLanguageModelIface {
	GTypeInterface parent_iface;
	gboolean (*has_bigram) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_cost) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_backoff) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
};

struct _KkcBigramDecoderPrivate {
	KkcBigramLanguageModel* _model;
};

struct _KkcTrellisNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KkcTrellisNodePrivate * priv;
	KkcTrellisNode* previous;
	gdouble cumulative_cost;
};

struct _KkcTrellisNodeClass {
	GTypeClass parent_class;
	void (*finalize) (KkcTrellisNode *self);
	gchar* (*to_string) (KkcTrellisNode* self);
	guint (*get_endpos) (KkcTrellisNode* self);
	guint (*get_length) (KkcTrellisNode* self);
	const gchar* (*get_input) (KkcTrellisNode* self);
	const gchar* (*get_output) (KkcTrellisNode* self);
	KkcLanguageModelEntry* (*get_entries) (KkcTrellisNode* self, int* result_length1);
};

struct _KkcSegment {
	GObject parent_instance;
	KkcSegmentPrivate * priv;
	KkcSegment* next;
};

struct _KkcSegmentClass {
	GObjectClass parent_class;
};


static gpointer kkc_nbest_node_parent_class = NULL;
static gpointer kkc_bigram_decoder_parent_class = NULL;

gpointer kkc_nbest_node_ref (gpointer instance);
void kkc_nbest_node_unref (gpointer instance);
GParamSpec* kkc_param_spec_nbest_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void kkc_value_set_nbest_node (GValue* value, gpointer v_object);
void kkc_value_take_nbest_node (GValue* value, gpointer v_object);
gpointer kkc_value_get_nbest_node (const GValue* value);
GType kkc_nbest_node_get_type (void) G_GNUC_CONST;
gpointer kkc_trellis_node_ref (gpointer instance);
void kkc_trellis_node_unref (gpointer instance);
GParamSpec* kkc_param_spec_trellis_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void kkc_value_set_trellis_node (GValue* value, gpointer v_object);
void kkc_value_take_trellis_node (GValue* value, gpointer v_object);
gpointer kkc_value_get_trellis_node (const GValue* value);
GType kkc_trellis_node_get_type (void) G_GNUC_CONST;
KkcNbestNode* kkc_nbest_node_new (KkcTrellisNode* node);
KkcNbestNode* kkc_nbest_node_construct (GType object_type, KkcTrellisNode* node);
static void kkc_nbest_node_finalize (KkcNbestNode * obj);
GType kkc_decoder_get_type (void) G_GNUC_CONST;
GType kkc_segment_get_type (void) G_GNUC_CONST;
GType kkc_bigram_decoder_get_type (void) G_GNUC_CONST;
GType kkc_language_model_get_type (void) G_GNUC_CONST;
GType kkc_language_model_entry_get_type (void) G_GNUC_CONST;
KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self);
void kkc_language_model_entry_free (KkcLanguageModelEntry* self);
void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest);
void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self);
GType kkc_unigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_bigram_language_model_get_type (void) G_GNUC_CONST;
#define KKC_BIGRAM_DECODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoderPrivate))
static KkcSegment** kkc_bigram_decoder_real_decode (KkcDecoder* base, const gchar* input, gint nbest, gint* constraint, int constraint_length1, int* result_length1);
KkcSegment** kkc_decoder_decode_with_costs (KkcDecoder* self, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1);
static KkcSegment** kkc_bigram_decoder_real_decode_with_costs (KkcDecoder* base, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1);
GeeArrayList** kkc_bigram_decoder_build_trellis (KkcBigramDecoder* self, const gchar* input, gint* constraint, int constraint_length1, int* result_length1);
void kkc_bigram_decoder_add_unknown_nodes (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, const gchar* input, gint* constraint, int constraint_length1);
void kkc_bigram_decoder_forward_search (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, const gchar* input);
KkcSegment** kkc_bigram_decoder_backward_search (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, gint nbest, gdouble max_distance, gdouble min_path_cost, int* result_length1);
static gboolean kkc_bigram_decoder_check_overlaps (KkcBigramDecoder* self, gint* constraint, int constraint_length1, gint i, gint j);
GType kkc_unigram_trellis_node_get_type (void) G_GNUC_CONST;
KkcUnigramTrellisNode* kkc_unigram_trellis_node_new (KkcLanguageModelEntry* entry, guint endpos);
KkcUnigramTrellisNode* kkc_unigram_trellis_node_construct (GType object_type, KkcLanguageModelEntry* entry, guint endpos);
KkcBigramLanguageModel* kkc_bigram_decoder_get_model (KkcBigramDecoder* self);
void kkc_language_model_get_bos (KkcLanguageModel* self, KkcLanguageModelEntry * result);
void kkc_language_model_get_eos (KkcLanguageModel* self, KkcLanguageModelEntry * result);
GeeCollection* kkc_language_model_entries (KkcLanguageModel* self, const gchar* input);
static gboolean kkc_bigram_decoder_check_constraint (KkcBigramDecoder* self, gint* constraint, int constraint_length1, gint i, gint j);
guint kkc_trellis_node_get_length (KkcTrellisNode* self);
gdouble kkc_bigram_decoder_path_cost (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos);
static gdouble kkc_bigram_decoder_real_path_cost (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos);
gdouble kkc_bigram_language_model_bigram_backoff_cost (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
void kkc_unigram_trellis_node_get_entry (KkcUnigramTrellisNode* self, KkcLanguageModelEntry * result);
static KkcSegment* kkc_bigram_decoder_nbest_node_to_segment (KkcBigramDecoder* self, KkcNbestNode* nbest_node);
KkcLanguageModelEntry* kkc_trellis_node_get_entries (KkcTrellisNode* self, int* result_length1);
KkcSegment* kkc_segment_new (const gchar* input, const gchar* output);
KkcSegment* kkc_segment_construct (GType object_type, const gchar* input, const gchar* output);
static gboolean _kkc_language_model_entry_equal (const KkcLanguageModelEntry * s1, const KkcLanguageModelEntry * s2);
static gint kkc_bigram_decoder_compare_nbest_node (KkcNbestNode* a, KkcNbestNode* b);
static gint _kkc_bigram_decoder_compare_nbest_node_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gchar* kkc_bigram_decoder_concat_nbest_node_outputs (KkcBigramDecoder* self, KkcNbestNode* nbest_node);
guint kkc_trellis_node_get_endpos (KkcTrellisNode* self);
const gchar* kkc_trellis_node_get_output (KkcTrellisNode* self);
KkcBigramDecoder* kkc_bigram_decoder_new (KkcBigramLanguageModel* model);
KkcBigramDecoder* kkc_bigram_decoder_construct (GType object_type, KkcBigramLanguageModel* model);
KkcDecoder* kkc_decoder_construct (GType object_type);
static void kkc_bigram_decoder_finalize (GObject * obj);
static void _vala_kkc_bigram_decoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _kkc_trellis_node_ref0 (gpointer self) {
	return self ? kkc_trellis_node_ref (self) : NULL;
}


KkcNbestNode* kkc_nbest_node_construct (GType object_type, KkcTrellisNode* node) {
	KkcNbestNode* self = NULL;
	KkcTrellisNode* _tmp0_;
	KkcTrellisNode* _tmp1_;
	g_return_val_if_fail (node != NULL, NULL);
	self = (KkcNbestNode*) g_type_create_instance (object_type);
	_tmp0_ = node;
	_tmp1_ = _kkc_trellis_node_ref0 (_tmp0_);
	_kkc_trellis_node_unref0 (self->node);
	self->node = _tmp1_;
	return self;
}


KkcNbestNode* kkc_nbest_node_new (KkcTrellisNode* node) {
	return kkc_nbest_node_construct (KKC_TYPE_NBEST_NODE, node);
}


static void kkc_value_nbest_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void kkc_value_nbest_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		kkc_nbest_node_unref (value->data[0].v_pointer);
	}
}


static void kkc_value_nbest_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = kkc_nbest_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer kkc_value_nbest_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* kkc_value_nbest_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		KkcNbestNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = kkc_nbest_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* kkc_value_nbest_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	KkcNbestNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = kkc_nbest_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* kkc_param_spec_nbest_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	KkcParamSpecNbestNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, KKC_TYPE_NBEST_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer kkc_value_get_nbest_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KKC_TYPE_NBEST_NODE), NULL);
	return value->data[0].v_pointer;
}


void kkc_value_set_nbest_node (GValue* value, gpointer v_object) {
	KkcNbestNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KKC_TYPE_NBEST_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KKC_TYPE_NBEST_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		kkc_nbest_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		kkc_nbest_node_unref (old);
	}
}


void kkc_value_take_nbest_node (GValue* value, gpointer v_object) {
	KkcNbestNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KKC_TYPE_NBEST_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KKC_TYPE_NBEST_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		kkc_nbest_node_unref (old);
	}
}


static void kkc_nbest_node_class_init (KkcNbestNodeClass * klass) {
	kkc_nbest_node_parent_class = g_type_class_peek_parent (klass);
	((KkcNbestNodeClass *) klass)->finalize = kkc_nbest_node_finalize;
}


static void kkc_nbest_node_instance_init (KkcNbestNode * self) {
	self->gn = 0.0;
	self->fn = DBL_MAX;
	self->ref_count = 1;
}


static void kkc_nbest_node_finalize (KkcNbestNode * obj) {
	KkcNbestNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_NBEST_NODE, KkcNbestNode);
	g_signal_handlers_destroy (self);
	_kkc_trellis_node_unref0 (self->node);
	_kkc_nbest_node_unref0 (self->next);
}


GType kkc_nbest_node_get_type (void) {
	static volatile gsize kkc_nbest_node_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_nbest_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { kkc_value_nbest_node_init, kkc_value_nbest_node_free_value, kkc_value_nbest_node_copy_value, kkc_value_nbest_node_peek_pointer, "p", kkc_value_nbest_node_collect_value, "p", kkc_value_nbest_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (KkcNbestNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_nbest_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcNbestNode), 0, (GInstanceInitFunc) kkc_nbest_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType kkc_nbest_node_type_id;
		kkc_nbest_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KkcNbestNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&kkc_nbest_node_type_id__volatile, kkc_nbest_node_type_id);
	}
	return kkc_nbest_node_type_id__volatile;
}


gpointer kkc_nbest_node_ref (gpointer instance) {
	KkcNbestNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void kkc_nbest_node_unref (gpointer instance) {
	KkcNbestNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		KKC_NBEST_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static KkcSegment** kkc_bigram_decoder_real_decode (KkcDecoder* base, const gchar* input, gint nbest, gint* constraint, int constraint_length1, int* result_length1) {
	KkcBigramDecoder * self;
	KkcSegment** result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	KkcSegment** _tmp4_;
	KkcSegment** _tmp5_;
	gint _tmp5__length1;
	self = (KkcBigramDecoder*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = nbest;
	_tmp2_ = constraint;
	_tmp2__length1 = constraint_length1;
	_tmp4_ = kkc_decoder_decode_with_costs ((KkcDecoder*) self, _tmp0_, _tmp1_, _tmp2_, _tmp2__length1, DBL_MAX, -DBL_MAX, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}


static KkcSegment** kkc_bigram_decoder_real_decode_with_costs (KkcDecoder* base, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1) {
	KkcBigramDecoder * self;
	KkcSegment** result = NULL;
	GeeArrayList** trellis = NULL;
	const gchar* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GeeArrayList** _tmp3_;
	gint trellis_length1;
	gint _trellis_size_;
	GeeArrayList** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	GeeArrayList** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	KkcSegment** segments = NULL;
	GeeArrayList** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gint _tmp13_;
	KkcSegment** _tmp14_;
	gint segments_length1;
	gint _segments_size_;
	KkcSegment** _tmp22_;
	gint _tmp22__length1;
	self = (KkcBigramDecoder*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = constraint;
	_tmp1__length1 = constraint_length1;
	_tmp3_ = kkc_bigram_decoder_build_trellis (self, _tmp0_, _tmp1_, _tmp1__length1, &_tmp2_);
	trellis = _tmp3_;
	trellis_length1 = _tmp2_;
	_trellis_size_ = trellis_length1;
	_tmp4_ = trellis;
	_tmp4__length1 = trellis_length1;
	_tmp5_ = input;
	_tmp6_ = constraint;
	_tmp6__length1 = constraint_length1;
	kkc_bigram_decoder_add_unknown_nodes (self, _tmp4_, _tmp4__length1, _tmp5_, _tmp6_, _tmp6__length1);
	_tmp7_ = trellis;
	_tmp7__length1 = trellis_length1;
	_tmp8_ = input;
	kkc_bigram_decoder_forward_search (self, _tmp7_, _tmp7__length1, _tmp8_);
	_tmp9_ = trellis;
	_tmp9__length1 = trellis_length1;
	_tmp10_ = nbest;
	_tmp11_ = max_distance;
	_tmp12_ = min_path_cost;
	_tmp14_ = kkc_bigram_decoder_backward_search (self, _tmp9_, _tmp9__length1, _tmp10_, _tmp11_, _tmp12_, &_tmp13_);
	segments = _tmp14_;
	segments_length1 = _tmp13_;
	_segments_size_ = segments_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				GeeArrayList** _tmp18_;
				gint _tmp18__length1;
				GeeArrayList** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				GeeArrayList* _tmp21_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = trellis;
				_tmp18__length1 = trellis_length1;
				if (!(_tmp17_ < _tmp18__length1)) {
					break;
				}
				_tmp19_ = trellis;
				_tmp19__length1 = trellis_length1;
				_tmp20_ = i;
				_tmp21_ = _tmp19_[_tmp20_];
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp21_);
			}
		}
	}
	_tmp22_ = segments;
	_tmp22__length1 = segments_length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	trellis = (_vala_array_free (trellis, trellis_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


void kkc_bigram_decoder_add_unknown_nodes (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, const gchar* input, gint* constraint, int constraint_length1) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GeeArrayList** _tmp3_;
				gint _tmp3__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = trellis;
				_tmp3__length1 = trellis_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				{
					gint j = 0;
					gint _tmp4_;
					_tmp4_ = i;
					j = _tmp4_;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_ = FALSE;
							gint _tmp8_;
							GeeArrayList** _tmp9_;
							gint _tmp9__length1;
							gint* _tmp15_;
							gint _tmp15__length1;
							gint _tmp16_;
							gint _tmp17_;
							gboolean _tmp18_;
							glong offset = 0L;
							const gchar* _tmp19_;
							gint _tmp20_;
							gint _tmp21_;
							glong length = 0L;
							const gchar* _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							glong _tmp25_;
							gchar* _input = NULL;
							const gchar* _tmp26_;
							glong _tmp27_;
							glong _tmp28_;
							gchar* _tmp29_;
							KkcLanguageModelEntry entry = {0};
							const gchar* _tmp30_;
							gchar* _tmp31_;
							const gchar* _tmp32_;
							gchar* _tmp33_;
							KkcLanguageModelEntry _tmp34_ = {0};
							KkcUnigramTrellisNode* node = NULL;
							KkcLanguageModelEntry _tmp35_;
							gint _tmp36_;
							KkcUnigramTrellisNode* _tmp37_;
							GeeArrayList** _tmp38_;
							gint _tmp38__length1;
							gint _tmp39_;
							GeeArrayList* _tmp40_;
							KkcUnigramTrellisNode* _tmp41_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = j;
							_tmp9_ = trellis;
							_tmp9__length1 = trellis_length1;
							if (_tmp8_ < _tmp9__length1) {
								GeeArrayList** _tmp10_;
								gint _tmp10__length1;
								gint _tmp11_;
								GeeArrayList* _tmp12_;
								gboolean _tmp13_;
								gboolean _tmp14_;
								_tmp10_ = trellis;
								_tmp10__length1 = trellis_length1;
								_tmp11_ = j;
								_tmp12_ = _tmp10_[_tmp11_];
								_tmp13_ = gee_collection_get_is_empty ((GeeCollection*) _tmp12_);
								_tmp14_ = _tmp13_;
								_tmp7_ = _tmp14_;
							} else {
								_tmp7_ = FALSE;
							}
							if (!_tmp7_) {
								break;
							}
							_tmp15_ = constraint;
							_tmp15__length1 = constraint_length1;
							_tmp16_ = i;
							_tmp17_ = j;
							_tmp18_ = kkc_bigram_decoder_check_overlaps (self, _tmp15_, _tmp15__length1, _tmp16_, _tmp17_);
							if (!_tmp18_) {
								continue;
							}
							_tmp19_ = input;
							_tmp20_ = i;
							_tmp21_ = string_index_of_nth_char (_tmp19_, (glong) (_tmp20_ - 1));
							offset = (glong) _tmp21_;
							_tmp22_ = input;
							_tmp23_ = j;
							_tmp24_ = string_index_of_nth_char (_tmp22_, (glong) _tmp23_);
							_tmp25_ = offset;
							length = _tmp24_ - _tmp25_;
							_tmp26_ = input;
							_tmp27_ = offset;
							_tmp28_ = length;
							_tmp29_ = string_substring (_tmp26_, _tmp27_, _tmp28_);
							_input = _tmp29_;
							_tmp30_ = _input;
							_tmp31_ = g_strdup (_tmp30_);
							_tmp32_ = _input;
							_tmp33_ = g_strdup (_tmp32_);
							_g_free0 (_tmp34_.input);
							_tmp34_.input = _tmp31_;
							_g_free0 (_tmp34_.output);
							_tmp34_.output = _tmp33_;
							_tmp34_.id = (guint) 2;
							entry = _tmp34_;
							_tmp35_ = entry;
							_tmp36_ = j;
							_tmp37_ = kkc_unigram_trellis_node_new (&_tmp35_, (guint) _tmp36_);
							node = _tmp37_;
							_tmp38_ = trellis;
							_tmp38__length1 = trellis_length1;
							_tmp39_ = j;
							_tmp40_ = _tmp38_[_tmp39_];
							_tmp41_ = node;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, (KkcTrellisNode*) _tmp41_);
							_kkc_trellis_node_unref0 (node);
							kkc_language_model_entry_destroy (&entry);
							_g_free0 (_input);
						}
					}
				}
			}
		}
	}
}


GeeArrayList** kkc_bigram_decoder_build_trellis (KkcBigramDecoder* self, const gchar* input, gint* constraint, int constraint_length1, int* result_length1) {
	GeeArrayList** result = NULL;
	gint length = 0;
	const gchar* _tmp0_;
	gint _tmp1_;
	GeeArrayList** trellis = NULL;
	gint _tmp2_;
	GeeArrayList** _tmp3_;
	gint trellis_length1;
	gint _trellis_size_;
	KkcUnigramTrellisNode* bos_node = NULL;
	KkcBigramLanguageModel* _tmp12_;
	KkcBigramLanguageModel* _tmp13_;
	KkcLanguageModelEntry _tmp14_ = {0};
	KkcLanguageModelEntry _tmp15_;
	KkcUnigramTrellisNode* _tmp16_;
	GeeArrayList** _tmp17_;
	gint _tmp17__length1;
	GeeArrayList* _tmp18_;
	KkcUnigramTrellisNode* _tmp19_;
	KkcUnigramTrellisNode* eos_node = NULL;
	KkcBigramLanguageModel* _tmp20_;
	KkcBigramLanguageModel* _tmp21_;
	KkcLanguageModelEntry _tmp22_ = {0};
	KkcLanguageModelEntry _tmp23_;
	gint _tmp24_;
	KkcUnigramTrellisNode* _tmp25_;
	GeeArrayList** _tmp26_;
	gint _tmp26__length1;
	gint _tmp27_;
	GeeArrayList* _tmp28_;
	KkcUnigramTrellisNode* _tmp29_;
	GeeArrayList** _tmp66_;
	gint _tmp66__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = g_utf8_strlen (_tmp0_, (gssize) -1);
	length = _tmp1_;
	_tmp2_ = length;
	_tmp3_ = g_new0 (GeeArrayList*, (_tmp2_ + 2) + 1);
	trellis = _tmp3_;
	trellis_length1 = _tmp2_ + 2;
	_trellis_size_ = trellis_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				GeeArrayList** _tmp7_;
				gint _tmp7__length1;
				GeeArrayList** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = trellis;
				_tmp7__length1 = trellis_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = trellis;
				_tmp8__length1 = trellis_length1;
				_tmp9_ = i;
				_tmp10_ = gee_array_list_new (KKC_TYPE_TRELLIS_NODE, (GBoxedCopyFunc) kkc_trellis_node_ref, (GDestroyNotify) kkc_trellis_node_unref, NULL, NULL, NULL);
				_g_object_unref0 (_tmp8_[_tmp9_]);
				_tmp8_[_tmp9_] = _tmp10_;
				_tmp11_ = _tmp8_[_tmp9_];
			}
		}
	}
	_tmp12_ = kkc_bigram_decoder_get_model (self);
	_tmp13_ = _tmp12_;
	kkc_language_model_get_bos ((KkcLanguageModel*) _tmp13_, &_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp16_ = kkc_unigram_trellis_node_new (&_tmp15_, (guint) 1);
	bos_node = _tmp16_;
	_tmp17_ = trellis;
	_tmp17__length1 = trellis_length1;
	_tmp18_ = _tmp17_[0];
	_tmp19_ = bos_node;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (KkcTrellisNode*) _tmp19_);
	_tmp20_ = kkc_bigram_decoder_get_model (self);
	_tmp21_ = _tmp20_;
	kkc_language_model_get_eos ((KkcLanguageModel*) _tmp21_, &_tmp22_);
	_tmp23_ = _tmp22_;
	_tmp24_ = length;
	_tmp25_ = kkc_unigram_trellis_node_new (&_tmp23_, (guint) (_tmp24_ + 1));
	eos_node = _tmp25_;
	_tmp26_ = trellis;
	_tmp26__length1 = trellis_length1;
	_tmp27_ = length;
	_tmp28_ = _tmp26_[_tmp27_ + 1];
	_tmp29_ = eos_node;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (KkcTrellisNode*) _tmp29_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				glong byte_offset = 0L;
				const gchar* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gchar* _input = NULL;
				const gchar* _tmp37_;
				glong _tmp38_;
				gchar* _tmp39_;
				GeeCollection* entries = NULL;
				KkcBigramLanguageModel* _tmp40_;
				KkcBigramLanguageModel* _tmp41_;
				const gchar* _tmp42_;
				GeeCollection* _tmp43_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp32_ = i;
				_tmp33_ = length;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = input;
				_tmp35_ = i;
				_tmp36_ = string_index_of_nth_char (_tmp34_, (glong) _tmp35_);
				byte_offset = (glong) _tmp36_;
				_tmp37_ = input;
				_tmp38_ = byte_offset;
				_tmp39_ = string_substring (_tmp37_, _tmp38_, (glong) -1);
				_input = _tmp39_;
				_tmp40_ = kkc_bigram_decoder_get_model (self);
				_tmp41_ = _tmp40_;
				_tmp42_ = _input;
				_tmp43_ = kkc_language_model_entries ((KkcLanguageModel*) _tmp41_, _tmp42_);
				entries = _tmp43_;
				{
					GeeIterator* _entry_it = NULL;
					GeeCollection* _tmp44_;
					GeeIterator* _tmp45_;
					_tmp44_ = entries;
					_tmp45_ = gee_iterable_iterator ((GeeIterable*) _tmp44_);
					_entry_it = _tmp45_;
					while (TRUE) {
						GeeIterator* _tmp46_;
						gboolean _tmp47_;
						KkcLanguageModelEntry* entry = NULL;
						GeeIterator* _tmp48_;
						gpointer _tmp49_;
						gint j = 0;
						gint _tmp50_;
						KkcLanguageModelEntry* _tmp51_;
						const gchar* _tmp52_;
						gint _tmp53_;
						gint* _tmp54_;
						gint _tmp54__length1;
						gint _tmp55_;
						gint _tmp56_;
						gboolean _tmp57_;
						KkcUnigramTrellisNode* node = NULL;
						KkcLanguageModelEntry* _tmp58_;
						gint _tmp59_;
						KkcLanguageModelEntry _tmp60_;
						KkcUnigramTrellisNode* _tmp61_;
						GeeArrayList** _tmp62_;
						gint _tmp62__length1;
						gint _tmp63_;
						GeeArrayList* _tmp64_;
						KkcUnigramTrellisNode* _tmp65_;
						_tmp46_ = _entry_it;
						_tmp47_ = gee_iterator_next (_tmp46_);
						if (!_tmp47_) {
							break;
						}
						_tmp48_ = _entry_it;
						_tmp49_ = gee_iterator_get (_tmp48_);
						entry = (KkcLanguageModelEntry*) _tmp49_;
						_tmp50_ = i;
						_tmp51_ = entry;
						_tmp52_ = (*_tmp51_).input;
						_tmp53_ = g_utf8_strlen (_tmp52_, (gssize) -1);
						j = _tmp50_ + _tmp53_;
						_tmp54_ = constraint;
						_tmp54__length1 = constraint_length1;
						_tmp55_ = i;
						_tmp56_ = j;
						_tmp57_ = kkc_bigram_decoder_check_constraint (self, _tmp54_, _tmp54__length1, _tmp55_, _tmp56_);
						if (!_tmp57_) {
							_kkc_language_model_entry_free0 (entry);
							continue;
						}
						_tmp58_ = entry;
						_tmp59_ = j;
						_tmp60_ = *_tmp58_;
						_tmp61_ = kkc_unigram_trellis_node_new (&_tmp60_, (guint) _tmp59_);
						node = _tmp61_;
						_tmp62_ = trellis;
						_tmp62__length1 = trellis_length1;
						_tmp63_ = j;
						_tmp64_ = _tmp62_[_tmp63_];
						_tmp65_ = node;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, (KkcTrellisNode*) _tmp65_);
						_kkc_trellis_node_unref0 (node);
						_kkc_language_model_entry_free0 (entry);
					}
					_g_object_unref0 (_entry_it);
				}
				_g_object_unref0 (entries);
				_g_free0 (_input);
			}
		}
	}
	_tmp66_ = trellis;
	_tmp66__length1 = trellis_length1;
	if (result_length1) {
		*result_length1 = _tmp66__length1;
	}
	result = _tmp66_;
	_kkc_trellis_node_unref0 (eos_node);
	_kkc_trellis_node_unref0 (bos_node);
	return result;
}


static gboolean kkc_bigram_decoder_check_constraint (KkcBigramDecoder* self, gint* constraint, int constraint_length1, gint i, gint j) {
	gboolean result = FALSE;
	gint last_c = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	last_c = 0;
	_tmp0_ = constraint;
	_tmp0__length1 = constraint_length1;
	{
		gint* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < _tmp0__length1; c_it = c_it + 1) {
			gint c = 0;
			c = c_collection[c_it];
			{
				gboolean _tmp1_ = FALSE;
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp6_;
				_tmp2_ = i;
				_tmp3_ = last_c;
				if (_tmp2_ == _tmp3_) {
					gint _tmp4_;
					gint _tmp5_;
					_tmp4_ = j;
					_tmp5_ = c;
					_tmp1_ = _tmp4_ == _tmp5_;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					result = TRUE;
					return result;
				}
				_tmp6_ = c;
				last_c = _tmp6_;
			}
		}
	}
	_tmp7_ = i;
	_tmp8_ = last_c;
	result = _tmp7_ >= _tmp8_;
	return result;
}


static gboolean kkc_bigram_decoder_check_overlaps (KkcBigramDecoder* self, gint* constraint, int constraint_length1, gint i, gint j) {
	gboolean result = FALSE;
	gint last_c = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp13_;
	gint _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	last_c = 0;
	_tmp0_ = constraint;
	_tmp0__length1 = constraint_length1;
	{
		gint* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < _tmp0__length1; c_it = c_it + 1) {
			gint c = 0;
			c = c_collection[c_it];
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp12_;
				_tmp3_ = last_c;
				_tmp4_ = i;
				if (_tmp3_ <= _tmp4_) {
					gint _tmp5_;
					gint _tmp6_;
					_tmp5_ = i;
					_tmp6_ = c;
					_tmp2_ = _tmp5_ <= _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gboolean _tmp7_ = FALSE;
					gint _tmp8_;
					gint _tmp9_;
					_tmp8_ = last_c;
					_tmp9_ = j;
					if (_tmp8_ <= _tmp9_) {
						gint _tmp10_;
						gint _tmp11_;
						_tmp10_ = j;
						_tmp11_ = c;
						_tmp7_ = _tmp10_ <= _tmp11_;
					} else {
						_tmp7_ = FALSE;
					}
					_tmp1_ = _tmp7_;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					result = TRUE;
					return result;
				}
				_tmp12_ = c;
				last_c = _tmp12_;
			}
		}
	}
	_tmp13_ = i;
	_tmp14_ = last_c;
	result = _tmp13_ >= _tmp14_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void kkc_bigram_decoder_forward_search (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, const gchar* input) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GeeArrayList** _tmp3_;
				gint _tmp3__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = trellis;
				_tmp3__length1 = trellis_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				{
					GeeArrayList* _node_list = NULL;
					GeeArrayList** _tmp4_;
					gint _tmp4__length1;
					gint _tmp5_;
					GeeArrayList* _tmp6_;
					GeeArrayList* _tmp7_;
					gint _node_size = 0;
					GeeArrayList* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					gint _node_index = 0;
					_tmp4_ = trellis;
					_tmp4__length1 = trellis_length1;
					_tmp5_ = i;
					_tmp6_ = _tmp4_[_tmp5_];
					_tmp7_ = _g_object_ref0 (_tmp6_);
					_node_list = _tmp7_;
					_tmp8_ = _node_list;
					_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
					_tmp10_ = _tmp9_;
					_node_size = _tmp10_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp11_;
						gint _tmp12_;
						gint _tmp13_;
						KkcTrellisNode* node = NULL;
						GeeArrayList* _tmp14_;
						gint _tmp15_;
						gpointer _tmp16_;
						gint j = 0;
						gint _tmp17_;
						KkcTrellisNode* _tmp18_;
						guint _tmp19_;
						guint _tmp20_;
						gint _tmp21_;
						gdouble max_cost = 0.0;
						KkcTrellisNode* max_pnode = NULL;
						KkcTrellisNode* _tmp46_;
						KkcTrellisNode* _tmp51_;
						gdouble _tmp52_;
						KkcTrellisNode* _tmp53_;
						KkcTrellisNode* _tmp54_;
						KkcTrellisNode* _tmp55_;
						_tmp11_ = _node_index;
						_node_index = _tmp11_ + 1;
						_tmp12_ = _node_index;
						_tmp13_ = _node_size;
						if (!(_tmp12_ < _tmp13_)) {
							break;
						}
						_tmp14_ = _node_list;
						_tmp15_ = _node_index;
						_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
						node = (KkcTrellisNode*) _tmp16_;
						_tmp17_ = i;
						_tmp18_ = node;
						_tmp19_ = kkc_trellis_node_get_length (_tmp18_);
						_tmp20_ = _tmp19_;
						j = _tmp17_ - ((gint) _tmp20_);
						_tmp21_ = j;
						if (_tmp21_ < 0) {
							_kkc_trellis_node_unref0 (node);
							continue;
						}
						max_cost = -DBL_MAX;
						max_pnode = NULL;
						{
							GeeArrayList* _pnode_list = NULL;
							GeeArrayList** _tmp22_;
							gint _tmp22__length1;
							gint _tmp23_;
							GeeArrayList* _tmp24_;
							GeeArrayList* _tmp25_;
							gint _pnode_size = 0;
							GeeArrayList* _tmp26_;
							gint _tmp27_;
							gint _tmp28_;
							gint _pnode_index = 0;
							_tmp22_ = trellis;
							_tmp22__length1 = trellis_length1;
							_tmp23_ = j;
							_tmp24_ = _tmp22_[_tmp23_];
							_tmp25_ = _g_object_ref0 (_tmp24_);
							_pnode_list = _tmp25_;
							_tmp26_ = _pnode_list;
							_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
							_tmp28_ = _tmp27_;
							_pnode_size = _tmp28_;
							_pnode_index = -1;
							while (TRUE) {
								gint _tmp29_;
								gint _tmp30_;
								gint _tmp31_;
								KkcTrellisNode* pnode = NULL;
								GeeArrayList* _tmp32_;
								gint _tmp33_;
								gpointer _tmp34_;
								gdouble cost = 0.0;
								KkcTrellisNode* _tmp35_;
								gdouble _tmp36_;
								KkcTrellisNode* _tmp37_;
								KkcTrellisNode* _tmp38_;
								gint _tmp39_;
								gdouble _tmp40_;
								gdouble _tmp41_;
								gdouble _tmp42_;
								_tmp29_ = _pnode_index;
								_pnode_index = _tmp29_ + 1;
								_tmp30_ = _pnode_index;
								_tmp31_ = _pnode_size;
								if (!(_tmp30_ < _tmp31_)) {
									break;
								}
								_tmp32_ = _pnode_list;
								_tmp33_ = _pnode_index;
								_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
								pnode = (KkcTrellisNode*) _tmp34_;
								_tmp35_ = pnode;
								_tmp36_ = _tmp35_->cumulative_cost;
								_tmp37_ = pnode;
								_tmp38_ = node;
								_tmp39_ = j;
								_tmp40_ = kkc_bigram_decoder_path_cost (self, _tmp37_, _tmp38_, _tmp39_);
								cost = _tmp36_ + _tmp40_;
								_tmp41_ = cost;
								_tmp42_ = max_cost;
								if (_tmp41_ > _tmp42_) {
									KkcTrellisNode* _tmp43_;
									KkcTrellisNode* _tmp44_;
									gdouble _tmp45_;
									_tmp43_ = pnode;
									_tmp44_ = _kkc_trellis_node_ref0 (_tmp43_);
									_kkc_trellis_node_unref0 (max_pnode);
									max_pnode = _tmp44_;
									_tmp45_ = cost;
									max_cost = _tmp45_;
								}
								_kkc_trellis_node_unref0 (pnode);
							}
							_g_object_unref0 (_pnode_list);
						}
						_tmp46_ = max_pnode;
						if (_tmp46_ == NULL) {
							GeeArrayList** _tmp47_;
							gint _tmp47__length1;
							gint _tmp48_;
							GeeArrayList* _tmp49_;
							gpointer _tmp50_;
							_tmp47_ = trellis;
							_tmp47__length1 = trellis_length1;
							_tmp48_ = i;
							_tmp49_ = _tmp47_[_tmp48_];
							_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, 0);
							_kkc_trellis_node_unref0 (max_pnode);
							max_pnode = (KkcTrellisNode*) _tmp50_;
						}
						_tmp51_ = node;
						_tmp52_ = max_cost;
						_tmp51_->cumulative_cost = _tmp52_;
						_tmp53_ = node;
						_tmp54_ = max_pnode;
						_tmp55_ = _kkc_trellis_node_ref0 (_tmp54_);
						_kkc_trellis_node_unref0 (_tmp53_->previous);
						_tmp53_->previous = _tmp55_;
						_kkc_trellis_node_unref0 (max_pnode);
						_kkc_trellis_node_unref0 (node);
					}
					_g_object_unref0 (_node_list);
				}
			}
		}
	}
}


static gdouble kkc_bigram_decoder_real_path_cost (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos) {
	gdouble result = 0.0;
	KkcUnigramTrellisNode* upnode = NULL;
	KkcTrellisNode* _tmp0_;
	KkcUnigramTrellisNode* _tmp1_;
	KkcUnigramTrellisNode* unode = NULL;
	KkcTrellisNode* _tmp2_;
	KkcUnigramTrellisNode* _tmp3_;
	gboolean _tmp4_ = FALSE;
	KkcUnigramTrellisNode* _tmp5_;
	KkcBigramLanguageModel* _tmp7_;
	KkcBigramLanguageModel* _tmp8_;
	KkcUnigramTrellisNode* _tmp9_;
	KkcLanguageModelEntry _tmp10_ = {0};
	KkcLanguageModelEntry _tmp11_;
	KkcUnigramTrellisNode* _tmp12_;
	KkcLanguageModelEntry _tmp13_ = {0};
	KkcLanguageModelEntry _tmp14_;
	gdouble _tmp15_;
	g_return_val_if_fail (pnode != NULL, 0.0);
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = pnode;
	_tmp1_ = _kkc_trellis_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_UNIGRAM_TRELLIS_NODE) ? ((KkcUnigramTrellisNode*) _tmp0_) : NULL);
	upnode = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = _kkc_trellis_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, KKC_TYPE_UNIGRAM_TRELLIS_NODE) ? ((KkcUnigramTrellisNode*) _tmp2_) : NULL);
	unode = _tmp3_;
	_tmp5_ = upnode;
	if (_tmp5_ != NULL) {
		KkcUnigramTrellisNode* _tmp6_;
		_tmp6_ = unode;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	_vala_assert (_tmp4_, "upnode != null && unode != null");
	_tmp7_ = kkc_bigram_decoder_get_model (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = upnode;
	kkc_unigram_trellis_node_get_entry (_tmp9_, &_tmp10_);
	_tmp11_ = _tmp10_;
	_tmp12_ = unode;
	kkc_unigram_trellis_node_get_entry (_tmp12_, &_tmp13_);
	_tmp14_ = _tmp13_;
	_tmp15_ = kkc_bigram_language_model_bigram_backoff_cost (_tmp8_, &_tmp11_, &_tmp14_);
	result = _tmp15_;
	_kkc_trellis_node_unref0 (unode);
	_kkc_trellis_node_unref0 (upnode);
	return result;
}


gdouble kkc_bigram_decoder_path_cost (KkcBigramDecoder* self, KkcTrellisNode* pnode, KkcTrellisNode* node, gint endpos) {
	g_return_val_if_fail (self != NULL, 0.0);
	return KKC_BIGRAM_DECODER_GET_CLASS (self)->path_cost (self, pnode, node, endpos);
}


static KkcSegment* kkc_bigram_decoder_nbest_node_to_segment (KkcBigramDecoder* self, KkcNbestNode* nbest_node) {
	KkcSegment* result = NULL;
	KkcSegment* start_segment = NULL;
	KkcSegment* previous_segment = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nbest_node != NULL, NULL);
	start_segment = NULL;
	previous_segment = NULL;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			KkcNbestNode* _tmp3_;
			KkcNbestNode* _tmp4_;
			if (!_tmp0_) {
				KkcNbestNode* _tmp1_;
				KkcNbestNode* _tmp2_;
				_tmp1_ = nbest_node;
				_tmp2_ = _tmp1_->next;
				nbest_node = _tmp2_;
			}
			_tmp0_ = FALSE;
			_tmp3_ = nbest_node;
			_tmp4_ = _tmp3_->next;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp5_ = FALSE;
					_tmp5_ = TRUE;
					while (TRUE) {
						gint _tmp7_;
						KkcNbestNode* _tmp8_;
						KkcTrellisNode* _tmp9_;
						KkcLanguageModelEntry* _tmp10_;
						gint _tmp10__length1;
						KkcLanguageModelEntry* _tmp11_;
						gint _tmp11__length1;
						KkcLanguageModelEntry entry = {0};
						KkcNbestNode* _tmp12_;
						KkcTrellisNode* _tmp13_;
						KkcLanguageModelEntry* _tmp14_;
						gint _tmp14__length1;
						KkcLanguageModelEntry* _tmp15_;
						gint _tmp15__length1;
						gint _tmp16_;
						KkcLanguageModelEntry _tmp17_;
						KkcLanguageModelEntry _tmp18_ = {0};
						KkcSegment* segment = NULL;
						KkcLanguageModelEntry _tmp19_;
						const gchar* _tmp20_;
						KkcLanguageModelEntry _tmp21_;
						const gchar* _tmp22_;
						KkcSegment* _tmp23_;
						KkcSegment* _tmp24_;
						KkcSegment* _tmp27_;
						KkcSegment* _tmp31_;
						KkcSegment* _tmp32_;
						if (!_tmp5_) {
							gint _tmp6_;
							_tmp6_ = i;
							i = _tmp6_ + 1;
						}
						_tmp5_ = FALSE;
						_tmp7_ = i;
						_tmp8_ = nbest_node;
						_tmp9_ = _tmp8_->node;
						_tmp10_ = kkc_trellis_node_get_entries (_tmp9_, &_tmp10__length1);
						_tmp11_ = _tmp10_;
						_tmp11__length1 = _tmp10__length1;
						if (!(_tmp7_ < _tmp11__length1)) {
							break;
						}
						_tmp12_ = nbest_node;
						_tmp13_ = _tmp12_->node;
						_tmp14_ = kkc_trellis_node_get_entries (_tmp13_, &_tmp14__length1);
						_tmp15_ = _tmp14_;
						_tmp15__length1 = _tmp14__length1;
						_tmp16_ = i;
						_tmp17_ = _tmp15_[_tmp16_];
						kkc_language_model_entry_copy (&_tmp17_, &_tmp18_);
						entry = _tmp18_;
						_tmp19_ = entry;
						_tmp20_ = _tmp19_.input;
						_tmp21_ = entry;
						_tmp22_ = _tmp21_.output;
						_tmp23_ = kkc_segment_new (_tmp20_, _tmp22_);
						segment = _tmp23_;
						_tmp24_ = start_segment;
						if (_tmp24_ == NULL) {
							KkcSegment* _tmp25_;
							KkcSegment* _tmp26_;
							_tmp25_ = segment;
							_tmp26_ = _g_object_ref0 (_tmp25_);
							_g_object_unref0 (start_segment);
							start_segment = _tmp26_;
						}
						_tmp27_ = previous_segment;
						if (_tmp27_ != NULL) {
							KkcSegment* _tmp28_;
							KkcSegment* _tmp29_;
							KkcSegment* _tmp30_;
							_tmp28_ = previous_segment;
							_tmp29_ = segment;
							_tmp30_ = _g_object_ref0 (_tmp29_);
							_g_object_unref0 (_tmp28_->next);
							_tmp28_->next = _tmp30_;
						}
						_tmp31_ = segment;
						_tmp32_ = _g_object_ref0 (_tmp31_);
						_g_object_unref0 (previous_segment);
						previous_segment = _tmp32_;
						_g_object_unref0 (segment);
						kkc_language_model_entry_destroy (&entry);
					}
				}
			}
		}
	}
	result = start_segment;
	_g_object_unref0 (previous_segment);
	return result;
}


static gboolean _kkc_language_model_entry_equal (const KkcLanguageModelEntry * s1, const KkcLanguageModelEntry * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (g_strcmp0 (s1->input, s2->input)) {
		return FALSE;
	}
	if (g_strcmp0 (s1->output, s2->output)) {
		return FALSE;
	}
	if (s1->id != s2->id) {
		return FALSE;
	}
	return TRUE;
}


static gint _kkc_bigram_decoder_compare_nbest_node_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = kkc_bigram_decoder_compare_nbest_node ((KkcNbestNode*) a, (KkcNbestNode*) b);
	return result;
}


static gpointer _kkc_nbest_node_ref0 (gpointer self) {
	return self ? kkc_nbest_node_ref (self) : NULL;
}


KkcSegment** kkc_bigram_decoder_backward_search (KkcBigramDecoder* self, GeeArrayList** trellis, int trellis_length1, gint nbest, gdouble max_distance, gdouble min_path_cost, int* result_length1) {
	KkcSegment** result = NULL;
	KkcTrellisNode* bos_trellis_node = NULL;
	GeeArrayList** _tmp0_;
	gint _tmp0__length1;
	GeeArrayList* _tmp1_;
	gpointer _tmp2_;
	KkcTrellisNode* eos_trellis_node = NULL;
	GeeArrayList** _tmp3_;
	gint _tmp3__length1;
	GeeArrayList** _tmp4_;
	gint _tmp4__length1;
	GeeArrayList* _tmp5_;
	gpointer _tmp6_;
	gint _tmp7_;
	GeeHashMap* trellis_nbest_map = NULL;
	GeeHashMap* _tmp47_;
	GeePriorityQueue* open_list = NULL;
	GeePriorityQueue* _tmp48_;
	GeePriorityQueue* close_list = NULL;
	GeePriorityQueue* _tmp49_;
	GeeHashSet* duplicates = NULL;
	GeeHashSet* _tmp50_;
	KkcNbestNode* eos_nbest_node = NULL;
	KkcTrellisNode* _tmp51_;
	KkcNbestNode* _tmp52_;
	GeeHashMap* _tmp53_;
	KkcTrellisNode* _tmp54_;
	KkcNbestNode* _tmp55_;
	GeePriorityQueue* _tmp56_;
	KkcNbestNode* _tmp57_;
	GeeArrayList* segments = NULL;
	GeeArrayList* _tmp144_;
	GeeArrayList* _tmp156_;
	gint _tmp157_;
	gpointer* _tmp158_;
	KkcSegment** _tmp159_;
	gint _tmp159__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = trellis;
	_tmp0__length1 = trellis_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, 0);
	bos_trellis_node = (KkcTrellisNode*) _tmp2_;
	_tmp3_ = trellis;
	_tmp3__length1 = trellis_length1;
	_tmp4_ = trellis;
	_tmp4__length1 = trellis_length1;
	_tmp5_ = _tmp3_[_tmp4__length1 - 1];
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, 0);
	eos_trellis_node = (KkcTrellisNode*) _tmp6_;
	_tmp7_ = nbest;
	if (_tmp7_ == 1) {
		KkcSegment* segment = NULL;
		KkcSegment* next_segment = NULL;
		KkcSegment* _tmp43_;
		KkcSegment* _tmp44_;
		KkcSegment** _tmp45_;
		KkcSegment** _tmp46_;
		gint _tmp46__length1;
		segment = NULL;
		next_segment = NULL;
		{
			KkcTrellisNode* node = NULL;
			KkcTrellisNode* _tmp8_;
			KkcTrellisNode* _tmp9_;
			KkcTrellisNode* _tmp10_;
			_tmp8_ = eos_trellis_node;
			_tmp9_ = _tmp8_->previous;
			_tmp10_ = _kkc_trellis_node_ref0 (_tmp9_);
			node = _tmp10_;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					KkcTrellisNode* _tmp15_;
					if (!_tmp11_) {
						KkcTrellisNode* _tmp12_;
						KkcTrellisNode* _tmp13_;
						KkcTrellisNode* _tmp14_;
						_tmp12_ = node;
						_tmp13_ = _tmp12_->previous;
						_tmp14_ = _kkc_trellis_node_ref0 (_tmp13_);
						_kkc_trellis_node_unref0 (node);
						node = _tmp14_;
					}
					_tmp11_ = FALSE;
					_tmp15_ = node;
					if (!(_tmp15_ != NULL)) {
						break;
					}
					{
						gint i = 0;
						KkcTrellisNode* _tmp16_;
						KkcLanguageModelEntry* _tmp17_;
						gint _tmp17__length1;
						KkcLanguageModelEntry* _tmp18_;
						gint _tmp18__length1;
						_tmp16_ = node;
						_tmp17_ = kkc_trellis_node_get_entries (_tmp16_, &_tmp17__length1);
						_tmp18_ = _tmp17_;
						_tmp18__length1 = _tmp17__length1;
						i = _tmp18__length1 - 1;
						{
							gboolean _tmp19_ = FALSE;
							_tmp19_ = TRUE;
							while (TRUE) {
								gint _tmp21_;
								KkcLanguageModelEntry entry = {0};
								KkcTrellisNode* _tmp22_;
								KkcLanguageModelEntry* _tmp23_;
								gint _tmp23__length1;
								KkcLanguageModelEntry* _tmp24_;
								gint _tmp24__length1;
								gint _tmp25_;
								KkcLanguageModelEntry _tmp26_;
								KkcLanguageModelEntry _tmp27_ = {0};
								KkcLanguageModelEntry _tmp28_;
								KkcBigramLanguageModel* _tmp29_;
								KkcBigramLanguageModel* _tmp30_;
								KkcLanguageModelEntry _tmp31_ = {0};
								KkcLanguageModelEntry _tmp32_;
								KkcLanguageModelEntry _tmp33_;
								const gchar* _tmp34_;
								KkcLanguageModelEntry _tmp35_;
								const gchar* _tmp36_;
								KkcSegment* _tmp37_;
								KkcSegment* _tmp38_;
								KkcSegment* _tmp39_;
								KkcSegment* _tmp40_;
								KkcSegment* _tmp41_;
								KkcSegment* _tmp42_;
								if (!_tmp19_) {
									gint _tmp20_;
									_tmp20_ = i;
									i = _tmp20_ - 1;
								}
								_tmp19_ = FALSE;
								_tmp21_ = i;
								if (!(_tmp21_ >= 0)) {
									break;
								}
								_tmp22_ = node;
								_tmp23_ = kkc_trellis_node_get_entries (_tmp22_, &_tmp23__length1);
								_tmp24_ = _tmp23_;
								_tmp24__length1 = _tmp23__length1;
								_tmp25_ = i;
								_tmp26_ = _tmp24_[_tmp25_];
								kkc_language_model_entry_copy (&_tmp26_, &_tmp27_);
								entry = _tmp27_;
								_tmp28_ = entry;
								_tmp29_ = kkc_bigram_decoder_get_model (self);
								_tmp30_ = _tmp29_;
								kkc_language_model_get_bos ((KkcLanguageModel*) _tmp30_, &_tmp31_);
								_tmp32_ = _tmp31_;
								if (_kkc_language_model_entry_equal (&_tmp28_, &_tmp32_) == TRUE) {
									kkc_language_model_entry_destroy (&entry);
									break;
								}
								_tmp33_ = entry;
								_tmp34_ = _tmp33_.input;
								_tmp35_ = entry;
								_tmp36_ = _tmp35_.output;
								_tmp37_ = kkc_segment_new (_tmp34_, _tmp36_);
								_g_object_unref0 (segment);
								segment = _tmp37_;
								_tmp38_ = segment;
								_tmp39_ = next_segment;
								_tmp40_ = _g_object_ref0 (_tmp39_);
								_g_object_unref0 (_tmp38_->next);
								_tmp38_->next = _tmp40_;
								_tmp41_ = segment;
								_tmp42_ = _g_object_ref0 (_tmp41_);
								_g_object_unref0 (next_segment);
								next_segment = _tmp42_;
								kkc_language_model_entry_destroy (&entry);
							}
						}
					}
				}
			}
			_kkc_trellis_node_unref0 (node);
		}
		_tmp43_ = segment;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		_tmp45_ = g_new0 (KkcSegment*, 1 + 1);
		_tmp45_[0] = _tmp44_;
		_tmp46_ = _tmp45_;
		_tmp46__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp46__length1;
		}
		result = _tmp46_;
		_g_object_unref0 (next_segment);
		_g_object_unref0 (segment);
		_kkc_trellis_node_unref0 (eos_trellis_node);
		_kkc_trellis_node_unref0 (bos_trellis_node);
		return result;
	}
	_tmp47_ = gee_hash_map_new (KKC_TYPE_TRELLIS_NODE, (GBoxedCopyFunc) kkc_trellis_node_ref, (GDestroyNotify) kkc_trellis_node_unref, KKC_TYPE_NBEST_NODE, (GBoxedCopyFunc) kkc_nbest_node_ref, (GDestroyNotify) kkc_nbest_node_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	trellis_nbest_map = _tmp47_;
	_tmp48_ = gee_priority_queue_new (KKC_TYPE_NBEST_NODE, (GBoxedCopyFunc) kkc_nbest_node_ref, (GDestroyNotify) kkc_nbest_node_unref, _kkc_bigram_decoder_compare_nbest_node_gcompare_data_func, NULL, NULL);
	open_list = _tmp48_;
	_tmp49_ = gee_priority_queue_new (KKC_TYPE_NBEST_NODE, (GBoxedCopyFunc) kkc_nbest_node_ref, (GDestroyNotify) kkc_nbest_node_unref, _kkc_bigram_decoder_compare_nbest_node_gcompare_data_func, NULL, NULL);
	close_list = _tmp49_;
	_tmp50_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	duplicates = _tmp50_;
	_tmp51_ = eos_trellis_node;
	_tmp52_ = kkc_nbest_node_new (_tmp51_);
	eos_nbest_node = _tmp52_;
	_tmp53_ = trellis_nbest_map;
	_tmp54_ = eos_trellis_node;
	_tmp55_ = eos_nbest_node;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp53_, _tmp54_, _tmp55_);
	_tmp56_ = open_list;
	_tmp57_ = eos_nbest_node;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp57_);
	while (TRUE) {
		GeePriorityQueue* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		KkcNbestNode* current_nbest_node = NULL;
		GeePriorityQueue* _tmp61_;
		gpointer _tmp62_;
		KkcNbestNode* _tmp63_;
		KkcTrellisNode* _tmp64_;
		KkcTrellisNode* _tmp65_;
		_tmp58_ = open_list;
		_tmp59_ = gee_collection_get_is_empty ((GeeCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		if (!(!_tmp60_)) {
			break;
		}
		_tmp61_ = open_list;
		_tmp62_ = gee_abstract_queue_poll ((GeeAbstractQueue*) _tmp61_);
		current_nbest_node = (KkcNbestNode*) _tmp62_;
		_tmp63_ = current_nbest_node;
		_tmp64_ = _tmp63_->node;
		_tmp65_ = bos_trellis_node;
		if (_tmp64_ == _tmp65_) {
			gchar* output = NULL;
			KkcNbestNode* _tmp66_;
			gchar* _tmp67_;
			GeeHashSet* _tmp68_;
			const gchar* _tmp69_;
			gboolean _tmp70_;
			_tmp66_ = current_nbest_node;
			_tmp67_ = kkc_bigram_decoder_concat_nbest_node_outputs (self, _tmp66_);
			output = _tmp67_;
			_tmp68_ = duplicates;
			_tmp69_ = output;
			_tmp70_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp68_, _tmp69_);
			if (!_tmp70_) {
				KkcTrellisNode* _tmp71_;
				gdouble _tmp72_;
				KkcNbestNode* _tmp73_;
				gdouble _tmp74_;
				gdouble _tmp75_;
				GeePriorityQueue* _tmp76_;
				KkcNbestNode* _tmp77_;
				GeePriorityQueue* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				GeeHashSet* _tmp82_;
				const gchar* _tmp83_;
				_tmp71_ = eos_trellis_node;
				_tmp72_ = _tmp71_->cumulative_cost;
				_tmp73_ = current_nbest_node;
				_tmp74_ = _tmp73_->fn;
				_tmp75_ = max_distance;
				if ((_tmp72_ - _tmp74_) > _tmp75_) {
					_g_free0 (output);
					_kkc_nbest_node_unref0 (current_nbest_node);
					break;
				}
				_tmp76_ = close_list;
				_tmp77_ = current_nbest_node;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, _tmp77_);
				_tmp78_ = close_list;
				_tmp79_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = nbest;
				if (_tmp80_ == _tmp81_) {
					_g_free0 (output);
					_kkc_nbest_node_unref0 (current_nbest_node);
					break;
				}
				_tmp82_ = duplicates;
				_tmp83_ = output;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp82_, _tmp83_);
			}
			_g_free0 (output);
		} else {
			KkcNbestNode* _tmp84_;
			KkcTrellisNode* _tmp85_;
			guint _tmp86_;
			guint _tmp87_;
			KkcNbestNode* _tmp88_;
			KkcTrellisNode* _tmp89_;
			guint _tmp90_;
			guint _tmp91_;
			_tmp84_ = current_nbest_node;
			_tmp85_ = _tmp84_->node;
			_tmp86_ = kkc_trellis_node_get_endpos (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = current_nbest_node;
			_tmp89_ = _tmp88_->node;
			_tmp90_ = kkc_trellis_node_get_length (_tmp89_);
			_tmp91_ = _tmp90_;
			if (_tmp87_ >= _tmp91_) {
				guint i = 0U;
				KkcNbestNode* _tmp92_;
				KkcTrellisNode* _tmp93_;
				guint _tmp94_;
				guint _tmp95_;
				KkcNbestNode* _tmp96_;
				KkcTrellisNode* _tmp97_;
				guint _tmp98_;
				guint _tmp99_;
				_tmp92_ = current_nbest_node;
				_tmp93_ = _tmp92_->node;
				_tmp94_ = kkc_trellis_node_get_endpos (_tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = current_nbest_node;
				_tmp97_ = _tmp96_->node;
				_tmp98_ = kkc_trellis_node_get_length (_tmp97_);
				_tmp99_ = _tmp98_;
				i = ((gint) _tmp95_) - _tmp99_;
				{
					GeeArrayList* _trellis_node_list = NULL;
					GeeArrayList** _tmp100_;
					gint _tmp100__length1;
					guint _tmp101_;
					GeeArrayList* _tmp102_;
					GeeArrayList* _tmp103_;
					gint _trellis_node_size = 0;
					GeeArrayList* _tmp104_;
					gint _tmp105_;
					gint _tmp106_;
					gint _trellis_node_index = 0;
					_tmp100_ = trellis;
					_tmp100__length1 = trellis_length1;
					_tmp101_ = i;
					_tmp102_ = _tmp100_[_tmp101_];
					_tmp103_ = _g_object_ref0 (_tmp102_);
					_trellis_node_list = _tmp103_;
					_tmp104_ = _trellis_node_list;
					_tmp105_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp104_);
					_tmp106_ = _tmp105_;
					_trellis_node_size = _tmp106_;
					_trellis_node_index = -1;
					while (TRUE) {
						gint _tmp107_;
						gint _tmp108_;
						gint _tmp109_;
						KkcTrellisNode* trellis_node = NULL;
						GeeArrayList* _tmp110_;
						gint _tmp111_;
						gpointer _tmp112_;
						KkcNbestNode* nbest_node = NULL;
						KkcTrellisNode* _tmp113_;
						KkcNbestNode* _tmp114_;
						gdouble cost = 0.0;
						KkcNbestNode* _tmp115_;
						KkcTrellisNode* _tmp116_;
						KkcNbestNode* _tmp117_;
						KkcTrellisNode* _tmp118_;
						guint _tmp119_;
						gdouble _tmp120_;
						gboolean _tmp121_ = FALSE;
						KkcTrellisNode* _tmp122_;
						KkcTrellisNode* _tmp123_;
						KkcNbestNode* _tmp126_;
						gdouble _tmp127_;
						KkcNbestNode* _tmp128_;
						gdouble _tmp129_;
						KkcNbestNode* _tmp130_;
						KkcNbestNode* _tmp131_;
						gdouble _tmp132_;
						KkcNbestNode* _tmp133_;
						KkcTrellisNode* _tmp134_;
						gdouble _tmp135_;
						KkcNbestNode* _tmp136_;
						KkcNbestNode* _tmp137_;
						KkcNbestNode* _tmp138_;
						GeeHashMap* _tmp139_;
						KkcTrellisNode* _tmp140_;
						KkcNbestNode* _tmp141_;
						GeePriorityQueue* _tmp142_;
						KkcNbestNode* _tmp143_;
						_tmp107_ = _trellis_node_index;
						_trellis_node_index = _tmp107_ + 1;
						_tmp108_ = _trellis_node_index;
						_tmp109_ = _trellis_node_size;
						if (!(_tmp108_ < _tmp109_)) {
							break;
						}
						_tmp110_ = _trellis_node_list;
						_tmp111_ = _trellis_node_index;
						_tmp112_ = gee_abstract_list_get ((GeeAbstractList*) _tmp110_, _tmp111_);
						trellis_node = (KkcTrellisNode*) _tmp112_;
						_tmp113_ = trellis_node;
						_tmp114_ = kkc_nbest_node_new (_tmp113_);
						nbest_node = _tmp114_;
						_tmp115_ = nbest_node;
						_tmp116_ = _tmp115_->node;
						_tmp117_ = current_nbest_node;
						_tmp118_ = _tmp117_->node;
						_tmp119_ = i;
						_tmp120_ = kkc_bigram_decoder_path_cost (self, _tmp116_, _tmp118_, (gint) _tmp119_);
						cost = _tmp120_;
						_tmp122_ = trellis_node;
						_tmp123_ = bos_trellis_node;
						if (_tmp122_ != _tmp123_) {
							gdouble _tmp124_;
							gdouble _tmp125_;
							_tmp124_ = cost;
							_tmp125_ = min_path_cost;
							_tmp121_ = _tmp124_ < _tmp125_;
						} else {
							_tmp121_ = FALSE;
						}
						if (_tmp121_) {
							_kkc_nbest_node_unref0 (nbest_node);
							_kkc_trellis_node_unref0 (trellis_node);
							continue;
						}
						_tmp126_ = nbest_node;
						_tmp127_ = cost;
						_tmp128_ = current_nbest_node;
						_tmp129_ = _tmp128_->gn;
						_tmp126_->gn = _tmp127_ + _tmp129_;
						_tmp130_ = nbest_node;
						_tmp131_ = nbest_node;
						_tmp132_ = _tmp131_->gn;
						_tmp133_ = nbest_node;
						_tmp134_ = _tmp133_->node;
						_tmp135_ = _tmp134_->cumulative_cost;
						_tmp130_->fn = _tmp132_ + _tmp135_;
						_tmp136_ = nbest_node;
						_tmp137_ = current_nbest_node;
						_tmp138_ = _kkc_nbest_node_ref0 (_tmp137_);
						_kkc_nbest_node_unref0 (_tmp136_->next);
						_tmp136_->next = _tmp138_;
						_tmp139_ = trellis_nbest_map;
						_tmp140_ = trellis_node;
						_tmp141_ = nbest_node;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp139_, _tmp140_, _tmp141_);
						_tmp142_ = open_list;
						_tmp143_ = nbest_node;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp142_, _tmp143_);
						_kkc_nbest_node_unref0 (nbest_node);
						_kkc_trellis_node_unref0 (trellis_node);
					}
					_g_object_unref0 (_trellis_node_list);
				}
			}
		}
		_kkc_nbest_node_unref0 (current_nbest_node);
	}
	_tmp144_ = gee_array_list_new (KKC_TYPE_SEGMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	segments = _tmp144_;
	{
		GeeIterator* _nbest_node_it = NULL;
		GeePriorityQueue* _tmp145_;
		GeeIterator* _tmp146_;
		_tmp145_ = close_list;
		_tmp146_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp145_);
		_nbest_node_it = _tmp146_;
		while (TRUE) {
			GeeIterator* _tmp147_;
			gboolean _tmp148_;
			KkcNbestNode* nbest_node = NULL;
			GeeIterator* _tmp149_;
			gpointer _tmp150_;
			GeeArrayList* _tmp151_;
			KkcNbestNode* _tmp152_;
			KkcNbestNode* _tmp153_;
			KkcSegment* _tmp154_;
			KkcSegment* _tmp155_;
			_tmp147_ = _nbest_node_it;
			_tmp148_ = gee_iterator_next (_tmp147_);
			if (!_tmp148_) {
				break;
			}
			_tmp149_ = _nbest_node_it;
			_tmp150_ = gee_iterator_get (_tmp149_);
			nbest_node = (KkcNbestNode*) _tmp150_;
			_tmp151_ = segments;
			_tmp152_ = nbest_node;
			_tmp153_ = _tmp152_->next;
			_tmp154_ = kkc_bigram_decoder_nbest_node_to_segment (self, _tmp153_);
			_tmp155_ = _tmp154_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp151_, _tmp155_);
			_g_object_unref0 (_tmp155_);
			_kkc_nbest_node_unref0 (nbest_node);
		}
		_g_object_unref0 (_nbest_node_it);
	}
	_tmp156_ = segments;
	_tmp158_ = gee_collection_to_array ((GeeCollection*) _tmp156_, &_tmp157_);
	_tmp159_ = _tmp158_;
	_tmp159__length1 = _tmp157_;
	if (result_length1) {
		*result_length1 = _tmp159__length1;
	}
	result = _tmp159_;
	_g_object_unref0 (segments);
	_kkc_nbest_node_unref0 (eos_nbest_node);
	_g_object_unref0 (duplicates);
	_g_object_unref0 (close_list);
	_g_object_unref0 (open_list);
	_g_object_unref0 (trellis_nbest_map);
	_kkc_trellis_node_unref0 (eos_trellis_node);
	_kkc_trellis_node_unref0 (bos_trellis_node);
	return result;
}


static gint kkc_bigram_decoder_compare_nbest_node (KkcNbestNode* a, KkcNbestNode* b) {
	gint result = 0;
	KkcNbestNode* _tmp0_;
	gdouble _tmp1_;
	KkcNbestNode* _tmp2_;
	gdouble _tmp3_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->fn;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->fn;
	if (_tmp1_ == _tmp3_) {
		result = 0;
		return result;
	} else {
		KkcNbestNode* _tmp4_;
		gdouble _tmp5_;
		KkcNbestNode* _tmp6_;
		gdouble _tmp7_;
		_tmp4_ = a;
		_tmp5_ = _tmp4_->fn;
		_tmp6_ = b;
		_tmp7_ = _tmp6_->fn;
		if (_tmp5_ < _tmp7_) {
			result = 1;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
}


static gchar* kkc_bigram_decoder_concat_nbest_node_outputs (KkcBigramDecoder* self, KkcNbestNode* nbest_node) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nbest_node != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		KkcNbestNode* _tmp1_;
		GString* _tmp2_;
		KkcNbestNode* _tmp3_;
		KkcTrellisNode* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		KkcNbestNode* _tmp7_;
		KkcNbestNode* _tmp8_;
		_tmp1_ = nbest_node;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = builder;
		_tmp3_ = nbest_node;
		_tmp4_ = _tmp3_->node;
		_tmp5_ = kkc_trellis_node_get_output (_tmp4_);
		_tmp6_ = _tmp5_;
		g_string_append (_tmp2_, _tmp6_);
		_tmp7_ = nbest_node;
		_tmp8_ = _tmp7_->next;
		nbest_node = _tmp8_;
	}
	_tmp9_ = builder;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (builder);
	return result;
}


KkcBigramDecoder* kkc_bigram_decoder_construct (GType object_type, KkcBigramLanguageModel* model) {
	KkcBigramDecoder * self = NULL;
	KkcBigramLanguageModel* _tmp0_;
	KkcBigramLanguageModel* _tmp1_;
	g_return_val_if_fail (model != NULL, NULL);
	self = (KkcBigramDecoder*) kkc_decoder_construct (object_type);
	_tmp0_ = model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp1_;
	return self;
}


KkcBigramDecoder* kkc_bigram_decoder_new (KkcBigramLanguageModel* model) {
	return kkc_bigram_decoder_construct (KKC_TYPE_BIGRAM_DECODER, model);
}


KkcBigramLanguageModel* kkc_bigram_decoder_get_model (KkcBigramDecoder* self) {
	KkcBigramLanguageModel* result;
	KkcBigramLanguageModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}


static void kkc_bigram_decoder_class_init (KkcBigramDecoderClass * klass) {
	kkc_bigram_decoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcBigramDecoderPrivate));
	((KkcDecoderClass *) klass)->decode = (KkcSegment** (*) (KkcDecoder *, const gchar*, gint, gint*, int, int*)) kkc_bigram_decoder_real_decode;
	((KkcDecoderClass *) klass)->decode_with_costs = (KkcSegment** (*) (KkcDecoder *, const gchar*, gint, gint*, int, gdouble, gdouble, int*)) kkc_bigram_decoder_real_decode_with_costs;
	((KkcBigramDecoderClass *) klass)->path_cost = (gdouble (*) (KkcBigramDecoder *, KkcTrellisNode*, KkcTrellisNode*, gint)) kkc_bigram_decoder_real_path_cost;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_bigram_decoder_get_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_bigram_decoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_BIGRAM_DECODER_MODEL_PROPERTY, kkc_bigram_decoder_properties[KKC_BIGRAM_DECODER_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", KKC_TYPE_BIGRAM_LANGUAGE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_bigram_decoder_instance_init (KkcBigramDecoder * self) {
	self->priv = KKC_BIGRAM_DECODER_GET_PRIVATE (self);
}


static void kkc_bigram_decoder_finalize (GObject * obj) {
	KkcBigramDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoder);
	_g_object_unref0 (self->priv->_model);
	G_OBJECT_CLASS (kkc_bigram_decoder_parent_class)->finalize (obj);
}


GType kkc_bigram_decoder_get_type (void) {
	static volatile gsize kkc_bigram_decoder_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_bigram_decoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcBigramDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_bigram_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcBigramDecoder), 0, (GInstanceInitFunc) kkc_bigram_decoder_instance_init, NULL };
		GType kkc_bigram_decoder_type_id;
		kkc_bigram_decoder_type_id = g_type_register_static (KKC_TYPE_DECODER, "KkcBigramDecoder", &g_define_type_info, 0);
		g_once_init_leave (&kkc_bigram_decoder_type_id__volatile, kkc_bigram_decoder_type_id);
	}
	return kkc_bigram_decoder_type_id__volatile;
}


static void _vala_kkc_bigram_decoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcBigramDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_BIGRAM_DECODER, KkcBigramDecoder);
	switch (property_id) {
		case KKC_BIGRAM_DECODER_MODEL_PROPERTY:
		g_value_set_object (value, kkc_bigram_decoder_get_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



