/* keybindingmanager.c generated by valac 0.20.1, the Vala compiler
 * generated from keybindingmanager.vala, do not modify */

/* vim:set et sts=4 sw=4:
valac --pkg gtk+-2.0 --pkg x11 --pkg gdk-x11-2.0 --pkg gee-1.0 keybinding-manager.vala
*/

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gobject/gvaluecollector.h>


#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
typedef struct _KeybindingManagerPrivate KeybindingManagerPrivate;

#define KEYBINDING_MANAGER_TYPE_KEYBINDING (keybinding_manager_keybinding_get_type ())
#define KEYBINDING_MANAGER_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybinding))
#define KEYBINDING_MANAGER_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybindingClass))
#define KEYBINDING_MANAGER_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBINDING_MANAGER_TYPE_KEYBINDING))
#define KEYBINDING_MANAGER_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBINDING_MANAGER_TYPE_KEYBINDING))
#define KEYBINDING_MANAGER_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybindingClass))

typedef struct _KeybindingManagerKeybinding KeybindingManagerKeybinding;
typedef struct _KeybindingManagerKeybindingClass KeybindingManagerKeybindingClass;
#define __g_list_free__keybinding_manager_keybinding_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__keybinding_manager_keybinding_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _keybinding_manager_keybinding_unref0(var) ((var == NULL) ? NULL : (var = (keybinding_manager_keybinding_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _KeybindingManagerKeybindingPrivate KeybindingManagerKeybindingPrivate;
typedef struct _KeybindingManagerParamSpecKeybinding KeybindingManagerParamSpecKeybinding;

struct _KeybindingManager {
	GObject parent_instance;
	KeybindingManagerPrivate * priv;
};

struct _KeybindingManagerClass {
	GObjectClass parent_class;
};

struct _KeybindingManagerPrivate {
	GList* m_bindings;
};

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, void* user_data);
struct _KeybindingManagerKeybinding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KeybindingManagerKeybindingPrivate * priv;
};

struct _KeybindingManagerKeybindingClass {
	GTypeClass parent_class;
	void (*finalize) (KeybindingManagerKeybinding *self);
};

struct _KeybindingManagerKeybindingPrivate {
	gchar* _accelerator;
	guint _keysym;
	GdkModifierType _modifiers;
	KeybindingManagerKeybindingHandlerFunc _handler;
	gpointer _handler_target;
};

struct _KeybindingManagerParamSpecKeybinding {
	GParamSpec parent_instance;
};


static gpointer keybinding_manager_parent_class = NULL;
static KeybindingManager* keybinding_manager_m_instance;
static KeybindingManager* keybinding_manager_m_instance = NULL;
static gpointer keybinding_manager_keybinding_parent_class = NULL;

gboolean grab_keycode (GdkDisplay* display, guint keyval, guint modifiers);
gboolean ungrab_keycode (GdkDisplay* display, guint keyval, guint modifiers);
GType keybinding_manager_get_type (void) G_GNUC_CONST;
static gpointer keybinding_manager_keybinding_ref (gpointer instance);
static void keybinding_manager_keybinding_unref (gpointer instance);
static GParamSpec* keybinding_manager_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void keybinding_manager_value_set_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void keybinding_manager_value_take_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer keybinding_manager_value_get_keybinding (const GValue* value) G_GNUC_UNUSED;
static GType keybinding_manager_keybinding_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define KEYBINDING_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEYBINDING_MANAGER, KeybindingManagerPrivate))
enum  {
	KEYBINDING_MANAGER_DUMMY_PROPERTY
};
static void _keybinding_manager_keybinding_unref0_ (gpointer var);
static void _g_list_free__keybinding_manager_keybinding_unref0_ (GList* self);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~((((((((GDK_MOD2_MASK | GDK_LOCK_MASK) | GDK_MOD4_MASK) | GDK_MOD5_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK))))
static KeybindingManager* keybinding_manager_new (void);
static KeybindingManager* keybinding_manager_construct (GType object_type);
static void keybinding_manager_event_handler (KeybindingManager* self, GdkEvent* event);
static void _keybinding_manager_event_handler_gdk_event_func (GdkEvent* event, gpointer self);
gboolean keybinding_manager_bind (KeybindingManager* self, const gchar* accelerator, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target);
static KeybindingManagerKeybinding* keybinding_manager_keybinding_new (const gchar* accelerator, guint keysym, GdkModifierType modifiers, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target);
static KeybindingManagerKeybinding* keybinding_manager_keybinding_construct (GType object_type, const gchar* accelerator, guint keysym, GdkModifierType modifiers, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target);
void keybinding_manager_unbind (KeybindingManager* self, const gchar* accelerator);
static const gchar* keybinding_manager_keybinding_get_accelerator (KeybindingManagerKeybinding* self);
static guint keybinding_manager_keybinding_get_keysym (KeybindingManagerKeybinding* self);
static GdkModifierType keybinding_manager_keybinding_get_modifiers (KeybindingManagerKeybinding* self);
GList* keybinding_manager_get_keybindings (KeybindingManager* self);
KeybindingManager* keybinding_manager_get_instance (void);
guint keybinding_manager_get_primary_modifier (guint binding_mask);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
guint keybinding_manager_keyval_to_modifier (guint keyval);
static KeybindingManagerKeybindingHandlerFunc keybinding_manager_keybinding_get_handler (KeybindingManagerKeybinding* self, gpointer* result_target);
#define KEYBINDING_MANAGER_KEYBINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybindingPrivate))
enum  {
	KEYBINDING_MANAGER_KEYBINDING_DUMMY_PROPERTY
};
static void keybinding_manager_keybinding_set_accelerator (KeybindingManagerKeybinding* self, const gchar* value);
static void keybinding_manager_keybinding_set_keysym (KeybindingManagerKeybinding* self, guint value);
static void keybinding_manager_keybinding_set_modifiers (KeybindingManagerKeybinding* self, GdkModifierType value);
static void keybinding_manager_keybinding_set_handler (KeybindingManagerKeybinding* self, KeybindingManagerKeybindingHandlerFunc value, gpointer value_target);
static void keybinding_manager_keybinding_finalize (KeybindingManagerKeybinding* obj);
static void keybinding_manager_finalize (GObject* obj);


/**
 * This class is in charge to grab keybindings on the X11 display
 * and filter X11-events and passing on such events to the registed
 * handler methods.
 *
 * @author Oliver Sauder <os@esite.ch>
 */
static void _keybinding_manager_keybinding_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (keybinding_manager_keybinding_unref (var), NULL));
}


static void _g_list_free__keybinding_manager_keybinding_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _keybinding_manager_keybinding_unref0_, NULL);
	g_list_free (self);
}


static void _keybinding_manager_event_handler_gdk_event_func (GdkEvent* event, gpointer self) {
	keybinding_manager_event_handler (self, event);
}


static KeybindingManager* keybinding_manager_construct (GType object_type) {
	KeybindingManager * self = NULL;
	self = (KeybindingManager*) g_object_new (object_type, NULL);
	gdk_event_handler_set (_keybinding_manager_event_handler_gdk_event_func, g_object_ref (self), g_object_unref);
	return self;
}


static KeybindingManager* keybinding_manager_new (void) {
	return keybinding_manager_construct (TYPE_KEYBINDING_MANAGER);
}


/**
     * Bind accelerator to given handler
     *
     * @param accelerator accelerator parsable by Gtk.accelerator_parse
     * @param handler handler called when given accelerator is pressed
     */
static gpointer _keybinding_manager_keybinding_ref0 (gpointer self) {
	return self ? keybinding_manager_keybinding_ref (self) : NULL;
}


gboolean keybinding_manager_bind (KeybindingManager* self, const gchar* accelerator, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint keysym = 0U;
	GdkModifierType modifiers = 0;
	const gchar* _tmp3_;
	guint _tmp4_ = 0U;
	GdkModifierType _tmp5_ = 0;
	Display* _tmp6_ = NULL;
	Display* display;
	Display* _tmp7_;
	guint _tmp8_;
	guchar _tmp9_ = '\0';
	gint keycode;
	gint _tmp10_;
	GdkDisplay* _tmp11_ = NULL;
	guint _tmp12_;
	GdkModifierType _tmp13_;
	const gchar* _tmp14_;
	guint _tmp15_;
	GdkModifierType _tmp16_;
	KeybindingManagerKeybindingHandlerFunc _tmp17_;
	void* _tmp17__target;
	KeybindingManagerKeybinding* _tmp18_;
	KeybindingManagerKeybinding* binding;
	KeybindingManagerKeybinding* _tmp19_;
	KeybindingManagerKeybinding* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (accelerator != NULL, FALSE);
	_tmp0_ = accelerator;
	_tmp1_ = g_strconcat ("Binding key ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	g_debug ("keybindingmanager.vala:86: %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = accelerator;
	gtk_accelerator_parse (_tmp3_, &_tmp4_, &_tmp5_);
	keysym = _tmp4_;
	modifiers = _tmp5_;
	_tmp6_ = gdk_x11_get_default_xdisplay ();
	display = _tmp6_;
	_tmp7_ = display;
	_tmp8_ = keysym;
	_tmp9_ = XKeysymToKeycode (_tmp7_, (gulong) _tmp8_);
	keycode = (gint) _tmp9_;
	_tmp10_ = keycode;
	if (_tmp10_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp11_ = gdk_display_get_default ();
	_tmp12_ = keysym;
	_tmp13_ = modifiers;
	grab_keycode (_tmp11_, _tmp12_, (guint) _tmp13_);
	_tmp14_ = accelerator;
	_tmp15_ = keysym;
	_tmp16_ = modifiers;
	_tmp17_ = handler;
	_tmp17__target = handler_target;
	_tmp18_ = keybinding_manager_keybinding_new (_tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp17__target);
	binding = _tmp18_;
	_tmp19_ = binding;
	_tmp20_ = _keybinding_manager_keybinding_ref0 (_tmp19_);
	self->priv->m_bindings = g_list_append (self->priv->m_bindings, _tmp20_);
	_tmp21_ = accelerator;
	_tmp22_ = g_strconcat ("Successfully binded key ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	g_debug ("keybindingmanager.vala:108: %s", _tmp23_);
	_g_free0 (_tmp23_);
	result = TRUE;
	_keybinding_manager_keybinding_unref0 (binding);
	return result;
}


/**
     * Unbind given accelerator.
     *
     * @param accelerator accelerator parsable by Gtk.accelerator_parse
     */
void keybinding_manager_unbind (KeybindingManager* self, const gchar* accelerator) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GList* remove_bindings;
	GList* _tmp3_;
	GList* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (accelerator != NULL);
	_tmp0_ = accelerator;
	_tmp1_ = g_strconcat ("Unbinding key ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	g_debug ("keybindingmanager.vala:118: %s", _tmp2_);
	_g_free0 (_tmp2_);
	remove_bindings = NULL;
	_tmp3_ = self->priv->m_bindings;
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
		binding_collection = _tmp3_;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			KeybindingManagerKeybinding* _tmp4_;
			KeybindingManagerKeybinding* binding = NULL;
			_tmp4_ = _keybinding_manager_keybinding_ref0 ((KeybindingManagerKeybinding*) binding_it->data);
			binding = _tmp4_;
			{
				GEqualFunc _tmp5_;
				const gchar* _tmp6_;
				KeybindingManagerKeybinding* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp5_ = g_str_equal;
				_tmp6_ = accelerator;
				_tmp7_ = binding;
				_tmp8_ = keybinding_manager_keybinding_get_accelerator (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp5_ (_tmp6_, _tmp9_);
				if (_tmp10_) {
					GdkDisplay* _tmp11_ = NULL;
					KeybindingManagerKeybinding* _tmp12_;
					guint _tmp13_;
					guint _tmp14_;
					KeybindingManagerKeybinding* _tmp15_;
					GdkModifierType _tmp16_;
					GdkModifierType _tmp17_;
					KeybindingManagerKeybinding* _tmp18_;
					KeybindingManagerKeybinding* _tmp19_;
					_tmp11_ = gdk_display_get_default ();
					_tmp12_ = binding;
					_tmp13_ = keybinding_manager_keybinding_get_keysym (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = binding;
					_tmp16_ = keybinding_manager_keybinding_get_modifiers (_tmp15_);
					_tmp17_ = _tmp16_;
					ungrab_keycode (_tmp11_, _tmp14_, (guint) _tmp17_);
					_tmp18_ = binding;
					_tmp19_ = _keybinding_manager_keybinding_ref0 (_tmp18_);
					remove_bindings = g_list_append (remove_bindings, _tmp19_);
				}
				_keybinding_manager_keybinding_unref0 (binding);
			}
		}
	}
	_tmp20_ = remove_bindings;
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
		binding_collection = _tmp20_;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			KeybindingManagerKeybinding* _tmp21_;
			KeybindingManagerKeybinding* binding = NULL;
			_tmp21_ = _keybinding_manager_keybinding_ref0 ((KeybindingManagerKeybinding*) binding_it->data);
			binding = _tmp21_;
			{
				KeybindingManagerKeybinding* _tmp22_;
				_tmp22_ = binding;
				self->priv->m_bindings = g_list_remove (self->priv->m_bindings, _tmp22_);
				_keybinding_manager_keybinding_unref0 (binding);
			}
		}
	}
	__g_list_free__keybinding_manager_keybinding_unref0_0 (remove_bindings);
}


GList* keybinding_manager_get_keybindings (KeybindingManager* self) {
	GList* result = NULL;
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_bindings;
	_tmp1_ = g_list_copy (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


KeybindingManager* keybinding_manager_get_instance (void) {
	KeybindingManager* result = NULL;
	KeybindingManager* _tmp0_;
	KeybindingManager* _tmp2_;
	KeybindingManager* _tmp3_;
	_tmp0_ = keybinding_manager_m_instance;
	if (_tmp0_ == NULL) {
		KeybindingManager* _tmp1_;
		_tmp1_ = keybinding_manager_new ();
		_g_object_unref0 (keybinding_manager_m_instance);
		keybinding_manager_m_instance = _tmp1_;
	}
	_tmp2_ = keybinding_manager_m_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


guint keybinding_manager_get_primary_modifier (guint binding_mask) {
	guint result = 0U;
	static const guint masks[] = {(guint) GDK_MOD5_MASK, (guint) GDK_MOD4_MASK, (guint) GDK_MOD3_MASK, (guint) GDK_MOD2_MASK, (guint) GDK_MOD1_MASK, (guint) GDK_CONTROL_MASK, (guint) GDK_SHIFT_MASK, (guint) GDK_LOCK_MASK};
	{
		guint* mask_collection = NULL;
		gint mask_collection_length1 = 0;
		gint _mask_collection_size_ = 0;
		gint mask_it = 0;
		mask_collection = masks;
		mask_collection_length1 = G_N_ELEMENTS (masks);
		for (mask_it = 0; mask_it < G_N_ELEMENTS (masks); mask_it = mask_it + 1) {
			guint mask = 0U;
			mask = mask_collection[mask_it];
			{
				guint _tmp0_;
				guint _tmp1_;
				guint _tmp2_;
				_tmp0_ = binding_mask;
				_tmp1_ = mask;
				_tmp2_ = mask;
				if ((_tmp0_ & _tmp1_) == _tmp2_) {
					result = mask;
					return result;
				}
			}
		}
	}
	result = (guint) 0;
	return result;
}


gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier) {
	gboolean result = FALSE;
	GdkEvent* _tmp0_;
	GdkEventKey _tmp1_;
	GdkEventKey keyevent;
	guint _tmp2_;
	GdkEvent* _tmp3_;
	GdkDevice* _tmp4_ = NULL;
	GdkDevice* _tmp5_;
	GdkDevice* device;
	GdkDevice* pointer = NULL;
	GdkDevice* _tmp6_;
	GdkInputSource _tmp7_ = 0;
	guint modifier;
	GdkDevice* _tmp13_;
	GdkEventKey _tmp14_;
	GdkWindow* _tmp15_;
	GdkModifierType _tmp16_ = 0;
	guint _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->key;
	keyevent = _tmp1_;
	_tmp2_ = primary_modifier;
	if (_tmp2_ == ((guint) 0)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = event;
	_tmp4_ = gdk_event_get_device (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	device = _tmp5_;
	_tmp6_ = device;
	_tmp7_ = gdk_device_get_source (_tmp6_);
	if (_tmp7_ == GDK_SOURCE_KEYBOARD) {
		GdkDevice* _tmp8_;
		GdkDevice* _tmp9_ = NULL;
		GdkDevice* _tmp10_;
		_tmp8_ = device;
		_tmp9_ = gdk_device_get_associated_device (_tmp8_);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (pointer);
		pointer = _tmp10_;
	} else {
		GdkDevice* _tmp11_;
		GdkDevice* _tmp12_;
		_tmp11_ = device;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (pointer);
		pointer = _tmp12_;
	}
	modifier = (guint) 0;
	_tmp13_ = pointer;
	_tmp14_ = keyevent;
	_tmp15_ = _tmp14_.window;
	gdk_device_get_state (_tmp13_, _tmp15_, (gdouble*) NULL, &_tmp16_);
	modifier = (guint) _tmp16_;
	_tmp17_ = primary_modifier;
	_tmp18_ = modifier;
	_tmp19_ = primary_modifier;
	if ((_tmp17_ & _tmp18_) == _tmp19_) {
		result = TRUE;
		_g_object_unref0 (pointer);
		_g_object_unref0 (device);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (pointer);
	_g_object_unref0 (device);
	return result;
}


guint keybinding_manager_keyval_to_modifier (guint keyval) {
	guint result = 0U;
	guint _tmp0_;
	_tmp0_ = keyval;
	switch (_tmp0_) {
		case 0xffe3:
		case 0xffe4:
		{
			result = (guint) GDK_CONTROL_MASK;
			return result;
		}
		case 0xffe1:
		case 0xffe2:
		{
			result = (guint) GDK_SHIFT_MASK;
			return result;
		}
		case 0xffe5:
		{
			result = (guint) GDK_LOCK_MASK;
			return result;
		}
		case 0xffe9:
		case 0xffea:
		{
			result = (guint) GDK_MOD1_MASK;
			return result;
		}
		case 0xffe7:
		case 0xffe8:
		{
			result = (guint) GDK_META_MASK;
			return result;
		}
		case 0xffeb:
		case 0xffec:
		{
			result = (guint) GDK_SUPER_MASK;
			return result;
		}
		case 0xffed:
		case 0xffee:
		{
			result = (guint) GDK_HYPER_MASK;
			return result;
		}
		default:
		{
			result = (guint) 0;
			return result;
		}
	}
}


static void keybinding_manager_event_handler (KeybindingManager* self, GdkEvent* event) {
	GdkEvent* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			GdkEvent* _tmp2_;
			GdkEventAny _tmp3_;
			GdkWindow* _tmp4_;
			GdkWindow* _tmp5_ = NULL;
			GdkEvent* _tmp6_;
			GdkEventType _tmp7_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				if (!FALSE) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp2_ = event;
			_tmp3_ = _tmp2_->any;
			_tmp4_ = _tmp3_.window;
			_tmp5_ = gdk_get_default_root_window ();
			if (_tmp4_ != _tmp5_) {
				break;
			}
			_tmp6_ = event;
			_tmp7_ = _tmp6_->type;
			if (_tmp7_ == GDK_KEY_PRESS) {
				GdkEvent* _tmp8_;
				GdkEventKey _tmp9_;
				GdkModifierType _tmp10_;
				guint modifiers;
				GList* _tmp11_;
				_tmp8_ = event;
				_tmp9_ = _tmp8_->key;
				_tmp10_ = _tmp9_.state;
				modifiers = (guint) (_tmp10_ & KEYBINDING_MANAGER_MODIFIER_FILTER);
				_tmp11_ = self->priv->m_bindings;
				{
					GList* binding_collection = NULL;
					GList* binding_it = NULL;
					binding_collection = _tmp11_;
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
						KeybindingManagerKeybinding* _tmp12_;
						KeybindingManagerKeybinding* binding = NULL;
						_tmp12_ = _keybinding_manager_keybinding_ref0 ((KeybindingManagerKeybinding*) binding_it->data);
						binding = _tmp12_;
						{
							gboolean _tmp13_ = FALSE;
							GdkEvent* _tmp14_;
							GdkEventKey _tmp15_;
							guint _tmp16_;
							KeybindingManagerKeybinding* _tmp17_;
							guint _tmp18_;
							guint _tmp19_;
							gboolean _tmp24_;
							KeybindingManagerKeybinding* _tmp25_;
							KeybindingManagerKeybindingHandlerFunc _tmp26_;
							void* _tmp26__target;
							KeybindingManagerKeybindingHandlerFunc _tmp27_;
							void* _tmp27__target;
							GdkEvent* _tmp28_;
							_tmp14_ = event;
							_tmp15_ = _tmp14_->key;
							_tmp16_ = _tmp15_.keyval;
							_tmp17_ = binding;
							_tmp18_ = keybinding_manager_keybinding_get_keysym (_tmp17_);
							_tmp19_ = _tmp18_;
							if (_tmp16_ != _tmp19_) {
								_tmp13_ = TRUE;
							} else {
								guint _tmp20_;
								KeybindingManagerKeybinding* _tmp21_;
								GdkModifierType _tmp22_;
								GdkModifierType _tmp23_;
								_tmp20_ = modifiers;
								_tmp21_ = binding;
								_tmp22_ = keybinding_manager_keybinding_get_modifiers (_tmp21_);
								_tmp23_ = _tmp22_;
								_tmp13_ = _tmp20_ != ((guint) _tmp23_);
							}
							_tmp24_ = _tmp13_;
							if (_tmp24_) {
								_keybinding_manager_keybinding_unref0 (binding);
								continue;
							}
							_tmp25_ = binding;
							_tmp26_ = keybinding_manager_keybinding_get_handler (_tmp25_, &_tmp26__target);
							_tmp27_ = _tmp26_;
							_tmp27__target = _tmp26__target;
							_tmp28_ = event;
							_tmp27_ (_tmp28_, _tmp27__target);
							_keybinding_manager_keybinding_unref0 (binding);
							return;
						}
					}
				}
			}
		}
	}
	_tmp29_ = event;
	gtk_main_do_event (_tmp29_);
}


static KeybindingManagerKeybinding* keybinding_manager_keybinding_construct (GType object_type, const gchar* accelerator, guint keysym, GdkModifierType modifiers, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target) {
	KeybindingManagerKeybinding* self = NULL;
	const gchar* _tmp0_;
	guint _tmp1_;
	GdkModifierType _tmp2_;
	KeybindingManagerKeybindingHandlerFunc _tmp3_;
	void* _tmp3__target;
	g_return_val_if_fail (accelerator != NULL, NULL);
	self = (KeybindingManagerKeybinding*) g_type_create_instance (object_type);
	_tmp0_ = accelerator;
	keybinding_manager_keybinding_set_accelerator (self, _tmp0_);
	_tmp1_ = keysym;
	keybinding_manager_keybinding_set_keysym (self, _tmp1_);
	_tmp2_ = modifiers;
	keybinding_manager_keybinding_set_modifiers (self, _tmp2_);
	_tmp3_ = handler;
	_tmp3__target = handler_target;
	keybinding_manager_keybinding_set_handler (self, _tmp3_, _tmp3__target);
	return self;
}


static KeybindingManagerKeybinding* keybinding_manager_keybinding_new (const gchar* accelerator, guint keysym, GdkModifierType modifiers, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target) {
	return keybinding_manager_keybinding_construct (KEYBINDING_MANAGER_TYPE_KEYBINDING, accelerator, keysym, modifiers, handler, handler_target);
}


static const gchar* keybinding_manager_keybinding_get_accelerator (KeybindingManagerKeybinding* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accelerator;
	result = _tmp0_;
	return result;
}


static void keybinding_manager_keybinding_set_accelerator (KeybindingManagerKeybinding* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_accelerator);
	self->priv->_accelerator = _tmp1_;
}


static guint keybinding_manager_keybinding_get_keysym (KeybindingManagerKeybinding* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keysym;
	result = _tmp0_;
	return result;
}


static void keybinding_manager_keybinding_set_keysym (KeybindingManagerKeybinding* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keysym = _tmp0_;
}


static GdkModifierType keybinding_manager_keybinding_get_modifiers (KeybindingManagerKeybinding* self) {
	GdkModifierType result;
	GdkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


static void keybinding_manager_keybinding_set_modifiers (KeybindingManagerKeybinding* self, GdkModifierType value) {
	GdkModifierType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modifiers = _tmp0_;
}


static KeybindingManagerKeybindingHandlerFunc keybinding_manager_keybinding_get_handler (KeybindingManagerKeybinding* self, gpointer* result_target) {
	KeybindingManagerKeybindingHandlerFunc result;
	KeybindingManagerKeybindingHandlerFunc _tmp0_;
	void* _tmp0__target;
	KeybindingManagerKeybindingHandlerFunc _tmp1_;
	void* _tmp1__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_handler;
	_tmp0__target = self->priv->_handler_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


static void keybinding_manager_keybinding_set_handler (KeybindingManagerKeybinding* self, KeybindingManagerKeybindingHandlerFunc value, gpointer value_target) {
	KeybindingManagerKeybindingHandlerFunc _tmp0_;
	void* _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__target = value_target;
	self->priv->_handler = _tmp0_;
	self->priv->_handler_target = _tmp0__target;
}


static void keybinding_manager_value_keybinding_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void keybinding_manager_value_keybinding_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		keybinding_manager_keybinding_unref (value->data[0].v_pointer);
	}
}


static void keybinding_manager_value_keybinding_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = keybinding_manager_keybinding_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer keybinding_manager_value_keybinding_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* keybinding_manager_value_keybinding_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		KeybindingManagerKeybinding* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = keybinding_manager_keybinding_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* keybinding_manager_value_keybinding_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	KeybindingManagerKeybinding** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = keybinding_manager_keybinding_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* keybinding_manager_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	KeybindingManagerParamSpecKeybinding* spec;
	g_return_val_if_fail (g_type_is_a (object_type, KEYBINDING_MANAGER_TYPE_KEYBINDING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer keybinding_manager_value_get_keybinding (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KEYBINDING_MANAGER_TYPE_KEYBINDING), NULL);
	return value->data[0].v_pointer;
}


static void keybinding_manager_value_set_keybinding (GValue* value, gpointer v_object) {
	KeybindingManagerKeybinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KEYBINDING_MANAGER_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KEYBINDING_MANAGER_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		keybinding_manager_keybinding_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		keybinding_manager_keybinding_unref (old);
	}
}


static void keybinding_manager_value_take_keybinding (GValue* value, gpointer v_object) {
	KeybindingManagerKeybinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KEYBINDING_MANAGER_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KEYBINDING_MANAGER_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		keybinding_manager_keybinding_unref (old);
	}
}


static void keybinding_manager_keybinding_class_init (KeybindingManagerKeybindingClass * klass) {
	keybinding_manager_keybinding_parent_class = g_type_class_peek_parent (klass);
	KEYBINDING_MANAGER_KEYBINDING_CLASS (klass)->finalize = keybinding_manager_keybinding_finalize;
	g_type_class_add_private (klass, sizeof (KeybindingManagerKeybindingPrivate));
}


static void keybinding_manager_keybinding_instance_init (KeybindingManagerKeybinding * self) {
	self->priv = KEYBINDING_MANAGER_KEYBINDING_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void keybinding_manager_keybinding_finalize (KeybindingManagerKeybinding* obj) {
	KeybindingManagerKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybinding);
	_g_free0 (self->priv->_accelerator);
}


/**
     * Helper class to store keybinding
     */
static GType keybinding_manager_keybinding_get_type (void) {
	static volatile gsize keybinding_manager_keybinding_type_id__volatile = 0;
	if (g_once_init_enter (&keybinding_manager_keybinding_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { keybinding_manager_value_keybinding_init, keybinding_manager_value_keybinding_free_value, keybinding_manager_value_keybinding_copy_value, keybinding_manager_value_keybinding_peek_pointer, "p", keybinding_manager_value_keybinding_collect_value, "p", keybinding_manager_value_keybinding_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (KeybindingManagerKeybindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keybinding_manager_keybinding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeybindingManagerKeybinding), 0, (GInstanceInitFunc) keybinding_manager_keybinding_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType keybinding_manager_keybinding_type_id;
		keybinding_manager_keybinding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KeybindingManagerKeybinding", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&keybinding_manager_keybinding_type_id__volatile, keybinding_manager_keybinding_type_id);
	}
	return keybinding_manager_keybinding_type_id__volatile;
}


static gpointer keybinding_manager_keybinding_ref (gpointer instance) {
	KeybindingManagerKeybinding* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void keybinding_manager_keybinding_unref (gpointer instance) {
	KeybindingManagerKeybinding* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		KEYBINDING_MANAGER_KEYBINDING_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void keybinding_manager_class_init (KeybindingManagerClass * klass) {
	keybinding_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KeybindingManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = keybinding_manager_finalize;
}


static void keybinding_manager_instance_init (KeybindingManager * self) {
	self->priv = KEYBINDING_MANAGER_GET_PRIVATE (self);
	self->priv->m_bindings = NULL;
}


static void keybinding_manager_finalize (GObject* obj) {
	KeybindingManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYBINDING_MANAGER, KeybindingManager);
	__g_list_free__keybinding_manager_keybinding_unref0_0 (self->priv->m_bindings);
	G_OBJECT_CLASS (keybinding_manager_parent_class)->finalize (obj);
}


GType keybinding_manager_get_type (void) {
	static volatile gsize keybinding_manager_type_id__volatile = 0;
	if (g_once_init_enter (&keybinding_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeybindingManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keybinding_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeybindingManager), 0, (GInstanceInitFunc) keybinding_manager_instance_init, NULL };
		GType keybinding_manager_type_id;
		keybinding_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "KeybindingManager", &g_define_type_info, 0);
		g_once_init_leave (&keybinding_manager_type_id__volatile, keybinding_manager_type_id);
	}
	return keybinding_manager_type_id__volatile;
}



