/* TweetUtils.c generated by valac 0.38.7, the Vala compiler
 * generated from TweetUtils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "CbTweet.h"
#include "rest/rest-proxy-call.h"
#include <stdlib.h>
#include <string.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include <gtk/gtk.h>
#include "CbUtils.h"
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libsoup/soup.h>
#include "CbBundle.h"
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include <float.h>
#include <math.h>
#include "CbTypes.h"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _Block54Data Block54Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TweetUtilsDeleteTweetData TweetUtilsDeleteTweetData;
typedef struct _Block55Data Block55Data;
typedef struct _TweetUtilsSetFavoriteStatusData TweetUtilsSetFavoriteStatusData;
typedef struct _Block56Data Block56Data;
typedef struct _TweetUtilsSetRetweetStatusData TweetUtilsSetRetweetStatusData;
typedef struct _Block57Data Block57Data;
typedef struct _TweetUtilsDownloadAvatarData TweetUtilsDownloadAvatarData;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_MEDIA_DIALOG (media_dialog_get_type ())
#define MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_DIALOG, MediaDialog))
#define MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_DIALOG, MediaDialogClass))
#define IS_MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_DIALOG))
#define IS_MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_DIALOG))
#define MEDIA_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_DIALOG, MediaDialogClass))

typedef struct _MediaDialog MediaDialog;
typedef struct _MediaDialogClass MediaDialogClass;

struct _Block54Data {
	int _ref_count_;
	RestProxyCall* call;
	gpointer _async_data_;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _TweetUtilsDeleteTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* account;
	CbTweet* tweet;
	Block54Data* _data54_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	CbTweet* _tmp3_;
	gint64 _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	CbTweet* _tmp11_;
	gint64 _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
};

struct _Block55Data {
	int _ref_count_;
	RestProxyCall* call;
	CbTweet* tweet;
	gboolean status;
	gpointer _async_data_;
};

struct _TweetUtilsSetFavoriteStatusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* account;
	CbTweet* tweet;
	gboolean status;
	Block55Data* _data55_;
	CbTweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	gboolean _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	CbTweet* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
};

struct _Block56Data {
	int _ref_count_;
	RestProxyCall* call;
	CbTweet* tweet;
	gboolean status;
	gpointer _async_data_;
};

struct _TweetUtilsSetRetweetStatusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* account;
	CbTweet* tweet;
	gboolean status;
	Block56Data* _data56_;
	CbTweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	gboolean _tmp6_;
	RestProxyCall* _tmp7_;
	CbTweet* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	CbTweet* _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	RestProxyCall* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	RestProxyCall* _tmp24_;
};

struct _Block57Data {
	int _ref_count_;
	GdkPixbuf* avatar;
	SoupMessage* msg;
	GError* err;
	gint size;
	gpointer _async_data_;
};

struct _TweetUtilsDownloadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* avatar_url;
	gint size;
	GCancellable* cancellable;
	GdkPixbuf* result;
	Block57Data* _data57_;
	gint _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	SoupSession* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GError * _inner_error_;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};


extern SoupSession* SOUP_SESSION;

static void tweet_utils_delete_tweet_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda52_ (Block54Data* _data54_, GObject* obj, GAsyncResult* res);
static void ___lambda52__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_set_favorite_status_data_free (gpointer _data);
void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_);
static gboolean tweet_utils_set_favorite_status_co (TweetUtilsSetFavoriteStatusData* _data_);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void __lambda49_ (Block55Data* _data55_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda49__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_set_retweet_status_data_free (gpointer _data);
void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_);
static gboolean tweet_utils_set_retweet_status_co (TweetUtilsSetRetweetStatusData* _data_);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static void __lambda66_ (Block56Data* _data56_, GObject* obj, GAsyncResult* res);
static void ___lambda66__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_download_avatar_data_free (gpointer _data);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
static void ___lambda58_ (Block57Data* _data57_);
static void ____lambda58__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void __lambda59_ (Block57Data* _data57_, SoupSession* s, SoupMessage* _msg);
static guint8* _vala_array_dup7 (guint8* self, int length);
static void ___lambda59__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
GType main_window_get_type (void) G_GNUC_CONST;
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
#define PROFILE_PAGE_KEY_USER_ID 1
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
#define PROFILE_PAGE_KEY_SCREEN_NAME 0
#define SEARCH_PAGE_KEY_QUERY 0
#define TWEET_INFO_PAGE_KEY_MODE 0
#define TWEET_INFO_PAGE_BY_ID 2
#define TWEET_INFO_PAGE_KEY_TWEET_ID 3
#define TWEET_INFO_PAGE_KEY_SCREEN_NAME 4
GType tweet_list_box_get_type (void) G_GNUC_CONST;
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account);
gboolean account_filter_matches (Account* self, CbTweet* t);
void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index, gdouble px, gdouble py);
GType media_dialog_get_type (void) G_GNUC_CONST;
MediaDialog* media_dialog_new (CbTweet* tweet, gint start_media_index, gdouble px, gdouble py);
MediaDialog* media_dialog_construct (GType object_type, CbTweet* tweet, gint start_media_index, gdouble px, gdouble py);
void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void tweet_utils_delete_tweet_data_free (gpointer _data) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->tweet);
	g_slice_free (TweetUtilsDeleteTweetData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDeleteTweetData* _data_;
	Account* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	CbTweet* _tmp3_;
	_data_ = g_slice_new0 (TweetUtilsDeleteTweetData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tweet_utils_delete_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	tweet_utils_delete_tweet_co (_data_);
}


void tweet_utils_delete_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Deletes the given tweet.
   *
   * @param account The account to delete the tweet from
   * @param tweet the tweet to delete
   */
static Block54Data* block54_data_ref (Block54Data* _data54_) {
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}


static void block54_data_unref (void * _userdata_) {
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		_g_object_unref0 (_data54_->call);
		g_slice_free (Block54Data, _data54_);
	}
}


static void __lambda52_ (Block54Data* _data54_, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data54_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch61_g_error;
		}
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("TweetUtils.vala:31: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally61:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_delete_tweet_co (_data54_->_async_data_);
}


static void ___lambda52__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda52_ (self, source_object, res);
	block54_data_unref (self);
}


static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data54_ = g_slice_new0 (Block54Data);
	_data_->_data54_->_ref_count_ = 1;
	_data_->_data54_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->_data54_->call = _data_->_tmp2_;
	rest_proxy_call_set_method (_data_->_data54_->call, "POST");
	_data_->_tmp3_ = _data_->tweet;
	_data_->_tmp4_ = _data_->_tmp3_->id;
	_data_->_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp6_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strconcat (_data_->_tmp8_, ".json", NULL);
	_data_->_tmp10_ = _data_->_tmp9_;
	rest_proxy_call_set_function (_data_->_data54_->call, _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_g_free0 (_data_->_tmp8_);
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp11_ = _data_->tweet;
	_data_->_tmp12_ = _data_->_tmp11_->id;
	_data_->_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	rest_proxy_call_add_param (_data_->_data54_->call, "id", _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	rest_proxy_call_invoke_async (_data_->_data54_->call, NULL, ___lambda52__gasync_ready_callback, block54_data_ref (_data_->_data54_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block54_data_unref (_data_->_data54_);
	_data_->_data54_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_set_favorite_status_data_free (gpointer _data) {
	TweetUtilsSetFavoriteStatusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsSetFavoriteStatusData, _data_);
}


void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsSetFavoriteStatusData* _data_;
	Account* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	CbTweet* _tmp3_;
	gboolean _tmp4_;
	_data_ = g_slice_new0 (TweetUtilsSetFavoriteStatusData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tweet_utils_set_favorite_status_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = status;
	_data_->status = _tmp4_;
	tweet_utils_set_favorite_status_co (_data_);
}


void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_) {
	TweetUtilsSetFavoriteStatusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * (Un)favorites the given tweet.
   *
   * @param account The account to (un)favorite from
   * @param tweet The tweet to (un)favorite
   * @param status %true to favorite the tweet, %false to unfavorite it.
   */
static Block55Data* block55_data_ref (Block55Data* _data55_) {
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}


static void block55_data_unref (void * _userdata_) {
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		_g_object_unref0 (_data55_->call);
		_g_object_unref0 (_data55_->tweet);
		g_slice_free (Block55Data, _data55_);
	}
}


static void __lambda49_ (Block55Data* _data55_, GObject* obj, GAsyncResult* res) {
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data55_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch62_g_error;
		}
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data55_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 58, "TweetUtils.vala", NULL);
		_g_error_free0 (e);
	}
	__finally62:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data55_->status;
	if (_tmp6_) {
		CbTweet* _tmp7_;
		_tmp7_ = _data55_->tweet;
		cb_tweet_set_flag (_tmp7_, (guint) CB_TWEET_STATE_FAVORITED);
	} else {
		CbTweet* _tmp8_;
		_tmp8_ = _data55_->tweet;
		cb_tweet_unset_flag (_tmp8_, (guint) CB_TWEET_STATE_FAVORITED);
	}
	tweet_utils_set_favorite_status_co (_data55_->_async_data_);
}


static void ___lambda49__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda49_ (self, source_object, res);
	block55_data_unref (self);
}


static gboolean tweet_utils_set_favorite_status_co (TweetUtilsSetFavoriteStatusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data55_ = g_slice_new0 (Block55Data);
	_data_->_data55_->_ref_count_ = 1;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data55_->tweet);
	_data_->_data55_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->status;
	_data_->_data55_->status = _data_->_tmp1_;
	_data_->_data55_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = _data_->_tmp2_->proxy;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->_data55_->call = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->_data55_->status;
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = _data_->_data55_->call;
		rest_proxy_call_set_function (_data_->_tmp6_, "1.1/favorites/create.json");
	} else {
		_data_->_tmp7_ = _data_->_data55_->call;
		rest_proxy_call_set_function (_data_->_tmp7_, "1.1/favorites/destroy.json");
	}
	_data_->_tmp8_ = _data_->_data55_->call;
	rest_proxy_call_set_method (_data_->_tmp8_, "POST");
	_data_->_tmp9_ = _data_->_data55_->call;
	_data_->_tmp10_ = _data_->_data55_->tweet;
	_data_->_tmp11_ = _data_->_tmp10_->id;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp9_, "id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = _data_->_data55_->call;
	rest_proxy_call_invoke_async (_data_->_tmp14_, NULL, ___lambda49__gasync_ready_callback, block55_data_ref (_data_->_data55_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block55_data_unref (_data_->_data55_);
	_data_->_data55_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_set_retweet_status_data_free (gpointer _data) {
	TweetUtilsSetRetweetStatusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsSetRetweetStatusData, _data_);
}


void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsSetRetweetStatusData* _data_;
	Account* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	CbTweet* _tmp3_;
	gboolean _tmp4_;
	_data_ = g_slice_new0 (TweetUtilsSetRetweetStatusData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tweet_utils_set_retweet_status_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = status;
	_data_->status = _tmp4_;
	tweet_utils_set_retweet_status_co (_data_);
}


void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_) {
	TweetUtilsSetRetweetStatusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * (Un)retweets the given tweet.
   *
   * @param account The account to (un)retweet from
   * @param tweet The tweet to (un)retweet
   * @param status %true to retweet it, false to unretweet it.
   */
static Block56Data* block56_data_ref (Block56Data* _data56_) {
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}


static void block56_data_unref (void * _userdata_) {
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		_g_object_unref0 (_data56_->call);
		_g_object_unref0 (_data56_->tweet);
		g_slice_free (Block56Data, _data56_);
	}
}


static void __lambda66_ (Block56Data* _data56_, GObject* obj, GAsyncResult* res) {
	const gchar* back = NULL;
	RestProxyCall* _tmp6_;
	const gchar* _tmp7_;
	JsonParser* parser = NULL;
	JsonParser* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data56_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch63_g_error;
		}
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data56_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 91, "TweetUtils.vala", NULL);
		_g_error_free0 (e);
	}
	__finally63:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data56_->call;
	_tmp7_ = rest_proxy_call_get_payload (_tmp6_);
	back = _tmp7_;
	_tmp8_ = json_parser_new ();
	parser = _tmp8_;
	{
		gboolean _tmp9_;
		gboolean _tmp16_;
		json_parser_load_from_data (parser, back, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch64_g_error;
		}
		_tmp9_ = _data56_->status;
		if (_tmp9_) {
			gint64 new_id = 0LL;
			JsonNode* _tmp10_;
			JsonObject* _tmp11_;
			gint64 _tmp12_;
			CbTweet* _tmp13_;
			gint64 _tmp14_;
			_tmp10_ = json_parser_get_root (parser);
			_tmp11_ = json_node_get_object (_tmp10_);
			_tmp12_ = json_object_get_int_member (_tmp11_, "id");
			new_id = _tmp12_;
			_tmp13_ = _data56_->tweet;
			_tmp14_ = new_id;
			_tmp13_->my_retweet = _tmp14_;
		} else {
			CbTweet* _tmp15_;
			_tmp15_ = _data56_->tweet;
			_tmp15_->my_retweet = (gint64) 0;
		}
		_tmp16_ = _data56_->status;
		if (_tmp16_) {
			CbTweet* _tmp17_;
			_tmp17_ = _data56_->tweet;
			cb_tweet_set_flag (_tmp17_, (guint) CB_TWEET_STATE_RETWEETED);
		} else {
			CbTweet* _tmp18_;
			_tmp18_ = _data56_->tweet;
			cb_tweet_unset_flag (_tmp18_, (guint) CB_TWEET_STATE_RETWEETED);
		}
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("TweetUtils.vala:108: %s", _tmp20_);
		g_critical ("TweetUtils.vala:109: %s", back);
		_g_error_free0 (e);
	}
	__finally64:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_set_retweet_status_co (_data56_->_async_data_);
	_g_object_unref0 (parser);
}


static void ___lambda66__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda66_ (self, source_object, res);
	block56_data_unref (self);
}


static gboolean tweet_utils_set_retweet_status_co (TweetUtilsSetRetweetStatusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data56_ = g_slice_new0 (Block56Data);
	_data_->_data56_->_ref_count_ = 1;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data56_->tweet);
	_data_->_data56_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->status;
	_data_->_data56_->status = _data_->_tmp1_;
	_data_->_data56_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = _data_->_tmp2_->proxy;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->_data56_->call = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->_data56_->call;
	rest_proxy_call_set_method (_data_->_tmp5_, "POST");
	_data_->_tmp6_ = _data_->_data56_->status;
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->_data56_->call;
		_data_->_tmp8_ = _data_->_data56_->tweet;
		_data_->_tmp9_ = _data_->_tmp8_->id;
		_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = g_strconcat ("1.1/statuses/retweet/", _data_->_tmp11_, ".json", NULL);
		_data_->_tmp13_ = _data_->_tmp12_;
		rest_proxy_call_set_function (_data_->_tmp7_, _data_->_tmp13_);
		_g_free0 (_data_->_tmp13_);
		_g_free0 (_data_->_tmp11_);
	} else {
		_data_->_tmp14_ = _data_->_data56_->call;
		_data_->_tmp15_ = _data_->_data56_->tweet;
		_data_->_tmp16_ = _data_->_tmp15_->my_retweet;
		_data_->_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp18_, ".json", NULL);
		_data_->_tmp20_ = _data_->_tmp19_;
		rest_proxy_call_set_function (_data_->_tmp14_, _data_->_tmp20_);
		_g_free0 (_data_->_tmp20_);
		_g_free0 (_data_->_tmp18_);
	}
	_data_->_tmp21_ = _data_->_data56_->call;
	_data_->_tmp22_ = cb_utils_rest_proxy_call_to_string (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	g_debug ("TweetUtils.vala:85: %s", _data_->_tmp23_);
	_g_free0 (_data_->_tmp23_);
	_data_->_tmp24_ = _data_->_data56_->call;
	rest_proxy_call_invoke_async (_data_->_tmp24_, NULL, ___lambda66__gasync_ready_callback, block56_data_ref (_data_->_data56_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block56_data_unref (_data_->_data56_);
	_data_->_data56_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_download_avatar_data_free (gpointer _data) {
	TweetUtilsDownloadAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->avatar_url);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TweetUtilsDownloadAvatarData, _data_);
}


void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDownloadAvatarData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (TweetUtilsDownloadAvatarData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tweet_utils_download_avatar_data_free);
	_tmp0_ = avatar_url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->avatar_url);
	_data_->avatar_url = _tmp1_;
	_tmp2_ = size;
	_data_->size = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	tweet_utils_download_avatar_co (_data_);
}


GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error) {
	GdkPixbuf* result;
	TweetUtilsDownloadAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Downloads the avatar from the given url.
   *
   * @param avatar_url The avatar url to download
   *
   * @return The loaded avatar.
   */
static Block57Data* block57_data_ref (Block57Data* _data57_) {
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}


static void block57_data_unref (void * _userdata_) {
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		_g_error_free0 (_data57_->err);
		_g_object_unref0 (_data57_->msg);
		_g_object_unref0 (_data57_->avatar);
		g_slice_free (Block57Data, _data57_);
	}
}


static void ___lambda58_ (Block57Data* _data57_) {
	SoupSession* _tmp0_;
	SoupMessage* _tmp1_;
	_tmp0_ = SOUP_SESSION;
	_tmp1_ = _data57_->msg;
	soup_session_cancel_message (_tmp0_, _tmp1_, (guint) SOUP_STATUS_CANCELLED);
}


static void ____lambda58__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	___lambda58_ (self);
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda59_ (Block57Data* _data57_, SoupSession* s, SoupMessage* _msg) {
	SoupMessage* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GMemoryInputStream* memory_stream = NULL;
	SoupMessage* _tmp3_;
	SoupMessageBody* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GDestroyNotify _tmp7_;
	GMemoryInputStream* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
		_g_object_unref0 (_data57_->avatar);
		_data57_->avatar = NULL;
		tweet_utils_download_avatar_co (_data57_->_async_data_);
		return;
	}
	_tmp3_ = _msg;
	_tmp4_ = _tmp3_->response_body;
	_tmp5_ = _tmp4_->data;
	_tmp5__length1 = (gint) _tmp4_->length;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup7 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = g_free;
	_tmp8_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp6_, _tmp6__length1, _tmp7_);
	memory_stream = _tmp8_;
	{
		GdkPixbuf* _tmp9_ = NULL;
		GMemoryInputStream* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		_tmp10_ = memory_stream;
		_tmp11_ = _data57_->size;
		_tmp12_ = _data57_->size;
		_tmp13_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_input_stream_get_type (), GInputStream), _tmp11_, _tmp12_, FALSE, NULL, &_inner_error_);
		_tmp9_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch65_g_error;
		}
		_tmp14_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (_data57_->avatar);
		_data57_->avatar = _tmp14_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally65;
	__catch65_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		GError* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _g_error_copy0 (_tmp15_);
		_g_error_free0 (_data57_->err);
		_data57_->err = _tmp16_;
		_g_error_free0 (e);
	}
	__finally65:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (memory_stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_download_avatar_co (_data57_->_async_data_);
	_g_object_unref0 (memory_stream);
}


static void ___lambda59__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda59_ (self, session, msg);
	block57_data_unref (self);
}


static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data57_ = g_slice_new0 (Block57Data);
	_data_->_data57_->_ref_count_ = 1;
	_data_->_tmp0_ = _data_->size;
	_data_->_data57_->size = _data_->_tmp0_;
	_data_->_data57_->_async_data_ = _data_;
	_data_->_data57_->avatar = NULL;
	_data_->_tmp1_ = _data_->avatar_url;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->_data57_->msg = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->cancellable;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->cancellable;
		g_signal_connect_data (_data_->_tmp4_, "cancelled", (GCallback) ____lambda58__g_cancellable_cancelled, block57_data_ref (_data_->_data57_), (GClosureNotify) block57_data_unref, 0);
	}
	_data_->_data57_->err = NULL;
	_data_->_tmp5_ = SOUP_SESSION;
	_data_->_tmp6_ = _data_->_data57_->msg;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
	soup_session_queue_message (_data_->_tmp5_, _data_->_tmp7_, ___lambda59__soup_session_callback, block57_data_ref (_data_->_data57_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp8_ = _data_->_data57_->err;
	if (_data_->_tmp8_ != NULL) {
		_data_->_tmp9_ = _data_->_data57_->err;
		_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
		_data_->_inner_error_ = _data_->_tmp10_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		block57_data_unref (_data_->_data57_);
		_data_->_data57_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->_data57_->avatar;
	_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
	_data_->result = _data_->_tmp12_;
	block57_data_unref (_data_->_data57_);
	_data_->_data57_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* term = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (IS_MAIN_WINDOW (window), FALSE);
	_tmp0_ = uri;
	g_debug ("TweetUtils.vala:156: Activating '%s'", _tmp0_);
	_tmp1_ = uri;
	_tmp2_ = g_strstrip (_tmp1_);
	uri = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) -1);
	term = _tmp4_;
	_tmp5_ = uri;
	_tmp6_ = g_str_has_prefix (_tmp5_, "@");
	if (_tmp6_) {
		gint slash_index = 0;
		const gchar* _tmp7_;
		gint _tmp8_;
		CbBundle* bundle = NULL;
		CbBundle* _tmp9_;
		gint _tmp10_;
		_tmp7_ = uri;
		_tmp8_ = string_index_of (_tmp7_, "/", 0);
		slash_index = _tmp8_;
		_tmp9_ = cb_bundle_new ();
		bundle = _tmp9_;
		_tmp10_ = slash_index;
		if (_tmp10_ == -1) {
			CbBundle* _tmp11_;
			const gchar* _tmp12_;
			gint64 _tmp13_;
			MainWindow* _tmp14_;
			MainWidget* _tmp15_;
			CbBundle* _tmp16_;
			_tmp11_ = bundle;
			_tmp12_ = term;
			_tmp13_ = int64_parse (_tmp12_);
			cb_bundle_put_int64 (_tmp11_, PROFILE_PAGE_KEY_USER_ID, _tmp13_);
			_tmp14_ = window;
			_tmp15_ = _tmp14_->main_widget;
			_tmp16_ = bundle;
			main_widget_switch_page (_tmp15_, (gint) PAGE_PROFILE, _tmp16_);
		} else {
			CbBundle* _tmp17_;
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gint64 _tmp22_;
			CbBundle* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			const gchar* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			MainWindow* _tmp32_;
			MainWidget* _tmp33_;
			CbBundle* _tmp34_;
			_tmp17_ = bundle;
			_tmp18_ = term;
			_tmp19_ = slash_index;
			_tmp20_ = string_substring (_tmp18_, (glong) 0, (glong) (_tmp19_ - 1));
			_tmp21_ = _tmp20_;
			_tmp22_ = int64_parse (_tmp21_);
			cb_bundle_put_int64 (_tmp17_, PROFILE_PAGE_KEY_USER_ID, _tmp22_);
			_g_free0 (_tmp21_);
			_tmp23_ = bundle;
			_tmp24_ = term;
			_tmp25_ = slash_index;
			_tmp26_ = term;
			_tmp27_ = strlen (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = slash_index;
			_tmp30_ = string_substring (_tmp24_, (glong) (_tmp25_ + 1), (glong) ((_tmp28_ - _tmp29_) - 1));
			_tmp31_ = _tmp30_;
			cb_bundle_put_string (_tmp23_, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp31_);
			_g_free0 (_tmp31_);
			_tmp32_ = window;
			_tmp33_ = _tmp32_->main_widget;
			_tmp34_ = bundle;
			main_widget_switch_page (_tmp33_, (gint) PAGE_PROFILE, _tmp34_);
		}
		result = TRUE;
		_g_object_unref0 (bundle);
		_g_free0 (term);
		return result;
	} else {
		const gchar* _tmp35_;
		gboolean _tmp36_;
		_tmp35_ = uri;
		_tmp36_ = g_str_has_prefix (_tmp35_, "#");
		if (_tmp36_) {
			CbBundle* bundle = NULL;
			CbBundle* _tmp37_;
			CbBundle* _tmp38_;
			const gchar* _tmp39_;
			MainWindow* _tmp40_;
			MainWidget* _tmp41_;
			CbBundle* _tmp42_;
			_tmp37_ = cb_bundle_new ();
			bundle = _tmp37_;
			_tmp38_ = bundle;
			_tmp39_ = uri;
			cb_bundle_put_string (_tmp38_, SEARCH_PAGE_KEY_QUERY, _tmp39_);
			_tmp40_ = window;
			_tmp41_ = _tmp40_->main_widget;
			_tmp42_ = bundle;
			main_widget_switch_page (_tmp41_, (gint) PAGE_SEARCH, _tmp42_);
			result = TRUE;
			_g_object_unref0 (bundle);
			_g_free0 (term);
			return result;
		} else {
			const gchar* _tmp43_;
			gboolean _tmp44_;
			_tmp43_ = uri;
			_tmp44_ = g_str_has_prefix (_tmp43_, "https://twitter.com/");
			if (_tmp44_) {
				gchar** parts = NULL;
				const gchar* _tmp45_;
				gchar** _tmp46_;
				gchar** _tmp47_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				const gchar* _tmp49_;
				_tmp45_ = uri;
				_tmp47_ = _tmp46_ = g_strsplit (_tmp45_, "/", 0);
				parts = _tmp47_;
				parts_length1 = _vala_array_length (_tmp46_);
				_parts_size_ = parts_length1;
				_tmp48_ = parts;
				_tmp48__length1 = parts_length1;
				_tmp49_ = _tmp48_[4];
				if (g_strcmp0 (_tmp49_, "status") == 0) {
					gint64 tweet_id = 0LL;
					gchar** _tmp50_;
					gint _tmp50__length1;
					const gchar* _tmp51_;
					gint64 _tmp52_;
					CbBundle* bundle = NULL;
					CbBundle* _tmp53_;
					CbBundle* _tmp54_;
					CbBundle* _tmp55_;
					gint64 _tmp56_;
					CbBundle* _tmp57_;
					gchar** _tmp58_;
					gint _tmp58__length1;
					const gchar* _tmp59_;
					MainWindow* _tmp60_;
					MainWidget* _tmp61_;
					CbBundle* _tmp62_;
					_tmp50_ = parts;
					_tmp50__length1 = parts_length1;
					_tmp51_ = _tmp50_[5];
					_tmp52_ = int64_parse (_tmp51_);
					tweet_id = _tmp52_;
					_tmp53_ = cb_bundle_new ();
					bundle = _tmp53_;
					_tmp54_ = bundle;
					cb_bundle_put_int (_tmp54_, TWEET_INFO_PAGE_KEY_MODE, TWEET_INFO_PAGE_BY_ID);
					_tmp55_ = bundle;
					_tmp56_ = tweet_id;
					cb_bundle_put_int64 (_tmp55_, TWEET_INFO_PAGE_KEY_TWEET_ID, _tmp56_);
					_tmp57_ = bundle;
					_tmp58_ = parts;
					_tmp58__length1 = parts_length1;
					_tmp59_ = _tmp58_[3];
					cb_bundle_put_string (_tmp57_, TWEET_INFO_PAGE_KEY_SCREEN_NAME, _tmp59_);
					_tmp60_ = window;
					_tmp61_ = _tmp60_->main_widget;
					_tmp62_ = bundle;
					main_widget_switch_page (_tmp61_, (gint) PAGE_TWEET_INFO, _tmp62_);
					result = TRUE;
					_g_object_unref0 (bundle);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (term);
					return result;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = FALSE;
	_g_free0 (term);
	return result;
}


void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account) {
	guint n_tweets = 0U;
	JsonArray* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GDateTime* now = NULL;
	GDateTime* _tmp3_;
	g_return_if_fail (json_array != NULL);
	g_return_if_fail (IS_TWEET_LIST_BOX (tweet_list));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = json_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	n_tweets = _tmp1_;
	_tmp2_ = n_tweets;
	if (_tmp2_ == ((guint) 0)) {
		return;
	}
	_tmp3_ = g_date_time_new_now_local ();
	now = _tmp3_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				guint _tmp6_;
				guint _tmp7_;
				CbTweet* tweet = NULL;
				CbTweet* _tmp8_;
				CbTweet* _tmp9_;
				JsonArray* _tmp10_;
				guint _tmp11_;
				JsonNode* _tmp12_;
				Account* _tmp13_;
				gint64 _tmp14_;
				GDateTime* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				Account* _tmp18_;
				CbUserCounter* _tmp19_;
				Account* _tmp23_;
				CbUserCounter* _tmp24_;
				CbTweet* _tmp25_;
				CbTweet* _tmp26_;
				CbMiniTweet* _tmp27_;
				Account* _tmp32_;
				CbTweet* _tmp33_;
				gboolean _tmp34_;
				TweetListBox* _tmp36_;
				CbTweetModel* _tmp37_;
				CbTweet* _tmp38_;
				if (!_tmp4_) {
					guint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = n_tweets;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = cb_tweet_new ();
				tweet = _tmp8_;
				_tmp9_ = tweet;
				_tmp10_ = json_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_element (_tmp10_, _tmp11_);
				_tmp13_ = account;
				_tmp14_ = _tmp13_->id;
				_tmp15_ = now;
				cb_tweet_load_from_json (_tmp9_, _tmp12_, _tmp14_, _tmp15_);
				_tmp18_ = account;
				_tmp19_ = _tmp18_->user_counter;
				if (_tmp19_ == NULL) {
					_tmp17_ = TRUE;
				} else {
					TweetListBox* _tmp20_;
					_tmp20_ = tweet_list;
					_tmp17_ = _tmp20_ == NULL;
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					TweetListBox* _tmp21_;
					GtkWidget* _tmp22_;
					_tmp21_ = tweet_list;
					_tmp22_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
					_tmp16_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_window_get_type ());
				}
				if (_tmp16_) {
					_g_object_unref0 (tweet);
					break;
				}
				_tmp23_ = account;
				_tmp24_ = _tmp23_->user_counter;
				_tmp25_ = tweet;
				cb_user_counter_id_seen (_tmp24_, &_tmp25_->source_tweet.author);
				_tmp26_ = tweet;
				_tmp27_ = _tmp26_->retweeted_tweet;
				if (_tmp27_ != NULL) {
					Account* _tmp28_;
					CbUserCounter* _tmp29_;
					CbTweet* _tmp30_;
					CbMiniTweet* _tmp31_;
					_tmp28_ = account;
					_tmp29_ = _tmp28_->user_counter;
					_tmp30_ = tweet;
					_tmp31_ = _tmp30_->retweeted_tweet;
					cb_user_counter_id_seen (_tmp29_, &(*_tmp31_).author);
				}
				_tmp32_ = account;
				_tmp33_ = tweet;
				_tmp34_ = account_filter_matches (_tmp32_, _tmp33_);
				if (_tmp34_) {
					CbTweet* _tmp35_;
					_tmp35_ = tweet;
					cb_tweet_set_flag (_tmp35_, (guint) CB_TWEET_STATE_HIDDEN_FILTERED);
				}
				_tmp36_ = tweet_list;
				_tmp37_ = _tmp36_->model;
				_tmp38_ = tweet;
				cb_tweet_model_add (_tmp37_, _tmp38_);
				_g_object_unref0 (tweet);
			}
		}
	}
	_g_date_time_unref0 (now);
}


void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index, gdouble px, gdouble py) {
	MediaDialog* media_dialog = NULL;
	CbTweet* _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	MediaDialog* _tmp4_;
	MainWindow* _tmp5_;
	g_return_if_fail (CB_IS_TWEET (t));
	g_return_if_fail (IS_MAIN_WINDOW (window));
	_tmp0_ = t;
	_tmp1_ = index;
	_tmp2_ = px;
	_tmp3_ = py;
	_tmp4_ = media_dialog_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	g_object_ref_sink (_tmp4_);
	media_dialog = _tmp4_;
	_tmp5_ = window;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (media_dialog);
}


void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1) {
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				CbTextEntity* _tmp3_;
				gint _tmp3__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = *entities;
				_tmp3__length1 = *entities_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							CbTextEntity* _tmp7_;
							gint _tmp7__length1;
							CbTextEntity* _tmp8_;
							gint _tmp8__length1;
							gint _tmp9_;
							CbTextEntity _tmp10_;
							guint _tmp11_;
							CbTextEntity* _tmp12_;
							gint _tmp12__length1;
							gint _tmp13_;
							CbTextEntity _tmp14_;
							guint _tmp15_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = k;
								k = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = k;
							_tmp7_ = *entities;
							_tmp7__length1 = *entities_length1;
							if (!(_tmp6_ < _tmp7__length1)) {
								break;
							}
							_tmp8_ = *entities;
							_tmp8__length1 = *entities_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_.from;
							_tmp12_ = *entities;
							_tmp12__length1 = *entities_length1;
							_tmp13_ = k;
							_tmp14_ = _tmp12_[_tmp13_];
							_tmp15_ = _tmp14_.from;
							if (_tmp11_ < _tmp15_) {
								CbTextEntity c = {0};
								CbTextEntity* _tmp16_;
								gint _tmp16__length1;
								gint _tmp17_;
								CbTextEntity _tmp18_;
								CbTextEntity _tmp19_ = {0};
								CbTextEntity* _tmp20_;
								gint _tmp20__length1;
								gint _tmp21_;
								CbTextEntity* _tmp22_;
								gint _tmp22__length1;
								gint _tmp23_;
								CbTextEntity _tmp24_;
								CbTextEntity _tmp25_ = {0};
								CbTextEntity _tmp26_;
								CbTextEntity* _tmp27_;
								gint _tmp27__length1;
								gint _tmp28_;
								CbTextEntity _tmp29_;
								CbTextEntity _tmp30_ = {0};
								CbTextEntity _tmp31_;
								_tmp16_ = *entities;
								_tmp16__length1 = *entities_length1;
								_tmp17_ = i;
								_tmp18_ = _tmp16_[_tmp17_];
								cb_text_entity_copy (&_tmp18_, &_tmp19_);
								c = _tmp19_;
								_tmp20_ = *entities;
								_tmp20__length1 = *entities_length1;
								_tmp21_ = i;
								_tmp22_ = *entities;
								_tmp22__length1 = *entities_length1;
								_tmp23_ = k;
								_tmp24_ = _tmp22_[_tmp23_];
								cb_text_entity_copy (&_tmp24_, &_tmp25_);
								cb_text_entity_free (&_tmp20_[_tmp21_]);
								_tmp20_[_tmp21_] = _tmp25_;
								_tmp26_ = _tmp20_[_tmp21_];
								_tmp27_ = *entities;
								_tmp27__length1 = *entities_length1;
								_tmp28_ = k;
								_tmp29_ = c;
								cb_text_entity_copy (&_tmp29_, &_tmp30_);
								cb_text_entity_free (&_tmp27_[_tmp28_]);
								_tmp27_[_tmp28_] = _tmp30_;
								_tmp31_ = _tmp27_[_tmp28_];
								cb_text_entity_free (&c);
							}
						}
					}
				}
			}
		}
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



