/* TweetListEntry.c generated by valac 0.34.6, the Vala compiler
 * generated from TweetListEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbTweet.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "CbTextTransform.h"
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbMedia.h"
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>


#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_DOUBLE_TAP_BUTTON (double_tap_button_get_type ())
#define DOUBLE_TAP_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButton))
#define DOUBLE_TAP_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButtonClass))
#define IS_DOUBLE_TAP_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOUBLE_TAP_BUTTON))
#define IS_DOUBLE_TAP_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOUBLE_TAP_BUTTON))
#define DOUBLE_TAP_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButtonClass))

typedef struct _DoubleTapButton DoubleTapButton;
typedef struct _DoubleTapButtonClass DoubleTapButtonClass;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _MultiMediaWidgetPrivate MultiMediaWidgetPrivate;

#define TYPE_MEDIA_VISIBILITY (media_visibility_get_type ())

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
typedef struct _Block60Data Block60Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block61Data Block61Data;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _TweetListEntryPrivate {
	GtkLabel* screen_name_label;
	TextButton* name_button;
	GtkLabel* time_delta_label;
	AvatarWidget* avatar_image;
	GtkLabel* text_label;
	GtkLabel* rt_label;
	GtkImage* rt_image;
	GtkImage* conversation_image;
	GtkImage* rt_status_image;
	GtkImage* fav_status_image;
	DoubleTapButton* retweet_button;
	GtkToggleButton* favorite_button;
	GtkGrid* grid;
	GtkStack* stack;
	GtkBox* action_box;
	GtkLabel* quote_label;
	TextButton* quote_name;
	GtkLabel* quote_time_delta;
	GtkLabel* quote_screen_name;
	GtkGrid* quote_grid;
	GtkStack* media_stack;
	MultiMediaWidget* mm_widget;
	gboolean _read_only;
	Account* account;
	MainWindow* main_window;
	gboolean values_set;
	gboolean delete_first_activated;
	gint64 start_time;
	gint64 end_time;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _MultiMediaWidget {
	GtkBox parent_instance;
	MultiMediaWidgetPrivate * priv;
	gboolean restrict_height;
	GtkWindow* window;
};

struct _MultiMediaWidgetClass {
	GtkBoxClass parent_class;
};

typedef enum  {
	MEDIA_VISIBILITY_SHOW = 1,
	MEDIA_VISIBILITY_HIDE = 2,
	MEDIA_VISIBILITY_HIDE_IN_TIMELINES = 3
} MediaVisibility;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block60Data {
	int _ref_count_;
	TweetListEntry* self;
	gchar* link_text;
};

struct _Block61Data {
	int _ref_count_;
	TweetListEntry* self;
	gulong realize_id;
};


static gpointer tweet_list_entry_parent_class = NULL;
static ITwitterItemIface* tweet_list_entry_itwitter_item_parent_iface = NULL;

GType itwitter_item_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType double_tap_button_get_type (void) G_GNUC_CONST;
GType multi_media_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define TWEET_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_LIST_ENTRY, TweetListEntryPrivate))
enum  {
	TWEET_LIST_ENTRY_DUMMY_PROPERTY,
	TWEET_LIST_ENTRY_READ_ONLY,
	TWEET_LIST_ENTRY_SORT_FACTOR,
	TWEET_LIST_ENTRY_SHOWS_ACTIONS
};
GSettings* settings_get (void);
static void tweet_list_entry_transform_flags_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_transform_flags_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void tweet_list_entry_hide_nsfw_content_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_hide_nsfw_content_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void tweet_list_entry_media_visibility_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_media_visibility_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void tweet_list_entry_quote_activated (TweetListEntry* self);
static void _tweet_list_entry_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_list_entry_delete_activated (TweetListEntry* self);
static void _tweet_list_entry_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
void text_button_set_markup (TextButton* self, const gchar* text);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_get_avatar (Twitter* self, gint64 user_id, const gchar* url, AvatarWidget* dest_widget, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_);
void twitter_get_avatar_finish (Twitter* self, GAsyncResult* _res_);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
CbTransformFlags settings_get_text_transform_flags (void);
static void tweet_list_entry_create_quote_grid (TweetListEntry* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void tweet_list_entry_state_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_state_changed_cb_cb_tweet_state_changed (CbTweet* _sender, gpointer self);
static void tweet_list_entry_create_media_widget (TweetListEntry* self, gboolean nsfw);
void multi_media_widget_set_all_media (MultiMediaWidget* self, CbMedia** medias, int medias_length1);
static void tweet_list_entry_media_clicked_cb (TweetListEntry* self, CbMedia* m, gint index);
static void _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked (MultiMediaWidget* _sender, CbMedia* m, gint index, gpointer self);
static void tweet_list_entry_media_invalid_cb (TweetListEntry* self);
static void _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid (MultiMediaWidget* _sender, gpointer self);
GType media_visibility_get_type (void) G_GNUC_CONST;
MediaVisibility settings_get_media_visiblity (void);
static void tweet_list_entry_reply_tweet_activated (TweetListEntry* self);
static void _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet (TweetListEntry* _sender, gpointer self);
static void tweet_list_entry_delete_tweet_activated (TweetListEntry* self);
static void _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet (TweetListEntry* _sender, gpointer self);
static void _tweet_list_entry_quote_activated_tweet_list_entry_quote_tweet (TweetListEntry* _sender, gpointer self);
static void __lambda193_ (TweetListEntry* self);
static void ___lambda193__tweet_list_entry_favorite_tweet (TweetListEntry* _sender, gpointer self);
static void __lambda194_ (TweetListEntry* self);
void double_tap_button_tap (DoubleTapButton* self);
static void ___lambda194__tweet_list_entry_retweet_tweet (TweetListEntry* _sender, gpointer self);
gint itwitter_item_update_time_delta (ITwitterItem* self, GDateTime* now);
gboolean settings_hide_nsfw_content (void);
void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index);
void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static void ___lambda192_ (TweetListEntry* self);
static void ____lambda192__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean tweet_list_entry_focus_out_cb (TweetListEntry* self, GdkEventFocus* evt);
void double_tap_button_reset (DoubleTapButton* self);
static gboolean _tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean tweet_list_entry_key_released_cb (TweetListEntry* self, GdkEventKey* evt);
static gboolean _tweet_list_entry_key_released_cb_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tweet_list_entry_retweet_button_toggled_cb (TweetListEntry* self);
void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_);
static void __lambda195_ (TweetListEntry* self);
static void ___lambda195__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static void _tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_list_entry_favorite_button_toggled_cb (TweetListEntry* self);
void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_);
static void __lambda196_ (TweetListEntry* self);
static void ___lambda196__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_list_entry_name_button_clicked_cb (TweetListEntry* self);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _tweet_list_entry_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tweet_list_entry_quote_name_button_clicked_cb (TweetListEntry* self);
static void tweet_list_entry_reply_button_clicked_cb (TweetListEntry* self);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
static void _tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tweet_list_entry_show_media_clicked_cb (TweetListEntry* self);
static gboolean tweet_list_entry_link_activated_cb (TweetListEntry* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _tweet_list_entry_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void tweet_list_entry_populate_popup_cb (TweetListEntry* self, GtkLabel* source, GtkMenu* menu);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static void ___lambda191_ (Block60Data* _data60_);
CbFilter* utils_create_persistent_filter (const gchar* content, Account* account);
void main_window_rerun_filters (MainWindow* self);
static void ____lambda191__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _tweet_list_entry_populate_popup_cb_gtk_label_populate_popup (GtkLabel* _sender, GtkMenu* menu, gpointer self);
void tweet_list_entry_set_avatar (TweetListEntry* self, cairo_surface_t* surface);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static gint tweet_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
static gboolean tweet_list_entry_anim_tick (TweetListEntry* self, GtkWidget* widget, GdkFrameClock* frame_clock);
gdouble ease_out_cubic (gdouble t);
void tweet_list_entry_fade_in (TweetListEntry* self);
static Block61Data* block61_data_ref (Block61Data* _data61_);
static void block61_data_unref (void * _userdata_);
static void __lambda33_ (Block61Data* _data61_);
#define TRANSITION_DURATION (200 * 1000)
static gboolean _tweet_list_entry_anim_tick_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static void ___lambda33__gtk_widget_realize (GtkWidget* _sender, gpointer self);
MultiMediaWidget* multi_media_widget_new (void);
MultiMediaWidget* multi_media_widget_construct (GType object_type);
static void _tweet_list_entry_show_media_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean tweet_list_entry_quote_link_activated_cb (TweetListEntry* self, const gchar* uri);
TextButton* text_button_new (const gchar* label);
TextButton* text_button_construct (GType object_type, const gchar* label);
static void _tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _tweet_list_entry_quote_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
static void tweet_list_entry_finalize (GObject* obj);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
static void _vala_tweet_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tweet_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry TWEET_LIST_ENTRY_action_entries[2] = {{"quote", _tweet_list_entry_quote_activated_gsimple_action_activate_callback}, {"delete", _tweet_list_entry_delete_activated_gsimple_action_activate_callback}};

static void _tweet_list_entry_transform_flags_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_list_entry_transform_flags_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_hide_nsfw_content_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_list_entry_hide_nsfw_content_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_media_visibility_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_list_entry_media_visibility_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_list_entry_quote_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_list_entry_delete_activated ((TweetListEntry*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch73_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch73_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally73;
	__catch73_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally73:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void _tweet_list_entry_state_changed_cb_cb_tweet_state_changed (CbTweet* _sender, gpointer self) {
	tweet_list_entry_state_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked (MultiMediaWidget* _sender, CbMedia* m, gint index, gpointer self) {
	tweet_list_entry_media_clicked_cb ((TweetListEntry*) self, m, index);
}


static void _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid (MultiMediaWidget* _sender, gpointer self) {
	tweet_list_entry_media_invalid_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_reply_tweet_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_delete_tweet_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_quote_activated_tweet_list_entry_quote_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_quote_activated ((TweetListEntry*) self);
}


static void __lambda193_ (TweetListEntry* self) {
	GtkToggleButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->favorite_button;
	_tmp1_ = self->priv->favorite_button;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (_tmp0_, !_tmp3_);
}


static void ___lambda193__tweet_list_entry_favorite_tweet (TweetListEntry* _sender, gpointer self) {
	__lambda193_ ((TweetListEntry*) self);
}


static void __lambda194_ (TweetListEntry* self) {
	DoubleTapButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	double_tap_button_tap (_tmp0_);
}


static void ___lambda194__tweet_list_entry_retweet_tweet (TweetListEntry* _sender, gpointer self) {
	__lambda194_ ((TweetListEntry*) self);
}


TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height) {
	TweetListEntry * self = NULL;
	Account* _tmp0_ = NULL;
	CbTweet* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	TextButton* _tmp4_ = NULL;
	CbTweet* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	CbTweet* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	CbTweet* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	AvatarWidget* _tmp27_ = NULL;
	CbTweet* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GtkLabel* _tmp30_ = NULL;
	CbTweet* _tmp31_ = NULL;
	CbTransformFlags _tmp32_ = 0;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	CbTweet* _tmp37_ = NULL;
	CbMiniTweet* _tmp38_ = NULL;
	CbTweet* _tmp72_ = NULL;
	CbMiniTweet* _tmp73_ = NULL;
	DoubleTapButton* _tmp91_ = NULL;
	CbTweet* _tmp92_ = NULL;
	gboolean _tmp93_ = FALSE;
	gboolean _tmp94_ = FALSE;
	CbTweet* _tmp95_ = NULL;
	gboolean _tmp96_ = FALSE;
	DoubleTapButton* _tmp101_ = NULL;
	GtkToggleButton* _tmp102_ = NULL;
	CbTweet* _tmp103_ = NULL;
	gboolean _tmp104_ = FALSE;
	CbTweet* _tmp105_ = NULL;
	GtkImage* _tmp106_ = NULL;
	CbTweet* _tmp107_ = NULL;
	gint64 _tmp108_ = 0LL;
	CbTweet* _tmp109_ = NULL;
	gboolean _tmp110_ = FALSE;
	GSimpleActionGroup* actions = NULL;
	GSimpleActionGroup* _tmp144_ = NULL;
	GSimpleActionGroup* _tmp145_ = NULL;
	GSimpleActionGroup* _tmp146_ = NULL;
	CbTweet* _tmp147_ = NULL;
	gint64 _tmp148_ = 0LL;
	Account* _tmp149_ = NULL;
	gint64 _tmp150_ = 0LL;
	CbTweet* _tmp153_ = NULL;
	gboolean _tmp154_ = FALSE;
	CbTweet* _tmp157_ = NULL;
	gboolean _tmp158_ = FALSE;
	CbTweet* _tmp160_ = NULL;
	gboolean _tmp161_ = FALSE;
	GSettings* _tmp163_ = NULL;
	GSettings* _tmp164_ = NULL;
	g_return_val_if_fail (CB_IS_TWEET (tweet), NULL);
	g_return_val_if_fail ((main_window == NULL) || IS_MAIN_WINDOW (main_window), NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (TweetListEntry*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = tweet;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->tweet);
	self->tweet = _tmp2_;
	_tmp3_ = main_window;
	self->priv->main_window = _tmp3_;
	_tmp4_ = self->priv->name_button;
	_tmp5_ = tweet;
	_tmp6_ = cb_tweet_get_user_name (_tmp5_);
	text_button_set_markup (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->screen_name_label;
	_tmp8_ = tweet;
	_tmp9_ = cb_tweet_get_screen_name (_tmp8_);
	_tmp10_ = g_strconcat ("@", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp7_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = tweet;
	_tmp13_ = _tmp12_->avatar_url;
	if (_tmp13_ != NULL) {
		gchar* avatar_url = NULL;
		CbTweet* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		Twitter* _tmp20_ = NULL;
		Twitter* _tmp21_ = NULL;
		CbTweet* _tmp22_ = NULL;
		gint64 _tmp23_ = 0LL;
		const gchar* _tmp24_ = NULL;
		AvatarWidget* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		_tmp14_ = tweet;
		_tmp15_ = _tmp14_->avatar_url;
		_tmp16_ = g_strdup (_tmp15_);
		avatar_url = _tmp16_;
		_tmp17_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		if (_tmp17_ == 2) {
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			_tmp18_ = avatar_url;
			_tmp19_ = string_replace (_tmp18_, "_normal", "_bigger");
			_g_free0 (avatar_url);
			avatar_url = _tmp19_;
		}
		_tmp20_ = twitter_get ();
		_tmp21_ = _tmp20_;
		_tmp22_ = tweet;
		_tmp23_ = cb_tweet_get_user_id (_tmp22_);
		_tmp24_ = avatar_url;
		_tmp25_ = self->priv->avatar_image;
		_tmp26_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		twitter_get_avatar (_tmp21_, _tmp23_, _tmp24_, _tmp25_, 48 * _tmp26_, FALSE, NULL, NULL);
		_g_object_unref0 (_tmp21_);
		_g_free0 (avatar_url);
	}
	_tmp27_ = self->priv->avatar_image;
	_tmp28_ = tweet;
	_tmp29_ = cb_tweet_is_flag_set (_tmp28_, (guint) CB_TWEET_STATE_VERIFIED);
	avatar_widget_set_verified (_tmp27_, _tmp29_);
	_tmp30_ = self->priv->text_label;
	_tmp31_ = tweet;
	_tmp32_ = settings_get_text_transform_flags ();
	_tmp33_ = cb_tweet_get_trimmed_text (_tmp31_, (guint) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = string_strip (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_label_set_label (_tmp30_, _tmp36_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_tmp37_ = tweet;
	_tmp38_ = _tmp37_->retweeted_tweet;
	if (_tmp38_ != NULL) {
		GtkLabel* _tmp39_ = NULL;
		GtkImage* _tmp40_ = NULL;
		GString* buff = NULL;
		GString* _tmp41_ = NULL;
		GString* _tmp42_ = NULL;
		GString* _tmp43_ = NULL;
		CbTweet* _tmp44_ = NULL;
		CbMiniTweet _tmp45_ = {0};
		CbUserIdentity _tmp46_ = {0};
		gint64 _tmp47_ = 0LL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		GString* _tmp50_ = NULL;
		GString* _tmp51_ = NULL;
		CbTweet* _tmp52_ = NULL;
		CbMiniTweet _tmp53_ = {0};
		CbUserIdentity _tmp54_ = {0};
		const gchar* _tmp55_ = NULL;
		GString* _tmp56_ = NULL;
		GString* _tmp57_ = NULL;
		CbTweet* _tmp58_ = NULL;
		CbMiniTweet _tmp59_ = {0};
		CbUserIdentity _tmp60_ = {0};
		const gchar* _tmp61_ = NULL;
		GString* _tmp62_ = NULL;
		GString* _tmp63_ = NULL;
		CbTweet* _tmp64_ = NULL;
		CbMiniTweet _tmp65_ = {0};
		CbUserIdentity _tmp66_ = {0};
		const gchar* _tmp67_ = NULL;
		GString* _tmp68_ = NULL;
		GtkLabel* _tmp69_ = NULL;
		GString* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		_tmp39_ = self->priv->rt_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget));
		_tmp40_ = self->priv->rt_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_widget_get_type (), GtkWidget));
		_tmp41_ = g_string_new ("");
		buff = _tmp41_;
		_tmp42_ = buff;
		_tmp43_ = g_string_append (_tmp42_, "<span underline='none'><a href=\"@");
		_tmp44_ = tweet;
		_tmp45_ = _tmp44_->source_tweet;
		_tmp46_ = _tmp45_.author;
		_tmp47_ = _tmp46_.id;
		_tmp48_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_string_append (_tmp43_, _tmp49_);
		_tmp51_ = g_string_append (_tmp50_, "/@");
		_tmp52_ = tweet;
		_tmp53_ = _tmp52_->source_tweet;
		_tmp54_ = _tmp53_.author;
		_tmp55_ = _tmp54_.screen_name;
		_tmp56_ = g_string_append (_tmp51_, _tmp55_);
		_tmp57_ = g_string_append (_tmp56_, "\" title=\"@");
		_tmp58_ = tweet;
		_tmp59_ = _tmp58_->source_tweet;
		_tmp60_ = _tmp59_.author;
		_tmp61_ = _tmp60_.screen_name;
		_tmp62_ = g_string_append (_tmp57_, _tmp61_);
		_tmp63_ = g_string_append (_tmp62_, "\">");
		_tmp64_ = tweet;
		_tmp65_ = _tmp64_->source_tweet;
		_tmp66_ = _tmp65_.author;
		_tmp67_ = _tmp66_.user_name;
		_tmp68_ = g_string_append (_tmp63_, _tmp67_);
		g_string_append (_tmp68_, "</a></span>");
		_g_free0 (_tmp49_);
		_tmp69_ = self->priv->rt_label;
		_tmp70_ = buff;
		_tmp71_ = _tmp70_->str;
		gtk_label_set_label (_tmp69_, _tmp71_);
		_g_string_free0 (buff);
	}
	_tmp72_ = tweet;
	_tmp73_ = _tmp72_->quoted_tweet;
	if (_tmp73_ != NULL) {
		GtkLabel* _tmp74_ = NULL;
		CbTweet* _tmp75_ = NULL;
		CbTransformFlags _tmp76_ = 0;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		TextButton* _tmp79_ = NULL;
		CbTweet* _tmp80_ = NULL;
		CbMiniTweet* _tmp81_ = NULL;
		CbUserIdentity _tmp82_ = {0};
		const gchar* _tmp83_ = NULL;
		GtkLabel* _tmp84_ = NULL;
		CbTweet* _tmp85_ = NULL;
		CbMiniTweet* _tmp86_ = NULL;
		CbUserIdentity _tmp87_ = {0};
		const gchar* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
		gchar* _tmp90_ = NULL;
		tweet_list_entry_create_quote_grid (self);
		_tmp74_ = self->priv->quote_label;
		_tmp75_ = tweet;
		_tmp76_ = settings_get_text_transform_flags ();
		_tmp77_ = cb_text_transform_tweet (_tmp75_->quoted_tweet, (guint) _tmp76_, (gint64) 0);
		_tmp78_ = _tmp77_;
		gtk_label_set_label (_tmp74_, _tmp78_);
		_g_free0 (_tmp78_);
		_tmp79_ = self->priv->quote_name;
		_tmp80_ = tweet;
		_tmp81_ = _tmp80_->quoted_tweet;
		_tmp82_ = (*_tmp81_).author;
		_tmp83_ = _tmp82_.user_name;
		text_button_set_markup (_tmp79_, _tmp83_);
		_tmp84_ = self->priv->quote_screen_name;
		_tmp85_ = tweet;
		_tmp86_ = _tmp85_->quoted_tweet;
		_tmp87_ = (*_tmp86_).author;
		_tmp88_ = _tmp87_.screen_name;
		_tmp89_ = g_strconcat ("@", _tmp88_, NULL);
		_tmp90_ = _tmp89_;
		gtk_label_set_label (_tmp84_, _tmp90_);
		_g_free0 (_tmp90_);
	}
	_tmp91_ = self->priv->retweet_button;
	_tmp92_ = tweet;
	_tmp93_ = cb_tweet_is_flag_set (_tmp92_, (guint) CB_TWEET_STATE_RETWEETED);
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp93_);
	_tmp95_ = tweet;
	_tmp96_ = cb_tweet_is_flag_set (_tmp95_, (guint) CB_TWEET_STATE_PROTECTED);
	if (_tmp96_) {
		CbTweet* _tmp97_ = NULL;
		gint64 _tmp98_ = 0LL;
		Account* _tmp99_ = NULL;
		gint64 _tmp100_ = 0LL;
		_tmp97_ = tweet;
		_tmp98_ = cb_tweet_get_user_id (_tmp97_);
		_tmp99_ = account;
		_tmp100_ = _tmp99_->id;
		_tmp94_ = _tmp98_ != _tmp100_;
	} else {
		_tmp94_ = FALSE;
	}
	_tmp101_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, gtk_widget_get_type (), GtkWidget), !_tmp94_);
	_tmp102_ = self->priv->favorite_button;
	_tmp103_ = tweet;
	_tmp104_ = cb_tweet_is_flag_set (_tmp103_, (guint) CB_TWEET_STATE_FAVORITED);
	gtk_toggle_button_set_active (_tmp102_, _tmp104_);
	_tmp105_ = tweet;
	g_signal_connect_object (_tmp105_, "state-changed", (GCallback) _tweet_list_entry_state_changed_cb_cb_tweet_state_changed, self, 0);
	_tmp106_ = self->priv->conversation_image;
	_tmp107_ = tweet;
	_tmp108_ = _tmp107_->reply_id;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, gtk_widget_get_type (), GtkWidget), _tmp108_ != ((gint64) 0));
	_tmp109_ = tweet;
	_tmp110_ = cb_tweet_has_inline_media (_tmp109_);
	if (_tmp110_) {
		CbTweet* _tmp111_ = NULL;
		gboolean _tmp112_ = FALSE;
		MultiMediaWidget* _tmp113_ = NULL;
		gboolean _tmp114_ = FALSE;
		MultiMediaWidget* _tmp115_ = NULL;
		CbTweet* _tmp116_ = NULL;
		gint _tmp117_ = 0;
		CbMedia** _tmp118_ = NULL;
		MultiMediaWidget* _tmp119_ = NULL;
		MultiMediaWidget* _tmp120_ = NULL;
		MultiMediaWidget* _tmp121_ = NULL;
		MainWindow* _tmp122_ = NULL;
		gboolean _tmp123_ = FALSE;
		GtkLabel* _tmp124_ = NULL;
		const gchar* _tmp125_ = NULL;
		const gchar* _tmp126_ = NULL;
		gint _tmp127_ = 0;
		gint _tmp128_ = 0;
		CbTweet* _tmp136_ = NULL;
		gboolean _tmp137_ = FALSE;
		GSettings* _tmp140_ = NULL;
		GSettings* _tmp141_ = NULL;
		MultiMediaWidget* _tmp142_ = NULL;
		MediaVisibility _tmp143_ = 0;
		_tmp111_ = tweet;
		_tmp112_ = cb_tweet_is_flag_set (_tmp111_, (guint) CB_TWEET_STATE_NSFW);
		tweet_list_entry_create_media_widget (self, _tmp112_);
		_tmp113_ = self->priv->mm_widget;
		_tmp114_ = restrict_height;
		_tmp113_->restrict_height = _tmp114_;
		_tmp115_ = self->priv->mm_widget;
		_tmp116_ = tweet;
		_tmp118_ = cb_tweet_get_medias (_tmp116_, &_tmp117_);
		multi_media_widget_set_all_media (_tmp115_, _tmp118_, _tmp117_);
		_tmp119_ = self->priv->mm_widget;
		g_signal_connect_object (_tmp119_, "media-clicked", (GCallback) _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked, self, 0);
		_tmp120_ = self->priv->mm_widget;
		g_signal_connect_object (_tmp120_, "media-invalid", (GCallback) _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid, self, 0);
		_tmp121_ = self->priv->mm_widget;
		_tmp122_ = main_window;
		_tmp121_->window = G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, gtk_window_get_type (), GtkWindow);
		_tmp124_ = self->priv->text_label;
		_tmp125_ = gtk_label_get_label (_tmp124_);
		_tmp126_ = _tmp125_;
		_tmp127_ = strlen (_tmp126_);
		_tmp128_ = _tmp127_;
		if (_tmp128_ == 0) {
			CbTweet* _tmp129_ = NULL;
			CbMiniTweet* _tmp130_ = NULL;
			_tmp129_ = tweet;
			_tmp130_ = _tmp129_->quoted_tweet;
			_tmp123_ = _tmp130_ == NULL;
		} else {
			_tmp123_ = FALSE;
		}
		if (_tmp123_) {
			GtkStack* _tmp131_ = NULL;
			_tmp131_ = self->priv->media_stack;
			if (_tmp131_ == NULL) {
				GtkGrid* _tmp132_ = NULL;
				MultiMediaWidget* _tmp133_ = NULL;
				_tmp132_ = self->priv->grid;
				_tmp133_ = self->priv->mm_widget;
				gtk_container_child_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, gtk_widget_get_type (), GtkWidget), "top-attach", 1, NULL);
			} else {
				GtkGrid* _tmp134_ = NULL;
				GtkStack* _tmp135_ = NULL;
				_tmp134_ = self->priv->grid;
				_tmp135_ = self->priv->media_stack;
				gtk_container_child_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, gtk_widget_get_type (), GtkWidget), "top-attach", 1, NULL);
			}
		}
		_tmp136_ = tweet;
		_tmp137_ = cb_tweet_is_flag_set (_tmp136_, (guint) CB_TWEET_STATE_NSFW);
		if (_tmp137_) {
			GSettings* _tmp138_ = NULL;
			GSettings* _tmp139_ = NULL;
			_tmp138_ = settings_get ();
			_tmp139_ = _tmp138_;
			g_signal_connect_object (_tmp139_, "changed::hide-nsfw-content", (GCallback) _tweet_list_entry_hide_nsfw_content_changed_cb_g_settings_changed, self, 0);
			_g_object_unref0 (_tmp139_);
		}
		_tmp140_ = settings_get ();
		_tmp141_ = _tmp140_;
		g_signal_connect_object (_tmp141_, "changed::media-visibility", (GCallback) _tweet_list_entry_media_visibility_changed_cb_g_settings_changed, self, 0);
		_g_object_unref0 (_tmp141_);
		_tmp142_ = self->priv->mm_widget;
		_tmp143_ = settings_get_media_visiblity ();
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp142_, gtk_widget_get_type (), GtkWidget), _tmp143_ == MEDIA_VISIBILITY_SHOW);
	}
	_tmp144_ = g_simple_action_group_new ();
	actions = _tmp144_;
	_tmp145_ = actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, g_action_map_get_type (), GActionMap), TWEET_LIST_ENTRY_action_entries, G_N_ELEMENTS (TWEET_LIST_ENTRY_action_entries), self);
	_tmp146_ = actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, g_action_group_get_type (), GActionGroup));
	_tmp147_ = tweet;
	_tmp148_ = cb_tweet_get_user_id (_tmp147_);
	_tmp149_ = account;
	_tmp150_ = _tmp149_->id;
	if (_tmp148_ != _tmp150_) {
		GSimpleActionGroup* _tmp151_ = NULL;
		GAction* _tmp152_ = NULL;
		_tmp151_ = actions;
		_tmp152_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, g_action_map_get_type (), GActionMap), "delete");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	_tmp153_ = tweet;
	_tmp154_ = cb_tweet_is_flag_set (_tmp153_, (guint) CB_TWEET_STATE_PROTECTED);
	if (_tmp154_) {
		GSimpleActionGroup* _tmp155_ = NULL;
		GAction* _tmp156_ = NULL;
		_tmp155_ = actions;
		_tmp156_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp155_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	g_signal_connect_object (self, "reply-tweet", (GCallback) _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet, self, 0);
	g_signal_connect_object (self, "delete-tweet", (GCallback) _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet, self, 0);
	g_signal_connect_object (self, "quote-tweet", (GCallback) _tweet_list_entry_quote_activated_tweet_list_entry_quote_tweet, self, 0);
	g_signal_connect_object (self, "favorite-tweet", (GCallback) ___lambda193__tweet_list_entry_favorite_tweet, self, 0);
	g_signal_connect_object (self, "retweet-tweet", (GCallback) ___lambda194__tweet_list_entry_retweet_tweet, self, 0);
	_tmp157_ = tweet;
	_tmp158_ = cb_tweet_is_flag_set (_tmp157_, (guint) CB_TWEET_STATE_FAVORITED);
	if (_tmp158_) {
		GtkImage* _tmp159_ = NULL;
		_tmp159_ = self->priv->fav_status_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp160_ = tweet;
	_tmp161_ = cb_tweet_is_flag_set (_tmp160_, (guint) CB_TWEET_STATE_RETWEETED);
	if (_tmp161_) {
		GtkImage* _tmp162_ = NULL;
		_tmp162_ = self->priv->rt_status_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, gtk_widget_get_type (), GtkWidget));
	}
	self->priv->values_set = TRUE;
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem), NULL);
	_tmp163_ = settings_get ();
	_tmp164_ = _tmp163_;
	g_signal_connect_object (_tmp164_, "changed::text-transform-flags", (GCallback) _tweet_list_entry_transform_flags_changed_cb_g_settings_changed, self, 0);
	_g_object_unref0 (_tmp164_);
	_g_object_unref0 (actions);
	return self;
}


TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height) {
	return tweet_list_entry_construct (TYPE_TWEET_LIST_ENTRY, tweet, main_window, account, restrict_height);
}


static void tweet_list_entry_media_visibility_changed_cb (TweetListEntry* self) {
	MediaVisibility _tmp0_ = 0;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = settings_get_media_visiblity ();
	if (_tmp0_ == MEDIA_VISIBILITY_SHOW) {
		MultiMediaWidget* _tmp1_ = NULL;
		_tmp1_ = self->priv->mm_widget;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	} else {
		MultiMediaWidget* _tmp2_ = NULL;
		_tmp2_ = self->priv->mm_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	}
}


static void tweet_list_entry_transform_flags_changed_cb (TweetListEntry* self) {
	GtkLabel* _tmp0_ = NULL;
	CbTweet* _tmp1_ = NULL;
	CbTransformFlags _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	CbTweet* _tmp5_ = NULL;
	CbMiniTweet* _tmp6_ = NULL;
	gboolean _tmp12_ = FALSE;
	MultiMediaWidget* _tmp13_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->text_label;
	_tmp1_ = self->tweet;
	_tmp2_ = settings_get_text_transform_flags ();
	_tmp3_ = cb_tweet_get_trimmed_text (_tmp1_, (guint) _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->tweet;
	_tmp6_ = _tmp5_->quoted_tweet;
	if (_tmp6_ != NULL) {
		GtkLabel* _tmp7_ = NULL;
		CbTweet* _tmp8_ = NULL;
		CbTransformFlags _tmp9_ = 0;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp7_ = self->priv->quote_label;
		_tmp8_ = self->tweet;
		_tmp9_ = settings_get_text_transform_flags ();
		_tmp10_ = cb_text_transform_tweet (_tmp8_->quoted_tweet, (guint) _tmp9_, (gint64) 0);
		_tmp11_ = _tmp10_;
		gtk_label_set_label (_tmp7_, _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp13_ = self->priv->mm_widget;
	if (_tmp13_ != NULL) {
		CbTweet* _tmp14_ = NULL;
		CbMiniTweet* _tmp15_ = NULL;
		_tmp14_ = self->tweet;
		_tmp15_ = _tmp14_->quoted_tweet;
		_tmp12_ = _tmp15_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkLabel* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		_tmp16_ = self->priv->text_label;
		_tmp17_ = gtk_label_get_label (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ == 0) {
			GtkGrid* _tmp21_ = NULL;
			MultiMediaWidget* _tmp22_ = NULL;
			_tmp21_ = self->priv->grid;
			_tmp22_ = self->priv->mm_widget;
			gtk_container_child_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), "top-attach", 1, NULL);
		} else {
			GtkGrid* _tmp23_ = NULL;
			MultiMediaWidget* _tmp24_ = NULL;
			_tmp23_ = self->priv->grid;
			_tmp24_ = self->priv->mm_widget;
			gtk_container_child_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), "top-attach", 7, NULL);
		}
	}
}


static void tweet_list_entry_hide_nsfw_content_changed_cb (TweetListEntry* self) {
	GtkStack* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	CbTweet* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->media_stack;
	_vala_assert (_tmp0_ != NULL, "this.media_stack != null");
	_tmp2_ = self->tweet;
	_tmp3_ = cb_tweet_is_flag_set (_tmp2_, (guint) CB_TWEET_STATE_NSFW);
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = settings_hide_nsfw_content ();
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkStack* _tmp5_ = NULL;
		_tmp5_ = self->priv->media_stack;
		gtk_stack_set_visible_child_name (_tmp5_, "nsfw");
	} else {
		GtkStack* _tmp6_ = NULL;
		MultiMediaWidget* _tmp7_ = NULL;
		_tmp6_ = self->priv->media_stack;
		_tmp7_ = self->priv->mm_widget;
		gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	}
}


static void tweet_list_entry_media_clicked_cb (TweetListEntry* self, CbMedia* m, gint index) {
	CbTweet* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (CB_IS_MEDIA (m));
	_tmp0_ = self->tweet;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = index;
	tweet_utils_handle_media_click (_tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda192_ (TweetListEntry* self) {
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
}


static void ____lambda192__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda192_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_delete_tweet_activated (TweetListEntry* self) {
	CbTweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	Account* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = cb_tweet_get_user_id (_tmp0_);
	_tmp2_ = self->priv->account;
	_tmp3_ = _tmp2_->id;
	if (_tmp1_ != _tmp3_) {
		return;
	}
	_tmp4_ = self->priv->delete_first_activated;
	if (_tmp4_) {
		Account* _tmp5_ = NULL;
		CbTweet* _tmp6_ = NULL;
		_tmp5_ = self->priv->account;
		_tmp6_ = self->tweet;
		tweet_utils_delete_tweet (_tmp5_, _tmp6_, ____lambda192__gasync_ready_callback, g_object_ref (self));
	} else {
		self->priv->delete_first_activated = TRUE;
	}
}


static gboolean tweet_list_entry_focus_out_cb (TweetListEntry* self, GdkEventFocus* evt) {
	gboolean result = FALSE;
	DoubleTapButton* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	self->priv->delete_first_activated = FALSE;
	_tmp0_ = self->priv->retweet_button;
	double_tap_button_reset (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean _tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = tweet_list_entry_focus_out_cb ((TweetListEntry*) self, event);
	return result;
}


static gboolean tweet_list_entry_key_released_cb (TweetListEntry* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _tweet_list_entry_key_released_cb_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tweet_list_entry_key_released_cb ((TweetListEntry*) self, event);
	return result;
}


/**
   * Retweets or un-retweets the tweet.
   */
static void __lambda195_ (TweetListEntry* self) {
	DoubleTapButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda195__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda195_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_retweet_button_toggled_cb (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	CbTweet* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Account* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gboolean retweetable = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	DoubleTapButton* _tmp10_ = NULL;
	Account* _tmp11_ = NULL;
	CbTweet* _tmp12_ = NULL;
	DoubleTapButton* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp1_ = self->tweet;
	_tmp2_ = cb_tweet_get_user_id (_tmp1_);
	_tmp3_ = self->priv->account;
	_tmp4_ = _tmp3_->id;
	if (_tmp2_ == _tmp4_) {
		_tmp0_ = TRUE;
	} else {
		CbTweet* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = self->tweet;
		_tmp6_ = cb_tweet_is_flag_set (_tmp5_, (guint) CB_TWEET_STATE_PROTECTED);
		_tmp0_ = !_tmp6_;
	}
	retweetable = _tmp0_;
	_tmp8_ = retweetable;
	if (!_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		_tmp9_ = self->priv->values_set;
		_tmp7_ = !_tmp9_;
	}
	if (_tmp7_) {
		return;
	}
	_tmp10_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp11_ = self->priv->account;
	_tmp12_ = self->tweet;
	_tmp13_ = self->priv->retweet_button;
	_tmp14_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp15_ = _tmp14_;
	tweet_utils_set_retweet_status (_tmp11_, _tmp12_, _tmp15_, ___lambda195__gasync_ready_callback, g_object_ref (self));
	_tmp16_ = tweet_list_entry_get_shows_actions (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		tweet_list_entry_toggle_mode (self);
	}
}


static void _tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_list_entry_retweet_button_toggled_cb ((TweetListEntry*) self);
}


static void __lambda196_ (TweetListEntry* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda196__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda196_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_favorite_button_toggled_cb (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	CbTweet* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->account;
	_tmp3_ = self->tweet;
	_tmp4_ = self->priv->favorite_button;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	tweet_utils_set_favorite_status (_tmp2_, _tmp3_, _tmp6_, ___lambda196__gasync_ready_callback, g_object_ref (self));
	_tmp7_ = tweet_list_entry_get_shows_actions (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		tweet_list_entry_toggle_mode (self);
	}
}


static void _tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_list_entry_favorite_button_toggled_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_name_button_clicked_cb (TweetListEntry* self) {
	gint64 user_id = 0LL;
	gchar* screen_name = NULL;
	CbTweet* _tmp0_ = NULL;
	CbMiniTweet* _tmp1_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp20_ = NULL;
	gint64 _tmp21_ = 0LL;
	const gchar* _tmp22_ = NULL;
	MainWindow* _tmp23_ = NULL;
	MainWidget* _tmp24_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->retweeted_tweet;
	if (_tmp1_ != NULL) {
		CbTweet* _tmp2_ = NULL;
		CbMiniTweet* _tmp3_ = NULL;
		CbUserIdentity _tmp4_ = {0};
		gint64 _tmp5_ = 0LL;
		CbTweet* _tmp6_ = NULL;
		CbMiniTweet* _tmp7_ = NULL;
		CbUserIdentity _tmp8_ = {0};
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp2_ = self->tweet;
		_tmp3_ = _tmp2_->retweeted_tweet;
		_tmp4_ = (*_tmp3_).author;
		_tmp5_ = _tmp4_.id;
		user_id = _tmp5_;
		_tmp6_ = self->tweet;
		_tmp7_ = _tmp6_->retweeted_tweet;
		_tmp8_ = (*_tmp7_).author;
		_tmp9_ = _tmp8_.screen_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (screen_name);
		screen_name = _tmp10_;
	} else {
		CbTweet* _tmp11_ = NULL;
		CbMiniTweet _tmp12_ = {0};
		CbUserIdentity _tmp13_ = {0};
		gint64 _tmp14_ = 0LL;
		CbTweet* _tmp15_ = NULL;
		CbMiniTweet _tmp16_ = {0};
		CbUserIdentity _tmp17_ = {0};
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp11_ = self->tweet;
		_tmp12_ = _tmp11_->source_tweet;
		_tmp13_ = _tmp12_.author;
		_tmp14_ = _tmp13_.id;
		user_id = _tmp14_;
		_tmp15_ = self->tweet;
		_tmp16_ = _tmp15_->source_tweet;
		_tmp17_ = _tmp16_.author;
		_tmp18_ = _tmp17_.screen_name;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (screen_name);
		screen_name = _tmp19_;
	}
	_tmp20_ = bundle_new ();
	bundle = _tmp20_;
	_tmp21_ = user_id;
	bundle_put_int64 (bundle, "user_id", _tmp21_);
	_tmp22_ = screen_name;
	bundle_put_string (bundle, "screen_name", _tmp22_);
	_tmp23_ = self->priv->main_window;
	_tmp24_ = _tmp23_->main_widget;
	main_widget_switch_page (_tmp24_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
	_g_free0 (screen_name);
}


static void _tweet_list_entry_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_name_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_quote_name_button_clicked_cb (TweetListEntry* self) {
	CbTweet* _tmp0_ = NULL;
	CbMiniTweet* _tmp1_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp2_ = NULL;
	CbTweet* _tmp3_ = NULL;
	CbMiniTweet* _tmp4_ = NULL;
	CbUserIdentity _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	CbTweet* _tmp7_ = NULL;
	CbMiniTweet* _tmp8_ = NULL;
	CbUserIdentity _tmp9_ = {0};
	const gchar* _tmp10_ = NULL;
	MainWindow* _tmp11_ = NULL;
	MainWidget* _tmp12_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->quoted_tweet;
	_vala_assert (_tmp1_ != NULL, "tweet.quoted_tweet != null");
	_tmp2_ = bundle_new ();
	bundle = _tmp2_;
	_tmp3_ = self->tweet;
	_tmp4_ = _tmp3_->quoted_tweet;
	_tmp5_ = (*_tmp4_).author;
	_tmp6_ = _tmp5_.id;
	bundle_put_int64 (bundle, "user_id", _tmp6_);
	_tmp7_ = self->tweet;
	_tmp8_ = _tmp7_->quoted_tweet;
	_tmp9_ = (*_tmp8_).author;
	_tmp10_ = _tmp9_.screen_name;
	bundle_put_string (bundle, "screen_name", _tmp10_);
	_tmp11_ = self->priv->main_window;
	_tmp12_ = _tmp11_->main_widget;
	main_widget_switch_page (_tmp12_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void tweet_list_entry_reply_button_clicked_cb (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	ComposeTweetWindow* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	_tmp4_ = ctw;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = tweet_list_entry_get_shows_actions (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		tweet_list_entry_toggle_mode (self);
	}
	_g_object_unref0 (ctw);
}


static void _tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_reply_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_show_media_clicked_cb (TweetListEntry* self) {
	GtkStack* _tmp0_ = NULL;
	MultiMediaWidget* _tmp1_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->media_stack;
	_tmp1_ = self->priv->mm_widget;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
}


static void tweet_list_entry_quote_activated (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	ComposeTweetWindow* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_QUOTE);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	_tmp4_ = ctw;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = tweet_list_entry_get_shows_actions (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		tweet_list_entry_toggle_mode (self);
	}
	_g_object_unref0 (ctw);
}


static void tweet_list_entry_reply_tweet_activated (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void tweet_list_entry_delete_activated (TweetListEntry* self) {
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->delete_first_activated = TRUE;
	g_signal_emit_by_name (self, "delete-tweet");
	tweet_list_entry_toggle_mode (self);
}


static gboolean tweet_list_entry_link_activated_cb (TweetListEntry* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = uri;
	_tmp2_ = self->priv->main_window;
	_tmp3_ = tweet_utils_activate_link (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean _tweet_list_entry_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_list_entry_link_activated_cb ((TweetListEntry*) self, uri);
	return result;
}


static Block60Data* block60_data_ref (Block60Data* _data60_) {
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}


static void block60_data_unref (void * _userdata_) {
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		TweetListEntry* self;
		self = _data60_->self;
		_g_free0 (_data60_->link_text);
		_g_object_unref0 (self);
		g_slice_free (Block60Data, _data60_);
	}
}


static void ___lambda191_ (Block60Data* _data60_) {
	TweetListEntry* self;
	const gchar* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbFilter* _tmp2_ = NULL;
	CbFilter* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	self = _data60_->self;
	_tmp0_ = _data60_->link_text;
	_tmp1_ = self->priv->account;
	_tmp2_ = utils_create_persistent_filter (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->main_window;
	main_window_rerun_filters (_tmp4_);
}


static void ____lambda191__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda191_ (self);
}


static void tweet_list_entry_populate_popup_cb (TweetListEntry* self, GtkLabel* source, GtkMenu* menu) {
	Block60Data* _data60_;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (GTK_IS_LABEL (source));
	g_return_if_fail (GTK_IS_MENU (menu));
	_data60_ = g_slice_new0 (Block60Data);
	_data60_->_ref_count_ = 1;
	_data60_->self = g_object_ref (self);
	_tmp0_ = source;
	_tmp1_ = gtk_label_get_current_uri (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_data60_->link_text = _tmp2_;
	_tmp3_ = _data60_->link_text;
	_tmp4_ = g_str_has_prefix (_tmp3_, "#");
	if (_tmp4_) {
		GtkMenuItem* item = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GtkMenuItem* _tmp9_ = NULL;
		GtkMenuItem* _tmp10_ = NULL;
		GtkMenuItem* _tmp11_ = NULL;
		GtkMenuItem* _tmp12_ = NULL;
		GtkMenu* _tmp13_ = NULL;
		GtkMenuItem* _tmp14_ = NULL;
		_tmp5_ = _ ("Block %s");
		_tmp6_ = _data60_->link_text;
		_tmp7_ = g_strdup_printf (_tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp8_);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		item = _tmp10_;
		_tmp11_ = item;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
		_tmp12_ = item;
		g_signal_connect_data (_tmp12_, "activate", (GCallback) ____lambda191__gtk_menu_item_activate, block60_data_ref (_data60_), (GClosureNotify) block60_data_unref, 0);
		_tmp13_ = menu;
		_tmp14_ = item;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (item);
	}
	block60_data_unref (_data60_);
	_data60_ = NULL;
}


static void _tweet_list_entry_populate_popup_cb_gtk_label_populate_popup (GtkLabel* _sender, GtkMenu* menu, gpointer self) {
	tweet_list_entry_populate_popup_cb ((TweetListEntry*) self, _sender, menu);
}


static void tweet_list_entry_media_invalid_cb (TweetListEntry* self) {
	CbTransformFlags flags = 0;
	CbTransformFlags _tmp0_ = 0;
	gchar* new_text = NULL;
	CbTweet* _tmp1_ = NULL;
	CbMiniTweet* _tmp2_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	CbTweet* _tmp11_ = NULL;
	CbMiniTweet* _tmp12_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = settings_get_text_transform_flags ();
	flags = _tmp0_ & (~CB_TEXT_TRANSFORM_REMOVE_MEDIA_LINKS);
	_tmp1_ = self->tweet;
	_tmp2_ = _tmp1_->retweeted_tweet;
	if (_tmp2_ != NULL) {
		CbTweet* _tmp3_ = NULL;
		CbTransformFlags _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		_tmp3_ = self->tweet;
		_tmp4_ = flags;
		_tmp5_ = cb_text_transform_tweet (_tmp3_->retweeted_tweet, (guint) _tmp4_, (gint64) 0);
		_g_free0 (new_text);
		new_text = _tmp5_;
	} else {
		CbTweet* _tmp6_ = NULL;
		CbTransformFlags _tmp7_ = 0;
		gchar* _tmp8_ = NULL;
		_tmp6_ = self->tweet;
		_tmp7_ = flags;
		_tmp8_ = cb_text_transform_tweet (&_tmp6_->source_tweet, (guint) _tmp7_, (gint64) 0);
		_g_free0 (new_text);
		new_text = _tmp8_;
	}
	_tmp9_ = self->priv->text_label;
	_tmp10_ = new_text;
	gtk_label_set_label (_tmp9_, _tmp10_);
	_tmp11_ = self->tweet;
	_tmp12_ = _tmp11_->quoted_tweet;
	if (_tmp12_ != NULL) {
		gchar* new_quote_text = NULL;
		CbTweet* _tmp13_ = NULL;
		CbTransformFlags _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		GtkLabel* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp13_ = self->tweet;
		_tmp14_ = flags;
		_tmp15_ = cb_text_transform_tweet (_tmp13_->quoted_tweet, (guint) _tmp14_, (gint64) 0);
		new_quote_text = _tmp15_;
		_tmp16_ = self->priv->quote_label;
		_tmp17_ = new_quote_text;
		gtk_label_set_label (_tmp16_, _tmp17_);
		_g_free0 (new_quote_text);
	}
	_g_free0 (new_text);
}


static void tweet_list_entry_state_changed_cb (TweetListEntry* self) {
	GtkImage* _tmp0_ = NULL;
	CbTweet* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkToggleButton* _tmp3_ = NULL;
	CbTweet* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	DoubleTapButton* _tmp6_ = NULL;
	CbTweet* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkImage* _tmp9_ = NULL;
	CbTweet* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	CbTweet* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->values_set = FALSE;
	_tmp0_ = self->priv->fav_status_image;
	_tmp1_ = self->tweet;
	_tmp2_ = cb_tweet_is_flag_set (_tmp1_, (guint) CB_TWEET_STATE_FAVORITED);
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), _tmp2_);
	_tmp3_ = self->priv->favorite_button;
	_tmp4_ = self->tweet;
	_tmp5_ = cb_tweet_is_flag_set (_tmp4_, (guint) CB_TWEET_STATE_FAVORITED);
	gtk_toggle_button_set_active (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->retweet_button;
	_tmp7_ = self->tweet;
	_tmp8_ = cb_tweet_is_flag_set (_tmp7_, (guint) CB_TWEET_STATE_RETWEETED);
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp8_);
	_tmp9_ = self->priv->rt_status_image;
	_tmp10_ = self->tweet;
	_tmp11_ = cb_tweet_is_flag_set (_tmp10_, (guint) CB_TWEET_STATE_RETWEETED);
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), _tmp11_);
	_tmp12_ = self->tweet;
	_tmp13_ = cb_tweet_is_flag_set (_tmp12_, (guint) CB_TWEET_STATE_DELETED);
	if (_tmp13_) {
		GtkStack* _tmp14_ = NULL;
		GtkGrid* _tmp15_ = NULL;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp14_ = self->priv->stack;
		_tmp15_ = self->priv->grid;
		gtk_stack_set_visible_child (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
	}
	self->priv->values_set = TRUE;
}


void tweet_list_entry_set_avatar (TweetListEntry* self, cairo_surface_t* surface) {
	AvatarWidget* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (surface != NULL);
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = surface;
	avatar_widget_set_surface (_tmp0_, _tmp1_);
}


/**
   * Updates the time delta label in the upper right
   *
   * @return The seconds between the current time and
   *         the time the tweet was created
   */
static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static gint tweet_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now) {
	TweetListEntry * self;
	gint result = 0;
	GDateTime* cur_time = NULL;
	GDateTime* _tmp0_ = NULL;
	gint64 _tmp4_ = 0LL;
	CbTweet* _tmp5_ = NULL;
	CbMiniTweet* _tmp6_ = NULL;
	GDateTime* then = NULL;
	GDateTime* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GDateTime* _tmp15_ = NULL;
	GDateTime* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GDateTime* _tmp29_ = NULL;
	GDateTime* _tmp30_ = NULL;
	GTimeSpan _tmp31_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = now;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_ = NULL;
		_tmp1_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp1_;
	} else {
		GDateTime* _tmp2_ = NULL;
		GDateTime* _tmp3_ = NULL;
		_tmp2_ = now;
		_tmp3_ = _g_date_time_ref0 (_tmp2_);
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp3_;
	}
	_tmp5_ = self->tweet;
	_tmp6_ = _tmp5_->retweeted_tweet;
	if (_tmp6_ != NULL) {
		CbTweet* _tmp7_ = NULL;
		CbMiniTweet* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		_tmp7_ = self->tweet;
		_tmp8_ = _tmp7_->retweeted_tweet;
		_tmp9_ = (*_tmp8_).created_at;
		_tmp4_ = _tmp9_;
	} else {
		CbTweet* _tmp10_ = NULL;
		CbMiniTweet _tmp11_ = {0};
		gint64 _tmp12_ = 0LL;
		_tmp10_ = self->tweet;
		_tmp11_ = _tmp10_->source_tweet;
		_tmp12_ = _tmp11_.created_at;
		_tmp4_ = _tmp12_;
	}
	_tmp13_ = g_date_time_new_from_unix_local (_tmp4_);
	then = _tmp13_;
	_tmp14_ = self->priv->time_delta_label;
	_tmp15_ = then;
	_tmp16_ = cur_time;
	_tmp17_ = utils_get_time_delta (_tmp15_, _tmp16_);
	_tmp18_ = _tmp17_;
	gtk_label_set_label (_tmp14_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = self->priv->quote_time_delta;
	if (_tmp19_ != NULL) {
		CbTweet* _tmp20_ = NULL;
		CbMiniTweet* _tmp21_ = NULL;
		gint64 _tmp22_ = 0LL;
		GDateTime* _tmp23_ = NULL;
		GtkLabel* _tmp24_ = NULL;
		GDateTime* _tmp25_ = NULL;
		GDateTime* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		_tmp20_ = self->tweet;
		_tmp21_ = _tmp20_->quoted_tweet;
		_tmp22_ = (*_tmp21_).created_at;
		_tmp23_ = g_date_time_new_from_unix_local (_tmp22_);
		_g_date_time_unref0 (then);
		then = _tmp23_;
		_tmp24_ = self->priv->quote_time_delta;
		_tmp25_ = then;
		_tmp26_ = cur_time;
		_tmp27_ = utils_get_time_delta (_tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		gtk_label_set_label (_tmp24_, _tmp28_);
		_g_free0 (_tmp28_);
	}
	_tmp29_ = cur_time;
	_tmp30_ = then;
	_tmp31_ = g_date_time_difference (_tmp29_, _tmp30_);
	result = (gint) ((_tmp31_ / 1000.0) / 1000.0);
	_g_date_time_unref0 (then);
	_g_date_time_unref0 (cur_time);
	return result;
}


void tweet_list_entry_toggle_mode (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	GtkStack* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->action_box;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		GtkStack* _tmp5_ = NULL;
		GtkGrid* _tmp6_ = NULL;
		_tmp5_ = self->priv->stack;
		_tmp6_ = self->priv->grid;
		gtk_stack_set_visible_child (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), TRUE);
	} else {
		GtkStack* _tmp7_ = NULL;
		GtkBox* _tmp8_ = NULL;
		_tmp7_ = self->priv->stack;
		_tmp8_ = self->priv->action_box;
		gtk_stack_set_visible_child (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	}
}


static gboolean tweet_list_entry_anim_tick (TweetListEntry* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	gint64 now = 0LL;
	GdkFrameClock* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gdouble t = 0.0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = frame_clock;
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = self->priv->end_time;
	if (_tmp2_ > _tmp3_) {
		gtk_widget_set_opacity (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 1.0);
		result = FALSE;
		return result;
	}
	_tmp4_ = now;
	_tmp5_ = self->priv->start_time;
	_tmp6_ = self->priv->end_time;
	_tmp7_ = self->priv->start_time;
	t = (_tmp4_ - _tmp5_) / ((gdouble) (_tmp6_ - _tmp7_));
	_tmp8_ = t;
	_tmp9_ = ease_out_cubic (_tmp8_);
	t = _tmp9_;
	_tmp10_ = t;
	gtk_widget_set_opacity (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp10_);
	result = TRUE;
	return result;
}


static Block61Data* block61_data_ref (Block61Data* _data61_) {
	g_atomic_int_inc (&_data61_->_ref_count_);
	return _data61_;
}


static void block61_data_unref (void * _userdata_) {
	Block61Data* _data61_;
	_data61_ = (Block61Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data61_->_ref_count_)) {
		TweetListEntry* self;
		self = _data61_->self;
		_g_object_unref0 (self);
		g_slice_free (Block61Data, _data61_);
	}
}


static gboolean _tweet_list_entry_anim_tick_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = tweet_list_entry_anim_tick ((TweetListEntry*) self, widget, frame_clock);
	return result;
}


static void __lambda33_ (Block61Data* _data61_) {
	TweetListEntry* self;
	GdkFrameClock* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gulong _tmp3_ = 0UL;
	self = _data61_->self;
	_tmp0_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	self->priv->start_time = _tmp1_;
	_tmp2_ = self->priv->start_time;
	self->priv->end_time = _tmp2_ + TRANSITION_DURATION;
	gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tweet_list_entry_anim_tick_gtk_tick_callback, g_object_ref (self), g_object_unref);
	_tmp3_ = _data61_->realize_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp3_);
}


static void ___lambda33__gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	__lambda33_ (self);
}


void tweet_list_entry_fade_in (TweetListEntry* self) {
	Block61Data* _data61_;
	gboolean _tmp0_ = FALSE;
	gulong _tmp1_ = 0UL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_data61_ = g_slice_new0 (Block61Data);
	_data61_->_ref_count_ = 1;
	_data61_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp0_) {
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		block61_data_unref (_data61_);
		_data61_ = NULL;
		return;
	}
	_data61_->realize_id = (gulong) 0;
	_tmp1_ = g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "realize", (GCallback) ___lambda33__gtk_widget_realize, block61_data_ref (_data61_), (GClosureNotify) block61_data_unref, 0);
	_data61_->realize_id = _tmp1_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	block61_data_unref (_data61_);
	_data61_ = NULL;
}


static void _tweet_list_entry_show_media_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_show_media_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_create_media_widget (TweetListEntry* self, gboolean nsfw) {
	MultiMediaWidget* _tmp0_ = NULL;
	MultiMediaWidget* _tmp1_ = NULL;
	MultiMediaWidget* _tmp2_ = NULL;
	MultiMediaWidget* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = multi_media_widget_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->mm_widget);
	self->priv->mm_widget = _tmp0_;
	_tmp1_ = self->priv->mm_widget;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
	_tmp2_ = self->priv->mm_widget;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp3_ = self->priv->mm_widget;
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp4_ = nsfw;
	if (_tmp4_) {
		GtkStack* _tmp5_ = NULL;
		GtkStack* _tmp6_ = NULL;
		GtkStack* _tmp7_ = NULL;
		MultiMediaWidget* _tmp8_ = NULL;
		GtkBox* box = NULL;
		GtkBox* _tmp9_ = NULL;
		GtkBox* _tmp10_ = NULL;
		GtkLabel* label = NULL;
		const gchar* _tmp11_ = NULL;
		GtkLabel* _tmp12_ = NULL;
		GtkLabel* _tmp13_ = NULL;
		GtkLabel* _tmp14_ = NULL;
		GtkLabel* _tmp15_ = NULL;
		GtkLabel* _tmp16_ = NULL;
		GtkBox* _tmp17_ = NULL;
		GtkLabel* _tmp18_ = NULL;
		GtkButton* button = NULL;
		const gchar* _tmp19_ = NULL;
		GtkButton* _tmp20_ = NULL;
		GtkButton* _tmp21_ = NULL;
		GtkButton* _tmp22_ = NULL;
		GtkButton* _tmp23_ = NULL;
		GtkBox* _tmp24_ = NULL;
		GtkButton* _tmp25_ = NULL;
		GtkStack* _tmp26_ = NULL;
		GtkBox* _tmp27_ = NULL;
		GtkStack* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		CbTweet* _tmp33_ = NULL;
		CbMiniTweet* _tmp34_ = NULL;
		_tmp5_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->media_stack);
		self->priv->media_stack = _tmp5_;
		_tmp6_ = self->priv->media_stack;
		gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
		_tmp7_ = self->priv->media_stack;
		_tmp8_ = self->priv->mm_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
		g_object_ref_sink (_tmp9_);
		box = _tmp9_;
		_tmp10_ = box;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
		_tmp11_ = _ ("This tweet contains images marked as inappropriate");
		_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
		g_object_ref_sink (_tmp12_);
		label = _tmp12_;
		_tmp13_ = label;
		gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), 12);
		_tmp14_ = label;
		gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), 12);
		_tmp15_ = label;
		g_object_set (_tmp15_, "wrap", TRUE, NULL);
		_tmp16_ = label;
		g_object_set (_tmp16_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
		_tmp17_ = box;
		_tmp18_ = label;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
		_tmp19_ = _ ("Show anyway");
		_tmp20_ = (GtkButton*) gtk_button_new_with_label (_tmp19_);
		g_object_ref_sink (_tmp20_);
		button = _tmp20_;
		_tmp21_ = button;
		gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
		_tmp22_ = button;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
		_tmp23_ = button;
		g_signal_connect_object (_tmp23_, "clicked", (GCallback) _tweet_list_entry_show_media_clicked_cb_gtk_button_clicked, self, 0);
		_tmp24_ = box;
		_tmp25_ = button;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
		_tmp26_ = self->priv->media_stack;
		_tmp27_ = box;
		gtk_stack_add_named (_tmp26_, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), "nsfw");
		_tmp28_ = self->priv->media_stack;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
		_tmp29_ = settings_hide_nsfw_content ();
		if (_tmp29_) {
			GtkStack* _tmp30_ = NULL;
			_tmp30_ = self->priv->media_stack;
			gtk_stack_set_visible_child_name (_tmp30_, "nsfw");
		} else {
			GtkStack* _tmp31_ = NULL;
			MultiMediaWidget* _tmp32_ = NULL;
			_tmp31_ = self->priv->media_stack;
			_tmp32_ = self->priv->mm_widget;
			gtk_stack_set_visible_child (_tmp31_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp33_ = self->tweet;
		_tmp34_ = _tmp33_->quoted_tweet;
		if (_tmp34_ != NULL) {
			GtkStack* _tmp35_ = NULL;
			GtkGrid* _tmp36_ = NULL;
			GtkStack* _tmp37_ = NULL;
			_tmp35_ = self->priv->media_stack;
			gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget), 12);
			_tmp36_ = self->priv->quote_grid;
			_tmp37_ = self->priv->media_stack;
			gtk_grid_attach (_tmp36_, G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget), 0, 2, 3, 1);
		} else {
			GtkGrid* _tmp38_ = NULL;
			GtkStack* _tmp39_ = NULL;
			_tmp38_ = self->priv->grid;
			_tmp39_ = self->priv->media_stack;
			gtk_grid_attach (_tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget), 1, 6, 7, 1);
		}
		_g_object_unref0 (button);
		_g_object_unref0 (label);
		_g_object_unref0 (box);
	} else {
		MultiMediaWidget* _tmp40_ = NULL;
		CbTweet* _tmp41_ = NULL;
		CbMiniTweet* _tmp42_ = NULL;
		_tmp40_ = self->priv->mm_widget;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_widget_get_type (), GtkWidget));
		_tmp41_ = self->tweet;
		_tmp42_ = _tmp41_->quoted_tweet;
		if (_tmp42_ != NULL) {
			MultiMediaWidget* _tmp43_ = NULL;
			GtkGrid* _tmp44_ = NULL;
			MultiMediaWidget* _tmp45_ = NULL;
			_tmp43_ = self->priv->mm_widget;
			gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget), 12);
			_tmp44_ = self->priv->quote_grid;
			_tmp45_ = self->priv->mm_widget;
			gtk_grid_attach (_tmp44_, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget), 0, 2, 3, 1);
		} else {
			GtkGrid* _tmp46_ = NULL;
			MultiMediaWidget* _tmp47_ = NULL;
			_tmp46_ = self->priv->grid;
			_tmp47_ = self->priv->mm_widget;
			gtk_grid_attach (_tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget), 1, 6, 7, 1);
		}
	}
}


static gboolean tweet_list_entry_quote_link_activated_cb (TweetListEntry* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = uri;
	_tmp2_ = self->priv->main_window;
	_tmp3_ = tweet_utils_activate_link (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static void _tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_quote_name_button_clicked_cb ((TweetListEntry*) self);
}


static gboolean _tweet_list_entry_quote_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_list_entry_quote_link_activated_cb ((TweetListEntry*) self, uri);
	return result;
}


static void tweet_list_entry_create_quote_grid (TweetListEntry* self) {
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	TextButton* _tmp5_ = NULL;
	TextButton* _tmp6_ = NULL;
	TextButton* _tmp7_ = NULL;
	TextButton* _tmp8_ = NULL;
	TextButton* _tmp9_ = NULL;
	TextButton* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	TextButton* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkStyleContext* _tmp18_ = NULL;
	GtkGrid* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp32_ = NULL;
	PangoAttribute* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkGrid* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkLabel* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	GtkStyleContext* _tmp40_ = NULL;
	GtkGrid* _tmp41_ = NULL;
	GtkLabel* _tmp42_ = NULL;
	GtkGrid* _tmp43_ = NULL;
	GtkGrid* _tmp44_ = NULL;
	GtkGrid* _tmp45_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->quote_grid);
	self->priv->quote_grid = _tmp0_;
	_tmp1_ = self->priv->quote_grid;
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp2_ = self->priv->quote_grid;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp3_ = self->priv->quote_grid;
	_tmp4_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp4_, "quote");
	_tmp5_ = text_button_new ("");
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->quote_name);
	self->priv->quote_name = _tmp5_;
	_tmp6_ = self->priv->quote_name;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp7_ = self->priv->quote_name;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp8_ = self->priv->quote_name;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), 12);
	_tmp9_ = self->priv->quote_name;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp10_ = self->priv->quote_name;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp11_ = self->priv->quote_grid;
	_tmp12_ = self->priv->quote_name;
	gtk_grid_attach (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), 0, 0, 1, 1);
	_tmp13_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->quote_screen_name);
	self->priv->quote_screen_name = _tmp13_;
	_tmp14_ = self->priv->quote_screen_name;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp15_ = self->priv->quote_screen_name;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp16_ = self->priv->quote_screen_name;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp17_ = self->priv->quote_screen_name;
	_tmp18_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp18_, "dim-label");
	_tmp19_ = self->priv->quote_grid;
	_tmp20_ = self->priv->quote_screen_name;
	gtk_grid_attach (_tmp19_, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), 1, 0, 1, 1);
	_tmp21_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->quote_label);
	self->priv->quote_label = _tmp21_;
	_tmp22_ = self->priv->quote_label;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp23_ = self->priv->quote_label;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp24_ = self->priv->quote_label;
	gtk_label_set_xalign (_tmp24_, (gfloat) 0);
	_tmp25_ = self->priv->quote_label;
	gtk_label_set_use_markup (_tmp25_, TRUE);
	_tmp26_ = self->priv->quote_label;
	g_object_set (_tmp26_, "wrap", TRUE, NULL);
	_tmp27_ = self->priv->quote_label;
	g_object_set (_tmp27_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp28_ = self->priv->quote_label;
	gtk_label_set_track_visited_links (_tmp28_, FALSE);
	_tmp29_ = self->priv->quote_label;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget), 12);
	_tmp30_ = self->priv->quote_label;
	g_signal_connect_object (_tmp30_, "activate-link", (GCallback) _tweet_list_entry_quote_link_activated_cb_gtk_label_activate_link, self, 0);
	_tmp31_ = self->priv->quote_label;
	g_signal_connect_object (_tmp31_, "populate-popup", (GCallback) _tweet_list_entry_populate_popup_cb_gtk_label_populate_popup, self, 0);
	_tmp32_ = pango_attr_list_new ();
	attrs = _tmp32_;
	_tmp33_ = pango_attr_style_new (PANGO_STYLE_ITALIC);
	pango_attr_list_insert (attrs, _tmp33_);
	_tmp34_ = self->priv->quote_label;
	gtk_label_set_attributes (_tmp34_, attrs);
	_tmp35_ = self->priv->quote_grid;
	_tmp36_ = self->priv->quote_label;
	gtk_grid_attach (_tmp35_, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), 0, 1, 3, 1);
	_tmp37_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->quote_time_delta);
	self->priv->quote_time_delta = _tmp37_;
	_tmp38_ = self->priv->quote_time_delta;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
	_tmp39_ = self->priv->quote_time_delta;
	_tmp40_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp40_, "dim-label");
	_tmp41_ = self->priv->quote_grid;
	_tmp42_ = self->priv->quote_time_delta;
	gtk_grid_attach (_tmp41_, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget), 2, 0, 1, 1);
	_tmp43_ = self->priv->quote_grid;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget));
	_tmp44_ = self->priv->grid;
	_tmp45_ = self->priv->quote_grid;
	gtk_grid_attach (_tmp44_, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget), 1, 3, 6, 1);
	_pango_attr_list_unref0 (attrs);
}


void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	MultiMediaWidget* _tmp1_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	TextButton* _tmp5_ = NULL;
	GtkLabel* name_label = NULL;
	CbTweet* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkStyleContext* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = value;
	_vala_assert (_tmp0_, "value");
	_tmp1_ = self->priv->mm_widget;
	if (_tmp1_ != NULL) {
		MultiMediaWidget* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->mm_widget;
		_tmp3_ = value;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), !_tmp3_);
	}
	_tmp4_ = self->priv->grid;
	_tmp5_ = self->priv->name_button;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->tweet;
	_tmp7_ = cb_tweet_get_user_name (_tmp6_);
	_tmp8_ = g_strconcat ("<b>", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "</b>", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	name_label = _tmp13_;
	gtk_label_set_use_markup (name_label, TRUE);
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (name_label, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (name_label, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = self->priv->grid;
	gtk_grid_attach (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (name_label, gtk_widget_get_type (), GtkWidget), 1, 0, 1, 1);
	_tmp15_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp15_, "read-only");
	_tmp16_ = value;
	self->priv->_read_only = _tmp16_;
	_g_object_unref0 (name_label);
	g_object_notify ((GObject *) self, "read-only");
}


static gint64 tweet_list_entry_real_get_sort_factor (ITwitterItem* base) {
	gint64 result;
	TweetListEntry* self;
	CbTweet* _tmp0_ = NULL;
	CbMiniTweet _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->source_tweet;
	_tmp2_ = _tmp1_.id;
	result = _tmp2_;
	return result;
}


gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self) {
	gboolean result;
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->action_box;
	result = _tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget);
	return result;
}


static void tweet_list_entry_class_init (TweetListEntryClass * klass) {
	gint TweetListEntry_private_offset;
	GtkBindingSet* binding_set = NULL;
	GTypeClass* _tmp0_ = NULL;
	GObjectClass* _tmp1_ = NULL;
	GtkBindingSet* _tmp2_ = NULL;
	GtkBindingSet* _tmp3_ = NULL;
	GtkBindingSet* _tmp4_ = NULL;
	GtkBindingSet* _tmp5_ = NULL;
	GtkBindingSet* _tmp6_ = NULL;
	GtkBindingSet* _tmp7_ = NULL;
	GtkBindingSet* _tmp8_ = NULL;
	tweet_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetListEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_list_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_list_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_list_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_SORT_FACTOR, g_param_spec_int64 ("sort-factor", "sort-factor", "sort-factor", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_SHOWS_ACTIONS, g_param_spec_boolean ("shows-actions", "shows-actions", "shows-actions", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	TweetListEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/tweet-list-entry.ui");
	g_signal_new ("reply_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("favorite_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("retweet_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("delete_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("quote_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_delta_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, time_delta_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, conversation_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_status_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_status_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_status_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, fav_status_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "retweet_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, retweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_box", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, action_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "focus_out_cb", G_CALLBACK(_tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_released_cb", G_CALLBACK(_tweet_list_entry_key_released_cb_gtk_widget_key_release_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retweet_button_toggled_cb", G_CALLBACK(_tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_button_toggled_cb", G_CALLBACK(_tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "name_button_clicked_cb", G_CALLBACK(_tweet_list_entry_name_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reply_button_clicked_cb", G_CALLBACK(_tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "link_activated_cb", G_CALLBACK(_tweet_list_entry_link_activated_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "populate_popup_cb", G_CALLBACK(_tweet_list_entry_populate_popup_cb_gtk_label_populate_popup));
	_tmp0_ = g_type_class_ref (TYPE_TWEET_LIST_ENTRY);
	_tmp1_ = (GObjectClass*) _tmp0_;
	_tmp2_ = gtk_binding_set_by_class (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_type_class_unref0 (_tmp1_);
	binding_set = _tmp3_;
	_tmp4_ = binding_set;
	gtk_binding_entry_add_signal (_tmp4_, (guint) GDK_KEY_r, 0, "reply-tweet", (guint) 0, NULL, NULL);
	_tmp5_ = binding_set;
	gtk_binding_entry_add_signal (_tmp5_, (guint) GDK_KEY_d, 0, "delete-tweet", (guint) 0, NULL, NULL);
	_tmp6_ = binding_set;
	gtk_binding_entry_add_signal (_tmp6_, (guint) GDK_KEY_t, 0, "retweet-tweet", (guint) 0, NULL, NULL);
	_tmp7_ = binding_set;
	gtk_binding_entry_add_signal (_tmp7_, (guint) GDK_KEY_f, 0, "favorite-tweet", (guint) 0, NULL, NULL);
	_tmp8_ = binding_set;
	gtk_binding_entry_add_signal (_tmp8_, (guint) GDK_KEY_q, 0, "quote-tweet", (guint) 0, NULL, NULL);
}


static void tweet_list_entry_itwitter_item_interface_init (ITwitterItemIface * iface) {
	tweet_list_entry_itwitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*)(ITwitterItem*, GDateTime*)) tweet_list_entry_real_update_time_delta;
	iface->get_sort_factor = tweet_list_entry_real_get_sort_factor;
}


static void tweet_list_entry_instance_init (TweetListEntry * self) {
	self->priv = TWEET_LIST_ENTRY_GET_PRIVATE (self);
	self->priv->quote_label = NULL;
	self->priv->quote_name = NULL;
	self->priv->quote_time_delta = NULL;
	self->priv->quote_screen_name = NULL;
	self->priv->quote_grid = NULL;
	self->priv->media_stack = NULL;
	self->priv->mm_widget = NULL;
	self->priv->_read_only = FALSE;
	self->priv->values_set = FALSE;
	self->priv->delete_first_activated = FALSE;
	g_type_ensure (TYPE_TEXT_BUTTON);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_DOUBLE_TAP_BUTTON);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void tweet_list_entry_finalize (GObject* obj) {
	TweetListEntry * self;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GQuark _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	CbTweet* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	MultiMediaWidget* _tmp12_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("changed::text-transform-flags", G_TYPE_SETTINGS, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _tweet_list_entry_transform_flags_changed_cb_g_settings_changed, self);
	_g_object_unref0 (_tmp1_);
	_tmp5_ = self->tweet;
	_tmp6_ = cb_tweet_is_flag_set (_tmp5_, (guint) CB_TWEET_STATE_NSFW);
	if (_tmp6_) {
		GtkStack* _tmp7_ = NULL;
		_tmp7_ = self->priv->media_stack;
		_tmp4_ = _tmp7_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GSettings* _tmp8_ = NULL;
		GSettings* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		GQuark _tmp11_ = 0U;
		_tmp8_ = settings_get ();
		_tmp9_ = _tmp8_;
		g_signal_parse_name ("changed::hide-nsfw-content", G_TYPE_SETTINGS, &_tmp10_, &_tmp11_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, _tmp11_, NULL, (GCallback) _tweet_list_entry_hide_nsfw_content_changed_cb_g_settings_changed, self);
		_g_object_unref0 (_tmp9_);
	}
	_tmp12_ = self->priv->mm_widget;
	if (_tmp12_ != NULL) {
		GSettings* _tmp13_ = NULL;
		GSettings* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		GQuark _tmp16_ = 0U;
		_tmp13_ = settings_get ();
		_tmp14_ = _tmp13_;
		g_signal_parse_name ("changed::media-visibility", G_TYPE_SETTINGS, &_tmp15_, &_tmp16_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, _tmp16_, NULL, (GCallback) _tweet_list_entry_media_visibility_changed_cb_g_settings_changed, self);
		_g_object_unref0 (_tmp14_);
	}
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->time_delta_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->rt_label);
	_g_object_unref0 (self->priv->rt_image);
	_g_object_unref0 (self->priv->conversation_image);
	_g_object_unref0 (self->priv->rt_status_image);
	_g_object_unref0 (self->priv->fav_status_image);
	_g_object_unref0 (self->priv->retweet_button);
	_g_object_unref0 (self->priv->favorite_button);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->action_box);
	_g_object_unref0 (self->priv->quote_label);
	_g_object_unref0 (self->priv->quote_name);
	_g_object_unref0 (self->priv->quote_time_delta);
	_g_object_unref0 (self->priv->quote_screen_name);
	_g_object_unref0 (self->priv->quote_grid);
	_g_object_unref0 (self->priv->media_stack);
	_g_object_unref0 (self->priv->mm_widget);
	_g_object_unref0 (self->tweet);
	G_OBJECT_CLASS (tweet_list_entry_parent_class)->finalize (obj);
}


GType tweet_list_entry_get_type (void) {
	static volatile gsize tweet_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetListEntry), 0, (GInstanceInitFunc) tweet_list_entry_instance_init, NULL };
		static const GInterfaceInfo itwitter_item_info = { (GInterfaceInitFunc) tweet_list_entry_itwitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_list_entry_type_id;
		tweet_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "TweetListEntry", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_list_entry_type_id, TYPE_ITWITTER_ITEM, &itwitter_item_info);
		g_once_init_leave (&tweet_list_entry_type_id__volatile, tweet_list_entry_type_id);
	}
	return tweet_list_entry_type_id__volatile;
}


static void _vala_tweet_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	switch (property_id) {
		case TWEET_LIST_ENTRY_SORT_FACTOR:
		g_value_set_int64 (value, itwitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case TWEET_LIST_ENTRY_SHOWS_ACTIONS:
		g_value_set_boolean (value, tweet_list_entry_get_shows_actions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	switch (property_id) {
		case TWEET_LIST_ENTRY_READ_ONLY:
		tweet_list_entry_set_read_only (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



