/* UserStream.c generated by valac 0.34.6, the Vala compiler
 * generated from UserStream.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */
/* See https://dev.twitter.com/docs/streaming-apis/messages*/

#include <glib.h>
#include <glib-object.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy-call.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rest/rest-proxy.h>


#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;
typedef struct _UserStreamPrivate UserStreamPrivate;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _UserStream {
	GObject parent_instance;
	UserStreamPrivate * priv;
};

struct _UserStreamClass {
	GObjectClass parent_class;
};

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _UserStreamPrivate {
	OAuthProxy* proxy;
	RestProxyCall* proxy_call;
	GString* data;
	GPtrArray* receivers;
	GNetworkMonitor* network_monitor;
	guint network_timeout_id;
	guint heartbeat_timeout_id;
	gchar* account_name;
	Account* account;
	gboolean network_available;
	gboolean stopping;
	gboolean restarting;
	gboolean running;
};


static gpointer user_stream_parent_class = NULL;

GType stream_message_type_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_STREAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_STREAM, UserStreamPrivate))
enum  {
	USER_STREAM_DUMMY_PROPERTY,
	USER_STREAM_TOKEN,
	USER_STREAM_TOKEN_SECRET
};
UserStream* user_stream_new (Account* account);
UserStream* user_stream_construct (GType object_type, Account* account);
const gchar* account_get_screen_name (Account* self);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
static void user_stream_network_changed_cb (UserStream* self, gboolean available);
static void _user_stream_network_changed_cb_g_network_monitor_network_changed (GNetworkMonitor* _sender, gboolean available, gpointer self);
static void user_stream_start_network_timeout (UserStream* self);
void user_stream_register (UserStream* self, IMessageReceiver* receiver);
void user_stream_unregister (UserStream* self, IMessageReceiver* receiver);
static void user_stream_restart (UserStream* self);
void user_stream_start (UserStream* self);
static void user_stream_start_heartbeat_timeout (UserStream* self);
void user_stream_parse_data_cb (UserStream* self, RestProxyCall* call, const gchar* buf, gsize length, GError* _error_);
static void _user_stream_parse_data_cb_rest_proxy_call_continuous_callback (RestProxyCall* call, const gchar* buf, gsize len, GError* _error_, GObject* weak_object, gpointer self);
void user_stream_stop (UserStream* self);
static gboolean __lambda10_ (UserStream* self);
static gboolean ___lambda10__gsource_func (gpointer self);
static gboolean __lambda9_ (UserStream* self);
static gboolean ___lambda9__gsource_func (gpointer self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
void account_set_friends (Account* self, JsonArray* friends_array);
static StreamMessageType user_stream_get_event_type (UserStream* self, const gchar* evt_str);
void imessage_receiver_stream_message_received (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
static void _vala_JsonNode_free (JsonNode* self);
void user_stream_set_token (UserStream* self, const gchar* value);
void user_stream_set_token_secret (UserStream* self, const gchar* value);
static void user_stream_finalize (GObject* obj);
static void _vala_user_stream_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType stream_message_type_get_type (void) {
	static volatile gsize stream_message_type_type_id__volatile = 0;
	if (g_once_init_enter (&stream_message_type_type_id__volatile)) {
		static const GEnumValue values[] = {{STREAM_MESSAGE_TYPE_UNSUPPORTED, "STREAM_MESSAGE_TYPE_UNSUPPORTED", "unsupported"}, {STREAM_MESSAGE_TYPE_DELETE, "STREAM_MESSAGE_TYPE_DELETE", "delete"}, {STREAM_MESSAGE_TYPE_SCRUB_GEO, "STREAM_MESSAGE_TYPE_SCRUB_GEO", "scrub-geo"}, {STREAM_MESSAGE_TYPE_LIMIT, "STREAM_MESSAGE_TYPE_LIMIT", "limit"}, {STREAM_MESSAGE_TYPE_DISCONNECT, "STREAM_MESSAGE_TYPE_DISCONNECT", "disconnect"}, {STREAM_MESSAGE_TYPE_FRIENDS, "STREAM_MESSAGE_TYPE_FRIENDS", "friends"}, {STREAM_MESSAGE_TYPE_EVENT, "STREAM_MESSAGE_TYPE_EVENT", "event"}, {STREAM_MESSAGE_TYPE_WARNING, "STREAM_MESSAGE_TYPE_WARNING", "warning"}, {STREAM_MESSAGE_TYPE_DIRECT_MESSAGE, "STREAM_MESSAGE_TYPE_DIRECT_MESSAGE", "direct-message"}, {STREAM_MESSAGE_TYPE_TWEET, "STREAM_MESSAGE_TYPE_TWEET", "tweet"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED, "STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED", "event-list-created"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED, "STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED", "event-list-destroyed"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED, "STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED", "event-list-updated"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED, "STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED", "event-list-unsubscribed"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED, "STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED", "event-list-subscribed"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED, "STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED", "event-list-member-added"}, {STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED, "STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED", "event-list-member-removed"}, {STREAM_MESSAGE_TYPE_EVENT_FAVORITE, "STREAM_MESSAGE_TYPE_EVENT_FAVORITE", "event-favorite"}, {STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE, "STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE", "event-unfavorite"}, {STREAM_MESSAGE_TYPE_EVENT_FOLLOW, "STREAM_MESSAGE_TYPE_EVENT_FOLLOW", "event-follow"}, {STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW, "STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW", "event-unfollow"}, {STREAM_MESSAGE_TYPE_EVENT_BLOCK, "STREAM_MESSAGE_TYPE_EVENT_BLOCK", "event-block"}, {STREAM_MESSAGE_TYPE_EVENT_UNBLOCK, "STREAM_MESSAGE_TYPE_EVENT_UNBLOCK", "event-unblock"}, {STREAM_MESSAGE_TYPE_EVENT_MUTE, "STREAM_MESSAGE_TYPE_EVENT_MUTE", "event-mute"}, {STREAM_MESSAGE_TYPE_EVENT_UNMUTE, "STREAM_MESSAGE_TYPE_EVENT_UNMUTE", "event-unmute"}, {STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE, "STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE", "event-user-update"}, {STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET, "STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET", "event-quoted-tweet"}, {0, NULL, NULL}};
		GType stream_message_type_type_id;
		stream_message_type_type_id = g_enum_register_static ("StreamMessageType", values);
		g_once_init_leave (&stream_message_type_type_id__volatile, stream_message_type_type_id);
	}
	return stream_message_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _user_stream_network_changed_cb_g_network_monitor_network_changed (GNetworkMonitor* _sender, gboolean available, gpointer self) {
	user_stream_network_changed_cb ((UserStream*) self, available);
}


UserStream* user_stream_construct (GType object_type, Account* account) {
	UserStream * self = NULL;
	Account* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	OAuthProxy* _tmp13_ = NULL;
	GNetworkMonitor* _tmp14_ = NULL;
	GNetworkMonitor* _tmp15_ = NULL;
	GNetworkMonitor* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GNetworkMonitor* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (UserStream*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	_tmp1_ = account_get_screen_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->account_name);
	self->priv->account_name = _tmp3_;
	_tmp4_ = account;
	self->priv->account = _tmp4_;
	_tmp5_ = g_ptr_array_new_full ((guint) 0, NULL);
	_g_ptr_array_unref0 (self->priv->receivers);
	self->priv->receivers = _tmp5_;
	_tmp6_ = self->priv->account_name;
	_tmp7_ = g_strconcat ("CREATING USER STREAM FOR ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	g_debug ("UserStream.vala:84: %s", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = settings_get_consumer_key ();
	_tmp10_ = _tmp9_;
	_tmp11_ = settings_get_consumer_secret ();
	_tmp12_ = _tmp11_;
	_tmp13_ = (OAuthProxy*) oauth_proxy_new (_tmp10_, _tmp12_, "https://userstream.twitter.com/", FALSE);
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp14_ = g_network_monitor_get_default ();
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->priv->network_monitor);
	self->priv->network_monitor = _tmp15_;
	_tmp16_ = self->priv->network_monitor;
	_tmp17_ = g_network_monitor_get_network_available (_tmp16_);
	self->priv->network_available = _tmp17_;
	_tmp18_ = self->priv->network_monitor;
	g_signal_connect_object (_tmp18_, "network-changed", (GCallback) _user_stream_network_changed_cb_g_network_monitor_network_changed, self, 0);
	_tmp19_ = self->priv->network_available;
	if (!_tmp19_) {
		user_stream_start_network_timeout (self);
	}
	return self;
}


UserStream* user_stream_new (Account* account) {
	return user_stream_construct (TYPE_USER_STREAM, account);
}


void user_stream_register (UserStream* self, IMessageReceiver* receiver) {
	GPtrArray* _tmp0_ = NULL;
	IMessageReceiver* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	g_return_if_fail (IS_IMESSAGE_RECEIVER (receiver));
	_tmp0_ = self->priv->receivers;
	_tmp1_ = receiver;
	g_ptr_array_add (_tmp0_, _tmp1_);
}


void user_stream_unregister (UserStream* self, IMessageReceiver* receiver) {
	GPtrArray* _tmp0_ = NULL;
	IMessageReceiver* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	g_return_if_fail (IS_IMESSAGE_RECEIVER (receiver));
	_tmp0_ = self->priv->receivers;
	_tmp1_ = receiver;
	g_ptr_array_remove (_tmp0_, _tmp1_);
}


static void user_stream_network_changed_cb (UserStream* self, gboolean available) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = available;
	_tmp1_ = self->priv->network_available;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = available;
	self->priv->network_available = _tmp2_;
	_tmp3_ = self->priv->network_available;
	if (_tmp3_) {
		g_debug ("UserStream.vala:113: Restarting stream (reason: Network available (cal" \
"lback))");
		user_stream_restart (self);
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = self->priv->account_name;
		g_debug ("UserStream.vala:117: Connection lost (%s) Reason: network unavailable", _tmp4_);
		g_signal_emit_by_name (self, "interrupted");
		user_stream_start_network_timeout (self);
	}
}


/**
   * Starts the UserStream
   */
static void _user_stream_parse_data_cb_rest_proxy_call_continuous_callback (RestProxyCall* call, const gchar* buf, gsize len, GError* _error_, GObject* weak_object, gpointer self) {
	user_stream_parse_data_cb ((UserStream*) self, call, buf, len, _error_);
}


void user_stream_start (UserStream* self) {
	const gchar* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	RestProxyCall* _tmp2_ = NULL;
	RestProxyCall* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = self->priv->account_name;
	g_debug ("UserStream.vala:129: Starting stream for %s", _tmp0_);
	_tmp1_ = self->priv->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_g_object_unref0 (self->priv->proxy_call);
	self->priv->proxy_call = _tmp2_;
	_tmp3_ = self->priv->proxy_call;
	rest_proxy_call_set_function (_tmp3_, "1.1/user.json");
	_tmp4_ = self->priv->proxy_call;
	rest_proxy_call_set_method (_tmp4_, "GET");
	user_stream_start_heartbeat_timeout (self);
	{
		RestProxyCall* _tmp5_ = NULL;
		RestProxyCall* _tmp6_ = NULL;
		_tmp5_ = self->priv->proxy_call;
		_tmp6_ = self->priv->proxy_call;
		rest_proxy_call_continuous (_tmp5_, _user_stream_parse_data_cb_rest_proxy_call_continuous_callback, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_OBJECT, GObject), self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e->message;
		g_error ("UserStream.vala:138: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Stops the UserStream
   */
void user_stream_stop (UserStream* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	RestProxyCall* _tmp7_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	self->priv->running = FALSE;
	_tmp0_ = self->priv->network_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->network_timeout_id;
		g_source_remove (_tmp1_);
		self->priv->network_timeout_id = (guint) 0;
	}
	_tmp2_ = self->priv->heartbeat_timeout_id;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_ = 0U;
		_tmp3_ = self->priv->heartbeat_timeout_id;
		g_source_remove (_tmp3_);
		self->priv->heartbeat_timeout_id = (guint) 0;
	}
	self->priv->stopping = TRUE;
	_tmp4_ = self->priv->account_name;
	_tmp5_ = g_strconcat ("STOPPING STREAM FOR ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	g_debug ("UserStream.vala:159: %s", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->proxy_call;
	rest_proxy_call_cancel (_tmp7_);
	self->priv->stopping = FALSE;
}


static void user_stream_restart (UserStream* self) {
	g_return_if_fail (IS_USER_STREAM (self));
	self->priv->restarting = TRUE;
	user_stream_stop (self);
	user_stream_start (self);
}


static gboolean __lambda10_ (UserStream* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean available = FALSE;
	GNetworkMonitor* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->running;
	if (_tmp0_) {
		self->priv->network_timeout_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp1_ = self->priv->network_monitor;
	_tmp2_ = g_network_monitor_get_network_available (_tmp1_);
	available = _tmp2_;
	_tmp3_ = available;
	if (_tmp3_) {
		g_debug ("UserStream.vala:183: Restarting stream (reason: network available (tim" \
"eout))");
		self->priv->network_timeout_id = (guint) 0;
		user_stream_restart (self);
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean ___lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda10_ ((UserStream*) self);
	return result;
}


static void user_stream_start_network_timeout (UserStream* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = self->priv->network_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		return;
	}
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (1 * 1000), ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->network_timeout_id = _tmp1_;
}


static gboolean __lambda9_ (UserStream* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = self->priv->account_name;
	g_debug ("UserStream.vala:195: Connection lost (%s) Reason: heartbeat. Restartin" \
"g...", _tmp0_);
	user_stream_restart (self);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda9_ ((UserStream*) self);
	return result;
}


static void user_stream_start_heartbeat_timeout (UserStream* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (45 * 1000), ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->heartbeat_timeout_id = _tmp0_;
}


/**
   * Callback called by the Rest.ProxyCall whenever it receives data.
   * Public for testing only
   */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


void user_stream_parse_data_cb (UserStream* self, RestProxyCall* call, const gchar* buf, gsize length, GError* _error_) {
	const gchar* _tmp0_ = NULL;
	gchar* real = NULL;
	const gchar* _tmp3_ = NULL;
	gsize _tmp4_ = 0UL;
	gchar* _tmp5_ = NULL;
	GString* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	g_return_if_fail (REST_IS_PROXY_CALL (call));
	_tmp0_ = buf;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = self->priv->stopping;
		if (!_tmp1_) {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = self->priv->account_name;
			g_debug ("UserStream.vala:216: buf(%s) == NULL. Starting timeout...", _tmp2_);
			user_stream_start_network_timeout (self);
		}
		return;
	}
	_tmp3_ = buf;
	_tmp4_ = length;
	_tmp5_ = string_substring (_tmp3_, (glong) 0, (glong) ((gint) _tmp4_));
	real = _tmp5_;
	_tmp6_ = self->priv->data;
	_tmp7_ = real;
	g_string_append (_tmp6_, _tmp7_);
	_tmp9_ = real;
	_tmp10_ = g_str_has_suffix (_tmp9_, "\r\n");
	if (_tmp10_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = real;
		_tmp12_ = g_str_has_suffix (_tmp11_, "\r");
		_tmp8_ = _tmp12_;
	}
	if (_tmp8_) {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_ = NULL;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		JsonParser* parser = NULL;
		JsonParser* _tmp25_ = NULL;
		JsonNode* root_node = NULL;
		JsonParser* _tmp34_ = NULL;
		JsonNode* _tmp35_ = NULL;
		JsonNode* _tmp36_ = NULL;
		JsonObject* root = NULL;
		JsonNode* _tmp37_ = NULL;
		JsonObject* _tmp38_ = NULL;
		JsonObject* _tmp39_ = NULL;
		StreamMessageType type = 0;
		JsonObject* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		GString* _tmp79_ = NULL;
		_tmp13_ = self->priv->restarting;
		if (_tmp13_) {
			g_signal_emit_by_name (self, "resumed");
			self->priv->restarting = FALSE;
		}
		_tmp14_ = real;
		if (g_strcmp0 (_tmp14_, "\r\n") == 0) {
			const gchar* _tmp15_ = NULL;
			GString* _tmp16_ = NULL;
			guint _tmp17_ = 0U;
			_tmp15_ = self->priv->account_name;
			g_debug ("UserStream.vala:235: HEARTBEAT(%s)", _tmp15_);
			_tmp16_ = self->priv->data;
			g_string_erase (_tmp16_, (gssize) 0, (gssize) -1);
			_tmp17_ = self->priv->heartbeat_timeout_id;
			if (_tmp17_ != ((guint) 0)) {
				guint _tmp18_ = 0U;
				_tmp18_ = self->priv->heartbeat_timeout_id;
				g_source_remove (_tmp18_);
				self->priv->heartbeat_timeout_id = (guint) 0;
			}
			user_stream_start_heartbeat_timeout (self);
			_g_free0 (real);
			return;
		}
		_tmp19_ = self->priv->data;
		_tmp20_ = _tmp19_->str;
		_tmp21_ = string_strip (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strcmp0 (_tmp22_, "OK") == 0;
		_g_free0 (_tmp22_);
		if (_tmp23_) {
			GString* _tmp24_ = NULL;
			_tmp24_ = self->priv->data;
			g_string_erase (_tmp24_, (gssize) 0, (gssize) -1);
			_g_free0 (real);
			return;
		}
		_tmp25_ = json_parser_new ();
		parser = _tmp25_;
		{
			JsonParser* _tmp26_ = NULL;
			GString* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			_tmp26_ = parser;
			_tmp27_ = self->priv->data;
			_tmp28_ = _tmp27_->str;
			json_parser_load_from_data (_tmp26_, _tmp28_, (gssize) -1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch11_g_error;
			}
		}
		goto __finally11;
		__catch11_g_error:
		{
			GError* e = NULL;
			GError* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			GString* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			GString* _tmp33_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			g_critical ("UserStream.vala:258: %s", _tmp30_);
			_tmp31_ = self->priv->data;
			_tmp32_ = _tmp31_->str;
			g_critical ("UserStream.vala:259: %s", _tmp32_);
			_tmp33_ = self->priv->data;
			g_string_erase (_tmp33_, (gssize) 0, (gssize) -1);
			_g_error_free0 (e);
			_g_object_unref0 (parser);
			_g_free0 (real);
			return;
		}
		__finally11:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (parser);
			_g_free0 (real);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->running = TRUE;
		_tmp34_ = parser;
		_tmp35_ = json_parser_get_root (_tmp34_);
		_tmp36_ = __vala_JsonNode_copy0 (_tmp35_);
		root_node = _tmp36_;
		_tmp37_ = root_node;
		_tmp38_ = json_node_get_object (_tmp37_);
		_tmp39_ = _json_object_ref0 (_tmp38_);
		root = _tmp39_;
		type = 0;
		_tmp40_ = root;
		_tmp41_ = json_object_has_member (_tmp40_, "delete");
		if (_tmp41_) {
			type = STREAM_MESSAGE_TYPE_DELETE;
		} else {
			JsonObject* _tmp42_ = NULL;
			gboolean _tmp43_ = FALSE;
			_tmp42_ = root;
			_tmp43_ = json_object_has_member (_tmp42_, "scrub_geo");
			if (_tmp43_) {
				type = STREAM_MESSAGE_TYPE_SCRUB_GEO;
			} else {
				JsonObject* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				_tmp44_ = root;
				_tmp45_ = json_object_has_member (_tmp44_, "limit");
				if (_tmp45_) {
					type = STREAM_MESSAGE_TYPE_LIMIT;
				} else {
					JsonObject* _tmp46_ = NULL;
					gboolean _tmp47_ = FALSE;
					_tmp46_ = root;
					_tmp47_ = json_object_has_member (_tmp46_, "disconnect");
					if (_tmp47_) {
						type = STREAM_MESSAGE_TYPE_DISCONNECT;
					} else {
						JsonObject* _tmp48_ = NULL;
						gboolean _tmp49_ = FALSE;
						_tmp48_ = root;
						_tmp49_ = json_object_has_member (_tmp48_, "friends");
						if (_tmp49_) {
							Account* _tmp50_ = NULL;
							JsonObject* _tmp51_ = NULL;
							JsonArray* _tmp52_ = NULL;
							_tmp50_ = self->priv->account;
							_tmp51_ = root;
							_tmp52_ = json_object_get_array_member (_tmp51_, "friends");
							account_set_friends (_tmp50_, _tmp52_);
							type = STREAM_MESSAGE_TYPE_FRIENDS;
						} else {
							JsonObject* _tmp53_ = NULL;
							gboolean _tmp54_ = FALSE;
							_tmp53_ = root;
							_tmp54_ = json_object_has_member (_tmp53_, "text");
							if (_tmp54_) {
								type = STREAM_MESSAGE_TYPE_TWEET;
							} else {
								JsonObject* _tmp55_ = NULL;
								gboolean _tmp56_ = FALSE;
								_tmp55_ = root;
								_tmp56_ = json_object_has_member (_tmp55_, "event");
								if (_tmp56_) {
									gchar* evt_str = NULL;
									JsonObject* _tmp57_ = NULL;
									const gchar* _tmp58_ = NULL;
									gchar* _tmp59_ = NULL;
									const gchar* _tmp60_ = NULL;
									StreamMessageType _tmp61_ = 0;
									_tmp57_ = root;
									_tmp58_ = json_object_get_string_member (_tmp57_, "event");
									_tmp59_ = g_strdup (_tmp58_);
									evt_str = _tmp59_;
									_tmp60_ = evt_str;
									_tmp61_ = user_stream_get_event_type (self, _tmp60_);
									type = _tmp61_;
									_g_free0 (evt_str);
								} else {
									JsonObject* _tmp62_ = NULL;
									gboolean _tmp63_ = FALSE;
									_tmp62_ = root;
									_tmp63_ = json_object_has_member (_tmp62_, "warning");
									if (_tmp63_) {
										type = STREAM_MESSAGE_TYPE_WARNING;
									} else {
										JsonObject* _tmp64_ = NULL;
										gboolean _tmp65_ = FALSE;
										_tmp64_ = root;
										_tmp65_ = json_object_has_member (_tmp64_, "direct_message");
										if (_tmp65_) {
											type = STREAM_MESSAGE_TYPE_DIRECT_MESSAGE;
										} else {
											JsonObject* _tmp66_ = NULL;
											gboolean _tmp67_ = FALSE;
											_tmp66_ = root;
											_tmp67_ = json_object_has_member (_tmp66_, "status_withheld");
											if (_tmp67_) {
												type = STREAM_MESSAGE_TYPE_UNSUPPORTED;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp68_ = FALSE;
				_tmp68_ = TRUE;
				while (TRUE) {
					gint _tmp70_ = 0;
					GPtrArray* _tmp71_ = NULL;
					gint _tmp72_ = 0;
					gint _tmp73_ = 0;
					GPtrArray* _tmp74_ = NULL;
					gint _tmp75_ = 0;
					gconstpointer _tmp76_ = NULL;
					StreamMessageType _tmp77_ = 0;
					JsonNode* _tmp78_ = NULL;
					if (!_tmp68_) {
						gint _tmp69_ = 0;
						_tmp69_ = i;
						i = _tmp69_ + 1;
					}
					_tmp68_ = FALSE;
					_tmp70_ = i;
					_tmp71_ = self->priv->receivers;
					_tmp72_ = g_ptr_array_get_length (_tmp71_);
					_tmp73_ = _tmp72_;
					if (!(_tmp70_ < _tmp73_)) {
						break;
					}
					_tmp74_ = self->priv->receivers;
					_tmp75_ = i;
					_tmp76_ = g_ptr_array_index (_tmp74_, (guint) _tmp75_);
					_tmp77_ = type;
					_tmp78_ = root_node;
					imessage_receiver_stream_message_received ((IMessageReceiver*) _tmp76_, _tmp77_, _tmp78_);
				}
			}
		}
		_tmp79_ = self->priv->data;
		g_string_erase (_tmp79_, (gssize) 0, (gssize) -1);
		_json_object_unref0 (root);
		__vala_JsonNode_free0 (root_node);
		_g_object_unref0 (parser);
	}
	_g_free0 (real);
}


static StreamMessageType user_stream_get_event_type (UserStream* self, const gchar* evt_str) {
	StreamMessageType result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	g_return_val_if_fail (IS_USER_STREAM (self), 0);
	g_return_val_if_fail (evt_str != NULL, 0);
	_tmp0_ = evt_str;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("follow")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_FOLLOW;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("list_created")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("list_destroyed")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("list_updated")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("list_user_unsubscribed")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("list_user_subscribed")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("list_member_added")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("list_member_removed")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("favorite")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_FAVORITE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("unfavorite")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("unfollow")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("block")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_BLOCK;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("unblock")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_UNBLOCK;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("mute")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_MUTE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("unmute")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_UNMUTE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("user_update")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("quoted_tweet")))) {
		switch (0) {
			default:
			{
				result = STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET;
				return result;
			}
		}
	}
	result = 0;
	return result;
}


void user_stream_set_token (UserStream* self, const gchar* value) {
	OAuthProxy* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = self->priv->proxy;
	_tmp1_ = value;
	oauth_proxy_set_token (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "token");
}


void user_stream_set_token_secret (UserStream* self, const gchar* value) {
	OAuthProxy* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_STREAM (self));
	_tmp0_ = self->priv->proxy;
	_tmp1_ = value;
	oauth_proxy_set_token_secret (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "token-secret");
}


static void user_stream_class_init (UserStreamClass * klass) {
	user_stream_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserStreamPrivate));
	G_OBJECT_CLASS (klass)->set_property = _vala_user_stream_set_property;
	G_OBJECT_CLASS (klass)->finalize = user_stream_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_STREAM_TOKEN, g_param_spec_string ("token", "token", "token", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_STREAM_TOKEN_SECRET, g_param_spec_string ("token-secret", "token-secret", "token-secret", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_signal_new ("interrupted", TYPE_USER_STREAM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("resumed", TYPE_USER_STREAM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void user_stream_instance_init (UserStream * self) {
	GString* _tmp0_ = NULL;
	self->priv = USER_STREAM_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->data = _tmp0_;
	self->priv->network_timeout_id = (guint) 0;
	self->priv->heartbeat_timeout_id = (guint) 0;
	self->priv->stopping = FALSE;
	self->priv->restarting = FALSE;
	self->priv->running = FALSE;
}


static void user_stream_finalize (GObject* obj) {
	UserStream * self;
	const gchar* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_STREAM, UserStream);
	_tmp0_ = self->priv->account_name;
	g_debug ("UserStream.vala:203: USERSTREAM for %s DESTROYED", _tmp0_);
	_g_object_unref0 (self->priv->proxy);
	_g_object_unref0 (self->priv->proxy_call);
	_g_string_free0 (self->priv->data);
	_g_ptr_array_unref0 (self->priv->receivers);
	_g_object_unref0 (self->priv->network_monitor);
	_g_free0 (self->priv->account_name);
	G_OBJECT_CLASS (user_stream_parent_class)->finalize (obj);
}


GType user_stream_get_type (void) {
	static volatile gsize user_stream_type_id__volatile = 0;
	if (g_once_init_enter (&user_stream_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserStreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_stream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserStream), 0, (GInstanceInitFunc) user_stream_instance_init, NULL };
		GType user_stream_type_id;
		user_stream_type_id = g_type_register_static (G_TYPE_OBJECT, "UserStream", &g_define_type_info, 0);
		g_once_init_leave (&user_stream_type_id__volatile, user_stream_type_id);
	}
	return user_stream_type_id__volatile;
}


static void _vala_user_stream_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UserStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_STREAM, UserStream);
	switch (property_id) {
		case USER_STREAM_TOKEN:
		user_stream_set_token (self, g_value_get_string (value));
		break;
		case USER_STREAM_TOKEN_SECRET:
		user_stream_set_token_secret (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



