; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=slp-vectorizer -S -slp-max-reg-size=1024 %s | FileCheck %s

define void @test1(ptr %a, ptr %b) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP0:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 0
; CHECK-NEXT:    [[GEP4:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i64 0
; CHECK-NEXT:    [[TMP0:%.*]] = load <4 x i32>, ptr [[GEP0]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = shl <4 x i32> [[TMP0]], <i32 1, i32 0, i32 1, i32 0>
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr [[GEP4]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %gep0 = getelementptr inbounds i32, ptr %a, i64 0
  %gep1 = getelementptr inbounds i32, ptr %a, i64 1
  %gep2 = getelementptr inbounds i32, ptr %a, i64 2
  %gep3 = getelementptr inbounds i32, ptr %a, i64 3
  %0 = load i32, ptr %gep0, align 4
  %1 = load i32, ptr %gep1, align 4
  %2 = load i32, ptr %gep2, align 4
  %3 = load i32, ptr %gep3, align 4
  %op0 = shl i32 %0, 1
  %op1 = add i32 %1, zeroinitializer
  %op2 = mul i32 %2, 2
  %op3 = shl i32 %3, zeroinitializer
  %gep4 = getelementptr inbounds i32, ptr %b, i64 0
  %gep5 = getelementptr inbounds i32, ptr %b, i64 1
  %gep6 = getelementptr inbounds i32, ptr %b, i64 2
  %gep7 = getelementptr inbounds i32, ptr %b, i64 3
  store i32 %op0, ptr %gep4, align 4
  store i32 %op1, ptr %gep5, align 4
  store i32 %op2, ptr %gep6, align 4
  store i32 %op3, ptr %gep7, align 4
  ret void
}

define void @test2(i64 %_xstride) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL3:%.*]] = mul i64 [[_XSTRIDE:%.*]], 1
; CHECK-NEXT:    [[MUL5:%.*]] = mul i64 0, 0
; CHECK-NEXT:    [[MUL9:%.*]] = sub i64 0, [[_XSTRIDE]]
; CHECK-NEXT:    [[MUL12:%.*]] = shl i64 [[_XSTRIDE]], 1
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr i8, ptr null, i64 [[MUL3]]
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr i8, ptr null, i64 [[MUL5]]
; CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr i8, ptr null, i64 [[MUL9]]
; CHECK-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr i8, ptr null, i64 [[MUL12]]
; CHECK-NEXT:    ret void
;
entry:
  %mul3 = mul i64 %_xstride, 1
  %mul5 = mul i64 0, 0
  %mul9 = sub i64 0, %_xstride
  %mul12 = shl i64 %_xstride, 1
  %arrayidx = getelementptr i8, ptr null, i64 %mul3
  %arrayidx6 = getelementptr i8, ptr null, i64 %mul5
  %arrayidx10 = getelementptr i8, ptr null, i64 %mul9
  %arrayidx13 = getelementptr i8, ptr null, i64 %mul12
  ret void
}
