; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=loop-fusion -loop-fusion-peel-max-count=3 < %s | FileCheck %s

; Tests that we do not fuse two guarded loops together.
; These loops do not have the same trip count, and the first loop meets the
; requirements for peeling. However, the exit block of the first loop makes the
; loops unsafe to fuse together.
; The expected output of this test is the function as below.


define void @unsafe_exitblock(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: define void @unsafe_exitblock(
; CHECK-SAME: ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; CHECK-NEXT:  [[FOR_FIRST_GUARD:.*:]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp slt i64 0, 45
; CHECK-NEXT:    br i1 [[CMP3]], label %[[FOR_FIRST_PREHEADER:.*]], label %[[FOR_SECOND_GUARD:.*]]
; CHECK:       [[FOR_FIRST_PREHEADER]]:
; CHECK-NEXT:    br label %[[FOR_FIRST:.*]]
; CHECK:       [[FOR_FIRST]]:
; CHECK-NEXT:    [[I_04:%.*]] = phi i64 [ [[INC:%.*]], %[[FOR_FIRST]] ], [ 0, %[[FOR_FIRST_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[I_04]]
; CHECK-NEXT:    store i32 0, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[INC]] = add nsw i64 [[I_04]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[INC]], 45
; CHECK-NEXT:    br i1 [[CMP]], label %[[FOR_FIRST]], label %[[FOR_FIRST_EXIT:.*]]
; CHECK:       [[FOR_FIRST_EXIT]]:
; CHECK-NEXT:    call void @bar()
; CHECK-NEXT:    br label %[[FOR_SECOND_GUARD]]
; CHECK:       [[FOR_SECOND_GUARD]]:
; CHECK-NEXT:    [[CMP21:%.*]] = icmp slt i64 2, 45
; CHECK-NEXT:    br i1 [[CMP21]], label %[[FOR_SECOND_PREHEADER:.*]], label %[[FOR_END:.*]]
; CHECK:       [[FOR_SECOND_PREHEADER]]:
; CHECK-NEXT:    br label %[[FOR_SECOND:.*]]
; CHECK:       [[FOR_SECOND]]:
; CHECK-NEXT:    [[J_02:%.*]] = phi i64 [ [[INC6:%.*]], %[[FOR_SECOND]] ], [ 2, %[[FOR_SECOND_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds i32, ptr [[B]], i64 [[J_02]]
; CHECK-NEXT:    store i32 0, ptr [[ARRAYIDX4]], align 4
; CHECK-NEXT:    [[INC6]] = add nsw i64 [[J_02]], 1
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i64 [[INC6]], 45
; CHECK-NEXT:    br i1 [[CMP2]], label %[[FOR_SECOND]], label %[[FOR_SECOND_EXIT:.*]]
; CHECK:       [[FOR_SECOND_EXIT]]:
; CHECK-NEXT:    br label %[[FOR_END]]
; CHECK:       [[FOR_END]]:
; CHECK-NEXT:    ret void
;
for.first.guard:
  %cmp3 = icmp slt i64 0, 45
  br i1 %cmp3, label %for.first.preheader, label %for.second.guard

for.first.preheader:                             ; preds = %for.first.guard
  br label %for.first

for.first:                                       ; preds = %for.first.preheader, %for.first
  %i.04 = phi i64 [ %inc, %for.first ], [ 0, %for.first.preheader ]
  %arrayidx = getelementptr inbounds i32, ptr %A, i64 %i.04
  store i32 0, ptr %arrayidx, align 4
  %inc = add nsw i64 %i.04, 1
  %cmp = icmp slt i64 %inc, 45
  br i1 %cmp, label %for.first, label %for.first.exit

for.first.exit:                                  ; preds = %for.first
  call void @bar()
  br label %for.second.guard

for.second.guard:                                ; preds = %for.first.exit, %for.first.guard
  %cmp21 = icmp slt i64 2,45
  br i1 %cmp21, label %for.second.preheader, label %for.end

for.second.preheader:                            ; preds = %for.second.guard
  br label %for.second

for.second:                                      ; preds = %for.second.preheader, %for.second
  %j.02 = phi i64 [ %inc6, %for.second ], [ 2, %for.second.preheader ]
  %arrayidx4 = getelementptr inbounds i32, ptr %B, i64 %j.02
  store i32 0, ptr %arrayidx4, align 4
  %inc6 = add nsw i64 %j.02, 1
  %cmp2 = icmp slt i64 %inc6, 45
  br i1 %cmp2, label %for.second, label %for.second.exit

for.second.exit:                                 ; preds = %for.second
  br label %for.end

for.end:                                         ; preds = %for.second.exit, %for.second.guard
  ret void
}

declare void @bar()
