/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.util;

import java.util.HashMap;
import java.util.Map;

public class Extension<T, E> {
    private ExtensionFactory<E> extensionFactory;
    private Map<T, E> extensions = new HashMap<T, E>();

    public Extension(ExtensionFactory<E> factory) {
        this.extensionFactory = factory;
    }

    public E createInstance() {
        return this.extensionFactory.create();
    }

    public E get(T t) {
        if (this.extensions.containsKey(t)) {
            return this.extensions.get(t);
        }
        E x = this.createInstance();
        this.extensions.put(t, x);
        return x;
    }

    public static class ExtensionManagerInstantiationException
    extends RuntimeException {
        Exception exception;

        public ExtensionManagerInstantiationException(Exception e) {
            this.exception = e;
        }
    }

    public static abstract class BaseExtension {
    }

    public static interface ExtensionFactory<E> {
        public E create();
    }
}

