/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressionStream;
import com.sun.j3d.utils.compression.HuffmanTable;

abstract class CompressionStreamElement {
    int length;
    int shift;
    boolean absolute;
    static final int[] quantizationMask = new int[]{-65536, Short.MIN_VALUE, -16384, -8192, -4096, -2048, -1024, -512, -256, -128, -64, -32, -16, -8, -4, -2, -1};
    static final long[] lengthMask = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};

    CompressionStreamElement() {
    }

    abstract void quantize(CompressionStream var1, HuffmanTable var2);

    void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
    }

    private static final int getLength(int n) {
        if (n == 0) {
            return 0;
        }
        if ((n & 0x8000) > 0) {
            if ((n & 0x4000) == 0) {
                return 16;
            }
            if ((n & 0x2000) == 0) {
                return 15;
            }
            if ((n & 0x1000) == 0) {
                return 14;
            }
            if ((n & 0x800) == 0) {
                return 13;
            }
            if ((n & 0x400) == 0) {
                return 12;
            }
            if ((n & 0x200) == 0) {
                return 11;
            }
            if ((n & 0x100) == 0) {
                return 10;
            }
            if ((n & 0x80) == 0) {
                return 9;
            }
            if ((n & 0x40) == 0) {
                return 8;
            }
            if ((n & 0x20) == 0) {
                return 7;
            }
            if ((n & 0x10) == 0) {
                return 6;
            }
            if ((n & 8) == 0) {
                return 5;
            }
            if ((n & 4) == 0) {
                return 4;
            }
            if ((n & 2) == 0) {
                return 3;
            }
            if ((n & 1) == 0) {
                return 2;
            }
            return 1;
        }
        if ((n & 0x4000) > 0) {
            return 16;
        }
        if ((n & 0x2000) > 0) {
            return 15;
        }
        if ((n & 0x1000) > 0) {
            return 14;
        }
        if ((n & 0x800) > 0) {
            return 13;
        }
        if ((n & 0x400) > 0) {
            return 12;
        }
        if ((n & 0x200) > 0) {
            return 11;
        }
        if ((n & 0x100) > 0) {
            return 10;
        }
        if ((n & 0x80) > 0) {
            return 9;
        }
        if ((n & 0x40) > 0) {
            return 8;
        }
        if ((n & 0x20) > 0) {
            return 7;
        }
        if ((n & 0x10) > 0) {
            return 6;
        }
        if ((n & 8) > 0) {
            return 5;
        }
        if ((n & 4) > 0) {
            return 4;
        }
        if ((n & 2) > 0) {
            return 3;
        }
        return 2;
    }

    private static final int getShift(int n) {
        if (n == 0) {
            return 0;
        }
        if ((n & 1) > 0) {
            return 0;
        }
        if ((n & 2) > 0) {
            return 1;
        }
        if ((n & 4) > 0) {
            return 2;
        }
        if ((n & 8) > 0) {
            return 3;
        }
        if ((n & 0x10) > 0) {
            return 4;
        }
        if ((n & 0x20) > 0) {
            return 5;
        }
        if ((n & 0x40) > 0) {
            return 6;
        }
        if ((n & 0x80) > 0) {
            return 7;
        }
        if ((n & 0x100) > 0) {
            return 8;
        }
        if ((n & 0x200) > 0) {
            return 9;
        }
        if ((n & 0x400) > 0) {
            return 10;
        }
        if ((n & 0x800) > 0) {
            return 11;
        }
        if ((n & 0x1000) > 0) {
            return 12;
        }
        if ((n & 0x2000) > 0) {
            return 13;
        }
        if ((n & 0x4000) > 0) {
            return 14;
        }
        return 15;
    }

    final void computeLengthShift(int n, int n2) {
        int n3 = n & 0x8000;
        int n4 = n2 & 0x8000;
        this.length = n3 == n4 ? (n3 == 0 ? CompressionStreamElement.getLength(n | n2) : CompressionStreamElement.getLength(n & n2)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n), CompressionStreamElement.getLength(n2));
        this.shift = CompressionStreamElement.getShift(n | n2);
    }

    final void computeLengthShift(int n, int n2, int n3) {
        int n4 = n & 0x8000;
        int n5 = n2 & 0x8000;
        int n6 = n3 & 0x8000;
        this.length = n4 == n5 ? (n5 == n6 ? (n6 == 0 ? CompressionStreamElement.getLength(n | n2 | n3) : CompressionStreamElement.getLength(n & n2 & n3)) : (n5 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n | n2), CompressionStreamElement.getLength(n3)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n & n2), CompressionStreamElement.getLength(n3)))) : (n5 == n6 ? (n6 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n2 | n3), CompressionStreamElement.getLength(n)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n2 & n3), CompressionStreamElement.getLength(n))) : (n4 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n | n3), CompressionStreamElement.getLength(n2)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n & n3), CompressionStreamElement.getLength(n2))));
        this.shift = CompressionStreamElement.getShift(n | n2 | n3);
    }

    final void computeLengthShift(int n, int n2, int n3, int n4) {
        this.length = CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n), CompressionStreamElement.getLength(n2), CompressionStreamElement.getLength(n3), CompressionStreamElement.getLength(n4));
        this.shift = CompressionStreamElement.getShift(n | n2 | n3 | n4);
    }

    private static final int getMaximum(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    private static final int getMaximum(int n, int n2, int n3) {
        if (n > n2) {
            if (n > n3) {
                return n;
            }
            return n3;
        }
        if (n2 > n3) {
            return n2;
        }
        return n3;
    }

    private static final int getMaximum(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n > n2 ? n : n2;
        if (n6 > (n5 = n3 > n4 ? n3 : n4)) {
            return n6;
        }
        return n5;
    }
}

