/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;

final class StableInvocationHandler<T>
implements InvocationHandler,
StableElement {
    private T oldValue;
    private T cachedValue;
    private final Set<Class<?>> classes;
    private final Supplier<? extends T> provider;
    private final Predicate<? super T> validator;

    StableInvocationHandler(T initial, Supplier<? extends T> provider, Predicate<? super T> validator) {
        this.provider = provider;
        this.cachedValue = initial;
        this.oldValue = initial;
        this.validator = validator;
        Class<?> superClass = initial.getClass().getSuperclass();
        HashSet classes = new HashSet();
        ContainerUtil.addAll(classes, (Object[])initial.getClass().getInterfaces());
        ContainerUtil.addIfNotNull(classes, superClass);
        classes.remove(MergedObject.class);
        this.classes = classes;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (StableElement.class.equals(method.getDeclaringClass())) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        if (AdvancedProxy.FINALIZE_METHOD.equals(method)) {
            return null;
        }
        if (this.isNotValid(this.cachedValue)) {
            if (this.cachedValue != null) {
                this.oldValue = this.cachedValue;
            }
            this.cachedValue = this.provider.get();
            if (this.isNotValid(this.cachedValue)) {
                if (AdvancedProxy.EQUALS_METHOD.equals(method)) {
                    Object arg = args[0];
                    if (!(arg instanceof StableElement)) {
                        return false;
                    }
                    StableInvocationHandler<?> handler = DomManagerImpl.getStableInvocationHandler(arg);
                    if (handler == null || handler.getWrappedElement() != null) {
                        return false;
                    }
                    return Comparing.equal(this.oldValue, handler.oldValue);
                }
                if (this.oldValue != null && Object.class.equals(method.getDeclaringClass())) {
                    return method.invoke(this.oldValue, args);
                }
                if ("isValid".equals(method.getName())) {
                    return Boolean.FALSE;
                }
                throw new AssertionError((Object)"Calling methods on invalid value");
            }
        }
        if (AdvancedProxy.EQUALS_METHOD.equals(method)) {
            Object arg = args[0];
            if (arg instanceof StableElement) {
                return this.cachedValue.equals(((StableElement)arg).getWrappedElement());
            }
            return this.cachedValue.equals(arg);
        }
        if (AdvancedProxy.HASHCODE_METHOD.equals(method)) {
            return this.cachedValue.hashCode();
        }
        try {
            return method.invoke(this.cachedValue, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void revalidate() {
        T t = this.provider.get();
        if (!this.isNotValid(t) && !t.equals(this.cachedValue)) {
            this.cachedValue = t;
        }
    }

    public void invalidate() {
        if (!this.isNotValid(this.cachedValue)) {
            this.cachedValue = null;
        }
    }

    public T getWrappedElement() {
        if (this.isNotValid(this.cachedValue)) {
            this.cachedValue = this.provider.get();
        }
        return this.cachedValue;
    }

    public T getOldValue() {
        return this.oldValue;
    }

    private boolean isNotValid(T t) {
        if (t == null || !this.validator.test(t)) {
            return true;
        }
        for (Class<?> aClass : this.classes) {
            if (aClass.isInstance(t)) continue;
            return true;
        }
        return false;
    }
}

