/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.knn.common.KNNVectorUtil;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;
import org.opensearch.knn.index.VectorDataType;

public enum SpaceType {
    UNDEFINED("undefined"){

        @Override
        public float scoreTranslation(float rawScore) {
            throw new IllegalStateException("Unsupported method");
        }

        @Override
        public KNNVectorSimilarityFunction getKnnVectorSimilarityFunction() {
            return null;
        }

        @Override
        public void validateVectorDataType(VectorDataType vectorDataType) {
            throw new IllegalStateException("Unsupported method");
        }
    }
    ,
    L2("l2", "`1 / (1 + rawScore)`"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }

        @Override
        public KNNVectorSimilarityFunction getKnnVectorSimilarityFunction() {
            return KNNVectorSimilarityFunction.EUCLIDEAN;
        }

        @Override
        public float scoreToDistanceTranslation(float score) {
            if (score == 0.0f) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "score cannot be 0 when space type is [%s]", this.getValue()));
            }
            return 1.0f / score - 1.0f;
        }
    }
    ,
    COSINESIMIL("cosinesimil", "`Math.max((2.0F - rawScore) / 2.0F, 0.0F)`"){

        @Override
        public float scoreTranslation(float rawScore) {
            return Math.max((2.0f - rawScore) / 2.0f, 0.0f);
        }

        @Override
        public KNNVectorSimilarityFunction getKnnVectorSimilarityFunction() {
            return KNNVectorSimilarityFunction.COSINE;
        }

        @Override
        public void validateVector(byte[] vector) {
            if (KNNVectorUtil.isZeroVector(vector)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "zero vector is not supported when space type is [%s]", this.getValue()));
            }
        }

        @Override
        public void validateVector(float[] vector) {
            if (KNNVectorUtil.isZeroVector(vector)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "zero vector is not supported when space type is [%s]", this.getValue()));
            }
        }
    }
    ,
    L1("l1", "`1 / (1 + rawScore)`"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }

        @Override
        public KNNVectorSimilarityFunction getKnnVectorSimilarityFunction() {
            return null;
        }
    }
    ,
    LINF("linf", "`1 / (1 + rawScore)`"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }

        @Override
        public KNNVectorSimilarityFunction getKnnVectorSimilarityFunction() {
            return null;
        }
    }
    ,
    INNER_PRODUCT("innerproduct"){

        @Override
        public float scoreTranslation(float rawScore) {
            if (rawScore >= 0.0f) {
                return 1.0f / (1.0f + rawScore);
            }
            return -rawScore + 1.0f;
        }

        @Override
        public String explainScoreTranslation(float rawScore) {
            return rawScore >= 0.0f ? SpaceType.GENERIC_SCORE_TRANSLATION : "`-rawScore + 1`";
        }

        @Override
        public KNNVectorSimilarityFunction getKnnVectorSimilarityFunction() {
            return KNNVectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
        }
    }
    ,
    HAMMING("hamming", "`1 / (1 + rawScore)`"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }

        @Override
        public void validateVectorDataType(VectorDataType vectorDataType) {
            if (VectorDataType.BINARY != vectorDataType) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Space type [%s] is not supported with [%s] data type", this.getValue(), vectorDataType.getValue()));
            }
        }

        @Override
        public KNNVectorSimilarityFunction getKnnVectorSimilarityFunction() {
            return KNNVectorSimilarityFunction.HAMMING;
        }
    };

    public static SpaceType DEFAULT;
    public static SpaceType DEFAULT_BINARY;
    public static final String[] VALID_VALUES;
    private static final String GENERIC_SCORE_TRANSLATION = "`1 / (1 + rawScore)`";
    private final String value;
    private final String explanationFormula;

    private SpaceType(String value) {
        this.value = value;
        this.explanationFormula = null;
    }

    private SpaceType(String value, String explanationFormula) {
        this.value = value;
        this.explanationFormula = explanationFormula;
    }

    public abstract float scoreTranslation(float var1);

    public String explainScoreTranslation(float rawScore) {
        if (this.explanationFormula != null) {
            return this.explanationFormula;
        }
        throw new UnsupportedOperationException("explainScoreTranslation is not defined for this space type.");
    }

    public abstract KNNVectorSimilarityFunction getKnnVectorSimilarityFunction();

    public void validateVector(byte[] vector) {
    }

    public void validateVector(float[] vector) {
    }

    public void validateVectorDataType(VectorDataType vectorDataType) {
        if (VectorDataType.FLOAT != vectorDataType && VectorDataType.BYTE != vectorDataType) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Space type [%s] is not supported with [%s] data type", this.getValue(), vectorDataType.getValue()));
        }
    }

    public String getValue() {
        return this.value;
    }

    public static Set<String> getValues() {
        HashSet<String> values = new HashSet<String>();
        for (SpaceType spaceType : SpaceType.values()) {
            values.add(spaceType.getValue());
        }
        return values;
    }

    public static SpaceType getSpace(String spaceTypeName) {
        for (SpaceType currentSpaceType : SpaceType.values()) {
            if (!currentSpaceType.getValue().equalsIgnoreCase(spaceTypeName)) continue;
            return currentSpaceType;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to find space: %s . Valid values are: %s", spaceTypeName, Arrays.toString(VALID_VALUES)));
    }

    public static SpaceType getSpace(VectorSimilarityFunction similarityFunction) {
        for (SpaceType currentSpaceType : SpaceType.values()) {
            KNNVectorSimilarityFunction knnSimilarityFunction = currentSpaceType.getKnnVectorSimilarityFunction();
            if (knnSimilarityFunction == null || knnSimilarityFunction.getVectorSimilarityFunction() != similarityFunction) continue;
            return currentSpaceType;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to find space type for similarity function : %s . Valid values are: %s", similarityFunction, Arrays.toString((Object[])KNNVectorSimilarityFunction.values())));
    }

    public float scoreToDistanceTranslation(float score) {
        throw new UnsupportedOperationException(String.format("Space [%s] does not have a score to distance translation", this.getValue()));
    }

    static {
        DEFAULT = L2;
        DEFAULT_BINARY = HAMMING;
        VALID_VALUES = Arrays.stream(SpaceType.values()).filter(space -> space != UNDEFINED).map(SpaceType::getValue).collect(Collectors.toList()).toArray(new String[0]);
    }
}

