"use strict";

Object.defineProperty(exports, "__esModule", {
  value: !0
});

var isBrowser = "undefined" != typeof document;

function getRegisteredStyles(registered, registeredStyles, classNames) {
  var rawClassName = "";
  return classNames.split(" ").forEach(function(className) {
    void 0 !== registered[className] ? registeredStyles.push(registered[className]) : rawClassName += className + " ";
  }), rawClassName;
}

var insertStyles = function(cache, serialized, isStringTag) {
  var className = cache.key + "-" + serialized.name;
  if ((!1 === isStringTag || !1 === isBrowser && void 0 !== cache.compat) && void 0 === cache.registered[className] && (cache.registered[className] = serialized.styles), 
  void 0 === cache.inserted[serialized.name]) {
    var stylesForSSR = "", current = serialized;
    do {
      var maybeStyles = cache.insert("." + className, current, cache.sheet, !0);
      isBrowser || void 0 === maybeStyles || (stylesForSSR += maybeStyles), current = current.next;
    } while (void 0 !== current);
    if (!isBrowser && 0 !== stylesForSSR.length) return stylesForSSR;
  }
};

exports.getRegisteredStyles = getRegisteredStyles, exports.insertStyles = insertStyles;
