/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.search.SearchService;
import org.opensearch.tasks.CancellableTask;

@PublicApi(since="2.18.0")
public class WorkloadGroupTask
extends CancellableTask {
    private static final Logger logger = LogManager.getLogger(WorkloadGroupTask.class);
    public static final String WORKLOAD_GROUP_ID_HEADER = "workloadGroupId";
    public static final Supplier<String> DEFAULT_WORKLOAD_GROUP_ID_SUPPLIER = () -> "DEFAULT_WORKLOAD_GROUP";
    private final LongSupplier nanoTimeSupplier;
    private String workloadGroupId;
    private boolean isWorkloadGroupSet = false;

    public WorkloadGroupTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        this(id, type, action, description, parentTaskId, headers, SearchService.NO_TIMEOUT, System::nanoTime);
    }

    public WorkloadGroupTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval) {
        this(id, type, action, description, parentTaskId, headers, cancelAfterTimeInterval, System::nanoTime);
    }

    public WorkloadGroupTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval, LongSupplier nanoTimeSupplier) {
        super(id, type, action, description, parentTaskId, headers, cancelAfterTimeInterval);
        this.nanoTimeSupplier = nanoTimeSupplier;
    }

    public final String getWorkloadGroupId() {
        if (this.workloadGroupId == null) {
            logger.warn("WorkloadGroup _id can't be null, It should be set before accessing it. This is abnormal behaviour ");
        }
        return this.workloadGroupId;
    }

    public final void setWorkloadGroupId(ThreadContext threadContext) {
        this.isWorkloadGroupSet = true;
        this.workloadGroupId = threadContext != null && threadContext.getHeader(WORKLOAD_GROUP_ID_HEADER) != null ? threadContext.getHeader(WORKLOAD_GROUP_ID_HEADER) : DEFAULT_WORKLOAD_GROUP_ID_SUPPLIER.get();
    }

    public long getElapsedTime() {
        return this.nanoTimeSupplier.getAsLong() - this.getStartTimeNanos();
    }

    public boolean isWorkloadGroupSet() {
        return this.isWorkloadGroupSet;
    }

    @Override
    public boolean shouldCancelChildrenOnCancellation() {
        return false;
    }
}

