/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.datasource.pooled;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ibatis.datasource.pooled.PooledConnection;
import org.apache.ibatis.datasource.pooled.PooledDataSource;

public class PoolState {
    private final ReentrantLock lock = new ReentrantLock();
    protected PooledDataSource dataSource;
    protected final List<PooledConnection> idleConnections = new ArrayList<PooledConnection>();
    protected final List<PooledConnection> activeConnections = new ArrayList<PooledConnection>();
    protected long requestCount;
    protected long accumulatedRequestTime;
    protected long accumulatedCheckoutTime;
    protected long claimedOverdueConnectionCount;
    protected long accumulatedCheckoutTimeOfOverdueConnections;
    protected long accumulatedWaitTime;
    protected long hadToWaitCount;
    protected long badConnectionCount;

    public PoolState(PooledDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public long getRequestCount() {
        this.lock.lock();
        try {
            long l = this.requestCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getAverageRequestTime() {
        this.lock.lock();
        try {
            long l = this.requestCount == 0L ? 0L : this.accumulatedRequestTime / this.requestCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getAverageWaitTime() {
        this.lock.lock();
        try {
            long l = this.hadToWaitCount == 0L ? 0L : this.accumulatedWaitTime / this.hadToWaitCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getHadToWaitCount() {
        this.lock.lock();
        try {
            long l = this.hadToWaitCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getBadConnectionCount() {
        this.lock.lock();
        try {
            long l = this.badConnectionCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getClaimedOverdueConnectionCount() {
        this.lock.lock();
        try {
            long l = this.claimedOverdueConnectionCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getAverageOverdueCheckoutTime() {
        this.lock.lock();
        try {
            long l = this.claimedOverdueConnectionCount == 0L ? 0L : this.accumulatedCheckoutTimeOfOverdueConnections / this.claimedOverdueConnectionCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getAverageCheckoutTime() {
        this.lock.lock();
        try {
            long l = this.requestCount == 0L ? 0L : this.accumulatedCheckoutTime / this.requestCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getIdleConnectionCount() {
        this.lock.lock();
        try {
            int n = this.idleConnections.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getActiveConnectionCount() {
        this.lock.lock();
        try {
            int n = this.activeConnections.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("\n===CONFIGURATION==============================================");
            builder.append("\n jdbcDriver                     ").append(this.dataSource.getDriver());
            builder.append("\n jdbcUrl                        ").append(this.dataSource.getUrl());
            builder.append("\n jdbcUsername                   ").append(this.dataSource.getUsername());
            builder.append("\n jdbcPassword                   ").append(this.dataSource.getPassword() == null ? "NULL" : "************");
            builder.append("\n poolMaxActiveConnections       ").append(this.dataSource.poolMaximumActiveConnections);
            builder.append("\n poolMaxIdleConnections         ").append(this.dataSource.poolMaximumIdleConnections);
            builder.append("\n poolMaxCheckoutTime            ").append(this.dataSource.poolMaximumCheckoutTime);
            builder.append("\n poolTimeToWait                 ").append(this.dataSource.poolTimeToWait);
            builder.append("\n poolPingEnabled                ").append(this.dataSource.poolPingEnabled);
            builder.append("\n poolPingQuery                  ").append(this.dataSource.poolPingQuery);
            builder.append("\n poolPingConnectionsNotUsedFor  ").append(this.dataSource.poolPingConnectionsNotUsedFor);
            builder.append("\n ---STATUS-----------------------------------------------------");
            builder.append("\n activeConnections              ").append(this.getActiveConnectionCount());
            builder.append("\n idleConnections                ").append(this.getIdleConnectionCount());
            builder.append("\n requestCount                   ").append(this.getRequestCount());
            builder.append("\n averageRequestTime             ").append(this.getAverageRequestTime());
            builder.append("\n averageCheckoutTime            ").append(this.getAverageCheckoutTime());
            builder.append("\n claimedOverdue                 ").append(this.getClaimedOverdueConnectionCount());
            builder.append("\n averageOverdueCheckoutTime     ").append(this.getAverageOverdueCheckoutTime());
            builder.append("\n hadToWait                      ").append(this.getHadToWaitCount());
            builder.append("\n averageWaitTime                ").append(this.getAverageWaitTime());
            builder.append("\n badConnectionCount             ").append(this.getBadConnectionCount());
            builder.append("\n===============================================================");
            String string = builder.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

