/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/Indent;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "<init>", "()V", "getListOfAcceptableFunctions", "", "", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "ir.interpreter"})
public final class Indent
extends IntrinsicBase {
    @NotNull
    public static final Indent INSTANCE = new Indent();

    private Indent() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        String[] stringArray = new String[]{"kotlin.text.StringsKt.trimIndent", "kotlin.text.trimIndent", "kotlin.text.StringsKt.trimMargin", "kotlin.text.trimMargin", "kotlin.text.StringsKt.trimMargin$default", "kotlin.text.trimMargin$default"};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        String string;
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        String str = StateKt.asString(environment.getCallStack$ir_interpreter().loadState(irFunction.getParameters().get(0).getSymbol()));
        switch (UtilsKt.getFqName(irFunction)) {
            case "kotlin.text.StringsKt.trimIndent": 
            case "kotlin.text.trimIndent": {
                string = StringsKt.trimIndent(str);
                break;
            }
            case "kotlin.text.StringsKt.trimMargin": 
            case "kotlin.text.trimMargin": {
                String marginPrefix = StateKt.asString(environment.getCallStack$ir_interpreter().loadState(irFunction.getParameters().get(1).getSymbol()));
                string = StringsKt.trimMargin(str, marginPrefix);
                break;
            }
            case "kotlin.text.trimMargin$default": 
            case "kotlin.text.StringsKt.trimMargin$default": {
                string = StringsKt.trimMargin$default(str, null, 1, null);
                break;
            }
            default: {
                String string2 = "unknown trim function";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
        }
        String trimmed = string;
        environment.getCallStack$ir_interpreter().pushState(environment.convertToState$ir_interpreter(trimmed, irFunction.getReturnType()));
    }
}

