/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator;

import io.quarkus.gizmo2.creator.AccessLevel;
import io.quarkus.gizmo2.creator.AnnotatableCreator;
import io.quarkus.gizmo2.creator.Modifier;
import io.quarkus.gizmo2.creator.ModifierFlag;
import io.quarkus.gizmo2.creator.ModifierLocation;
import java.util.Arrays;
import java.util.Collection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModifiableCreator
extends AnnotatableCreator {
    public ModifierLocation modifierLocation();

    public void addFlag(ModifierFlag var1);

    default public void addFlags(Collection<ModifierFlag> flags) {
        flags.forEach(this::addFlag);
    }

    default public void addFlags(ModifierFlag ... flags) {
        this.addFlags(Arrays.asList(flags));
    }

    public void removeFlag(ModifierFlag var1);

    default public void removeFlags(Collection<ModifierFlag> flags) {
        flags.forEach(this::removeFlag);
    }

    default public void removeFlags(ModifierFlag ... flags) {
        this.removeFlags(Arrays.asList(flags));
    }

    default public boolean supports(Modifier modifier) {
        return modifier.validIn(this.modifierLocation());
    }

    public void setAccess(AccessLevel var1);

    default public void public_() {
        this.setAccess(AccessLevel.PUBLIC);
    }

    default public void protected_() {
        this.setAccess(AccessLevel.PROTECTED);
    }

    default public void packagePrivate() {
        this.setAccess(AccessLevel.PACKAGE_PRIVATE);
    }

    default public void private_() {
        this.setAccess(AccessLevel.PRIVATE);
    }

    default public void final_() {
        this.addFlag(ModifierFlag.FINAL);
    }

    default public void synthetic() {
        this.addFlag(ModifierFlag.SYNTHETIC);
    }
}

