/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.time;

import java.util.Date;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.time.TimeConditionCreatedAfter;
import org.freeplane.features.time.TimeConditionCreatedBefore;
import org.freeplane.features.time.TimeConditionModifiedAfter;
import org.freeplane.features.time.TimeConditionModifiedBefore;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class TimeCondition
extends ASelectableCondition {
    static final String DATE = "DATE";
    static final String FILTER_CREATED_AFTER = "filter_created_after";
    static final String FILTER_CREATED_BEFORE = "filter_created_before";
    static final String FILTER_MODIFIED_AFTER = "filter_modified_after";
    static final String FILTER_MODIFIED_BEFORE = "filter_modified_before";
    private final FormattedDate date;

    public static ASelectableCondition create(TranslatedObject simpleCond, FormattedDate date) {
        if (simpleCond.objectEquals(FILTER_MODIFIED_AFTER)) {
            return new TimeConditionModifiedAfter(date);
        }
        if (simpleCond.objectEquals(FILTER_MODIFIED_BEFORE)) {
            return new TimeConditionModifiedBefore(date);
        }
        if (simpleCond.objectEquals(FILTER_CREATED_AFTER)) {
            return new TimeConditionCreatedAfter(date);
        }
        if (simpleCond.objectEquals(FILTER_CREATED_BEFORE)) {
            return new TimeConditionCreatedBefore(date);
        }
        return null;
    }

    public TimeCondition(FormattedDate date) {
        this.date = date;
    }

    @Override
    protected abstract String createDescription();

    public Date getDate() {
        return this.date;
    }

    @Override
    protected abstract String getName();

    @Override
    public void fillXML(XMLElement child) {
        child.setAttribute(DATE, Long.toString(this.getDate().getTime()));
    }
}

