/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.util.ColorUtil;

public class EdgeBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider topLeftColor;
    private ColorProvider bottomRightColor;
    private boolean drawTop;
    private boolean drawBottom;
    private boolean drawLeft;
    private boolean drawRight;
    private Insets insets;

    public EdgeBorder() {
        this(true, true, true, true);
    }

    public EdgeBorder(boolean drawTop, boolean drawBottom, boolean drawLeft, boolean drawRight) {
        this(null, drawTop, drawBottom, drawLeft, drawRight);
    }

    public EdgeBorder(Color color, boolean drawTop, boolean drawBottom, boolean drawLeft, boolean drawRight) {
        FixedColorProvider c = color == null ? null : new FixedColorProvider(color);
        this.init(c, c, drawTop, drawBottom, drawLeft, drawRight);
    }

    public EdgeBorder(ColorProvider color) {
        this.init(color, color, true, true, true, true);
    }

    public EdgeBorder(ColorProvider topLeftColor, ColorProvider bottomRightColor, boolean drawTop, boolean drawBottom, boolean drawLeft, boolean drawRight) {
        this.init(topLeftColor, bottomRightColor, drawTop, drawBottom, drawLeft, drawRight);
    }

    private void init(ColorProvider topLeftColor, ColorProvider bottomRightColor, boolean drawTop, boolean drawBottom, boolean drawLeft, boolean drawRight) {
        this.topLeftColor = topLeftColor;
        this.bottomRightColor = bottomRightColor;
        this.drawTop = drawTop;
        this.drawBottom = drawBottom;
        this.drawLeft = drawLeft;
        this.drawRight = drawRight;
        this.insets = new Insets(drawTop ? 1 : 0, drawLeft ? 1 : 0, drawBottom ? 1 : 0, drawRight ? 1 : 0);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color topLeft = this.getColor(this.topLeftColor, c);
        Color bottomRight = this.getColor(this.bottomRightColor, c);
        if (topLeft != null && bottomRight != null) {
            g.setColor(topLeft);
            if (this.drawTop) {
                GraphicsUtil.drawOptimizedLine(g, x, y, x + width - 1, y);
            }
            if (this.drawLeft) {
                GraphicsUtil.drawOptimizedLine(g, x, y, x, y + height - 1);
            }
            g.setColor(bottomRight);
            if (this.drawRight) {
                GraphicsUtil.drawOptimizedLine(g, x + width - 1, y, x + width - 1, y + height - 1);
            }
            if (this.drawBottom) {
                GraphicsUtil.drawOptimizedLine(g, x, y + height - 1, x + width - 1, y + height - 1);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private Color getColor(ColorProvider color, Component c) {
        Color col;
        Color color2 = col = color != null ? color.getColor() : null;
        if (col == null) {
            Color background = ComponentUtil.getBackgroundColor(c);
            return background == null ? null : ColorUtil.mult(background, 0.7f);
        }
        return col;
    }
}

