/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.util.List;
import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;
import org.apache.spark.sql.catalyst.util.geo.Point;

class LineString
extends GeometryModel {
    private final List<Point> points;

    LineString(List<Point> points, int srid, boolean hasZ, boolean hasM) {
        super(GeoTypeId.LINESTRING, srid, hasZ, hasM);
        this.points = points;
    }

    List<Point> getPoints() {
        return this.points;
    }

    int getNumPoints() {
        return this.points.size();
    }

    @Override
    boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    int getDimensionCount() {
        return 2 + (this.hasZ ? 1 : 0) + (this.hasM ? 1 : 0);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "LINESTRING EMPTY";
        }
        StringBuilder sb = new StringBuilder("LINESTRING (");
        for (int i = 0; i < this.points.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Point p = this.points.get(i);
            sb.append(p.getX()).append(" ").append(p.getY());
        }
        sb.append(")");
        return sb.toString();
    }
}

