/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.analysis.NamedStreamingRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.streaming.FlowAssigned;
import org.apache.spark.sql.catalyst.streaming.HasStreamingSourceIdentifyingName;
import org.apache.spark.sql.catalyst.streaming.StreamingSourceIdentifyingName;
import org.apache.spark.sql.catalyst.streaming.Unassigned$;
import org.apache.spark.sql.catalyst.streaming.UserProvided;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class NameStreamingSources$
extends Rule<LogicalPlan> {
    public static final NameStreamingSources$ MODULE$ = new NameStreamingSources$();

    private String getSourceDescriptor(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof HasStreamingSourceIdentifyingName) {
            LogicalPlan logicalPlan2 = logicalPlan;
            return logicalPlan2.toString();
        }
        if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            AliasIdentifier alias = subqueryAlias.identifier();
            return alias.toString();
        }
        return logicalPlan.nodeName();
    }

    private void checkSourceNamingEnforcement(LogicalPlan plan2) {
        Seq namedRelations = plan2.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NamedStreamingRelation) {
                    NamedStreamingRelation namedStreamingRelation = (NamedStreamingRelation)A1;
                    return (B1)namedStreamingRelation;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof NamedStreamingRelation;
            }
        });
        Seq unnamedSourcesInfo = (Seq)((IterableOps)namedRelations.zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                NamedStreamingRelation n = (NamedStreamingRelation)tuple2._1();
                int i = tuple2._2$mcI$sp();
                StreamingSourceIdentifyingName streamingSourceIdentifyingName = n.sourceIdentifyingName();
                if (streamingSourceIdentifyingName instanceof UserProvided ? true : streamingSourceIdentifyingName instanceof FlowAssigned) {
                    return None$.MODULE$;
                }
                if (Unassigned$.MODULE$.equals(streamingSourceIdentifyingName)) {
                    return new Some((Object)("Leaf position " + i + " - " + MODULE$.getSourceDescriptor(n.child())));
                }
                throw new MatchError((Object)streamingSourceIdentifyingName);
            }
            throw new MatchError((Object)tuple2);
        });
        if (unnamedSourcesInfo.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.unnamedStreamingSourcesWithEnforcementError(unnamedSourcesInfo.mkString("\n"));
        }
    }

    private LogicalPlan propagateSourceNames(LogicalPlan plan2) {
        return plan2.resolveOperatorsWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.containsPattern(TreePattern$.MODULE$.NAMED_STREAMING_RELATION())), plan2.resolveOperatorsWithPruning$default$2(), (PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                NamedStreamingRelation namedStreamingRelation = null;
                A1 A1 = x1;
                if (A1 instanceof NamedStreamingRelation) {
                    bl = true;
                    namedStreamingRelation = (NamedStreamingRelation)A1;
                    LogicalPlan h = namedStreamingRelation.child();
                    StreamingSourceIdentifyingName sourceIdentifyingName = namedStreamingRelation.sourceIdentifyingName();
                    if (h instanceof HasStreamingSourceIdentifyingName) {
                        LogicalPlan logicalPlan = h;
                        return (B1)((HasStreamingSourceIdentifyingName)((Object)logicalPlan)).withSourceIdentifyingName(sourceIdentifyingName);
                    }
                }
                if (bl) {
                    SubqueryAlias subqueryAlias;
                    LogicalPlan h;
                    LogicalPlan sa = namedStreamingRelation.child();
                    StreamingSourceIdentifyingName sourceIdentifyingName = namedStreamingRelation.sourceIdentifyingName();
                    if (sa instanceof SubqueryAlias && (h = (subqueryAlias = (SubqueryAlias)sa).child()) instanceof HasStreamingSourceIdentifyingName) {
                        LogicalPlan logicalPlan = h;
                        LogicalPlan x$1 = ((HasStreamingSourceIdentifyingName)((Object)logicalPlan)).withSourceIdentifyingName(sourceIdentifyingName);
                        AliasIdentifier x$2 = subqueryAlias.copy$default$1();
                        return (B1)subqueryAlias.copy(x$2, x$1);
                    }
                }
                if (bl) {
                    LogicalPlan child = namedStreamingRelation.child();
                    StreamingSourceIdentifyingName streamingSourceIdentifyingName = namedStreamingRelation.sourceIdentifyingName();
                    if (Unassigned$.MODULE$.equals(streamingSourceIdentifyingName) && child.resolved()) {
                        return (B1)child;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                SubqueryAlias subqueryAlias;
                LogicalPlan h;
                LogicalPlan sa;
                boolean bl = false;
                NamedStreamingRelation namedStreamingRelation = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof NamedStreamingRelation) {
                    bl = true;
                    namedStreamingRelation = (NamedStreamingRelation)logicalPlan;
                    LogicalPlan h2 = namedStreamingRelation.child();
                    if (h2 instanceof HasStreamingSourceIdentifyingName) {
                        return true;
                    }
                }
                if (bl && (sa = namedStreamingRelation.child()) instanceof SubqueryAlias && (h = (subqueryAlias = (SubqueryAlias)sa).child()) instanceof HasStreamingSourceIdentifyingName) {
                    return true;
                }
                if (bl) {
                    LogicalPlan child = namedStreamingRelation.child();
                    StreamingSourceIdentifyingName streamingSourceIdentifyingName = namedStreamingRelation.sourceIdentifyingName();
                    if (Unassigned$.MODULE$.equals(streamingSourceIdentifyingName) && child.resolved()) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        if (!plan2.isStreaming()) {
            return plan2;
        }
        if (this.conf().enableStreamingSourceEvolution()) {
            this.checkSourceNamingEnforcement(plan2);
            return this.propagateSourceNames(plan2);
        }
        return plan2.resolveOperatorsWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.containsPattern(TreePattern$.MODULE$.NAMED_STREAMING_RELATION())), plan2.resolveOperatorsWithPruning$default$2(), (PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                StreamingSourceIdentifyingName streamingSourceIdentifyingName;
                StreamingSourceIdentifyingName streamingSourceIdentifyingName2;
                boolean bl = false;
                NamedStreamingRelation namedStreamingRelation = null;
                A1 A1 = x1;
                if (A1 instanceof NamedStreamingRelation) {
                    bl = true;
                    namedStreamingRelation = (NamedStreamingRelation)A1;
                    LogicalPlan child = namedStreamingRelation.child();
                    StreamingSourceIdentifyingName streamingSourceIdentifyingName3 = namedStreamingRelation.sourceIdentifyingName();
                    if (Unassigned$.MODULE$.equals(streamingSourceIdentifyingName3) && child.resolved()) {
                        return (B1)child;
                    }
                }
                if (bl && (streamingSourceIdentifyingName2 = namedStreamingRelation.sourceIdentifyingName()) instanceof UserProvided) {
                    UserProvided userProvided = (UserProvided)streamingSourceIdentifyingName2;
                    String name = userProvided.name();
                    throw QueryCompilationErrors$.MODULE$.streamingSourceNamingNotSupportedError(name);
                }
                if (bl && (streamingSourceIdentifyingName = namedStreamingRelation.sourceIdentifyingName()) instanceof FlowAssigned) {
                    FlowAssigned flowAssigned = (FlowAssigned)streamingSourceIdentifyingName;
                    String name = flowAssigned.name();
                    throw QueryCompilationErrors$.MODULE$.streamingSourceNamingNotSupportedError(name);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                StreamingSourceIdentifyingName streamingSourceIdentifyingName;
                StreamingSourceIdentifyingName streamingSourceIdentifyingName2;
                boolean bl = false;
                NamedStreamingRelation namedStreamingRelation = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof NamedStreamingRelation) {
                    bl = true;
                    namedStreamingRelation = (NamedStreamingRelation)logicalPlan;
                    LogicalPlan child = namedStreamingRelation.child();
                    StreamingSourceIdentifyingName streamingSourceIdentifyingName3 = namedStreamingRelation.sourceIdentifyingName();
                    if (Unassigned$.MODULE$.equals(streamingSourceIdentifyingName3) && child.resolved()) {
                        return true;
                    }
                }
                if (bl && (streamingSourceIdentifyingName2 = namedStreamingRelation.sourceIdentifyingName()) instanceof UserProvided) {
                    return true;
                }
                return bl && (streamingSourceIdentifyingName = namedStreamingRelation.sourceIdentifyingName()) instanceof FlowAssigned;
            }
        });
    }

    private NameStreamingSources$() {
    }
}

