/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server.jmx;

import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.server.jmx.Handler;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;

@ManagedObject
public class ServerMBean
extends Handler.AbstractMBean {
    public ServerMBean(Object managedObject) {
        super(managedObject);
    }

    @Override
    public Server getManagedObject() {
        return (Server)super.getManagedObject();
    }

    public String getObjectNameBasis() {
        Server server = this.getManagedObject();
        return server.getName();
    }

    public String getObjectContextBasis() {
        Server server = this.getManagedObject();
        String name = server.getName();
        if (name != null) {
            return name;
        }
        return "%s@%x".formatted(TypeUtil.toShortName(server.getClass()), server.hashCode());
    }

    @ManagedAttribute(value="The contexts on this server")
    public List<ContextHandler> getContexts() {
        return this.getManagedObject().getDescendants(ContextHandler.class);
    }

    @ManagedAttribute(value="The UTC startup instant")
    public String getStartupTime() {
        ZonedDateTime zoned = this.getManagedObject().getStartupDateTime();
        return String.valueOf(zoned.withZoneSameInstant(ZoneOffset.UTC));
    }

    @ManagedAttribute(value="The startup date time in the system timezone")
    public String getStartupDateTime() {
        return String.valueOf(this.getManagedObject().getStartupDateTime());
    }

    @ManagedAttribute(value="The uptime duration in d:HH:mm:ss.SSS")
    public String getUpTime() {
        Duration upTime = Duration.ofMillis(this.getManagedObject().getUptimeMillis());
        return "%d:%02d:%02d:%02d.%03d".formatted(upTime.toDaysPart(), upTime.toHoursPart(), upTime.toMinutesPart(), upTime.toSecondsPart(), upTime.toMillisPart());
    }
}

