/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.security.internal;

import java.security.Principal;
import javax.security.auth.Subject;
import org.sparkproject.jetty.security.DefaultIdentityService;
import org.sparkproject.jetty.security.UserIdentity;

public class DefaultUserIdentity
implements UserIdentity {
    private final Subject _subject;
    private final Principal _userPrincipal;
    private final String[] _roles;

    public DefaultUserIdentity(Subject subject, Principal userPrincipal, String[] roles) {
        this._subject = subject;
        this._userPrincipal = userPrincipal;
        this._roles = roles;
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    @Override
    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (role == null) {
            return false;
        }
        if (DefaultIdentityService.isRoleAssociated(role)) {
            return true;
        }
        for (String r : this._roles) {
            if (!r.equals(role)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return DefaultUserIdentity.class.getSimpleName() + "('" + String.valueOf(this._userPrincipal) + "')";
    }
}

