/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.security.authentication;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.security.Authenticator;
import org.sparkproject.jetty.security.LoginService;
import org.sparkproject.jetty.security.SecurityHandler;
import org.sparkproject.jetty.security.UserIdentity;
import org.sparkproject.jetty.security.authentication.LoginAuthenticator;
import org.sparkproject.jetty.server.Session;
import org.sparkproject.jetty.util.TypeUtil;

public class SessionAuthentication
extends LoginAuthenticator.UserAuthenticationSucceeded
implements Serializable,
Session.ValueListener {
    private static final Logger LOG = LoggerFactory.getLogger(SessionAuthentication.class);
    private static final long serialVersionUID = -4643200685888258706L;
    public static final String AUTHENTICATED_ATTRIBUTE = "org.sparkproject.jetty.security.UserIdentity";
    private final String _name;
    private final Object _credentials;
    private transient Session _session;

    public SessionAuthentication(String method, UserIdentity userIdentity, Object credentials) {
        super(method, userIdentity);
        this._name = userIdentity.getUserPrincipal().getName();
        this._credentials = credentials;
    }

    @Override
    public UserIdentity getUserIdentity() {
        if (this._userIdentity == null) {
            throw new IllegalStateException("!UserIdentity");
        }
        return super.getUserIdentity();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!SecurityHandler");
            }
            return;
        }
        Authenticator authenticator = security.getAuthenticator();
        LoginService loginService = authenticator instanceof LoginAuthenticator ? ((LoginAuthenticator)authenticator).getLoginService() : security.getLoginService();
        if (loginService == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!LoginService");
            }
            return;
        }
        this._userIdentity = loginService.login(this._name, this._credentials, null, null);
        LOG.debug("Deserialized and relogged in {}", (Object)this);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._session == null ? "-" : this._session.getId(), this._userIdentity);
    }

    @Override
    public void onSessionActivation(Session session) {
        this._session = session;
    }

    @Override
    public void onSessionPassivation(Session session) {
    }
}

