/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.http.content;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Objects;
import org.sparkproject.jetty.http.MimeTypes;
import org.sparkproject.jetty.http.content.HttpContent;
import org.sparkproject.jetty.http.content.ResourceHttpContent;
import org.sparkproject.jetty.io.ByteBufferPool;
import org.sparkproject.jetty.util.resource.Resource;
import org.sparkproject.jetty.util.resource.ResourceFactory;
import org.sparkproject.jetty.util.resource.Resources;

public class ResourceHttpContentFactory
implements HttpContent.Factory {
    private final Resource _baseResource;
    private final MimeTypes _mimeTypes;
    private final ByteBufferPool.Sized _sizedBufferPool;

    public ResourceHttpContentFactory(Resource baseResource, MimeTypes mimeTypes, ByteBufferPool.Sized sizedBufferPool) {
        Objects.requireNonNull(mimeTypes, "MimeTypes cannot be null");
        this._baseResource = Objects.requireNonNullElse(baseResource, ResourceFactory.root().newResource("."));
        this._mimeTypes = mimeTypes;
        this._sizedBufferPool = sizedBufferPool;
    }

    @Override
    public HttpContent getContent(String pathInContext) throws IOException {
        try {
            Resource resource = this.resolve(pathInContext);
            if (Resources.missing(resource)) {
                return null;
            }
            return this.load(pathInContext, resource);
        }
        catch (Throwable t) {
            InvalidPathException saferException = new InvalidPathException(pathInContext, "Invalid PathInContext");
            saferException.initCause(t);
            throw saferException;
        }
    }

    protected Resource resolve(String pathInContext) {
        return this._baseResource.resolve(pathInContext);
    }

    private HttpContent load(String pathInContext, Resource resource) {
        if (resource == null || !resource.exists()) {
            return null;
        }
        return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(pathInContext), this._sizedBufferPool);
    }

    public String toString() {
        return "ResourceContentFactory[" + String.valueOf(this._baseResource) + "]@" + this.hashCode();
    }
}

