/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlet;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.ee10.servlet.Dispatcher;
import org.sparkproject.jetty.ee10.servlet.ServletApiRequest;
import org.sparkproject.jetty.ee10.servlet.ServletContextHandler;
import org.sparkproject.jetty.ee10.servlet.ServletContextRequest;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.HttpStatus;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.StringUtil;

public class ErrorHandler
extends org.sparkproject.jetty.server.handler.ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHandler.class);

    public ErrorHandler() {
        this.setShowOrigin(true);
        this.setShowStacks(true);
        this.setShowMessageInTitle(true);
    }

    @Override
    public boolean writeError(Request request, Response response, Callback callback, int code) {
        boolean enteredServletChannel;
        ServletContextRequest servletContextRequest = Request.as(request, ServletContextRequest.class);
        boolean bl = enteredServletChannel = servletContextRequest.getServletChannel().getCallback() != null;
        if (!enteredServletChannel) {
            response.setStatus(code);
            request.setAttribute("org.sparkproject.jetty.server.error_status", code);
            return false;
        }
        return super.writeError(request, response, callback, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String message;
        block14: {
            if (!this.errorPageForMethod(request.getMethod())) {
                callback.succeeded();
                return true;
            }
            this.generateCacheControl(response);
            ServletContextRequest servletContextRequest = Request.asInContext(request, ServletContextRequest.class);
            ServletApiRequest httpServletRequest = servletContextRequest.getServletApiRequest();
            HttpServletResponse httpServletResponse = servletContextRequest.getHttpServletResponse();
            ServletContextHandler contextHandler = servletContextRequest.getServletContext().getServletContextHandler();
            String cacheControl = this.getCacheControl();
            if (cacheControl != null) {
                response.getHeaders().put(HttpHeader.CACHE_CONTROL.asString(), cacheControl);
            }
            ServletContextHandler.ServletScopedContext context = servletContextRequest.getErrorContext();
            Integer errorStatus = (Integer)request.getAttribute("org.sparkproject.jetty.server.error_status");
            Throwable errorCause = (Throwable)request.getAttribute("org.sparkproject.jetty.server.error_exception");
            boolean enteredServletChannel = servletContextRequest.getServletChannel().getCallback() != null;
            ErrorHandler errorHandler = this;
            if (errorHandler instanceof ErrorPageMapper) {
                ErrorPageMapper mapper = (ErrorPageMapper)((Object)errorHandler);
                if (enteredServletChannel) {
                    RequestDispatcher requestDispatcher;
                    ErrorPageMapper.ErrorPage errorPage = mapper.getErrorPage(errorStatus, errorCause);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {} {} -> {}", new Object[]{context, errorStatus, errorCause, errorPage});
                    }
                    if (errorPage != null && (requestDispatcher = context.getServletContext().getRequestDispatcher(errorPage.errorPage)) instanceof Dispatcher) {
                        Dispatcher errorDispatcher = (Dispatcher)requestDispatcher;
                        try {
                            try {
                                mapper.prepare(errorPage, httpServletRequest, httpServletResponse);
                                contextHandler.requestInitialized(servletContextRequest, httpServletRequest);
                                errorDispatcher.error((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                            }
                            finally {
                                contextHandler.requestDestroyed(servletContextRequest, httpServletRequest);
                            }
                            callback.succeeded();
                            return true;
                        }
                        catch (ServletException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Unable to call error dispatcher", (Throwable)e);
                            }
                            if (!response.isCommitted()) break block14;
                            callback.failed(e);
                            return true;
                        }
                    }
                }
            }
        }
        if ((message = (String)request.getAttribute("org.sparkproject.jetty.server.error_message")) == null) {
            message = HttpStatus.getMessage(response.getStatus());
        }
        this.generateResponse(request, response, response.getStatus(), message, (Throwable)request.getAttribute("org.sparkproject.jetty.server.error_exception"), callback);
        callback.succeeded();
        return true;
    }

    @Override
    protected boolean generateAcceptableResponse(Request request, Response response, Callback callback, String contentType, List<Charset> charsets, int code, String message, Throwable cause) throws IOException {
        boolean result = super.generateAcceptableResponse(request, response, callback, contentType, charsets, code, message, cause);
        if (result) {
            ServletContextRequest servletContextRequest = Request.as(request, ServletContextRequest.class);
            servletContextRequest.getServletChannel().sendErrorResponseAndComplete();
        }
        return result;
    }

    @Override
    protected void writeErrorHtmlMessage(Request request, Writer writer, int code, String message, Throwable cause, String uri) throws IOException {
        writer.write("<h2>HTTP ERROR ");
        String status = Integer.toString(code);
        writer.write(status);
        if (message != null && !message.equals(status)) {
            writer.write(32);
            writer.write(StringUtil.sanitizeXmlString(message));
        }
        writer.write("</h2>\n");
        writer.write("<table>\n");
        this.htmlRow(writer, "URI", uri);
        this.htmlRow(writer, "STATUS", status);
        this.htmlRow(writer, "MESSAGE", message);
        this.writeErrorOrigin((String)request.getAttribute("org.sparkproject.jetty.server.error_origin"), o -> {
            try {
                this.htmlRow(writer, "SERVLET", o);
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        });
        while (cause != null) {
            this.htmlRow(writer, "CAUSED BY", cause);
            cause = cause.getCause();
        }
        writer.write("</table>\n");
    }

    public static Request.Handler getErrorHandler(Server server, ContextHandler context) {
        Request.Handler errorHandler = null;
        if (context != null) {
            errorHandler = context.getErrorHandler();
        }
        if (errorHandler == null && server != null) {
            errorHandler = server.getErrorHandler();
        }
        return errorHandler;
    }

    public static interface ErrorPageMapper {
        public ErrorPage getErrorPage(Integer var1, Throwable var2);

        default public void prepare(ErrorPage errorPage, HttpServletRequest request, HttpServletResponse response) {
        }

        public record ErrorPage(String errorPage, PageLookupTechnique match, Throwable error, Throwable cause, Class<?> matchedClass) {
        }

        public static enum PageLookupTechnique {
            THROWABLE,
            STATUS_CODE,
            GLOBAL;

        }
    }
}

