/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client.transport;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.client.AbstractConnectorHttpClientTransport;
import org.sparkproject.jetty.client.Destination;
import org.sparkproject.jetty.client.DuplexConnectionPool;
import org.sparkproject.jetty.client.HttpRequestException;
import org.sparkproject.jetty.client.Origin;
import org.sparkproject.jetty.client.Request;
import org.sparkproject.jetty.client.transport.HttpClientConnectionFactory;
import org.sparkproject.jetty.client.transport.HttpDestination;
import org.sparkproject.jetty.client.transport.HttpRequest;
import org.sparkproject.jetty.http.HttpVersion;
import org.sparkproject.jetty.io.ClientConnector;
import org.sparkproject.jetty.io.Connection;
import org.sparkproject.jetty.io.EndPoint;
import org.sparkproject.jetty.io.Transport;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    public static final Origin.Protocol HTTP11 = new Origin.Protocol(List.of("http/1.1"), false);
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransportOverHTTP.class);
    private final HttpClientConnectionFactory factory = new HttpClientConnectionFactory();
    private int headerCacheSize = 1024;
    private boolean headerCacheCaseSensitive;

    public HttpClientTransportOverHTTP() {
        this(1);
    }

    public HttpClientTransportOverHTTP(int selectors) {
        this(new ClientConnector());
        this.getClientConnector().setSelectors(selectors);
    }

    public HttpClientTransportOverHTTP(ClientConnector connector) {
        super(connector);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination()));
    }

    @Override
    public Origin newOrigin(Request request) {
        HttpVersion version = request.getVersion();
        HttpVersion http1 = HttpVersion.HTTP_1_1;
        if (((HttpRequest)request).isVersionExplicit() && version.compareTo(http1) > 0) {
            throw new HttpRequestException("Cannot send explicit %s requests with %s transport".formatted(new Object[]{version, http1}), request);
        }
        if (request.getTransport() == null) {
            request.transport(Transport.TCP_IP);
        }
        return this.getHttpClient().createOrigin(request, HTTP11);
    }

    @Override
    public Destination newDestination(Origin origin) {
        return new HttpDestination(this.getHttpClient(), origin);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        Connection connection = this.factory.newConnection(endPoint, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", (Object)connection);
        }
        return connection;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for the HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }

    @ManagedAttribute(value="Whether the HTTP header field cache is case-sensitive")
    public boolean isHeaderCacheCaseSensitive() {
        return this.headerCacheCaseSensitive;
    }

    public void setHeaderCacheCaseSensitive(boolean headerCacheCaseSensitive) {
        this.headerCacheCaseSensitive = headerCacheCaseSensitive;
    }

    @ManagedAttribute(value="Whether newly created connections should be initialized with an OPTIONS * HTTP/1.1 request")
    public boolean isInitializeConnections() {
        return this.factory.isInitializeConnections();
    }

    public void setInitializeConnections(boolean initialize) {
        this.factory.setInitializeConnections(initialize);
    }
}

