/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.VertxException;
import java.util.Objects;
import java.util.function.BiFunction;

@FunctionalInterface
public interface Expectation<V> {
    public boolean test(V var1);

    default public Expectation<V> and(final Expectation<? super V> other) {
        Objects.requireNonNull(other);
        return new Expectation<V>(){

            @Override
            public boolean test(V value) {
                return Expectation.this.test(value) && other.test(value);
            }

            @Override
            public Throwable describe(V value) {
                if (!Expectation.this.test(value)) {
                    return Expectation.this.describe(value);
                }
                if (!other.test(value)) {
                    return other.describe(value);
                }
                return null;
            }
        };
    }

    default public Expectation<V> or(final Expectation<? super V> other) {
        Objects.requireNonNull(other);
        return new Expectation<V>(){

            @Override
            public boolean test(V value) {
                return Expectation.this.test(value) || other.test(value);
            }

            @Override
            public Throwable describe(V value) {
                if (Expectation.this.test(value)) {
                    return null;
                }
                if (other.test(value)) {
                    return null;
                }
                return Expectation.this.describe(value);
            }
        };
    }

    default public Throwable describe(V value) {
        return new VertxException("Unexpected result: " + value, true);
    }

    default public Expectation<V> wrappingFailure(BiFunction<V, Throwable, Throwable> descriptor) {
        class CustomizedExpectation
        implements Expectation<V> {
            private final BiFunction<V, Throwable, Throwable> descriptor;

            CustomizedExpectation(BiFunction<V, Throwable, Throwable> descriptor) {
                this.descriptor = Objects.requireNonNull(descriptor);
            }

            @Override
            public boolean test(V value) {
                return Expectation.this.test(value);
            }

            @Override
            public Throwable describe(V value) {
                Throwable err = Expectation.this.describe(value);
                return this.descriptor.apply(value, err);
            }

            @Override
            public Expectation<V> wrappingFailure(BiFunction<V, Throwable, Throwable> descriptor) {
                return new CustomizedExpectation(descriptor);
            }
        }
        return new CustomizedExpectation(descriptor);
    }
}

