/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ITimestampInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class TimestampColumnInList
extends VectorExpression
implements ITimestampInExpr {
    private static final long serialVersionUID = 1L;
    private int inputCol;
    private Timestamp[] inListValues;
    private int outputColumn;
    private transient HashSet<Timestamp> inSet;

    public TimestampColumnInList() {
        this.inSet = null;
    }

    public TimestampColumnInList(int colNum, int outputColumn) {
        this.inputCol = colNum;
        this.outputColumn = outputColumn;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new HashSet(this.inListValues.length);
            for (Timestamp val : this.inListValues) {
                this.inSet.add(val);
            }
        }
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputCol];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        boolean[] outNulls = outputColVector.isNull;
        int n = batch.size;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        outputColVector.noNulls = inputColVector.noNulls;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = this.inSet.contains(inputColVector.asScratchTimestamp(0)) ? 1L : 0L;
                outputColVector.isRepeating = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                outputVector[0] = this.inSet.contains(inputColVector.asScratchTimestamp(0)) ? 1L : 0L;
                outNulls[0] = false;
            } else {
                outNulls[0] = true;
            }
            outputColVector.isRepeating = true;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outNulls[i] = nullPos[i];
                if (nullPos[i]) continue;
                outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
            }
        } else {
            System.arraycopy(nullPos, 0, outNulls, 0, n);
            for (int i = 0; i != n; ++i) {
                if (nullPos[i]) continue;
                outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public void setInListValues(Timestamp[] a) {
        this.inListValues = a;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputCol + ", values " + Arrays.toString(this.inListValues);
    }
}

