/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.thetacommon.BoundsOnRatiosInTupleSketchedSets;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;

public final class JaccardSimilarity {
    private static final double[] ZEROS = new double[]{0.0, 0.0, 0.0};
    private static final double[] ONES = new double[]{1.0, 1.0, 1.0};

    public static <S extends Summary> double[] jaccard(Sketch<S> sketchA, Sketch<S> sketchB, SummarySetOperations<S> summarySetOps) {
        if (sketchA == null || sketchB == null) {
            return (double[])ZEROS.clone();
        }
        if (sketchA.isEmpty() && sketchB.isEmpty()) {
            return (double[])ONES.clone();
        }
        if (sketchA.isEmpty() || sketchB.isEmpty()) {
            return (double[])ZEROS.clone();
        }
        int countA = sketchA.getRetainedEntries();
        int countB = sketchB.getRetainedEntries();
        int minK = 16;
        int maxK = 0x4000000;
        int newK = Math.max(Math.min(Util.ceilingPowerOf2(countA + countB), 0x4000000), 16);
        Union<S> union = new Union<S>(newK, summarySetOps);
        union.union(sketchA);
        union.union(sketchB);
        CompactSketch<S> unionAB = union.getResult();
        long thetaLongUAB = unionAB.getThetaLong();
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        int countUAB = ((Sketch)unionAB).getRetainedEntries();
        if (countUAB == countA && countUAB == countB && thetaLongUAB == thetaLongA && thetaLongUAB == thetaLongB) {
            return (double[])ONES.clone();
        }
        Intersection<S> inter = new Intersection<S>(summarySetOps);
        inter.intersect(sketchA);
        inter.intersect(sketchB);
        inter.intersect(unionAB);
        CompactSketch<S> interABU = inter.getResult();
        double lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA(unionAB, interABU);
        double est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA(unionAB, interABU);
        double ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA(unionAB, interABU);
        return new double[]{lb, est, ub};
    }

    public static <S extends Summary> double[] jaccard(Sketch<S> sketchA, org.apache.datasketches.theta.Sketch sketchB, S summary, SummarySetOperations<S> summarySetOps) {
        if (summary == null) {
            throw new SketchesArgumentException("Summary cannot be null.");
        }
        if (sketchA == null || sketchB == null) {
            return (double[])ZEROS.clone();
        }
        if (sketchA.isEmpty() && sketchB.isEmpty()) {
            return (double[])ONES.clone();
        }
        if (sketchA.isEmpty() || sketchB.isEmpty()) {
            return (double[])ZEROS.clone();
        }
        int countA = sketchA.getRetainedEntries();
        int countB = sketchB.getRetainedEntries(true);
        int minK = 16;
        int maxK = 0x4000000;
        int newK = Math.max(Math.min(Util.ceilingPowerOf2(countA + countB), 0x4000000), 16);
        Union<S> union = new Union<S>(newK, summarySetOps);
        union.union(sketchA);
        union.union(sketchB, summary);
        CompactSketch<S> unionAB = union.getResult();
        long thetaLongUAB = unionAB.getThetaLong();
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        int countUAB = ((Sketch)unionAB).getRetainedEntries();
        if (countUAB == countA && countUAB == countB && thetaLongUAB == thetaLongA && thetaLongUAB == thetaLongB) {
            return (double[])ONES.clone();
        }
        Intersection<S> inter = new Intersection<S>(summarySetOps);
        inter.intersect(sketchA);
        inter.intersect(sketchB, summary);
        inter.intersect(unionAB);
        CompactSketch<S> interABU = inter.getResult();
        double lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA(unionAB, interABU);
        double est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA(unionAB, interABU);
        double ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA(unionAB, interABU);
        return new double[]{lb, est, ub};
    }

    public static <S extends Summary> boolean exactlyEqual(Sketch<S> sketchA, Sketch<S> sketchB, SummarySetOperations<S> summarySetOps) {
        if (sketchA == null || sketchB == null) {
            return false;
        }
        if (sketchA == sketchB) {
            return true;
        }
        if (sketchA.isEmpty() && sketchB.isEmpty()) {
            return true;
        }
        if (sketchA.isEmpty() || sketchB.isEmpty()) {
            return false;
        }
        int countA = sketchA.getRetainedEntries();
        int countB = sketchB.getRetainedEntries();
        Union<S> union = new Union<S>(Util.ceilingPowerOf2(countA + countB), summarySetOps);
        union.union(sketchA);
        union.union(sketchB);
        CompactSketch<S> unionAB = union.getResult();
        long thetaLongUAB = unionAB.getThetaLong();
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        int countUAB = ((Sketch)unionAB).getRetainedEntries();
        return countUAB == countA && countUAB == countB && thetaLongUAB == thetaLongA && thetaLongUAB == thetaLongB;
    }

    public static <S extends Summary> boolean exactlyEqual(Sketch<S> sketchA, org.apache.datasketches.theta.Sketch sketchB, S summary, SummarySetOperations<S> summarySetOps) {
        if (summary == null) {
            throw new SketchesArgumentException("Summary cannot be null.");
        }
        if (sketchA == null || sketchB == null) {
            return false;
        }
        if (sketchA.isEmpty() && sketchB.isEmpty()) {
            return true;
        }
        if (sketchA.isEmpty() || sketchB.isEmpty()) {
            return false;
        }
        int countA = sketchA.getRetainedEntries();
        int countB = sketchB.getRetainedEntries(true);
        Union<S> union = new Union<S>(Util.ceilingPowerOf2(countA + countB), summarySetOps);
        union.union(sketchA);
        union.union(sketchB, summary);
        CompactSketch<S> unionAB = union.getResult();
        long thetaLongUAB = unionAB.getThetaLong();
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        int countUAB = ((Sketch)unionAB).getRetainedEntries();
        return countUAB == countA && countUAB == countB && thetaLongUAB == thetaLongA && thetaLongUAB == thetaLongB;
    }

    public static <S extends Summary> boolean similarityTest(Sketch<S> measured, Sketch<S> expected, SummarySetOperations<S> summarySetOps, double threshold) {
        double jRatioLB = JaccardSimilarity.jaccard(measured, expected, summarySetOps)[0];
        return jRatioLB >= threshold;
    }

    public static <S extends Summary> boolean similarityTest(Sketch<S> measured, org.apache.datasketches.theta.Sketch expected, S summary, SummarySetOperations<S> summarySetOps, double threshold) {
        double jRatioLB = JaccardSimilarity.jaccard(measured, expected, summary, summarySetOps)[0];
        return jRatioLB >= threshold;
    }

    public static <S extends Summary> boolean dissimilarityTest(Sketch<S> measured, Sketch<S> expected, SummarySetOperations<S> summarySetOps, double threshold) {
        double jRatioUB = JaccardSimilarity.jaccard(measured, expected, summarySetOps)[2];
        return jRatioUB <= threshold;
    }

    public static <S extends Summary> boolean dissimilarityTest(Sketch<S> measured, org.apache.datasketches.theta.Sketch expected, S summary, SummarySetOperations<S> summarySetOps, double threshold) {
        double jRatioUB = JaccardSimilarity.jaccard(measured, expected, summary, summarySetOps)[2];
        return jRatioUB <= threshold;
    }
}

