/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.bus.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.volcano.api.model.bus.v1alpha1.Command;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CommandFluent<A extends CommandFluent<A>>
extends BaseFluent<A> {
    private String action;
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String kind;
    private String message;
    private ObjectMetaBuilder metadata;
    private String reason;
    private OwnerReference target;

    public CommandFluent() {
    }

    public CommandFluent(Command instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    protected void copyInstance(Command instance) {
        Command command = instance = instance != null ? instance : new Command();
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMessage(instance.getMessage());
            this.withMetadata(instance.getMetadata());
            this.withReason(instance.getReason());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommandFluent that = (CommandFluent)((Object)o);
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public String getAction() {
        return this.action;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReason() {
        return this.reason;
    }

    public OwnerReference getTarget() {
        return this.target;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.kind, this.message, this.metadata, this.reason, this.target, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action);
            sb.append(",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason);
            sb.append(",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAction(String action) {
        this.action = action;
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)((Object)this);
    }

    public A withTarget(OwnerReference target) {
        this.target = target;
        return (A)((Object)this);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)CommandFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

