/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.Iso8601TimestampFormatter$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001\u0002\u000e\u001c\u0001!B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011!)\u0007A!A!\u0002\u00131\u0007\"B5\u0001\t\u0003Q\u0007\u0002C9\u0001\u0011\u000b\u0007I\u0011\u0003:\t\u0011u\u0004\u0001R1A\u0005\nID\u0011b \u0001\t\u0006\u0004%\t\"!\u0001\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0001bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!a\u0012\u0001\t\u0003\nI\u0005\u0003\u0004w\u0001\u0011\u0005\u0013q\n\u0005\u0007m\u0002!\t%a\u0017\t\rY\u0004A\u0011IA1\u0011\u00191\b\u0001\"\u0011\u0002r!9\u0011Q\u0010\u0001\u0005B\u0005}t!CAF7\u0005\u0005\t\u0012AAG\r!Q2$!A\t\u0002\u0005=\u0005BB5\u0017\t\u0003\ti\nC\u0005\u0002 Z\t\n\u0011\"\u0001\u0002\"\"I\u0011q\u0017\f\u0002\u0002\u0013%\u0011\u0011\u0018\u0002\u001a\u0013N|\u0007H\u000e\u00192)&lWm\u001d;b[B4uN]7biR,'O\u0003\u0002\u001d;\u0005!Q\u000f^5m\u0015\tqr$\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011fL\u001a\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\t\u0001\u0014'D\u0001\u001c\u0013\t\u00114D\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\bC\u0001\u00195\u0013\t)4DA\fECR,G+[7f\r>\u0014X.\u0019;uKJDU\r\u001c9fe\u00069\u0001/\u0019;uKJt\u0007C\u0001\u001d@\u001d\tIT\b\u0005\u0002;W5\t1H\u0003\u0002=O\u00051AH]8pizJ!AP\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}-\naA_8oK&#\u0007C\u0001#J\u001b\u0005)%B\u0001$H\u0003\u0011!\u0018.\\3\u000b\u0003!\u000bAA[1wC&\u0011!*\u0012\u0002\u00075>tW-\u00133\u0002\r1|7-\u00197f!\tiu*D\u0001O\u0015\tar)\u0003\u0002Q\u001d\n1Aj\\2bY\u0016\fA\u0002\\3hC\u000eLhi\u001c:nCR\u0004\"a\u00152\u000f\u0005Q\u0003gBA+`\u001d\t1fL\u0004\u0002X;:\u0011\u0001\f\u0018\b\u00033ns!A\u000f.\n\u0003\u0019J!\u0001J\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\tqr$\u0003\u0002\u001d;%\u0011\u0011mG\u0001\u0012\u0019\u0016<\u0017mY=ECR,gi\u001c:nCR\u001c\u0018BA2e\u0005AaUmZ1ds\u0012\u000bG/\u001a$pe6\fGO\u0003\u0002b7\u0005I\u0011n\u001d)beNLgn\u001a\t\u0003U\u001dL!\u0001[\u0016\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"ba\u001b7n]>\u0004\bC\u0001\u0019\u0001\u0011\u00151d\u00011\u00018\u0011\u0015\u0011e\u00011\u0001D\u0011\u0015Ye\u00011\u0001M\u0011\u001d\tf\u0001%AA\u0002ICQ!\u001a\u0004A\u0002\u0019\f\u0011BZ8s[\u0006$H/\u001a:\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A^#\u0002\r\u0019|'/\\1u\u0013\tAXOA\tECR,G+[7f\r>\u0014X.\u0019;uKJD#a\u0002>\u0011\u0005)Z\u0018B\u0001?,\u0005%!(/\u00198tS\u0016tG/\u0001\b{_:,GMR8s[\u0006$H/\u001a:)\u0005!Q\u0018a\u00047fO\u0006\u001c\u0017PR8s[\u0006$H/\u001a:\u0016\u0003=B#!\u0003>\u0002\u001bA\f'o]3PaRLwN\\1m)\u0011\tI!!\u0006\u0011\u000b)\nY!a\u0004\n\u0007\u000551F\u0001\u0004PaRLwN\u001c\t\u0004U\u0005E\u0011bAA\nW\t!Aj\u001c8h\u0011\u0019\t9B\u0003a\u0001o\u0005\t1/A\u0007fqR\u0014\u0018m\u0019;NS\u000e\u0014xn\u001d\u000b\u0005\u0003\u001f\ti\u0002C\u0004\u0002 -\u0001\r!!\t\u0002\rA\f'o]3e!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\u000b\u0006AA/Z7q_J\fG.\u0003\u0003\u0002,\u0005\u0015\"\u0001\u0005+f[B|'/\u00197BG\u000e,7o]8s\u0003\u0015\u0001\u0018M]:f)\u0011\ty!!\r\t\r\u0005]A\u00021\u00018\u0003q\u0001\u0018M]:f/&$\bn\\;u)&lWMW8oK>\u0003H/[8oC2$b!!\u0003\u00028\u0005e\u0002BBA\f\u001b\u0001\u0007q\u0007\u0003\u0004\u0002<5\u0001\rAZ\u0001\u000eC2dwn\u001e+j[\u0016TvN\\3\u0002!\u0015DHO]1di6K7M]8t\u001dRSF\u0003CA\b\u0003\u0003\n\u0019%!\u0012\t\r\u0005]a\u00021\u00018\u0011\u001d\tyB\u0004a\u0001\u0003CAa!a\u000f\u000f\u0001\u00041\u0017\u0001\u00069beN,w+\u001b;i_V$H+[7f5>tW\r\u0006\u0004\u0002\u0010\u0005-\u0013Q\n\u0005\u0007\u0003/y\u0001\u0019A\u001c\t\r\u0005mr\u00021\u0001g)\r9\u0014\u0011\u000b\u0005\b\u0003'\u0002\u0002\u0019AA+\u0003\u001dIgn\u001d;b]R\u00042\u0001RA,\u0013\r\tI&\u0012\u0002\b\u0013:\u001cH/\u00198u)\r9\u0014Q\f\u0005\b\u0003?\n\u0002\u0019AA\b\u0003\t)8\u000fF\u00028\u0003GBq!!\u001a\u0013\u0001\u0004\t9'\u0001\u0002ugB!\u0011\u0011NA7\u001b\t\tYG\u0003\u0002!\u000f&!\u0011qNA6\u0005%!\u0016.\\3ti\u0006l\u0007\u000fF\u00028\u0003gBq!!\u001e\u0014\u0001\u0004\t9(A\u0007m_\u000e\fG\u000eR1uKRKW.\u001a\t\u0004\t\u0006e\u0014bAA>\u000b\niAj\\2bY\u0012\u000bG/\u001a+j[\u0016\fQC^1mS\u0012\fG/\u001a)biR,'O\\*ue&tw\r\u0006\u0003\u0002\u0002\u0006\u001d\u0005c\u0001\u0016\u0002\u0004&\u0019\u0011QQ\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0013#\u0002\u0019\u00014\u0002\u0017\rDWmY6MK\u001e\f7-_\u0001\u001a\u0013N|\u0007H\u000e\u00192)&lWm\u001d;b[B4uN]7biR,'\u000f\u0005\u00021-M!a#KAI!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL\u000f\u0006\u0011\u0011n\\\u0005\u0005\u00037\u000b)J\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\u000e\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"!a)+\u0007I\u000b)k\u000b\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016!C;oG\",7m[3e\u0015\r\t\tlK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA[\u0003W\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tmR\u0001\u0005Y\u0006tw-\u0003\u0003\u0002F\u0006}&AB(cU\u0016\u001cG\u000f")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private transient DateTimeFormatter zonedFormatter;
    private transient TimestampFormatter legacyFormatter;
    private final String pattern;
    private final ZoneId zoneId;
    private final Locale locale;
    private final Enumeration.Value legacyFormat;
    private final boolean isParsing;
    private volatile transient byte bitmap$trans$0;

    public static Enumeration.Value $lessinit$greater$default$4() {
        return Iso8601TimestampFormatter$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public LocalDate toLocalDate(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalDate$(this, accessor);
    }

    @Override
    public LocalTime toLocalTime(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalTime$(this, accessor);
    }

    @Override
    public ZonedDateTime toZonedDateTime(TemporalAccessor accessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toZonedDateTime$(this, accessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale, boolean isParsing) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale, isParsing);
    }

    @Override
    public <T> PartialFunction<Throwable, T> checkParsedDiff(String s, Function1<String, T> legacyParseFunc) {
        return DateTimeFormatterHelper.checkParsedDiff$(this, s, legacyParseFunc);
    }

    @Override
    public <T extends Date> PartialFunction<Throwable, String> checkFormattedDiff(T d, Function1<T, String> legacyFormatFunc) {
        return DateTimeFormatterHelper.checkFormattedDiff$(this, d, legacyFormatFunc);
    }

    @Override
    public PartialFunction<Throwable, DateTimeFormatter> checkLegacyFormatter(String pattern, Function0<BoxedUnit> tryLegacyFormatter) {
        return DateTimeFormatterHelper.checkLegacyFormatter$(this, pattern, tryLegacyFormatter);
    }

    @Override
    public PartialFunction<Throwable, Nothing$> checkInvalidPattern(String pattern) {
        return DateTimeFormatterHelper.checkInvalidPattern$(this, pattern);
    }

    @Override
    public final long parseWithoutTimeZone(String s) throws ParseException, DateTimeParseException, DateTimeException, IllegalStateException {
        return TimestampFormatter.parseWithoutTimeZone$(this, s);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale, this.isParsing);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatter;
    }

    public DateTimeFormatter formatter() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.formatter$lzycompute();
        }
        return this.formatter;
    }

    private DateTimeFormatter zonedFormatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zonedFormatter = this.formatter().withZone(this.zoneId);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zonedFormatter;
    }

    private DateTimeFormatter zonedFormatter() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zonedFormatter$lzycompute();
        }
        return this.zonedFormatter;
    }

    private TimestampFormatter legacyFormatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.legacyFormatter = TimestampFormatter$.MODULE$.getLegacyFormatter(this.pattern, this.zoneId, this.locale, this.legacyFormat);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.legacyFormatter;
    }

    public TimestampFormatter legacyFormatter() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.legacyFormatter$lzycompute();
        }
        return this.legacyFormatter;
    }

    @Override
    public Option<Object> parseOptional(String s) {
        Object object;
        try {
            ParsePosition parsePosition = new ParsePosition(0);
            TemporalAccessor parsed = this.formatter().parseUnresolved(s, parsePosition);
            object = parsed != null && s.length() == parsePosition.getIndex() ? new Some((Object)BoxesRunTime.boxToLong((long)this.extractMicros(parsed))) : None$.MODULE$;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                object = None$.MODULE$;
            }
            throw throwable;
        }
        return object;
    }

    private long extractMicros(TemporalAccessor parsed) {
        ZoneId parsedZoneId = parsed.query(TemporalQueries.zone());
        ZoneId timeZoneId = parsedZoneId == null ? this.zoneId : parsedZoneId;
        ZonedDateTime zonedDateTime = this.toZonedDateTime(parsed, timeZoneId);
        long epochSeconds = zonedDateTime.toEpochSecond();
        int microsOfSecond = zonedDateTime.get(ChronoField.MICRO_OF_SECOND);
        return Math.addExact(Math.multiplyExact(epochSeconds, 1000000L), (long)microsOfSecond);
    }

    @Override
    public long parse(String s2) {
        long l;
        try {
            TemporalAccessor parsed = this.formatter().parse(s2);
            l = this.extractMicros(parsed);
        }
        catch (Throwable x$3) {
            PartialFunction catchExpr$1 = this.checkParsedDiff(s2, (Function1 & Serializable)s -> BoxesRunTime.boxToLong((long)Iso8601TimestampFormatter.$anonfun$parse$1(this, s)));
            if (catchExpr$1.isDefinedAt((Object)x$3)) {
                l = BoxesRunTime.unboxToLong((Object)catchExpr$1.apply((Object)x$3));
            }
            throw x$3;
        }
        return l;
    }

    @Override
    public Option<Object> parseWithoutTimeZoneOptional(String s, boolean allowTimeZone) {
        Object object;
        try {
            ParsePosition parsePosition = new ParsePosition(0);
            TemporalAccessor parsed = this.formatter().parseUnresolved(s, parsePosition);
            object = parsed != null && s.length() == parsePosition.getIndex() ? new Some((Object)BoxesRunTime.boxToLong((long)this.extractMicrosNTZ(s, parsed, allowTimeZone))) : None$.MODULE$;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                object = None$.MODULE$;
            }
            throw throwable;
        }
        return object;
    }

    private long extractMicrosNTZ(String s, TemporalAccessor parsed, boolean allowTimeZone) {
        if (!allowTimeZone && parsed.query(TemporalQueries.zone()) != null) {
            throw ExecutionErrors$.MODULE$.cannotParseStringAsDataTypeError(this.pattern, s, TimestampNTZType$.MODULE$);
        }
        LocalDate localDate = this.toLocalDate(parsed);
        LocalTime localTime = this.toLocalTime(parsed);
        return SparkDateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.of(localDate, localTime));
    }

    @Override
    public long parseWithoutTimeZone(String s2, boolean allowTimeZone) {
        long l;
        try {
            TemporalAccessor parsed = this.formatter().parse(s2);
            l = this.extractMicrosNTZ(s2, parsed, allowTimeZone);
        }
        catch (Throwable x$4) {
            PartialFunction catchExpr$2 = this.checkParsedDiff(s2, (Function1 & Serializable)s -> BoxesRunTime.boxToLong((long)Iso8601TimestampFormatter.$anonfun$parseWithoutTimeZone$1(this, s)));
            if (catchExpr$2.isDefinedAt((Object)x$4)) {
                l = BoxesRunTime.unboxToLong((Object)catchExpr$2.apply((Object)x$4));
            }
            throw x$4;
        }
        return l;
    }

    @Override
    public String format(Instant instant) {
        String string;
        try {
            string = this.zonedFormatter().format(instant);
        }
        catch (Throwable x$5) {
            PartialFunction<Throwable, String> catchExpr$3 = this.checkFormattedDiff(SparkDateTimeUtils$.MODULE$.toJavaTimestamp(SparkDateTimeUtils$.MODULE$.instantToMicros(instant)), (Function1 & Serializable)t -> this.format((Timestamp)t));
            if (catchExpr$3.isDefinedAt((Object)x$5)) {
                string = (String)catchExpr$3.apply((Object)x$5);
            }
            throw x$5;
        }
        return string;
    }

    @Override
    public String format(long us) {
        Instant instant = SparkDateTimeUtils$.MODULE$.microsToInstant(us);
        return this.format(instant);
    }

    @Override
    public String format(Timestamp ts) {
        return this.legacyFormatter().format(ts);
    }

    @Override
    public String format(LocalDateTime localDateTime) {
        return localDateTime.format(this.formatter());
    }

    @Override
    public void validatePatternString(boolean checkLegacy) {
        if (checkLegacy) {
            Object object;
            try {
                object = this.formatter();
            }
            catch (Throwable x$6) {
                PartialFunction<Throwable, DateTimeFormatter> catchExpr$4 = this.checkLegacyFormatter(this.pattern, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.legacyFormatter().validatePatternString(true));
                if (catchExpr$4.isDefinedAt((Object)x$6)) {
                    object = catchExpr$4.apply((Object)x$6);
                }
                throw x$6;
            }
            return;
        }
        try {
            this.formatter();
        }
        catch (Throwable x$7) {
            PartialFunction<Throwable, Nothing$> catchExpr$5 = this.checkInvalidPattern(this.pattern);
            if (catchExpr$5.isDefinedAt((Object)x$7)) {
                catchExpr$5.apply((Object)x$7);
            }
            throw x$7;
        }
    }

    public static final /* synthetic */ long $anonfun$parse$1(Iso8601TimestampFormatter $this, String s) {
        return $this.legacyFormatter().parse(s);
    }

    public static final /* synthetic */ long $anonfun$parseWithoutTimeZone$1(Iso8601TimestampFormatter $this, String s) {
        return $this.legacyFormatter().parse(s);
    }

    public Iso8601TimestampFormatter(String pattern, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        this.pattern = pattern;
        this.zoneId = zoneId;
        this.locale = locale;
        this.legacyFormat = legacyFormat;
        this.isParsing = isParsing;
        TimestampFormatter.$init$(this);
        DateTimeFormatterHelper.$init$(this);
    }
}

