/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.Channel;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Pair;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class OneForOneStreamManager
extends StreamManager {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(OneForOneStreamManager.class);
    private final AtomicLong nextStreamId = new AtomicLong((long)new Random().nextInt(Integer.MAX_VALUE) * 1000L);
    private final ConcurrentHashMap<Long, StreamState> streams = new ConcurrentHashMap();

    @Override
    public ManagedBuffer getChunk(long streamId, int chunkIndex) {
        StreamState state = this.streams.get(streamId);
        if (state == null) {
            throw new IllegalStateException(String.format("Requested chunk not available since streamId %s is closed", streamId));
        }
        if (chunkIndex != state.curChunk) {
            throw new IllegalStateException(String.format("Received out-of-order chunk index %s (expected %s)", chunkIndex, state.curChunk));
        }
        if (!state.buffers.hasNext()) {
            throw new IllegalStateException(String.format("Requested chunk index beyond end %s", chunkIndex));
        }
        ++state.curChunk;
        ManagedBuffer nextChunk = state.buffers.next();
        if (!state.buffers.hasNext()) {
            logger.trace("Removing stream id {}", (Object)streamId);
            this.streams.remove(streamId);
        }
        return nextChunk;
    }

    @Override
    public ManagedBuffer openStream(String streamChunkId) {
        Pair<Long, Integer> streamChunkIdPair = OneForOneStreamManager.parseStreamChunkId(streamChunkId);
        return this.getChunk((Long)streamChunkIdPair.getLeft(), (Integer)streamChunkIdPair.getRight());
    }

    public static String genStreamChunkId(long streamId, int chunkId) {
        return String.format("%d_%d", streamId, chunkId);
    }

    public static Pair<Long, Integer> parseStreamChunkId(String streamChunkId) {
        String[] array = streamChunkId.split("_");
        assert (array.length == 2) : "Stream id and chunk index should be specified.";
        long streamId = Long.valueOf(array[0]);
        int chunkIndex = Integer.valueOf(array[1]);
        return Pair.of((Object)streamId, (Object)chunkIndex);
    }

    @Override
    public void connectionTerminated(Channel channel) {
        RuntimeException failedToReleaseBufferException = null;
        for (Map.Entry<Long, StreamState> entry : this.streams.entrySet()) {
            StreamState state = entry.getValue();
            if (state.associatedChannel != channel) continue;
            this.streams.remove(entry.getKey());
            try {
                while (!state.isBufferMaterializedOnNext && state.buffers.hasNext()) {
                    ManagedBuffer buffer = state.buffers.next();
                    if (buffer == null) continue;
                    buffer.release();
                }
            }
            catch (RuntimeException e) {
                if (failedToReleaseBufferException == null) {
                    failedToReleaseBufferException = e;
                    continue;
                }
                logger.error("Exception trying to release remaining StreamState buffers", (Throwable)e);
            }
        }
        if (failedToReleaseBufferException != null) {
            throw failedToReleaseBufferException;
        }
    }

    @Override
    public void checkAuthorization(TransportClient client, long streamId) {
        if (client.getClientId() != null) {
            StreamState state = this.streams.get(streamId);
            JavaUtils.checkArgument((state != null ? 1 : 0) != 0, (String)"Unknown stream ID.", (Object[])new Object[0]);
            if (!client.getClientId().equals(state.appId)) {
                throw new SecurityException(String.format("Client %s not authorized to read stream %d (app %s).", client.getClientId(), streamId, state.appId));
            }
        }
    }

    @Override
    public void chunkBeingSent(long streamId) {
        StreamState streamState = this.streams.get(streamId);
        if (streamState != null) {
            streamState.chunksBeingTransferred.incrementAndGet();
        }
    }

    @Override
    public void streamBeingSent(String streamId) {
        this.chunkBeingSent((Long)OneForOneStreamManager.parseStreamChunkId(streamId).getLeft());
    }

    @Override
    public void chunkSent(long streamId) {
        StreamState streamState = this.streams.get(streamId);
        if (streamState != null) {
            streamState.chunksBeingTransferred.decrementAndGet();
        }
    }

    @Override
    public void streamSent(String streamId) {
        this.chunkSent((Long)OneForOneStreamManager.parseStreamChunkId(streamId).getLeft());
    }

    @Override
    public long chunksBeingTransferred() {
        long sum = 0L;
        for (StreamState streamState : this.streams.values()) {
            sum += streamState.chunksBeingTransferred.get();
        }
        return sum;
    }

    public long registerStream(String appId, Iterator<ManagedBuffer> buffers, Channel channel, boolean isBufferMaterializedOnNext) {
        long myStreamId = this.nextStreamId.getAndIncrement();
        this.streams.put(myStreamId, new StreamState(appId, buffers, channel, isBufferMaterializedOnNext));
        return myStreamId;
    }

    public long registerStream(String appId, Iterator<ManagedBuffer> buffers, Channel channel) {
        return this.registerStream(appId, buffers, channel, false);
    }

    @VisibleForTesting
    public int numStreamStates() {
        return this.streams.size();
    }

    private static class StreamState {
        final String appId;
        final Iterator<ManagedBuffer> buffers;
        final Channel associatedChannel;
        final boolean isBufferMaterializedOnNext;
        int curChunk = 0;
        final AtomicLong chunksBeingTransferred = new AtomicLong(0L);

        StreamState(String appId, Iterator<ManagedBuffer> buffers, Channel channel, boolean isBufferMaterializedOnNext) {
            this.appId = appId;
            this.buffers = Objects.requireNonNull(buffers);
            this.associatedChannel = channel;
            this.isBufferMaterializedOnNext = isBufferMaterializedOnNext;
        }
    }
}

