/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleBlockPusher;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Option;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005%4Q\u0001B\u0003\u0001\u000f5AQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00121BQA\u000e\u0001\u0005\u0002]\u0012Qc\u00155vM\u001adWm\u0016:ji\u0016\u0004&o\\2fgN|'O\u0003\u0002\u0007\u000f\u000591\u000f[;gM2,'B\u0001\u0005\n\u0003\u0015\u0019\b/\u0019:l\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0014\t\u0001qA#\t\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UqbB\u0001\f\u001d\u001d\t92$D\u0001\u0019\u0015\tI\"$\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005\t\u0012BA\u000f\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!a\b\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005u\u0001\u0002C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\b\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0014$\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\u0003\u0002+\r\u0014X-\u0019;f\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;feR\u0011Q\u0006\r\t\u0003U9J!aL\u0003\u00037MCWO\u001a4mK^\u0013\u0018\u000e^3NKR\u0014\u0018nY:SKB|'\u000f^3s\u0011\u0015\t$\u00011\u00013\u0003\u001d\u0019wN\u001c;fqR\u0004\"a\r\u001b\u000e\u0003\u001dI!!N\u0004\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010^\u0001\u0006oJLG/\u001a\u000b\u0007qyzel\u00195\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m:\u0011!C:dQ\u0016$W\u000f\\3s\u0013\ti$HA\u0005NCB\u001cF/\u0019;vg\")qh\u0001a\u0001\u0001\u00061\u0011N\u001c9viN\u0004$!\u0011$\u0011\u0007U\u0011E)\u0003\u0002DA\tA\u0011\n^3sCR|'\u000f\u0005\u0002F\r2\u0001A!C$?\u0003\u0003\u0005\tQ!\u0001I\u0005\ryF%M\t\u0003\u00132\u0003\"a\u0004&\n\u0005-\u0003\"a\u0002(pi\"Lgn\u001a\t\u0003\u001f5K!A\u0014\t\u0003\u0007\u0005s\u0017\u0010C\u0003Q\u0007\u0001\u0007\u0011+A\u0002eKB\u0004DA\u0015,Z9B)1gU+Y7&\u0011Ak\u0002\u0002\u0012'\",hM\u001a7f\t\u0016\u0004XM\u001c3f]\u000eL\bCA#W\t%9v*!A\u0001\u0002\u000b\u0005\u0001JA\u0002`II\u0002\"!R-\u0005\u0013i{\u0015\u0011!A\u0001\u0006\u0003A%aA0%gA\u0011Q\t\u0018\u0003\n;>\u000b\t\u0011!A\u0003\u0002!\u00131a\u0018\u00135\u0011\u0015y6\u00011\u0001a\u0003\u0015i\u0017\r]%e!\ty\u0011-\u0003\u0002c!\t!Aj\u001c8h\u0011\u0015!7\u00011\u0001f\u0003!i\u0017\r]%oI\u0016D\bCA\bg\u0013\t9\u0007CA\u0002J]RDQ!M\u0002A\u0002I\u0002")
public class ShuffleWriteProcessor
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ShuffleWriteMetricsReporter createMetricsReporter(TaskContext context) {
        return context.taskMetrics().shuffleWriteMetrics();
    }

    public MapStatus write(Iterator<Object> inputs, ShuffleDependency<?, ?, ?> dep, long mapId, int mapIndex, TaskContext context) {
        MapStatus mapStatus;
        ShuffleWriter writer = null;
        try {
            ShuffleManager manager = SparkEnv$.MODULE$.get().shuffleManager();
            writer = manager.getWriter(dep.shuffleHandle(), mapId, context, this.createMetricsReporter(context));
            writer.write(inputs);
            Option<MapStatus> mapStatus2 = writer.stop(true);
            if (mapStatus2.isDefined()) {
                MapOutputTracker mapOutputTracker;
                Seq<BlockManagerId> mergerLocs;
                if (dep.shuffleMergeAllowed() && dep.getMergerLocs().isEmpty() && (mergerLocs = (mapOutputTracker = SparkEnv$.MODULE$.get().mapOutputTracker()).getShufflePushMergerLocations(dep.shuffleId())).nonEmpty()) {
                    dep.setMergerLocs(mergerLocs);
                }
                if (!dep.shuffleMergeFinalized()) {
                    ShuffleBlockResolver shuffleBlockResolver = manager.shuffleBlockResolver();
                    if (shuffleBlockResolver instanceof IndexShuffleBlockResolver) {
                        IndexShuffleBlockResolver indexShuffleBlockResolver = (IndexShuffleBlockResolver)shuffleBlockResolver;
                        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Shuffle merge enabled with"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" ", " merger locations"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_MERGER_LOCATIONS, BoxesRunTime.boxToInteger((int)dep.getMergerLocs().size()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" for stage ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STAGE_ID, BoxesRunTime.boxToInteger((int)context.stageId()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" with shuffle ID ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SHUFFLE_ID, BoxesRunTime.boxToInteger((int)dep.shuffleId()))})))));
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Starting pushing blocks for the task " + context.taskAttemptId());
                        File dataFile = indexShuffleBlockResolver.getDataFile(dep.shuffleId(), mapId);
                        new ShuffleBlockPusher(SparkEnv$.MODULE$.get().conf()).initiateBlockPush(dataFile, writer.getPartitionLengths(), dep, mapIndex);
                    }
                }
            }
            mapStatus = (MapStatus)mapStatus2.get();
        }
        catch (Exception e) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = writer != null ? writer.stop(false) : BoxedUnit.UNIT;
            }
            catch (Exception e2) {
                this.log().debug("Could not stop writer", (Throwable)e2);
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        return mapStatus;
    }

    public ShuffleWriteProcessor() {
        Logging.$init$((Logging)this);
    }
}

