#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import pyspark.sql.connect.proto.expressions_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class MlParams(google.protobuf.message.Message):
    """MlParams stores param settings for ML Estimator / Transformer / Evaluator"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ParamsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> pyspark.sql.connect.proto.expressions_pb2.Expression.Literal: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: pyspark.sql.connect.proto.expressions_pb2.Expression.Literal | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    PARAMS_FIELD_NUMBER: builtins.int
    @property
    def params(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        builtins.str, pyspark.sql.connect.proto.expressions_pb2.Expression.Literal
    ]:
        """User-supplied params"""
    def __init__(
        self,
        *,
        params: collections.abc.Mapping[
            builtins.str, pyspark.sql.connect.proto.expressions_pb2.Expression.Literal
        ]
        | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["params", b"params"]) -> None: ...

global___MlParams = MlParams

class MlOperator(google.protobuf.message.Message):
    """MLOperator represents the ML operators like (Estimator, Transformer or Evaluator)"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _OperatorType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OperatorTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            MlOperator._OperatorType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OPERATOR_TYPE_UNSPECIFIED: MlOperator._OperatorType.ValueType  # 0
        OPERATOR_TYPE_ESTIMATOR: MlOperator._OperatorType.ValueType  # 1
        """ML estimator"""
        OPERATOR_TYPE_TRANSFORMER: MlOperator._OperatorType.ValueType  # 2
        """ML transformer (non-model)"""
        OPERATOR_TYPE_EVALUATOR: MlOperator._OperatorType.ValueType  # 3
        """ML evaluator"""
        OPERATOR_TYPE_MODEL: MlOperator._OperatorType.ValueType  # 4
        """ML model"""

    class OperatorType(_OperatorType, metaclass=_OperatorTypeEnumTypeWrapper): ...
    OPERATOR_TYPE_UNSPECIFIED: MlOperator.OperatorType.ValueType  # 0
    OPERATOR_TYPE_ESTIMATOR: MlOperator.OperatorType.ValueType  # 1
    """ML estimator"""
    OPERATOR_TYPE_TRANSFORMER: MlOperator.OperatorType.ValueType  # 2
    """ML transformer (non-model)"""
    OPERATOR_TYPE_EVALUATOR: MlOperator.OperatorType.ValueType  # 3
    """ML evaluator"""
    OPERATOR_TYPE_MODEL: MlOperator.OperatorType.ValueType  # 4
    """ML model"""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """(Required) The qualified name of the ML operator."""
    uid: builtins.str
    """(Required) Unique id of the ML operator"""
    type: global___MlOperator.OperatorType.ValueType
    """(Required) Represents what the ML operator is"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        type: global___MlOperator.OperatorType.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["name", b"name", "type", b"type", "uid", b"uid"]
    ) -> None: ...

global___MlOperator = MlOperator

class ObjectRef(google.protobuf.message.Message):
    """Represents a reference to the cached object which could be a model
    or summary evaluated by a model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """(Required) The ID is used to lookup the object on the server side.
    Note it is different from the 'uid' of a ML object.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___ObjectRef = ObjectRef
