/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.scostore.ListStore;

public class SCOListIterator<E>
implements ListIterator<E> {
    private final ListIterator<E> iter;
    private final List<E> ownerSCO;
    private boolean reverse;

    public SCOListIterator(List<E> sco, ObjectProvider sm, List<E> theDelegate, ListStore<E> theStore, boolean useDelegate, int startIndex) {
        this.ownerSCO = sco;
        ArrayList<E> entries = new ArrayList<E>();
        Iterator<E> i = null;
        i = useDelegate ? theDelegate.iterator() : (theStore != null ? theStore.iterator(sm) : theDelegate.iterator());
        while (i.hasNext()) {
            entries.add(i.next());
        }
        this.iter = startIndex >= 0 ? entries.listIterator(startIndex) : entries.listIterator();
    }

    @Override
    public void add(E o) {
        this.iter.add(o);
        this.ownerSCO.add(this.iter.previousIndex(), o);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.iter.hasPrevious();
    }

    @Override
    public E next() {
        E result = this.iter.next();
        this.reverse = false;
        return result;
    }

    @Override
    public int nextIndex() {
        return this.iter.nextIndex();
    }

    @Override
    public E previous() {
        E result = this.iter.previous();
        this.reverse = true;
        return result;
    }

    @Override
    public int previousIndex() {
        return this.iter.previousIndex();
    }

    @Override
    public void remove() {
        this.iter.remove();
        this.ownerSCO.remove(this.iter.nextIndex());
    }

    @Override
    public void set(E o) {
        this.iter.set(o);
        this.ownerSCO.set(this.reverse ? this.iter.nextIndex() : this.iter.previousIndex(), o);
    }
}

