/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.IntWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WindowFunctionDescription(description=@Description(name="row_number", value="_FUNC_() - The ROW_NUMBER function assigns a unique number (sequentially, starting from 1, as defined by ORDER BY) to each row within the partition."), supportsWindow=false, pivotResult=true)
public class GenericUDAFRowNumber
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFRowNumber.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 0) {
            throw new UDFArgumentTypeException(parameters.length - 1, "No argument is expected.");
        }
        return new GenericUDAFRowNumberEvaluator();
    }

    public static class GenericUDAFRowNumberEvaluator
    extends GenericUDAFAbstractRowNumberEvaluator
    implements ISupportStreamingModeForWindowing {
        @Override
        public Object getNextResult(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((RowNumberBuffer)agg).rowNums.get(0);
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            this.isStreamingMode = true;
            return this;
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            return 0;
        }
    }

    public static class GenericUDAFAbstractRowNumberEvaluator
    extends GenericUDAFEvaluator {
        boolean isStreamingMode = false;

        protected boolean isStreaming() {
            return this.isStreamingMode;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for row_number function");
            }
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new RowNumberBuffer(this.isStreamingMode);
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((RowNumberBuffer)agg).init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            ((RowNumberBuffer)agg).incr();
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((RowNumberBuffer)agg).rowNums;
        }
    }

    static class RowNumberBuffer
    implements GenericUDAFEvaluator.AggregationBuffer {
        ArrayList<IntWritable> rowNums;
        int nextRow;
        boolean supportsStreaming;

        void init() {
            this.rowNums = new ArrayList();
            this.nextRow = 1;
            if (this.supportsStreaming) {
                this.rowNums.add(null);
            }
        }

        RowNumberBuffer(boolean supportsStreaming) {
            this.supportsStreaming = supportsStreaming;
            this.init();
        }

        void incr() {
            if (this.supportsStreaming) {
                this.rowNums.set(0, new IntWritable(this.nextRow++));
            } else {
                this.rowNums.add(new IntWritable(this.nextRow++));
            }
        }
    }
}

