/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.LocalSparkCluster$;
import org.apache.spark.deploy.master.Master$;
import org.apache.spark.deploy.worker.Worker$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-c!B\u000f\u001f\u0001\u00012\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011a\u0002!\u0011!Q\u0001\nUB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)q\b\u0001C\u0005\u0001\"9q\t\u0001b\u0001\n\u0013A\u0005B\u0002+\u0001A\u0003%\u0011\nC\u0004V\u0001\t\u0007I\u0011\u0002,\t\r\u0015\u0004\u0001\u0015!\u0003X\u0011\u001d1\u0007A1A\u0005\nYCaa\u001a\u0001!\u0002\u00139\u0006b\u00025\u0001\u0001\u0004%\t!\u001b\u0005\bU\u0002\u0001\r\u0011\"\u0001l\u0011\u0019\t\b\u0001)Q\u0005k!9!\u000f\u0001b\u0001\n\u0013\u0019\bBB;\u0001A\u0003%A\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\u001e\u0001!\t!a\b\b\u0011\u0005\u0005b\u0004#\u0001!\u0003G1q!\b\u0010\t\u0002\u0001\n)\u0003\u0003\u0004@+\u0011\u0005\u0011q\u0005\u0005\n\u0003S)\u0002\u0019!C\u0005\u0003WA\u0011\"a\r\u0016\u0001\u0004%I!!\u000e\t\u0011\u0005eR\u0003)Q\u0005\u0003[A\u0001\"a\u000f\u0016\t\u0003\u0001\u00131\u0006\u0005\b\u0003{)B\u0011BA\u0010\u0011\u001d\ty$\u0006C\u0001\u0003\u0003\u0012\u0011\u0003T8dC2\u001c\u0006/\u0019:l\u00072,8\u000f^3s\u0015\ty\u0002%\u0001\u0004eKBdw.\u001f\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sON\u0019\u0001aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tq\u0013'D\u00010\u0015\t\u0001\u0004%\u0001\u0005j]R,'O\\1m\u0013\t\u0011tFA\u0004M_\u001e<\u0017N\\4\u0002\u00159,XnV8sW\u0016\u00148o\u0001\u0001\u0011\u0005!2\u0014BA\u001c*\u0005\rIe\u000e^\u0001\u000fG>\u0014Xm\u001d)fe^{'o[3s\u0003=iW-\\8ssB+'oV8sW\u0016\u0014\u0018\u0001B2p]\u001a\u0004\"\u0001P\u001f\u000e\u0003\u0001J!A\u0010\u0011\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\bF\u0003B\u0007\u0012+e\t\u0005\u0002C\u00015\ta\u0004C\u00034\u000b\u0001\u0007Q\u0007C\u00039\u000b\u0001\u0007Q\u0007C\u0003:\u000b\u0001\u0007Q\u0007C\u0003;\u000b\u0001\u00071(A\u0007m_\u000e\fG\u000eS8ti:\fW.Z\u000b\u0002\u0013B\u0011!*\u0015\b\u0003\u0017>\u0003\"\u0001T\u0015\u000e\u00035S!A\u0014\u001b\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0016&\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)*\u00039awnY1m\u0011>\u001cHO\\1nK\u0002\nQ\"\\1ti\u0016\u0014(\u000b]2F]Z\u001cX#A,\u0011\u0007akv,D\u0001Z\u0015\tQ6,A\u0004nkR\f'\r\\3\u000b\u0005qK\u0013AC2pY2,7\r^5p]&\u0011a,\u0017\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002aG6\t\u0011M\u0003\u0002cA\u0005\u0019!\u000f]2\n\u0005\u0011\f'A\u0002*qG\u0016sg/\u0001\bnCN$XM\u001d*qG\u0016sgo\u001d\u0011\u0002\u001b]|'o[3s%B\u001cWI\u001c<t\u000399xN]6feJ\u00038-\u00128wg\u0002\nq\"\\1ti\u0016\u0014x+\u001a2V\u0013B{'\u000f^\u000b\u0002k\u0005\u0019R.Y:uKJ<VMY+J!>\u0014Ho\u0018\u0013fcR\u0011An\u001c\t\u0003Q5L!A\\\u0015\u0003\tUs\u0017\u000e\u001e\u0005\ba6\t\t\u00111\u00016\u0003\rAH%M\u0001\u0011[\u0006\u001cH/\u001a:XK\n,\u0016\nU8si\u0002\n!b^8sW\u0016\u0014H)\u001b:t+\u0005!\bc\u0001-^\u0013\u0006Yqo\u001c:lKJ$\u0015N]:!\u0003\u0015\u0019H/\u0019:u)\u0005A\bc\u0001\u0015z\u0013&\u0011!0\u000b\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000fo>\u00148.\u001a:M_\u001e4\u0017\u000e\\3t)\u0005i\b#\u0002@\u0002\b\u00055abA@\u0002\u00049\u0019A*!\u0001\n\u0003)J1!!\u0002*\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0003\u0002\f\t\u00191+Z9\u000b\u0007\u0005\u0015\u0011\u0006\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0005%|'BAA\f\u0003\u0011Q\u0017M^1\n\t\u0005m\u0011\u0011\u0003\u0002\u0005\r&dW-\u0001\u0003ti>\u0004H#\u00017\u0002#1{7-\u00197Ta\u0006\u00148n\u00117vgR,'\u000f\u0005\u0002C+M\u0011Qc\n\u000b\u0003\u0003G\tA\u0002\\8dC2\u001cE.^:uKJ,\"!!\f\u0011\t!\ny#Q\u0005\u0004\u0003cI#AB(qi&|g.\u0001\tm_\u000e\fGn\u00117vgR,'o\u0018\u0013fcR\u0019A.a\u000e\t\u0011AD\u0012\u0011!a\u0001\u0003[\tQ\u0002\\8dC2\u001cE.^:uKJ\u0004\u0013aA4fi\u0006)1\r\\3be\u0006)\u0011\r\u001d9msRI\u0011)a\u0011\u0002F\u0005\u001d\u0013\u0011\n\u0005\u0006gq\u0001\r!\u000e\u0005\u0006qq\u0001\r!\u000e\u0005\u0006sq\u0001\r!\u000e\u0005\u0006uq\u0001\ra\u000f")
public class LocalSparkCluster
implements Logging {
    private final int numWorkers;
    private final int coresPerWorker;
    private final int memoryPerWorker;
    private final SparkConf conf;
    private final String localHostname;
    private final ArrayBuffer<RpcEnv> masterRpcEnvs;
    private final ArrayBuffer<RpcEnv> workerRpcEnvs;
    private int masterWebUIPort;
    private final ArrayBuffer<String> workerDirs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static LocalSparkCluster apply(int numWorkers, int coresPerWorker, int memoryPerWorker, SparkConf conf) {
        return LocalSparkCluster$.MODULE$.apply(numWorkers, coresPerWorker, memoryPerWorker, conf);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String localHostname() {
        return this.localHostname;
    }

    private ArrayBuffer<RpcEnv> masterRpcEnvs() {
        return this.masterRpcEnvs;
    }

    private ArrayBuffer<RpcEnv> workerRpcEnvs() {
        return this.workerRpcEnvs;
    }

    public int masterWebUIPort() {
        return this.masterWebUIPort;
    }

    public void masterWebUIPort_$eq(int x$1) {
        this.masterWebUIPort = x$1;
    }

    private ArrayBuffer<String> workerDirs() {
        return this.workerDirs;
    }

    public String[] start() {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting a local Spark cluster with "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " workers."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_WORKERS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)$this.numWorkers))})))));
        SparkConf _conf = this.conf.clone().setIfMissing(package$.MODULE$.MASTER_REST_SERVER_ENABLED(), BoxesRunTime.boxToBoolean((boolean)false)).set(package$.MODULE$.SHUFFLE_SERVICE_ENABLED(), BoxesRunTime.boxToBoolean((boolean)false));
        Tuple3<RpcEnv, Object, Option<Object>> tuple3 = Master$.MODULE$.startRpcEnvAndEndpoint(this.localHostname(), 0, 0, _conf);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        RpcEnv rpcEnv = (RpcEnv)tuple3._1();
        int webUiPort = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Tuple2 tuple2 = new Tuple2((Object)rpcEnv, (Object)BoxesRunTime.boxToInteger((int)webUiPort));
        RpcEnv rpcEnv2 = (RpcEnv)tuple2._1();
        int webUiPort2 = tuple2._2$mcI$sp();
        this.masterWebUIPort_$eq(webUiPort2);
        this.masterRpcEnvs().$plus$eq((Object)rpcEnv2);
        String masterUrl = "spark://" + Utils$.MODULE$.localHostNameForURI() + ":" + rpcEnv2.address().port();
        String[] masters = (String[])((Object[])new String[]{masterUrl});
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numWorkers).foreach((Function1 & Serializable)workerNum -> LocalSparkCluster.$anonfun$start$2(this, masters, _conf, BoxesRunTime.unboxToInt((Object)workerNum)));
        return masters;
    }

    public Seq<File> workerLogfiles() {
        return (Seq)this.workerDirs().toSeq().flatMap((Function1 & Serializable)dir -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.recursiveList(new File((String)dir))), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LocalSparkCluster.$anonfun$workerLogfiles$2(f)))));
    }

    public void stop() {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Shutting down local Spark cluster.");
        this.workerRpcEnvs().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.workerRpcEnvs().foreach((Function1 & Serializable)x$3 -> {
            x$3.awaitTermination();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().foreach((Function1 & Serializable)x$5 -> {
            x$5.awaitTermination();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().clear();
        this.workerRpcEnvs().clear();
        this.workerDirs().clear();
        LocalSparkCluster$.MODULE$.org$apache$spark$deploy$LocalSparkCluster$$clear();
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$start$2(LocalSparkCluster $this, String[] masters$1, SparkConf _conf$1, int workerNum) {
        String string;
        if (Utils$.MODULE$.isTesting()) {
            String x$1 = "worker";
            String x$2 = Utils$.MODULE$.createTempDir$default$1();
            string = Utils$.MODULE$.createTempDir(x$2, "worker").getAbsolutePath();
        } else {
            string = null;
        }
        String workDir = string;
        Object object = Utils$.MODULE$.isTesting() ? $this.workerDirs().$plus$eq(workDir) : BoxedUnit.UNIT;
        RpcEnv workerEnv = Worker$.MODULE$.startRpcEnvAndEndpoint($this.localHostname(), 0, 0, $this.coresPerWorker, $this.memoryPerWorker, masters$1, workDir, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)workerNum)), _conf$1, (Option<String>)((Option)$this.conf.get(org.apache.spark.internal.config.Worker$.MODULE$.SPARK_WORKER_RESOURCE_FILE())));
        return (ArrayBuffer)$this.workerRpcEnvs().$plus$eq((Object)workerEnv);
    }

    public static final /* synthetic */ boolean $anonfun$workerLogfiles$2(File f) {
        return f.isFile() && StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.log$")).findFirstMatchIn((CharSequence)f.getName()).isDefined();
    }

    public LocalSparkCluster(int numWorkers, int coresPerWorker, int memoryPerWorker, SparkConf conf) {
        this.numWorkers = numWorkers;
        this.coresPerWorker = coresPerWorker;
        this.memoryPerWorker = memoryPerWorker;
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.localHostname = Utils$.MODULE$.localHostName();
        this.masterRpcEnvs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.workerRpcEnvs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.masterWebUIPort = -1;
        this.workerDirs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

