/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaMulticlassLogisticRegressionWithElasticNetExample {
    public static void main(String[] args) {
        double[] fLabel;
        double[] recLabel;
        double[] precLabel;
        double[] tprLabel;
        double[] fprLabel;
        double[] objectiveHistory;
        SparkSession spark = SparkSession.builder().appName("JavaMulticlassLogisticRegressionWithElasticNetExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_multiclass_classification_data.txt");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        System.out.println("Coefficients: \n" + String.valueOf(lrModel.coefficientMatrix()) + " \nIntercept: " + String.valueOf(lrModel.interceptVector()));
        LogisticRegressionTrainingSummary trainingSummary = lrModel.summary();
        for (double lossPerIteration : objectiveHistory = trainingSummary.objectiveHistory()) {
            System.out.println(lossPerIteration);
        }
        System.out.println("False positive rate by label:");
        int i = 0;
        for (double fpr : fprLabel = trainingSummary.falsePositiveRateByLabel()) {
            System.out.println("label " + i + ": " + fpr);
            ++i;
        }
        System.out.println("True positive rate by label:");
        i = 0;
        for (double tpr : tprLabel = trainingSummary.truePositiveRateByLabel()) {
            System.out.println("label " + i + ": " + tpr);
            ++i;
        }
        System.out.println("Precision by label:");
        i = 0;
        for (double prec : precLabel = trainingSummary.precisionByLabel()) {
            System.out.println("label " + i + ": " + prec);
            ++i;
        }
        System.out.println("Recall by label:");
        i = 0;
        for (double rec : recLabel = trainingSummary.recallByLabel()) {
            System.out.println("label " + i + ": " + rec);
            ++i;
        }
        System.out.println("F-measure by label:");
        i = 0;
        for (double f : fLabel = trainingSummary.fMeasureByLabel()) {
            System.out.println("label " + i + ": " + f);
            ++i;
        }
        double accuracy = trainingSummary.accuracy();
        double falsePositiveRate = trainingSummary.weightedFalsePositiveRate();
        double truePositiveRate = trainingSummary.weightedTruePositiveRate();
        double fMeasure = trainingSummary.weightedFMeasure();
        double precision = trainingSummary.weightedPrecision();
        double recall = trainingSummary.weightedRecall();
        System.out.println("Accuracy: " + accuracy);
        System.out.println("FPR: " + falsePositiveRate);
        System.out.println("TPR: " + truePositiveRate);
        System.out.println("F-measure: " + fMeasure);
        System.out.println("Precision: " + precision);
        System.out.println("Recall: " + recall);
        spark.stop();
    }
}

