/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.io.IOException;
import java.lang.ref.Cleaner;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.RocksDB;
import org.apache.spark.util.kvstore.RocksDBTypeInfo;
import org.rocksdb.RocksIterator;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.base.Throwables;

class RocksDBIterator<T>
implements KVStoreIterator<T> {
    private static final Cleaner CLEANER = Cleaner.create();
    private final RocksDB db;
    private final boolean ascending;
    private final RocksIterator it;
    private final Class<T> type;
    private final RocksDBTypeInfo ti;
    private final RocksDBTypeInfo.Index index;
    private final byte[] indexKeyPrefix;
    private final byte[] end;
    private final long max;
    private final Cleaner.Cleanable cleanable;
    private final ResourceCleaner resourceCleaner;
    private boolean checkedNext;
    private byte[] next;
    private boolean closed;
    private long count;

    RocksDBIterator(Class<T> type, RocksDB db, KVStoreView<T> params) throws Exception {
        this.db = db;
        this.ascending = params.ascending;
        this.it = db.db().newIterator();
        this.type = type;
        this.ti = db.getTypeInfo(type);
        this.index = this.ti.index(params.index);
        this.max = params.max;
        this.resourceCleaner = new ResourceCleaner(this.it, db);
        this.cleanable = CLEANER.register(this, this.resourceCleaner);
        Preconditions.checkArgument((!this.index.isChild() || params.parent != null ? 1 : 0) != 0, (String)"Cannot iterate over child index %s without parent value.", (Object)params.index);
        byte[] parent = this.index.isChild() ? this.index.parent().childPrefix(params.parent) : null;
        this.indexKeyPrefix = this.index.keyPrefix(parent);
        byte[] firstKey = params.first != null ? (this.ascending ? this.index.start(parent, params.first) : this.index.end(parent, params.first)) : (this.ascending ? this.index.keyPrefix(parent) : this.index.end(parent));
        this.it.seek(firstKey);
        byte[] end = null;
        if (this.ascending) {
            end = params.last != null ? this.index.end(parent, params.last) : this.index.end(parent);
        } else {
            if (params.last != null) {
                end = this.index.start(parent, params.last);
            }
            if (!this.it.isValid()) {
                throw new NoSuchElementException();
            }
            if (RocksDBIterator.compare(this.it.key(), this.indexKeyPrefix) > 0) {
                this.it.prev();
            }
        }
        this.end = end;
        if (params.skip > 0L) {
            this.skip(params.skip);
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.checkedNext && !this.closed) {
            this.next = this.loadNext();
            this.checkedNext = true;
        }
        if (!this.closed && this.next == null) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.checkedNext = false;
        try {
            T ret;
            if (this.index == null || this.index.isCopy()) {
                ret = this.db.serializer.deserialize(this.next, this.type);
            } else {
                byte[] key = this.ti.buildKey(false, (byte[][])new byte[][]{this.ti.naturalIndex().keyPrefix(null), this.next});
                ret = this.db.get(key, this.type);
            }
            this.next = null;
            return ret;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<T> next(int max) {
        ArrayList<T> list = new ArrayList<T>(max);
        while (this.hasNext() && list.size() < max) {
            list.add(this.next());
        }
        return list;
    }

    @Override
    public boolean skip(long n) {
        if (this.closed) {
            return false;
        }
        long skipped = 0L;
        while (skipped < n) {
            if (this.next != null) {
                this.checkedNext = false;
                this.next = null;
                ++skipped;
                continue;
            }
            if (!this.it.isValid()) {
                this.checkedNext = true;
                return false;
            }
            if (!this.isEndMarker(this.it.key())) {
                ++skipped;
            }
            if (this.ascending) {
                this.it.next();
                continue;
            }
            this.it.prev();
        }
        return this.hasNext();
    }

    @Override
    public synchronized void close() throws IOException {
        this.db.notifyIteratorClosed(this.it);
        if (!this.closed) {
            try {
                this.it.close();
            }
            finally {
                this.closed = true;
                this.next = null;
                this.cancelResourceClean();
            }
        }
    }

    private void cancelResourceClean() {
        this.resourceCleaner.setStartedToFalse();
        this.cleanable.clean();
    }

    @VisibleForTesting
    ResourceCleaner getResourceCleaner() {
        return this.resourceCleaner;
    }

    RocksIterator internalIterator() {
        return this.it;
    }

    private byte[] loadNext() {
        if (this.count >= this.max) {
            return null;
        }
        while (this.it.isValid()) {
            int comp;
            AbstractMap.SimpleEntry<byte[], byte[]> nextEntry = new AbstractMap.SimpleEntry<byte[], byte[]>(this.it.key(), this.it.value());
            byte[] nextKey = (byte[])nextEntry.getKey();
            if (!RocksDBIterator.startsWith(nextKey, this.indexKeyPrefix)) {
                return null;
            }
            if (this.isEndMarker(nextKey)) {
                if (this.ascending) {
                    this.it.next();
                    continue;
                }
                this.it.prev();
                continue;
            }
            if (this.end != null && (comp = RocksDBIterator.compare(nextKey, this.end) * (this.ascending ? 1 : -1)) > 0) {
                return null;
            }
            ++this.count;
            if (this.ascending) {
                this.it.next();
            } else {
                this.it.prev();
            }
            return (byte[])nextEntry.getValue();
        }
        return null;
    }

    @VisibleForTesting
    static boolean startsWith(byte[] key, byte[] prefix) {
        if (key.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (key[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isEndMarker(byte[] key) {
        return key.length > 2 && key[key.length - 2] == 0 && key[key.length - 1] == RocksDBTypeInfo.END_MARKER[0];
    }

    static int compare(byte[] a, byte[] b) {
        int diff = 0;
        int minLen = Math.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            if ((diff += a[i] - b[i]) == 0) continue;
            return diff;
        }
        return a.length - b.length;
    }

    static class ResourceCleaner
    implements Runnable {
        private final RocksIterator rocksIterator;
        private final RocksDB rocksDB;
        private final AtomicBoolean started = new AtomicBoolean(true);

        ResourceCleaner(RocksIterator rocksIterator, RocksDB rocksDB) {
            this.rocksIterator = rocksIterator;
            this.rocksDB = rocksDB;
        }

        @Override
        public void run() {
            if (this.started.compareAndSet(true, false)) {
                this.rocksDB.closeIterator(this.rocksIterator);
            }
        }

        void setStartedToFalse() {
            this.started.set(false);
        }

        @VisibleForTesting
        boolean isCompleted() {
            return !this.started.get();
        }
    }
}

