/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ContextFluent<A extends ContextFluent<A>>
extends BaseFluent<A> {
    private String cluster;
    private ArrayList<NamedExtensionBuilder> extensions = new ArrayList();
    private String namespace;
    private String user;
    private Map<String, Object> additionalProperties;

    public ContextFluent() {
    }

    public ContextFluent(Context instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Context instance) {
        Context context = instance = instance != null ? instance : new Context();
        if (instance != null) {
            this.withCluster(instance.getCluster());
            this.withExtensions(instance.getExtensions());
            this.withNamespace(instance.getNamespace());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCluster() {
        return this.cluster;
    }

    public A withCluster(String cluster) {
        this.cluster = cluster;
        return (A)((Object)this);
    }

    public boolean hasCluster() {
        return this.cluster != null;
    }

    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get((Object)"extensions").add(index, builder);
            this.extensions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get((Object)"extensions").set(index, builder);
            this.extensions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").remove((Object)builder);
            this.extensions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").remove((Object)builder);
            this.extensions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        Iterator<NamedExtensionBuilder> each = this.extensions.iterator();
        List visitables = this._visitables.get((Object)"extensions");
        while (each.hasNext()) {
            NamedExtensionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NamedExtension> buildExtensions() {
        return this.extensions != null ? ContextFluent.build(this.extensions) : null;
    }

    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get((Object)"extensions").clear();
        }
        if (extensions != null) {
            this.extensions = new ArrayList();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)((Object)this);
    }

    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
            this._visitables.remove((Object)"extensions");
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public A addNewExtension(Object extension, String name) {
        return this.addToExtensions(new NamedExtension(extension, name));
    }

    public ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNested(-1, null);
    }

    public ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNested(-1, item);
    }

    public ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNested(index, item);
    }

    public ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    public ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.test(this.extensions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)((Object)this);
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContextFluent that = (ContextFluent)((Object)o);
        if (!Objects.equals(this.cluster, that.cluster)) {
            return false;
        }
        if (!Objects.equals(this.extensions, that.extensions)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.extensions, this.namespace, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cluster != null) {
            sb.append("cluster:");
            sb.append(this.cluster + ",");
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            sb.append("extensions:");
            sb.append(this.extensions + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ExtensionsNested<N>
    extends NamedExtensionFluent<ExtensionsNested<N>>
    implements Nested<N> {
        NamedExtensionBuilder builder;
        int index;

        ExtensionsNested(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        public N and() {
            return (N)ContextFluent.this.setToExtensions(this.index, this.builder.build());
        }

        public N endExtension() {
            return this.and();
        }
    }
}

