/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Converts `expr` to hexadecimal.", examples="\n    Examples:\n      > SELECT _FUNC_(17);\n       11\n      > SELECT _FUNC_('Spark SQL');\n       537061726B2053514C\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]q!B\u0011#\u0011\u0003yc!B\u0019#\u0011\u0003\u0011\u0004\"B!\u0002\t\u0003\u0011\u0005bB\"\u0002\u0005\u0004%i\u0001\u0012\u0005\u0007\u0017\u0006\u0001\u000bQB#\t\u000f1\u000b!\u0019!C\u0001\t\"1Q*\u0001Q\u0001\n\u0015CQAT\u0001\u0005\u0002=CQAT\u0001\u0005\u0002iCQ\u0001Y\u0001\u0005\u0002\u0005DQ\u0001Y\u0001\u0005\u0002\rDq!]\u0001\u0002\u0002\u0013\u0005%\u000fC\u0005\u0002\u0000\u0006\t\t\u0011\"!\u0003\u0002!I!QB\u0001\u0002\u0002\u0013%!q\u0002\u0004\u0005c\t\u0002E\u000f\u0003\u0006\u0002\u00149\u0011)\u001a!C\u0001\u0003+A!\"!\b\u000f\u0005#\u0005\u000b\u0011BA\f\u0011\u0019\te\u0002\"\u0001\u0002 !9\u00111\u0005\b\u0005B\u0005\u0015\u0002bBA\u0017\u001d\u0011\u0005\u0013q\u0006\u0005\b\u0003\u0003rA\u0011IA\"\u0011\u001d\tYE\u0004C)\u0003\u001bBq!a\u0016\u000f\t#\nI\u0006C\u0004\u0002v9!\t&a\u001e\t\u0013\u0005ud\"!A\u0005\u0002\u0005}\u0004\"CAB\u001dE\u0005I\u0011AAC\u0011%\tYJDA\u0001\n\u0003\ni\nC\u0005\u0002*:\t\t\u0011\"\u0001\u0002,\"I\u00111\u0017\b\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003ws\u0011\u0011!C!\u0003{C\u0011\"a3\u000f\u0003\u0003%\t!!4\t\u0013\u0005Eg\"!A\u0005B\u0005M\u0007\"CAl\u001d\u0005\u0005I\u0011IAm\u0003\rAU\r\u001f\u0006\u0003G\u0011\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QEJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001A\u0011\u0001'A\u0007\u0002E\t\u0019\u0001*\u001a=\u0014\u0007\u0005\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VM\u001a\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n!![8\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\n\u0011\u0002[3y\t&<\u0017\u000e^:\u0016\u0003\u0015\u00032\u0001\u000e$I\u0013\t9UGA\u0003BeJ\f\u0017\u0010\u0005\u00025\u0013&\u0011!*\u000e\u0002\u0005\u0005f$X-\u0001\u0006iKb$\u0015nZ5ug\u0002\n1\"\u001e8iKb$\u0015nZ5ug\u0006aQO\u001c5fq\u0012Kw-\u001b;tA\u0005\u0019\u0001.\u001a=\u0015\u0005AC\u0006CA)W\u001b\u0005\u0011&BA*U\u0003\u0015!\u0018\u0010]3t\u0015\t)\u0006&\u0001\u0004v]N\fg-Z\u0005\u0003/J\u0013!\"\u0016+GqM#(/\u001b8h\u0011\u0015Iv\u00011\u0001F\u0003\u0015\u0011\u0017\u0010^3t)\t\u00016\fC\u0003]\u0011\u0001\u0007Q,A\u0002ok6\u0004\"\u0001\u000e0\n\u0005}+$\u0001\u0002'p]\u001e\fQ!\u001e8iKb$\"!\u00122\t\u000beK\u0001\u0019A#\u0015\u0005\u0015#\u0007\"B3\u000b\u0001\u00041\u0017aA:ueB\u0011qM\u001c\b\u0003Q2\u0004\"![\u001b\u000e\u0003)T!a\u001b\u0018\u0002\rq\u0012xn\u001c;?\u0013\tiW'\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA76\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0019\u0018Q \t\u0003a9\u0019rAD;ywz\f\u0019\u0001\u0005\u00021m&\u0011qO\t\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0001'_\u0005\u0003u\n\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003aqL!! \u0012\u0003A\u0011+g-Y;miN#(/\u001b8h!J|G-^2j]\u001e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003i}L1!!\u00016\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u0002\u0002\u00109!\u0011qAA\u0006\u001d\rI\u0017\u0011B\u0005\u0002m%\u0019\u0011QB\u001b\u0002\u000fA\f7m[1hK&\u0019\u0001)!\u0005\u000b\u0007\u00055Q'A\u0003dQ&dG-\u0006\u0002\u0002\u0018A\u0019\u0001'!\u0007\n\u0007\u0005m!E\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004CcA:\u0002\"!9\u00111C\tA\u0002\u0005]\u0011A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0003\u0003O\u00012\u0001NA\u0015\u0013\r\tY#\u000e\u0002\b\u0005>|G.Z1o\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003c\u0001b!!\u0002\u00024\u0005]\u0012\u0002BA\u001b\u0003#\u00111aU3r!\u0011\tI$!\u0010\u000e\u0005\u0005m\"BA*'\u0013\u0011\ty$a\u000f\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0015\u0003\u0003BA\u001d\u0003\u000fJA!!\u0013\u0002<\tAA)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003\u0002P\u0005U\u0003c\u0001\u001b\u0002R%\u0019\u00111K\u001b\u0003\u0007\u0005s\u0017\u0010\u0003\u0004]+\u0001\u0007\u0011qJ\u0001\nI><UM\\\"pI\u0016$b!a\u0017\u0002h\u0005E\u0004\u0003BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005$%A\u0004d_\u0012,w-\u001a8\n\t\u0005\u0015\u0014q\f\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011\u000e\fA\u0002\u0005-\u0014aA2uqB!\u0011QLA7\u0013\u0011\ty'a\u0018\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111\u000f\fA\u0002\u0005m\u0013AA3w\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u00191/!\u001f\t\u000f\u0005mt\u00031\u0001\u0002\u0018\u0005Aa.Z<DQ&dG-\u0001\u0003d_BLHcA:\u0002\u0002\"I\u00111\u0003\r\u0011\u0002\u0003\u0007\u0011qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9I\u000b\u0003\u0002\u0018\u0005%5FAAF!\u0011\ti)a&\u000e\u0005\u0005=%\u0002BAI\u0003'\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UU'\u0001\u0006b]:|G/\u0019;j_:LA!!'\u0002\u0010\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\n\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\r\t)+P\u0001\u0005Y\u0006tw-C\u0002p\u0003G\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!,\u0011\u0007Q\ny+C\u0002\u00022V\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0014\u00028\"I\u0011\u0011\u0018\u000f\u0002\u0002\u0003\u0007\u0011QV\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0006CBAa\u0003\u000f\fy%\u0004\u0002\u0002D*\u0019\u0011QY\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0006\r'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\n\u0002P\"I\u0011\u0011\u0018\u0010\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002 \u0006U\u0007\"CA]?\u0005\u0005\t\u0019AAW\u0003\u0019)\u0017/^1mgR!\u0011qEAn\u0011%\tI\fIA\u0001\u0002\u0004\ty\u0005K\n\u000f\u0003?\f)/a:\u0002l\u00065\u0018\u0011_Az\u0003o\fI\u0010E\u00021\u0003CL1!a9#\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!;\u0002]}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005Y3yaJ\u0004\u0007\u0005^8!Q\u0016D\u0018\rZ3dS6\fGNL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011q^\u0001u\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nt'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO%Z$\u0002\t\u0011!A\u0001\u0002\u0003%N\u001a8aY\ntG\r\u001cCeA*4'N\u00195\u0007*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002v\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u00111`\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\bbBA\n\u0017\u0001\u0007\u0011qC\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019A!\u0003\u0011\u000bQ\u0012)!a\u0006\n\u0007\t\u001dQG\u0001\u0004PaRLwN\u001c\u0005\t\u0005\u0017a\u0011\u0011!a\u0001g\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tE\u0001\u0003BAQ\u0005'IAA!\u0006\u0002$\n1qJ\u00196fGR\u0004")
public class Hex
extends UnaryExpression
implements ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Hex x$0) {
        return Hex$.MODULE$.unapply(x$0);
    }

    public static byte[] unhex(String str) {
        return Hex$.MODULE$.unhex(str);
    }

    public static byte[] unhex(byte[] bytes) {
        return Hex$.MODULE$.unhex(bytes);
    }

    public static UTF8String hex(long num) {
        return Hex$.MODULE$.hex(num);
    }

    public static UTF8String hex(byte[] bytes) {
        return Hex$.MODULE$.hex(bytes);
    }

    public static byte[] unhexDigits() {
        return Hex$.MODULE$.unhexDigits();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, BinaryType$.MODULE$, StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return stringType;
        }
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public Object nullSafeEval(Object num) {
        DataType dataType = this.child().dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            return Hex$.MODULE$.hex(BoxesRunTime.unboxToLong((Object)num));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Hex$.MODULE$.hex((byte[])num);
        }
        if (dataType instanceof StringType) {
            return Hex$.MODULE$.hex(((UTF8String)num).getBytes());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            DataType dataType;
            String hex = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Hex$.MODULE$.getClass().getName()), "$");
            return ev.value() + " = " + ((dataType = this.child().dataType()) instanceof StringType ? hex + ".hex(" + c + ".getBytes());" : hex + ".hex(" + c + ");");
        });
    }

    @Override
    public Hex withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Hex copy(Expression child) {
        return new Hex(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Hex";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hex hex = (Hex)x$1;
        Expression expression = this.child();
        Expression expression2 = hex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hex.canEqual(this)) return false;
        return true;
    }

    public Hex(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

