/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` equals `expr2`, or false otherwise.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       NULL\n      > SELECT NULL _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005E\u0001\tE\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u00159\u0006\u0001\"\u0015Y\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015i\u0007\u0001\"\u0015o\u0011\u001d\u0019\b!!A\u0005\u0002QDqa\u001e\u0001\u0012\u0002\u0013\u0005\u0001\u0010\u0003\u0005\u0002\b\u0001\t\n\u0011\"\u0001y\u0011%\tI\u0001AA\u0001\n\u0003\nY\u0001C\u0005\u0002\u001c\u0001\t\t\u0011\"\u0001\u0002\u001e!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003[\u0001\u0011\u0011!C!\u0003_A\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005%\u0003!!A\u0005B\u0005-s!CA;7\u0005\u0005\t\u0012AA<\r!Q2$!A\t\u0002\u0005e\u0004BB#\u0015\t\u0003\t9\tC\u0005\u0002\nR\t\t\u0011\"\u0012\u0002\f\"I\u0011Q\u0012\u000b\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\n\u0003+#\u0012\u0011!CA\u0003/C\u0011\"!+\u0015\u0003\u0003%I!a+\u0003\u000f\u0015\u000bX/\u00197U_*\u0011A$H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001f?\u0005A1-\u0019;bYf\u001cHO\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001S5\"$\b\u0005\u0002+W5\t1$\u0003\u0002-7\t\u0001\")\u001b8bef\u001cu.\u001c9be&\u001cxN\u001c\t\u0003]Er!AK\u0018\n\u0005AZ\u0012a\u00029bG.\fw-Z\u0005\u0003eM\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u000217A\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t9\u0001K]8ek\u000e$\bCA\u001b<\u0013\tadG\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#A \u0011\u0005)\u0002\u0015BA!\u001c\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r9\u0005*\u0013\t\u0003U\u0001AQ!P\u0003A\u0002}BQaQ\u0003A\u0002}\naa]=nE>dW#\u0001'\u0011\u00055#fB\u0001(S!\tye'D\u0001Q\u0015\t\tv%\u0001\u0004=e>|GOP\u0005\u0003'Z\na\u0001\u0015:fI\u00164\u0017BA+W\u0005\u0019\u0019FO]5oO*\u00111KN\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00043rk\u0006CA\u001b[\u0013\tYfGA\u0002B]fDQ!P\u0004A\u0002eCQaQ\u0004A\u0002e\u000b\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007\u000147\u000e\u0005\u0002bI6\t!M\u0003\u0002d7\u000591m\u001c3fO\u0016t\u0017BA3c\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B4\t\u0001\u0004A\u0017aA2uqB\u0011\u0011-[\u0005\u0003U\n\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003m\u0011\u0001\u0007\u0001-\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\u000f>\f\b\"\u00029\n\u0001\u0004y\u0014a\u00028fo2+g\r\u001e\u0005\u0006e&\u0001\raP\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\r9UO\u001e\u0005\b{)\u0001\n\u00111\u0001@\u0011\u001d\u0019%\u0002%AA\u0002}\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001zU\ty$pK\u0001|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00017\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u000bi(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001\u00027b]\u001eT!!a\u0006\u0002\t)\fg/Y\u0005\u0004+\u0006E\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0010!\r)\u0014\u0011E\u0005\u0004\u0003G1$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA-\u0002*!I\u00111F\b\u0002\u0002\u0003\u0007\u0011qD\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0002#BA\u001a\u0003sIVBAA\u001b\u0015\r\t9DN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001e\u0003k\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011IA$!\r)\u00141I\u0005\u0004\u0003\u000b2$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003W\t\u0012\u0011!a\u00013\u00061Q-];bYN$B!!\u0011\u0002N!A\u00111\u0006\n\u0002\u0002\u0003\u0007\u0011\fK\f\u0001\u0003#\n9&!\u0017\u0002^\u0005}\u00131MA3\u0003S\nY'a\u001c\u0002rA\u0019!&a\u0015\n\u0007\u0005U3DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005m\u0013\u0001U3yaJ\f\u0004e\u0018$V\u001d\u000e{\u0006%\u001a=qeJ\u0002S\u0006\t*fiV\u0014hn\u001d\u0011ueV,\u0007%\u001b4!A\u0016D\bO]\u0019aA\u0015\fX/\u00197tA\u0001,\u0007\u0010\u001d:3A2\u0002sN\u001d\u0011gC2\u001cX\rI8uQ\u0016\u0014x/[:f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003C\n!Q\f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a![\u0001\"\b.\u001a\u0011uo>\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA5,8\u000f\u001e\u0011cK\u0002\u001a\u0018-\\3!if\u0004X\rI8sA\r\fg\u000e\t2fA\r\f7\u000f^3eAQ|\u0007%\u0019\u0011d_6lwN\u001c\u0011usB,GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\rI7vgR\u0004#-\u001a\u0011bAQL\b/\u001a\u0011uQ\u0006$\beY1oA\t,\u0007%^:fI\u0002Jg\u000eI3rk\u0006d\u0017\u000e^=!G>l\u0007/\u0019:jg>tg\u0006I'ba\u0002\"\u0018\u0010]3!SN\u0004cn\u001c;!gV\u0004\bo\u001c:uK\u0012t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\r>\u0014\beY8na2,\u0007\u0010\t;za\u0016\u001c\be];dQ\u0002\n'O]1z_M$(/^2uY\u0001\"\b.\u001a\u0011eCR\f\u0007\u0005^=qKN\u0004sN\u001a\u0011gS\u0016dGm\u001d\u0011nkN$\bEY3!_J$WM]1cY\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001a\u0002\u0003oR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006E\r\u0011`\rVs5i\u0018\u00113w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAE\u0002sLR+O\u0007~\u0003s%M\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!iJ,X\rI0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003c*\u0016'MA}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ti'A\u00032]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002t\u0005y\u0001O]3eS\u000e\fG/Z0gk:\u001c7/A\u0004FcV\fG\u000eV8\u0011\u0005)\"2\u0003\u0002\u000b\u0002|i\u0002r!! \u0002\u0004~zt)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u0011\u001c\u0002\u000fI,h\u000e^5nK&!\u0011QQA@\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003o\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001b\tQ!\u00199qYf$RaRAI\u0003'CQ!P\fA\u0002}BQaQ\fA\u0002}\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001a\u0006\u0015\u0006#B\u001b\u0002\u001c\u0006}\u0015bAAOm\t1q\n\u001d;j_:\u0004R!NAQ\u007f}J1!a)7\u0005\u0019!V\u000f\u001d7fe!A\u0011q\u0015\r\u0002\u0002\u0003\u0007q)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0016\t\u0005\u0003\u001f\ty+\u0003\u0003\u00022\u0006E!AB(cU\u0016\u001cG\u000f")
public class EqualTo
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualTo equalTo) {
        return EqualTo$.MODULE$.unapply(equalTo);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualTo> tupled() {
        return EqualTo$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualTo>> curried() {
        return EqualTo$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "=";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(left, right));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & java.io.Serializable & Serializable)(c1, c2) -> ctx.genEqual(this.left().dataType(), (String)c1, (String)c2));
    }

    @Override
    public EqualTo withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public EqualTo copy(Expression left, Expression right) {
        return new EqualTo(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualTo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualTo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualTo equalTo = (EqualTo)x$1;
        Expression expression = this.left();
        Expression expression2 = equalTo.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalTo.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalTo.canEqual(this)) return false;
        return true;
    }

    public EqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

